<?
include_once( dirname(__FILE__) . "/class.TableElement.php" );
include_once( dirname(__FILE__) . "/class.AElement.php" );
include_once( dirname(__FILE__) . "/class.HTMLElement.php" );
include_once( dirname(__FILE__) . "/class.TRElement.php" );
include_once( dirname(__FILE__) . "/class.CompoundElement.php" );
include_once( dirname(__FILE__) . "/class.SelectElement.php" );
include_once( dirname(__FILE__) . "/class.OptionElement.php" );
include_once( dirname(__FILE__) . "/class.ButtonURLElement.php" );
include_once( dirname(__FILE__) . "/class.OneLineTableElement.php" );
include_once( dirname(__FILE__) . "/class.InputTextElement.php" );
include_once( dirname(__FILE__) . "/class.FormElement.php" );


class PagedTableElement extends TableElement {
	var $mo_DataSourceLink; // link to data source
	var $ma_Steps;          // array of steps 
	var $mi_Step;        //    
	var $mi_Total;
	var $mi_Start;
	var $ms_NeedSearch; // if TRUE - then search box is needed
	var $ms_Search; // search string
	
	function PagedTableElement ( $po_DataSourceLink, $pa_FormAttributes=array(), $pa_TableAttributes=array() ) {

		$laEmptyAttr = array();	
		
		$la_Arguments = func_get_args();
		$lo_DataSourceLink = array_shift($la_Arguments); // first argument is link to data source
		array_shift($la_Arguments);

		$this->TableElement(array("class"=>"PagedTable"));
		$this->mo_DataSourceLink = new AElement($laEmptyAttr);
		$this->ma_Steps=$laEmptyAttr;
		
		$loRow =& $this->AppendRow($laEmptyAttr);
		$loComp = new CompoundElement();
		$loComp->SetSeparator('&nbsp;&nbsp;&nbsp;');
		$loForm = new FormElement ( array(), $loComp );
		$loRow->AppendCell( array(), "", $loForm );
		$loComp=new CompoundElement();
		$loComp->SetSeparator('&nbsp;');
		$loRow->AppendCell( array("align"=>"right"),"",$loComp);
		
		$loRow =& $this->AppendRow($laEmptyAttr);
		$loTable=new TableElement($laEmptyAttr);
		call_user_func_array( array( &$loTable, "TableElement" ), $la_Arguments );
		$loForm = new FormElement ( $pa_FormAttributes, $loTable );
		$loRow->AppendCell( array("colspan"=>2), "", $loForm );
		
		$loRow =& $this->AppendRow($laEmptyAttr);
		$loTable = new OneLineTableElement($laEmptyAttr);
		$loRow->AppendCell( array("align"=>"left","valign"=>"top"),"",$loTable);
	
		$this->SetDataSource($lo_DataSourceLink);
		$this->SetSteps(array("5"=>"5","10"=>"10","25"=>"25","50"=>"50"));
		$this->SetParams(array("start"=>0,"total"=>0,"step"=>25));
		$this->SetNeedSearch(FALSE);
		$this->SetSearchAttributes( array( "method"=>"get", "name"=>"pagedsearchform" ) );
	
	}

//--------------- get content ---------------------	
	function &GetStepsBox(){
		
		$loRow =& $this->GetContent(0);
		$loCell =& $loRow->GetContent(1);
		if(is_object($loCell)){
			return $loCell->GetContent(0);
		}else{
			echo "error: PagedTableElement.GetStepsBox: object not found<br>\n";
			prnit_r($this);
			echo "<br>\n";
			return null;
		}	
	}

	function &GetSearchForm() {
		$loRow =& $this->GetContent(0);
		$loCell =& $loRow->GetContent(0);
		return $loCell->GetContent(0);
	}

	function &GetSearchBox() {
		$loForm =& $this->GetSearchForm();
		return $loForm->GetContent(0);
	}

	function &GetMainForm() {
		$loRow =& $this->GetContent(1);
		$loCell =& $loRow->GetContent(0);
		return $loCell->getContent(0);
	}

	function &GetTable(){
		$loForm =& $this->GetMainForm();
		return $loForm->getContent(0);
	}
	
	function &GetPrevNextTable(){
		$loRow =& $this->GetContent(2);
		$loCell =& $loRow->GetContent(0);
		return $loCell->GetContent(0);
	}
	
	function &GetPrevNextRow(){
		$loTable =& $this->GetPrevNextTable();
		return $loTable->GetRow();
	}
	
	
	
//-------------- end get content	-----------------

//---------------- Data Source ---------------------	
	
	function &SetDataSource( $pm_DataSourceLink){
		if(is_object($pm_DataSourceLink)){
			$this->mo_DataSourceLink = $po_DataSourceLink;
		}elseif(is_string($pm_DataSourceLink)){
			$this->mo_DataSourceLink->SetAttribute('href',$pm_DataSourceLink);
		}	
//
// remake links		
//
		$this->makeSteps();
		$this->makePrevNext();
//
// end remake links
//		
		return $this->mo_DataSourceLink;
	}	
	
	function &GetDataSource(){
		return $this->mo_DataSourceLink;
	}

//----------- end Data Source ------------------------------- 	





	/* -------------------- search box/form -------------------- */
	function GetNeedSearch() {
		return $this->ms_NeedSearch;
	}

	function SetNeedSearch ( $ps_NeedSearch ) {
		$this->ms_NeedSearch = $ps_NeedSearch;
		if ( !$ps_NeedSearch ) {
			$lo_Cell =& $this->GetSearchBox();
			$lo_Cell->ClearContent();
			$this->SetSearch( "" );
		}
		else {
			$lo_Cell =& $this->GetSearchBox();
			$lo_Cell->ClearContent();
			$lo_Cell->AppendToContent( new InputTextElement( array( "name"=>"search", "value"=>$_GET["search"] ) ) );
			$lo_Cell->AppendToContent ( new AElement ( array( "href"=>"javascript:document.pagedsearchform.submit()" ),
						new HTMLElement(ltext("ll_search")) ) );
			$this->SetSearch( $_GET["search"] );
		}
	}

	function SetSearch ( $ps_Search ) {
		$this->ms_Search = $ps_Search;
		$this->makeSteps();
		$this->makePrevNext();
	}

	function GetSearch() {
		return $this->ms_Search;
	}

	function SetSearchAttributes( $pa_Attributes ) {
		$lo_Form =& $this->GetSearchForm();
		$lo_Form->SetAttributes ( $pa_Attributes );
	}
	/* -------------------- end search box/form -------------------- */





//----------- Set of steps ---------------------------------
	function &GetSteps(){
		return $this->ma_Steps;	
	}
	function SetSteps($pa_Steps){
		$this->ma_Steps = $pa_Steps;
		
		$this->makeSteps();
		}

	function makeSteps(){
		$loStepsBox =& $this->GetStepsBox();
		if(is_object($loStepsBox)){
			$loStepsBox->ClearContent();
			$loStepsBox->AppendToContent(new HTMLElement(ltext("ll_perpage")));
			$ls_Current = $this->GetStep();
			foreach( $this->ma_Steps as $liStep=>$lcLabel )
				if( $ls_Current == $liStep )
					$loStepsBox->AppendToContent( new HTMLElement($lcLabel) );
				else {
					$lo_Link = $this->mo_DataSourceLink->getClone("step=$liStep&start=0&search=".
							urlencode($this->GetSearch()));
					$lo_Link->SetContent(array(new HTMLElement($lcLabel)));
					$loStepsBox->AppendToContent($lo_Link);
				}
		}else{
			echo "error: PagedTableElement.makeSteps: object not found<br>\n";
			print_r($this);
			echo "<br>\n";
		}
	}
//----------- end Set of steps ------------------------------------
	
//-------- Start, Step, Total -------------------------------------
	function GetStart(){
		return $this->mi_Start;	
	}
	
	function GetTotal(){
		return $this->mi_Total;	
	}

	function GetStep(){
		return $this->mi_Step;	
	}

	function SetParams($pm_StartParams,$pi_Step=null,$pi_Total=null){
		
		global $DEBUG;
			
		if (is_array($pm_StartParams)){
			if (is_integer($pm_StartParams["start"])){
				$this->mi_Start=$pm_StartParams["start"];
			}
			if (is_integer($pm_StartParams["step"])){
				$this->mi_Step=$pm_StartParams["step"];
			}
			if (is_integer($pm_StartParams["total"])){
				$this->mi_Total=$pm_StartParams["total"];
			}
		}else{
			if(is_numeric($pm_StartParams)){
				$this->mi_Start=$pm_StartParams;
			}
			if(is_numeric($pi_Step)){	
				$this->mi_Step=$pi_Step;
			}
			if(is_numeric($pi_Total)){	
				$this->mi_Total=$pi_Total;
			}	
		}
		
		$this->makeSteps();
		$this->makePrevNext();
		
	}
	
	function makePrevNext(){
		
		global $DEBUG;
		
		$loPrevNextTable = &$this->GetPrevNextTable();
		$loPrevNextTable->ClearRowContent();
		$loDSLink =& $this->mo_DataSourceLink;
		$laCellAttr = array();
		
		if($this->mi_Start>0){
			
			$lo_Link = $loDSLink->getClone("prev=".$this->mi_Step."&start=".$this->mi_Start."&page=".intval($this->mi_Start/$this->mi_Step - 1)."&search=".
					urlencode($this->GetSearch()));
			
			
			$lo_Label = new HTMLElement('&lt;&lt;');
			$lo_Link->SetContent(array($lo_Label));

			$loPrevNextTable->AppendCell($laCellAttr,"",
				new ButtonURLElement($lo_Label->GetHTML(),$lo_Link->GetAttribute('href')));
		}
		if($this->mi_Start+$this->mi_Step < $this->mi_Total){
			$lo_Link = $loDSLink->getClone("next=".$this->mi_Step."&start=".$this->mi_Start."&page=".intval(1 + $this->mi_Start/$this->mi_Step)."&search=".
					urlencode($this->GetSearch()));
			$lo_Label = new HTMLElement('&gt;&gt;');
			$lo_Link->SetContent(array($lo_Label));

			$loPrevNextTable->AppendCell($laCellAttr,"",
				new ButtonURLElement($lo_Label->GetHTML(),$lo_Link->GetAttribute('href')));
		}
		if($loPrevNextTable->CountRowContent()>0){
			$lo_Link = $loDSLink->getClone("step=".$this->mi_Step."&search=".urlencode($this->GetSearch())."&start=");
			$newLocation = $lo_Link->GetAttribute('href');
			$lo_Sel = new SelectElement( array("onChange"=>"javascript:window.location='$newLocation'+this.value+'&page='+this.value/$this->mi_Step") );
			for($i=0; $i<$this->mi_Total; $i+=$this->mi_Step){
				$start = $i+1;
				$stop = $i+$this->mi_Step;
				if($stop>$this->mi_Total){
					$stop=$this->mi_Total;
				}
				$ls_Value = sprintf("%4d - %4d",$start,$stop);
				$ls_Value=str_replace(' ','&nbsp;',$ls_Value);
				$ll_selected = (($this->mi_Start+1>=$start) && ($this->mi_Start<$stop));
				
				$lo_Sel->AppendToContent( new OptionElement( 
					$ll_selected ? array( "value" => $i,"selected"=>NULL ) : array( "value" => $i ), 
					$ls_Value ) 
				);					
			}
			$loPrevNextTable->AppendCell($laCellAttr,"",$lo_Sel);
		}
		
	}

//-------- end  Start, Step, Total -------------------------------------	
	
}	
?>
