<?
include_once( 'class.CompoundElement.php' );
include_once( 'class.DivElement.php' );

class SetOfButtonElement extends CompoundElement {

	var $maDivAttributes;

	function SetOfButtonElement( $paContent = NULL ){
		if( !is_array( $paContent ) ) {
			$paContent = func_get_args();
		}
		$this->CompoundElement( $paContent );
		$this->maDivAttributes =  array('class' => 'formArea' );
	}

	function &GetDIvAttributes(){
		return $this->maDivAttributes;
	}
	
	function &SetDivAttributes( &$paAttributes ){
		if( is_array( $paAttributes ) ) {
			$this->maDivAttributes = $paAttributes;
		}
		return $this->maDivAttributes;
	}

	function DivAttribute( $pcKey, $pcValue = NULL){
		if( is_null( $pcValue ) ) {
			if( array_key_exists( $pcKey, $this->maDivAttributes )){
				return $this->maDivAttributes[$pcKey];
			} else {
				return NULL;
			}
		} else {
			$this->maDivAttributes[$pcKey] = $pcValue;
			return $this->maDivAttributes[$pcKey];
		}
	}

	function GetContentHTML() {

		$la_Result = array();
		foreach( $this->GetContent() as $lo_Element )
			$la_Result[] = $lo_Element->GetHTML( 'withoutDiv' );

		return implode( $this->GetSeparator(), $la_Result );
	}

	function printContentHTML(){
		$laContent =& $this->GetContent();
		$lcSep = $this->GetSeparator();
		$liRet = 0;
		foreach( $laContent as $loElement ){
			if( $liRet ){
				echo $lcSep;
			}
			$liRet += $loElement->printHTML( 'withoutDiv' );
		}
		return $liRet;
	}

	function GetHTML() {
		$loRet = new DivElement( $this->GetDivAttributes(), $this->GetContentHTML() );

		return $loRet->GetHTML();
	}

	function printHTML(){
		$loRet = new DivElement( $this->GetDivAttributes(), $this->GetContentHTML() );
		return $loRet->printHTML();
	}

}
?>