<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.Element.php" );


$gaAttrTranslate  = get_html_translation_table( HTML_SPECIALCHARS );

# don't translate &,',<
unset( $gaAttrTranslate['&'] );
unset( $gaAttrTranslate["'"] );
unset( $gaAttrTranslate['<'] );


class TagElement extends Element {

	/* -------------------- Members -------------------- */
	var $ms_Tag; // tag of element
	var $ma_Attributes; // attributes of element
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function TagElement ( $ps_Tag, $pa_Attributes ) {
		$this->Element();
		$this->SetTag ( $ps_Tag );
		$this->ma_Attributes = array();
		$this->SetAttributes ( $pa_Attributes );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Set.../Get... & related -------------------- */
	function SetTag( $ps_Tag ) {
		$this->ms_Tag = $ps_Tag;
	}

	function GetTag() {
		return $this->ms_Tag;
	}

	function SetAttributes( $pa_Attributes ) {
		global $DEBUG;
		if( is_array( $pa_Attributes ) ) {
			$this->ma_Attributes = $pa_Attributes;
		} else {
			if($DEBUG){
				echo "TagElement::SetAttributes: wrong type of argument (should be an array):<br>";
				echo get_class($this)."<br><pre>\n";
				print_r( $pa_Attributes );
				echo "</pre><hr>\n";
			}
		}
	}

	function &GetAttributes() {
		return $this->ma_Attributes;
	}

	function AppendAttributes( $pa_Attributes ) {
		$this->SetAttributes( array_merge( $this->GetAttributes(), $pa_Attributes ) );
	}
	
	function GetAttribute($ps_Name){
		return array_key_exists( $ps_Name, $this->ma_Attributes ) ? $this->ma_Attributes[$ps_Name] : NULL;
	}

	function UnsetAttribute( $ps_Name ) {
		if( array_key_exists( $ps_Name, $this->ma_Attributes ) )
			unset( $this->ma_Attributes, $ps_Name );
	}
	
	function SetAttribute($ps_Name,$pm_Value){
		$this->ma_Attributes[$ps_Name]=$pm_Value;
		return $this->ma_Attributes[$ps_Name];
	}
	/* -------------------- end Set.../Get... & related -------------------- */





	/* -------------------- GetHTML & related -------------------- */
	function GetAttributesHTML () {
		global $DEBUG;
		global $gaAttrTranslate;

		$la_Result = array( '' ); // first space

		foreach ( $this->GetAttributes() as $ls_Key => $ls_Value ){
			if( is_null( $ls_Value ) ){
				$la_Result[] = $ls_Key;
			} else {
				$la_Result[] = $ls_Key.'="'.strtr( $ls_Value, $gaAttrTranslate ).'"';
			}
		}
		$la_Result[] = ''; // add last space
		return join( ' ', $la_Result );
	}

	function GetHTML() {
		return "<" . $this->GetTag() . $this->GetAttributesHTML() . ">";
	}
	/* -------------------- end GetHTML & related -------------------- */
	
	function propID( $psID = NULL ){
		if( !is_null( $psID ) ) {
			$this->SetAttribute( 'id' );
		}
		return $this->GetAttribute( 'id' );
	}
	
	function propClass( $psClass = NULL ){
		if( !is_null( $psClass ) ) {
			$this->SetAttribute( 'class' );
		}
		return $this->GetAttribute( 'class' );
	}

	function propTitle( $psTitle = NULL ){
		if( !is_null( $psTitle ) ) {
			$this->SetAttribute( 'title' );
		}
		return $this->GetAttribute( 'title' );
	}


}
?>
