<?php

include_once( '../functions.inc.php' );
include_once( 'class.SQLFieldSet.php' );
include_once( '../events.inc.php' );

function eventAdd( $obj_type, $event_type, 
									 $obj=NULL, $server_id=NULL ){

  global $DEBUG;
  global $ServerID;
  if( ! $server_id ){
    $server_id = $ServerID;
  }

	if( is_array( $obj_type ) ){
		$args =& $obj_type;
	}else{
		$args = array( 'object_type' => $obj_type,
									 'event_type' => $event_type
									 );
		if( is_numeric( $obj ) ){
			$args['object_id'] = $obj;
		}elseif( is_string( $obj ) && $obj ){
			$args['object_prop'] = $obj;
		}
	}

	foreach( array('type','id','prop') as $key ){
		$short_ind = 'obj_'.$key;
		$long_ind = 'object_'.$key;
		if(array_key_exists( $short_ind, $args ) ){
			$args[$long_ind] = $args[$short_ind];
		}
	}

	if( array_key_exists( 'server_id', $args ) ){
		$server_id = $args['server_id'];
	}

	if( ! is_string( $server_id ) ){
		$server_id = $ServerID;
	}

	if( ! ( array_key_exists( 'object_type', $args) && 
					array_key_exists('event_type', $args ) ) ){
		return 0;
	}
	if( ! ( is_numeric( $args['object_type'] ) &&
					is_numeric( $args['event_type'] )	) ){
		return 0;
	}

	$loWhere = new SQLFieldSet( array( 'server_id' => array($server_id,'C'),
																		 'object_type' => $args['object_type'],
																		 'event_type' => $args['event_type']
																		 ) 
															); 
	if( array_key_exists('object_id',$args) && 
			is_numeric( $args['object_id'] ) ){
		$loWhere->addField( 'object_id', $args['object_id'] );

	}elseif( array_key_exists('object_prop', $args ) && 
					 $args['object_prop'] ){
		$loWhere->addField( 'object_prop', $args['object_prop'], 'C' );
	}

	$sql = "SELECT id FROM events WHERE ".$loWhere->getSQLWhere();
	$id = db_query( $sql );

  if( db_num_rows( $id ) > 0){ 
    list( $event_id ) = db_fetch_array( $id, 'N');
	}
	db_free_query( $id );

	if( $event_id){

		$loWhere = new SQLFieldSet( array( 'server_id' => array($server_id,'C'),
																			 'id' => $event_id )
																);
		$sql = "UPDATE events SET count=count+1 WHERE ".$loWhere->getSQLWhere();;

  }else{

		list( $lcFlds,$lcVals) = $loWhere->getSQLInsert();

    $sql = "INSERT INTO events( $lcFlds ) VALUES ( $lcVals )";
  }

	return db_query( $sql );
}

function eventGet( $obj_type, $event_type, $obj=NULL, $server_id = NULL ){
	global $ServerID;
	global $DEBUG;

	if( ! $server_id ){
		$server_id = $ServerID;
	}

	if( is_array( $obj_type ) ){
		$args =& $obj_type;
	}else{
		$args = array( 'object_type' => $obj_type,
									 'event_type' => $event_type
									 );
		if( is_numeric( $obj ) ){
			$args['object_id'] = $obj;
		}elseif( is_string( $obj ) && $obj ){
			$args['object_prop'] = $obj;
		}
	}

	foreach( array('type','id','prop') as $key ){
		$short_ind = 'obj_'.$key;
		$long_ind = 'object_'.$key;
		if(array_key_exists( $short_ind, $args ) ){
			$args[$long_ind] = $args[$short_ind];
		}
	}

	if( array_key_exists( 'server_id', $args ) ){
		$server_id = $args['server_id'];
	}

	if( ! is_string( $server_id ) ){
		$server_id = $ServerID;
	}

	if( ! ( array_key_exists( 'object_type', $args) && 
					array_key_exists('event_type', $args ) ) ){
		return 0;
	}
	if( ! ( is_numeric( $args['object_type'] ) &&
					is_numeric( $args['event_type'] )	) ){
		return 0;
	}
	$loWhere = new SQLFieldSet( array( 'server_id' => array($server_id,'C'),
																		 'object_type' => $args['object_type'],
																		 'event_type' => $args['event_type']
																		 ) 
															); 
	if( array_key_exists('object_id',$args) && 
			is_numeric( $args['object_id'] ) ){
		$loWhere->addField( 'object_id', $args['object_id'] );

	}elseif( array_key_exists('object_prop', $args ) && 
					 $args['object_prop'] ){
		$loWhere->addField( 'object_prop', $args['object_prop'], 'C' );
	}
	$sql = "SELECT * FROM events WHERE ".$loWhere->getSQLWhere();
	$id = db_query( $sql );

  if( db_num_rows( $id ) > 0){ 
		$ret = db_fetch_array( $id );
	}else{
		$ret = 0;
	}
	db_free_query( $id );

	return $ret;
}
?>
