<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/../class.Validatable.php" );
include_once ( dirname(__FILE__) . "/../module.Database.php" );





class AbstractLimit extends Validatable
{

    /* -------------------- Members -------------------- */
    var $ms_Value; // value of limit
    var $ms_Name; // name of limit, used for name of field
    var $ma_Names; // names of limit, different names are used for different tables
    var $ms_Label; // label
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function AbstractLimit ( $ps_Label, $ps_Name, $ps_Value, $pa_Names=array() )
    {
	$this->Validatable();

	$this->SetValue ($ps_Value);
	$this->SetName ($ps_Name);
	$this->SetLabel ($ps_Label);
	$this->SetNames ( $pa_Names, $this->GetName() );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- Get... -------------------- */
    function GetValue()
    {
	return $this->ms_Value;
    }

    function GetName()
    {
	return $this->ms_Name;
    }

    function GetLabel()
    {
	return $this->ms_Label;
    }

    function GetNameForTable ( $ps_Table )
    {
	return array_key_exists( $ps_Table, $this->ma_Names ) ? $this->ma_Names[$ps_Table] : "";
    }

    function GetHiddenHTML()
    {
	return "<input type=hidden name=\"" . htmlspecialchars($this->GetName()) . "\" value=\"" .
		htmlspecialchars($this->GetValue()) . "\">\n";
    }
    /* -------------------- end Get... -------------------- */





    /* -------------------- Set... -------------------- */
    function SetValue ( $ps_Value )
    {
	$this->ms_Value = $ps_Value;
    }

    function SetName ( $ps_Name )
    {
	$this->ms_Name = $ps_Name;
    }

    function SetLabel ( $ps_Label )
    {
	$this->ms_Label = $ps_Label;
    }

    function SetNames ( $pa_Names, $ps_Default )
    {
	$this->ma_Names = $pa_Names;
	$la_Tables = array( "admin", "anbieter", "angebote", "kunden", "regrequest" );
	foreach ( $la_Tables as $ls_Table )
	    if ( ! array_key_exists($ls_Table,$this->ma_Names) )
		$this->ma_Names[$ls_Table] = $ps_Default;
    }

    function SetFromRow ( $pa_Row, $ps_Table = NULL )
    {
	$ls_Name = is_null($ps_Table) ? $this->GetName() : $this->GetNameForTable ($ps_Table);
	$this->SetValue ( array_key_exists($ls_Name,$pa_Row) ? $pa_Row[$ls_Name] : NULL );
    }
    /* -------------------- end Set... -------------------- */





    /* -------------------- AdminAllowed -------------------- */
    function AdminAllowed ( $pa_Data=NULL )
    {
      global $ServerID;
      
	$ls_Name = $this->GetNameForTable("admin");
	if ( is_null($pa_Data) || !array_key_exists($ls_Name,$pa_Data) )
	{
	    $lo_DB =& get_db_connection ();
	    $lo_Query =& $lo_DB->Select ( "SELECT * FROM admin WHERE server_id='$ServerID'" );
	    $pa_Data =& $lo_Query->nextrow();
	}
	return array_key_exists($ls_Name,$pa_Data) && $pa_Data[$ls_Name];
    }
    /* -------------------- end AdminAllowed -------------------- */





    /* -------------------- methods to extract data from DB -------------------- */
    function GetData ( $ps_TableName, $ps_FieldName, $ps_User )
    {
      global $ServerID;
      
	if ( is_null($ps_User) )
	    return array();
	$lo_DB =& get_db_connection();
	$lo_Query =& $lo_DB->Select ( "SELECT * FROM $ps_TableName WHERE server_id='$ServerID' AND $ps_FieldName=".db_full_quote($ps_User) );
	$la_Data =& $lo_Query->nextrow();
	return $la_Data ? $la_Data : array();
    }

    function GetResellerData ( $ps_Reseller )
    {
	return $this->GetData ( "anbieter", "anbieter", $ps_Reseller );
    }

    function GetUserData ( $ps_User )
    {
	return $this->GetData ( "kunden", "kunde", $ps_User );
    }
    /* -------------------- end methods to extract data from DB -------------------- */





    /* -------------------- ...CanHave -------------------- */
    function ResellerCanHave ( $pa_Data=NULL )
    {
	return ! is_null( $this->GetNameForTable("anbieter") ) && $this->AdminAllowed ( $pa_Data );
    }

    function UserCanHave ( $pa_Data=NULL, $ps_Reseller=NULL )
    {
	return ! is_null( $this->GetNameForTable("kunden") ) && $this->ResellerAllowed( $pa_Data, $ps_Reseller );
    }

    function TemplateCanHave ( $pa_Data=NULL, $ps_Reseller=NULL )
    {
	return ! is_null( $this->GetNameForTable("angebote") ) && $this->ResellerAllowed( $pa_Data, $ps_Reseller );
    }
    /* -------------------- end ...CanHave -------------------- */





    /* -------------------- "abstract" methods -------------------- */
    function ResellerAllowed ( $pa_Data=NULL, $ps_Reseller=NULL )
    {
	echo ( "method ResellerAllowed should return TRUE or FALSE" );
    }

    function UserAllowed ( $pa_Data=NULL, $ps_User=NULL )
    {
	echo ( "method UserAllowed should return TRUE or FALSE" );
    }

    function GetHTML ()
    {
	echo ( "method GetHTML should return HTML" );
    }

    function GetStatHTML ()
    {
	echo ( "method GetStatHTML should return HTML for statistics" );
    }
    /* -------------------- end "abstract" methods -------------------- */

}
?>
