<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once ( dirname( __FILE__ ) . "/../module.Database.php" );
include_once ( dirname( __FILE__ ) . "/../class.SQLFieldSet.php" );

class EmailConnect {

	/* -------------------- Members -------------------- */
	var $mrMBox;
	var $mcProtocol;
	var $mcUser;
	var $mcPassword;
	var $mcHost;
	var $mcPort;
	var $mcFolder;
	var $miErrors; 
	var $mcOptions;
	var $mcFolderSeparator;
	var $mcFolderPrefix;
	
	/* -------------------- end Members -------------------- */

	/* -------------------- Constructor -------------------- */
	function EmailConnect( $pcUser, $pcPassword, $pcProtocol = 'pop3', $pcHost = 'localhost', 
	                       $pcPort = '110', $pcFolder = 'INBOX' ){

		global $DEBUG;
		
    $this->Protocol( $pcProtocol );
		$this->User( $pcUser );
		$this->Password( $pcPassword );
		$this->Host( $pcHost );
		$this->Port( $pcPort );
		$this->Folder( $pcFolder );
		$this->FolderPrefix( '' );
		$this->FolderSeparator( '' );
		$this->getOptions();
		$this->miErrors = 0;

		if( $pcProtocol && $pcUser && $pcPassword && $pcHost && $pcPort && $pcFolder ){
 			$this->getNamespace();
			$this->connect();
			if( !$this->MBox() ){
  		  
			  $laOptions = array( '', '/notls/novalidate-cert', '/notls', '/novalidate-cert' );
  		  
  		  foreach( $laOptions as $lcOption ){
  		  	if( $this->connect( $lcOption ) ){
    				$this->Options( $lcOption );
    				$this->saveOptions();
    				break;	
  			  }	                     
  		  }
      }
		}
		if( $DEBUG ){
			echo "EmailConnect::EmailConnect<br><pre>\n";
			var_dump($this);
			echo "</pre><hr>\n";
		}
	}
	
	/* -------------------- Set / Get methods -------------------- */
	
	function &Host( $pcHost = NULL ){
		if( is_string( $pcHost) ){
			$this->mcHost = $pcHost;
		}
		return $this->mcHost;
	}

	function &Folder( $pcFolder = NULL ){
		if( is_string( $pcFolder ) ){
			$this->mcFolder = $pcFolder;
		}
		return $this->mcFolder;
	}

	function &Protocol( $pcProtocol = NULL ){
		if( is_string( $pcProtocol ) ){
			$this->mcProtocol = $pcProtocol;
		}
		return $this->mcProtocol;
	}

  function isPop3(){
    if( strtolower( $this->mcProtocol ) == 'pop3' ){
			return true;
		}
		return false;
	}

  function isImap(){
    if( strtolower( $this->mcProtocol ) == 'imap' ){
			return true;
		}
		return false;
	}

	function &Port( $pcPort = NULL ){
		if( ! is_null( $pcPort) ){
			$this->mcPort = $pcPort;
		}
		return $this->mcPort;
	}

	function &User( $pcUser = NULL ){
		if( is_string( $pcUser) ){
			$this->mcUser = $pcUser;
		}
		return $this->mcUser;
	}

	function &Password( $pcPass = NULL ){
		if( is_string( $pcPass) ){
			$this->mcPassword = $pcPass;
		}
		return $this->mcPassword;
	}

	function &Options( $pcOptions = NULL ){
		if( is_string($pcOptions) ){
			$this->mcOptions = $pcOptions;
		}
		return $this->mcOptions;
	}
	
	function &FolderSeparator( $pcFolderSeparator = NULL ){
		if( is_string( $pcFolderSeparator) ){
			$this->mcFolderSeparator = $pcFolderSeparator;
		}
		return $this->mcFolderSeparator;
	}
	
	function &FolderPrefix( $pcFolderPrefix = NULL ){
		if( is_string( $pcFolderPrefix) ){
			$this->mcFolderPrefix = $pcFolderPrefix;
		}
		return $this->mcFolderPrefix;
	}
	
	function &fullFolderPrefix( ){
		return $this->mcFolderPrefix.( $this->mcFolderPrefix ? $this->mcFolderSeparator : '' );
	}
	
	function &MBox( $prMBox = NULL ){
		if( is_resource($prMBox) ){
			$this->mrMBox = $prMBox;
		}
		return $this->mrMBox;
	}
	
	function getNamespace( ){
	  global $ServerID;
	  global $DEBUG;
    
    $laNameSpaces = array();
    $laPersonalNameSpace = array();
    
	  if( strtolower( $this->mcProtocol ) != 'imap' ){
	  	return false;
	  }
	  
	  if( ! strlen( $this->mcFolderSeparator ) ){
	  
  	  $lrFp = null;

      //open socket connection
	    $lrFp = @fsockopen($this->mcHost, $this->mcPort, $liErrno, $lcErrstr, 10);
	   
      
	    if( !$lrFp ){
        $this->miErrors = 3;
  		  return false;
	    }
	    
			$lcResponse = fgets( $lrFp, 2048 );
			$laTmp = explode( " ", $lcResponse );
			$lcResponseStatus = $laTmp[1]; 
      
			if( $lcResponseStatus !== 'OK' ){
      	return  false;
      }
      if( $DEBUG ){
        echo "<br><pre>";
    		var_dump( "Connect to server" );
    		var_dump( $lcResponseStatus );
    		echo "</pre>";	
      }
  		
      fputs( $lrFp, "a001 LOGIN ".$this->mcUser." \"".$this->mcPassword."\"\r\n" );

      $lcResponse = fgets( $lrFp, 2048 );
			$laTmp = explode( " ", $lcResponse );
			$lcResponseStatus = $laTmp[1]; 
      
			if( $lcResponseStatus !== 'OK' ){
      	return  false;
      }
      
      if( $DEBUG ){
        echo "<br><pre>";
    		var_dump( "a001 LOGIN ".$this->mcUser." \"".$this->mcPassword."\"\r\n" );
    		var_dump( $lcResponseStatus );
    		echo "</pre>";	
      }
	
    	fputs( $lrFp, "a002 NAMESPACE\r\n" );

      $lcResponse = fgets( $lrFp, 2048 );
      
      if( $DEBUG ){
        echo "<br><pre>";
    		var_dump( "a002 NAMESPACE\r\n" );
    		var_dump( $lcResponse );
    		echo "</pre>";	
      }

       $namespace_array = array(
                1 => 'personal',
                2 => 'others',
                3 => 'shared'
            );

        /*
         * According to rfc2342 response from NAMESPACE command is:
         * * NAMESPACE (PERSONAL NAMESPACES) (OTHER_USERS NAMESPACE) (SHARED NAMESPACES)
         */

      if( eregi('\\* NAMESPACE +(\\( *\\(.+\\) *\\)|NIL) +(\\( *\\(.+\\) *\\)|NIL) +(\\( *\\(.+\\) *\\)|NIL)', $lcResponse, $data ) ) 
      {
        for( $i = 1; $i <= 3; $i++ ){
          if( $data[$i] == 'NIL' ){
            continue;
          }
          $pna = explode(')(', $data[$i]);
          
          while( list($k, $v ) = each( $pna ) ){
            $lst = explode('"', $v);
            $delimiter = ( isset( $lst[3] ) ) ? $lst[3] : '';
            $laNameSpaces[$lst[1]] = array( 'name'      => $lst[1], 
                                            'delimiter' => $delimiter, 
                                            'type'      => $namespace_array[$i], 
                                            'hidden'    => false );
          }
        }
      }
      
      $laPersonalNameSpace = reset( $laNameSpaces );
 
  		$this->FolderPrefix( $laPersonalNameSpace['name'] 
                           ? substr( $laPersonalNameSpace['name'], 0, -1)
                           : "" );
  		$this->FolderSeparator( $laPersonalNameSpace['delimiter'] );

      fputs( $lrFp, "I LOGOUT\r\n" );
      fclose( $lrFp );
		  $lrFp = null;
		  
		  if( $DEBUG ){
        echo "<br><pre>";
    		var_dump( $this );
    		echo "</pre>";	
      }
      $this->saveOptions();
      return true;
	  } 
	}
	
	function getOptions( ){
	  global $master_confixx;
    global $ServerID;
	  
	  $loDB =& get_db_connection();
		
		$loQuery =& $loDB->Select ( "SELECT imap_options FROM admin WHERE server_id='$ServerID'" );
		if( $laData  =& $loQuery->nextrow() ){
		  list( $this->mcOptions, $this->mcFolderPrefix, $this->mcFolderSeparator ) = explode( '|', $laData['imap_options'] );
		  return true;
		}else{
      return false;		  
		}
  }

  function saveOptions( ){
    global $master_confixx;
    global $ServerID;
	  
	  $loDB =& get_db_connection();
	  
		$options = implode( array( $this->mcOptions, $this->mcFolderPrefix, $this->mcFolderSeparator ), '|' );
		
    $loImap = new SQLField( 'imap_options', $options,'C' );
  	$lcSQL = "UPDATE admin SET ".$loImap->getSQLUpdate()." WHERE server_id='$ServerID'";
  	$loDB->Execute ( $lcSQL );
  	return true;
  }
	
/* -------------------- end of Set / Get methods -------------------- */
/**
 * Return error message according to error number
 * 	0 - No errors
 * 	1 - No IMAP library
 * 	2 - Bad connection 
 * 	
 * @return string $lcMessage
 */
	function &Errors( ){
    $lcMessage = '';
  	  switch ( $this->miErrors ){
  	    case 1:
  	      $lcMessage = ltext( 'wmail_noimap' );
  	      break;
  	    case 3:
  	    case 2:
  	      $lcMessage = ltext( 'wmail_pop3' );
  	      break;
  	    case 0:
  	    default:
   	      $lcMessage = 'No errors';
  	      break;
  	  }
  	  
		return $lcMessage;
	}


	function connect( $pcOptions = null ){
	  global $mbox;
  	global $master_confixx;
  	global $ServerID;
  	global $DEBUG;

  	if( !extension_loaded( 'imap' ) ){
  		$this->miErrors = 1;  	  
    	return false;
  	}
  	
  	if( is_string( $pcOptions ) ){
  		$this->Options( $pcOptions );
  	}
  	
	  $lcStrConn ='{'.$this->mcHost.':'.$this->mcPort.'/'.$this->mcProtocol.$this->mcOptions.'}';
    if( $this->fullFolderPrefix() 
          && strpos( $this->mcFolder, $this->fullFolderPrefix() ) !== 0 
          && strtolower( $this->mcFolder ) != 'inbox' ){
      $lcStrConn .= $this->fullFolderPrefix();
    }
    $lcStrConn .= $this->mcFolder;
    
    if( $DEBUG ){
      echo "<br><pre>";
      var_dump($lcStrConn);
      echo "</pre>";
    }
    
   $loDB =& get_db_connection();
	
   $loQuery =& $loDB->Select( "SELECT newpwd FROM allgemein WHERE server_id='$ServerID'" );
	 $laData  =& $loQuery->nextrow();

	  if( $laData['newpwd'] && $lcPass = getUserParam( $this->mcUser, 'old_password' ) ){
      $mbox = @imap_open( $lcStrConn, $this->mcUser, $lcPass );
  		$this->MBox( $mbox );
    	return $this->mrMBox;
  	} elseif( $mbox = @imap_open( $lcStrConn, $this->User(), $this->Password())){
  		delUserParam( $this->mcUser, 'old_password');
  		$this->MBox( $mbox );
    	return $this->mrMBox;
  	}else {
      $this->miErrors = 2;  	  
    	return false;
  	}
	}

	function disconnect() {
	  global $mbox;
	  
		imap_close($this->mrMBox);
		$this->mrMBox = $mbox = null;
		return true;
	}
	
}

/* -------------------- Factory -------------------- */

function &getEmailConnect( $pcFolder = 'INBOX' ){
	global $incomingMailPort;
	global $PHP_AUTH_USER;
	global $PHP_AUTH_PW;
	global $incomingMailServer;
	global $incomingMailProtocol;
	
	$loConnect = new EmailConnect( $PHP_AUTH_USER, $PHP_AUTH_PW, $incomingMailProtocol, $incomingMailServer, 
	                              $incomingMailPort, $pcFolder ); 
	return $loConnect;                    
}
/* -------------------- end of Factory -------------------- */

?>
