<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





/* -------------------- ff_ProcessTemplate -------------------- */
function ff_ProcessTemplate ( $ps_Reseller, $ps_Domain, $ps_IP, $ps_Serial, 
															&$ps_Template, &$ps_Primary, &$ps_Secondary,
															$server_id = NULL ){
  global $ServerID;

	if( is_array( $ps_Reseller ) ){
		list( $ps_Reseller, $server_id ) = $ps_Reseller;
	}

	if( ! $server_id  ){
		$server_id = $ServerID;
	}

	$loServerID = new SQLString( $server_id );

	$id = safe_query2( "SELECT dnstemplate,ip_pns,ip_sns FROM admin WHERE server_id=?",
										 $loServerID );
	$laAdmin = db_fetch_array( $id, 'A' );
	db_free_query( $id );


	if( is_null( $ps_Template ) || 
			is_null( $ps_Primary ) || 
			is_null( $ps_Secondary ) ){

		$loRes = new SQLString( $ps_Reseller );

		$id = safe_query2( "SELECT dnsspezial, pns, sns FROM anbieter ".
											 " WHERE server_id= ? AND anbieter = ?",
											 $loServerID, $loRes );

		$la_Row = db_fetch_array( $id, 'A' );
		db_free_query( $id );

		if ( is_null( $ps_Template ) ){
	    $ps_Template = $la_Row['dnsspezial'];
		}

		if ( is_null($ps_Primary) ){
	    $ps_Primary = $la_Row['pns'];
		}

		if ( is_null($ps_Secondary) ){
	    $ps_Secondary = $la_Row['sns'];
		}

		if( ! $ps_Template ){
			$ps_Template = $laAdmin['dnstemplate'];
		}
	}

	$ls_Zonefile = $ps_Template;
	$ls_Zonefile = str_replace ( "##domain##", $ps_Domain, $ls_Zonefile );

	$ls_Zonefile = preg_replace ( "/##ns1##\.?/", ff_AddDNSDot($ps_Primary), $ls_Zonefile );
	$ls_Zonefile = preg_replace ( "/##ns2##\.?/", ff_AddDNSDot($ps_Secondary), $ls_Zonefile );
	$ls_Zonefile = str_replace ( "##ip##", $ps_IP, $ls_Zonefile );

	$ls_PrimaryDomain = substr ( $ps_Primary, strpos( $ps_Primary, "." )+1 );
	$ls_SecondaryDomain = substr ( $ps_Secondary, strpos( $ps_Secondary, "." )+1 );

	if( $ls_SecondaryDomain == $ps_Domain ){

		$ls_Zonefile = ff_AddDNSDot($ps_Secondary) . "      86400  IN   A   " . $laAdmin['ip_sns'] . "\n" . $ls_Zonefile;

	}

	if ( $ls_PrimaryDomain == $ps_Domain ){
		$ls_Zonefile = ff_AddDNSDot($ps_Primary) . "      86400  IN   A   " . $laAdmin['ip_pns'] . "\n" . $ls_Zonefile;
	}

	$lcYmd = date( 'Ymd' );
	if( is_null( $ps_Serial ) ){
		$ls_Serial = $lcYmd."01";
	} else {
		$ls_Serial = substr ( $ps_Serial, 0, 8 );
		if ( $ls_Serial != $lcYmd ){
	    $ls_Serial = $lcYmd."01";
		}	else {
	    $ls_ID = substr ( $ps_Serial, -2 ) + 1;
	    $ls_Serial = $lcYmd.sprintf( "%02d", $ls_ID );
		}
	}

	return array( $ls_Zonefile, $ls_Serial );
}
/* -------------------- end ff_ProcessTemplate -------------------- */





/* -------------------- ff_AddDNSDot -------------------- */
function ff_AddDNSDot ( $ps_Name ){
    return preg_match( "/^(\d{1,3}\.){3}\d{1,3}$/", $ps_Name ) ? $ps_Name : $ps_Name.".";
}
/* -------------------- end ff_AddDNSDot -------------------- */
