<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





/* -------------------- ff_GetFromPostGet -------------------- */
function ff_GetFromPostGet ( $ps_Key )
{
    if ( $_SERVER["REQUEST_METHOD"] == "POST" && array_key_exists( $ps_Key, $_POST ) )
	return $_POST[$ps_Key];
    return array_key_exists( $ps_Key, $_GET ) ? $_GET[$ps_Key] : NULL;
}
/* -------------------- end ff_GetFromPostGet -------------------- */





/* -------------------- ff_AdjustURL -------------------- */
function ff_AdjustURL ( $ps_URL )
{
    if ( substr( $ps_URL, 0, 1 ) == "/" )
	return $ps_URL;
    if ( strpos( $ps_URL, "://" ) !== FALSE )
	return $ps_URL;
    return "http://" . $ps_URL;
}
/* -------------------- end ff_AdjustURL -------------------- */





/* -------------------- ff_RelativeRedirect -------------------- */
function ff_RelativeRedirect ( $ps_URL )
{
    header ( "Location: http://".$_SERVER['HTTP_HOST'].dirname($_SERVER['PHP_SELF'])."/$ps_URL" );
}
/* -------------------- end ff_RelativeRedirect -------------------- */

?>
