<?
########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

define('NONE',	0);
define('NOTE', 	1);
define('WARN', 	2);
define('ERROR', 3);

$informer_obj = NULL;	// global

class Informer
{
	var $messages = array();	// protected
	var $i_cur_mes = 0;			// protected
	
	function Informer() {
	}
	
	function addMessage(&$mes) {
		$this->messages[] = $mes;
	}

	function &nextMessage() {
		if ($this->i_cur_mes < sizeof($this->messages)) {
			return $this->messages[$this->i_cur_mes++];
		} 
		return false;
	}

	function numRecs() {
		return sizeof($this->messages);
	}
};

class Message
{
	var $type = NOTE;
	var $text = '';

	function Message($type, $text) {
		$this->type = $type;
		$this->text = $text;
	}

	function getType() {
		return $this->type;
	}

	function getText() {
		return $this->text;
	}
}

class InformerPresentation {

	var $infomer_obj = NULL;
	
	function InformerPresentation(&$informer_obj) {
		$this->informer_obj =& $informer_obj;
	}

	function show() {

		global $confixx_interface_version;

		if(!is_object($this->informer_obj) || $this->informer_obj->numRecs() == 0) {
			// nothing to show
			return true;
		}

		if( $confixx_interface_version != 'powp' ){
			echo "\n<hr noshade align=\"left\">\n<table>\n";
		}
		while ($message = $this->informer_obj->nextMessage()) {
			switch ($message->getType()) {
			case NOTE:
				$title_text = ltext('errtype_notice');
				$class = 'note_msg';
				break;
			case WARN:
				$title_text = ltext('errtype_warning');
				$class = 'warn_msg';
				break;
			case ERROR:
				$title_text = ltext('errtype_error');
				$class = 'error_msg';
				break;
			default:
				$title_text = ltext('errtype_notice');
				$class = 'note_msg';
			}
			$message_text = $message->getText();

			if( $confixx_interface_version == 'powp' ){
				echo "<fieldset class=\"$class\">\n<legend>$title_text</legend>\n";
				echo "<label>$message_text</label></fieldset>\n";

			} else {
				echo "<tr>\n<td class=\"inform_title\">$title_text</td>\n";
				echo "<td class=\"inform_message\" width=\"100%\">$message_text</td>\n</tr>\n";
			}
		}
		if( $confixx_interface_version != 'powp' ){
			echo "</table><hr noshade align=\"left\">\n";
		}	
		return true;
	}
}

function message($type, $text) {
	global $informer_obj;
	if (!is_object($informer_obj))
		$informer_obj = new Informer();
	$informer_obj->addMessage(new Message($type, $text));
	return true;
}

?>
