<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once('data_source/class.SQLQuery.php');

function checkMailList( $maillist, $domain_id=NULL, $user=NULL ){
	global $PHP_AUTH_USER;
  global $ServerID;
  global $DEBUG;
	
  if( !$maillist ){
		return array( NULL, ltext('ml_err_emptymaillist') );
	}

	$loUser = new SQLString( $user ? $user : $PHP_AUTH_USER );

  /**
   * Check ownership of maillist
   */
	if( is_numeric( $maillist ) ){
		$lcSQL = " SELECT ml.name FROM maillist ml, domains d ".
          	 " WHERE ml.server_id='$ServerID' AND d.server_id='$ServerID' ".
             " AND ml.domain_id=d.id AND d.kunde=? AND ml.id=? ";

		if( is_numeric( $domain_id ) ) {
			$lcSQL .= " AND ml.domain_id=?";
			$id = safe_query2( $lcSQL, 
												 $loUser, 
												 new SQLInteger( $maillist ), 
												 new SQLInteger( $domain_id ) 
												 );
		}else{
			$id = safe_query2( $lcSQL, 
			                   $loUser,
												 new SQLInteger( $maillist )
												  );
		}
		if( db_num_rows($id) ){
			list($name) = db_fetch_array($id,'N');
			return array($name, NULL); 
		}
	}

/**
 * Check syntax of maillist name
 */
	if( !preg_match( '/^[a-z0-9_-]+$/', $maillist ) ) {
		return array( NULL, ltext('ml_err_invalidmaillist', array($maillist) ) );		
	}

	$maillist = strtolower( $maillist );

  /**
   * Check existing of maillist
   */
	$lcSQL = " SELECT COUNT(*) FROM maillist ml, domains d ".
       	   " WHERE ml.server_id='$ServerID' AND d.server_id='$ServerID' ".
           " AND ml.domain_id=d.id  AND ml.name=? ";
    
	if( is_numeric( $domain_id ) ){
    /**
     * This check is needed because of shared domains
     */
    $lrId = safe_query2( "SELECT domain FROM domains WHERE id=? AND server_id='$ServerID'", 
                           new SQLInteger( $domain_id ) );
    list( $lcDomain ) = db_fetch_array( $lrId, 'N' );
    db_free_query( $lrId );
		$lcSQL .= " AND d.domain=?";
		$loQuery = new SQLQuery( $lcSQL, array( new SQLValue( $maillist, 'C' ),
  																					new SQLValue( $lcDomain, 'C' ) ) );
	}else{
		$lcSQL .= " AND d.kunde=?";
		$loQuery = new SQLQuery( $lcSQL, array( $loUser, 
																						new SQLValue($maillist,'C') ) );
	}

	$loQuery->doQuery();
	list( $cnt ) = $loQuery->fetchArray('N');

	if( $cnt ){
		return  array( NULL, ltext('ml_err_alreadymaillist', array( $maillist ) ) );
	}

	$lcSQL = " SELECT e.prefix, e.domain, d.richtigedomain  FROM email e, domains d ".
           " WHERE e.server_id='$ServerID' AND d.server_id='$ServerID' ".
           " AND e.domain = d.domain AND e.kunde=d.kunde ".
       		 " AND (e.prefix LIKE '?%' OR e.prefix LIKE 'majordomo%') ";

	if( is_numeric( $domain_id ) ) {
		$lcSQL .= " AND d.domain=?";
		$loQuery->Parameters( array( new SQLValue( $maillist,'S' ),
																 new SQLValue( $lcDomain,'C' ) 
																 )
													);

	}else{
		$lcSQL .= " AND d.kunde=?";
		$loQuery->Parameters( array( $loUser, 
																 new SQLValue($maillist,'S') 
																 )
													);
	}
	$loQuery->Query( $lcSQL ); 
	$loQuery->doQuery();
  
	while ( list( $prefix, $domain, $richtigedomain ) = $loQuery->fetchArray('N') ) {

		if( $maillist == $prefix ){
			return array( NULL, ltext('ml_err_emailconflict', array($prefix.'@'.$domain) ) );
		}
		if( preg_match('/^'.$maillist.'-(owner|approval|outgoing|archive|request)$/',
									 $prefix ) 
        || ( ( $prefix == 'majordomo' 
               || $prefix == 'majordomo-owner' ) 
             && $richtigedomain != 7 ) )
    {
			return array(NULL, ltext('ml_err_emailconflict', array($prefix.'@'.$domain) ) );
		}
	}

	return array( $maillist, NULL );

}

function canAddMaillist( $lcUser = NULL ){
	global $PHP_AUTH_USER;
  global $ServerID;
	$loUser = $user ? new SQLValue( $user, 'C') : new SQLValue($PHP_AUTH_USER,'C');
	$loQuery = new SQLQuery( "SELECT maxmaillist FROM kunden WHERE server_id='$ServerID' AND kunde=?", $loUser );
	$loQuery->doQuery();
	list($max) = $loQuery->fetchArray('N');
	if($max != -1){
		$loQuery->Query( "SELECT COUNT(name) FROM maillist ml, domains d ".
									 " WHERE d.server_id='$ServerID' AND ml.server_id='$ServerID' AND  ml.domain_id=d.id AND d.kunde=?" );
		$loQuery->doQuery();
		list($cnt) = $loQuery->fetchArray('N');
		if( $cnt>=$max){
			return array(FALSE,ltext('ml_havend', $cnt, $max ));
		}
	}
	return array(TRUE,NULL);
}

function checkOwnerEmail($owner){
	if(!preg_match('/^[\w.-]+\@(?:[\w-]+\.)+\w+$/', $owner))		{
		return array( NULL, ltext('ml_err_invalidemail'));
	}

	return array($owner, NULL);	
}


function checkMailListPassword($p1, $p2 )	{
	if (!( $p1 && $p2) ) {
		return array( NULL, ltext('ml_err_emptypass'));
	}

	if ( (substr_count($p1, " ")) || (substr_count($p2, " ")) ) {
		return array( NULL, ltext('ml_err_invalidpassword'));
	}
	
	if ($p1 != $p2) {
		return array( NULL, ltext('ml_err_passnotmatch'));
	}
	
	return array($p1,NULL);
}

function checkDomainId( $domain_id, $user = NULL ){
	global $PHP_AUTH_USER;
  global $ServerID;
  
	$loUser = $user ? new SQLValue($user,'C') : new SQLValue($PHP_AUTH_USER,'C');
	$lcQuery = "SELECT id,domain FROM domains WHERE server_id='$ServerID' AND kunde=?";
	if(is_numeric($domain_id)){
		$lcQuery .= " AND id=?";
		$loDomain = new SQLValue( $domain_id,'N');
	}else{
		$lcQuery .= " AND domain=?";
		$loDomain = new SQLValue( $domain_id,'C');
	}
	$loQuery = new SQLQuery( $lcQuery, array( $loUser, $loDomain ));
	$loQuery->doQuery();

	if($loQuery->getRowCount()){
		list($domain_id, $domain) = $loQuery->fetchArray('N');

/*
		echo "checkDomainId : domain_id: $domain_id<br>\n";
*/
		return array($domain_id, $domain );

	}else{
		return array(NULL,ltext('ml_domain_not_found'));
	}
}

?>
