<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "../class.SQLValuesSource.php" );
include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "../module.Database.php" );
include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "../module.Genlib.php" );





class AtDomainsValuesSource extends SQLValuesSource
{
    /* -------------------- Members -------------------- */
	var $ms_Limit; // limit of at domains (cached)
	var $ms_Total; // total number of at domains (cached)
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
	function AtDomainsValuesSource ( $ps_IDName=0, $ps_PageNumber = NULL, $ps_ItemsPerPage = NULL )
	{
		$this->ms_Limit = NULL;
		$this->ms_Total = NULL;
		$this->SQLValuesSource ( $ps_IDName, $ps_PageNumber, $ps_ItemsPerPage );
	}
    /* -------------------- end Constructor -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
	function GetBrowseSQL()
	{
		global $PHP_AUTH_USER;
		global $ServerID;
		return "SELECT atdomains.id, atdomains.name, atdomains.id_from, atdomains.todomain ".
			"FROM atdomains, domains WHERE atdomains.id_from=domains.id AND ".
			"domains.kunde='" . db_quote($PHP_AUTH_USER) . "' AND atdomains.server_id='$ServerID' AND domains.server_id='$ServerID'" . $this->GetOrder();
	}

	function GetSearchSQL ( &$pa_Search )
	{
		
		global $PHP_AUTH_USER;
		global $ServerID;

		$ls_Sql = '';
		$ls_NameCondition = strlen($pa_Search[0]->GetValue()) ?
			" AND atdomains.name LIKE '%" . db_quote($pa_Search[0]->GetValue()) . "%' " : "";
			
		$ls_DomainCondition = $pa_Search[1]->GetValue()==-1 ?
			"" : " AND atdomains.id_from='" . db_quote($pa_Search[1]->GetValue()) . "' ";
		$ls_DomainCondition .= strlen($pa_Search[2]->GetValue()) ?
			" AND atdomains.todomain LIKE '%" . db_quote($pa_Search[2]->GetValue()) . "%' " : "";
		$ls_Sql = "SELECT atdomains.id, atdomains.name, atdomains.id_from, atdomains.todomain ".
			"FROM atdomains, domains WHERE atdomains.server_id='$ServerID' AND domains.server_id='$ServerID' AND atdomains.id_from=domains.id AND ".
			"domains.kunde='" . db_quote($PHP_AUTH_USER) . "'	$ls_NameCondition $ls_DomainCondition" . 
			$this->GetOrder();
		
		return $ls_Sql;
	}

    // to help GetBrowseSQL & GetSearchSQL
	function GetOrder()
	{
		$ls_Reverse = $this->GetSortReverse() ? " DESC " : "";
		switch ( $this->GetSortColumn() )	{
		case "id_from":
			return " ORDER BY domains.domain $ls_Reverse ";
		case "todomain":
			return " ORDER BY atdomains.todomain $ls_Reverse ";
		case "name":
		default:
			return " ORDER BY atdomains.name $ls_Reverse ";
		}
	}

	function GetDefaultSort()
	{
		return "name";
	}

	function GetCountBrowseSQL()
	{
		global $PHP_AUTH_USER;
		global $ServerID;
		return "SELECT COUNT(*) FROM atdomains, domains WHERE atdomains.server_id='$ServerID' AND domains.server_id='$ServerID'".
		       " AND  atdomains.id_from=domains.id AND domains.kunde=".db_full_quote($PHP_AUTH_USER);
	}

	function GetCountSearchSQL()
	{
		global $PHP_AUTH_USER;
		global $ServerID;
		$ls_Name = ff_GetFromPostGet("search_name");
		$ls_DomainFrom = ff_GetFromPostGet("search_id_from");
		$ls_DomainTo = ff_GetFromPostGet("search_todomain");
		$ls_NameCondition = strlen($ls_Name) ? " AND atdomains.name LIKE '%" . db_quote($ls_Name) . "%' " : "";
		$ls_DomainCondition = $ls_DomainFrom == -1 ? "" : " AND atdomains.id_from='" . db_quote($ls_DomainFrom) . "' ";
		$ls_DomainCondition .= strlen($ls_DomainTo) ?
			" AND atdomains.todomain LIKE '%" . db_quote($ls_DomainTo) . "%'" : "";
		return "SELECT COUNT(*) FROM atdomains, domains WHERE atdomains.server_id='$ServerID' AND domains.server_id='$ServerID'"
		      ." AND atdomains.id_from=domains.id AND domains.kunde=" .
		      	db_full_quote($PHP_AUTH_USER) . " $ls_NameCondition $ls_DomainCondition";
	}

	function AddElement()
	{
		global $PHP_AUTH_USER;
		global $ServerID;

		if ( ! $this->CheckName( ff_GetFromPostGet("name") ) )
			return array( "message"=>ltext("ad_incorrectname"), "type"=>ERROR  );
		if ( ! $this->CheckDomain( ff_GetFromPostGet("todomain") ) )
			return array( "message"=>ltext("ad_incorrectdomain"), "type"=>ERROR );

		$ls_Name = db_full_quote ($_POST["name"]);
		$ls_IDFrom = intval($_POST["id_from"]);
		$ls_Auth = db_full_quote($PHP_AUTH_USER);
		$ls_ToDomain = db_full_quote($_POST["todomain"]);
		$lo_DB =& get_db_connection();
		$lo_DB->lockTables ( array( "domains", "kunden" ), array( "atdomains", "sessions", "allgemein" ) );

		if ( ! $this->CanAddDomain() ) {
			$lo_DB->unLockTables();
			return array( "message"=>ltext("ad_limit"), "type"=>ERROR );
		}

		$lo_Query =& $lo_DB->Select ( "SELECT 1 FROM domains WHERE id=" . $ls_IDFrom . " AND server_id='$ServerID' AND kunde=" .
																		db_full_quote($PHP_AUTH_USER)." AND richtigedomain<>0 " );
		if ( ! $lo_Query->nextrow() )
			return NULL;
			
		if ( ! $lo_DB->Execute ( "INSERT INTO atdomains ( name, id_from, todomain, server_id )".
														 " SELECT $ls_Name, id, $ls_ToDomain, server_id FROM domains ".
														 "WHERE kunde=$ls_Auth AND id=$ls_IDFrom AND server_id='$ServerID'" ) )	{
			$lo_DB->unLockTables();
			return array( "message"=>ltext("ad_nameinuse"),"type"=>ERROR );
		}
		$lo_DB->Execute ( "UPDATE kunden SET httpd=1 WHERE kunde=$ls_Auth AND server_id='$ServerID'" );
		$lo_DB->Execute ( "UPDATE allgemein SET httpd=1, httpdupdate=0 WHERE server_id='$ServerID'" );
		$lo_DB->unLockTables();
		$this->ms_Total = NULL;
		return NULL;
	}

	function EditElements()
	{
		global $PHP_AUTH_USER;
		global $ServerID;
		$la_Names = ff_GetFromPostGet ("name");
		$la_FromIDs = ff_GetFromPostGet ("id_from");
		$la_ToDomains = ff_GetFromPostGet ("todomain");
		$la_Error = NULL;
		$lo_DB =& get_db_connection();
		$ls_Updated = FALSE;
		$lo_DB->lockTables ( "domains", array( "atdomains", "allgemein" ) );


		$la_Error = NULL;

		foreach ( $la_Names as $ls_ID=>$ls_Value ) {
			if ( ! $this->CheckName($ls_Value) ) {
				$la_Error = array( "message"=>ltext("ad_incorrectname"),"type"=>ERROR ); // some errors will be lost
				continue;
			}
			if ( ! $this->CheckDomain($la_ToDomains[$ls_ID]) ) {
				$la_Error = array( "message"=>ltext("ad_incorrectdomain"),"type"=>ERROR ); // some errors will be lost
				continue;
			}
			$lo_Query =& $lo_DB->Select ( "SELECT 1 FROM domains WHERE id=" . intval($la_FromIDs[$ls_ID]) . " AND kunde=" .
																			db_full_quote($PHP_AUTH_USER)." AND richtigedomain<>0 AND server_id='$ServerID'" );
			if ( ! $lo_Query->nextrow() )
				continue;
			if ( ! $lo_DB->Execute ( "UPDATE atdomains SET name='" . db_quote($ls_Value) . "', id_from=" .
															 intval($la_FromIDs[$ls_ID]) . ", todomain=" . db_full_quote($la_ToDomains[$ls_ID]) . " WHERE server_id='$ServerID' AND id=" .
																 intval($ls_ID) ) )	{
				$la_Error = array( "message"=>ltext("ad_nameinuse"),"type"=>ERROR ); // some errors will be lost
				continue;
			} else {
				$la_Error = array( "message"=>"domain updated","type"=>NOTE );
				continue;
			}
			$ls_Updated = TRUE;
		}
		if ( $ls_Updated ) {
			$lo_DB->Execute ( "UPDATE kunden SET httpd=1 WHERE server_id='$ServerID' AND kunde=".db_full_quote($PHP_AUTH_USER) );
			$lo_DB->Execute ( "UPDATE allgemein SET httpd=1, httpdupdate=0 WHERE server_id='$ServerID'" );
			$la_Error = array( "message"=>"domain updated","type"=>NOTE );
		}
		$lo_DB->unLockTables();
		return $la_Error;
	}
	
	function DeleteElements ( &$pa_IDs )
	{
		global $PHP_AUTH_USER;
		global $ServerID;
		if ( count($pa_IDs) )	{
			$lo_DB =& get_db_connection ();
			$lo_DB->lockTables ( "domains", array( "atdomains", "allgemein" ) );
			$lo_Query = $lo_DB->Select ( "SELECT COUNT(*) FROM atdomains, domains WHERE atdomains.server_id='$ServerID' AND domains.server_id='$ServerID' AND".
																	 " atdomains.id_from=domains.id AND domains.kunde=" . db_full_quote($PHP_AUTH_USER) .
																	 " AND atdomains.id IN ( " . implode( ",", db_full_quote_array($pa_IDs) ) . " )" );
			$la_Row = $lo_Query->nextrow();
			if ( $la_Row[0] == count($pa_IDs) ) {
				$lo_DB->Execute ( "DELETE FROM atdomains WHERE server_id='$ServerID' AND id IN ( " . implode( ",", db_full_quote_array($pa_IDs) ) .
													" )" );
				$lo_DB->Execute ( "UPDATE kunden SET httpd=1 WHERE server_id='$ServerID' AND kunde=".db_full_quote($PHP_AUTH_USER) );
				$lo_DB->Execute ( "UPDATE allgemein SET httpd=1, httpdupdate=0 WHERE server_id='$ServerID'" );
			}
			$lo_DB->unLockTables();
			return NULL; // not absolutely correct
		}	else
			return array("message"=>"nothing to delete","type"=>WARN);
	}

	function ValidateAdd()
	{
		return NULL;
	}

	function ValidateEdit()
	{
		return NULL;
	}

	function ValidateDelete()
	{
		return NULL;
	}
    /* -------------------- end definitions of "abstract" methods -------------------- */





    /* -------------------- additional methods -------------------- */
	function CheckName( $ps_Name )
	{
		return preg_match ( "/^[^@]+$/", $ps_Name );
	}

	function CheckDomain ( $ps_Domain )
	{
		if (!$ps_Domain || ereg(" ", $ps_Domain) || ereg("[\n\t\r]", $ps_Domain) || (((ereg("[.]{2}", $ps_Domain)) || (ereg("[^_a-zA-Z0-9./~-]", $ps_Domain))) && (!ereg("^http[s]?://", $ps_Domain))) || ((!ereg("^/", $ps_Domain)) && (!ereg("^http[s]?://", $ps_Domain))) || ereg("[\\]", $ps_Domain))
			return FALSE;
		else return TRUE;  
	}

	function CanAddDomain ()
	{
		$ls_Limit = $this->GetLimit();
		if ( $ls_Limit == -1 )
	    return TRUE;
		if ( $ls_Limit == 0 )
	    return FALSE;
		return $this->GetTotal() < $this->GetLimit();
	}

	function GetLimit()
	{
		global $PHP_AUTH_USER;
		global $ServerID;
		if ( ! is_null($this->ms_Limit) )
	    return $this->ms_Limit;
		$lo_DB =& get_db_connection();
		$lo_Query =& $lo_DB->Select ( "SELECT maxatdomains FROM kunden WHERE server_id='$ServerID' AND kunde = " . db_full_quote($PHP_AUTH_USER) );
		$la_Row = $lo_Query->nextrow();
		return $la_Row ? $this->ms_Limit = $la_Row["maxatdomains"] : NULL;
	}

	function GetTotal()
	{
		global $PHP_AUTH_USER;
		global $ServerID;
		if ( ! is_null($this->ms_Total) )
	    return $this->ms_Total;
		$lo_DB =& get_db_connection();
		$lo_Query = $lo_DB->Select ( "SELECT COUNT(*) FROM atdomains, domains WHERE atdomains.server_id='$ServerID' AND domains.server_id='$ServerID' AND atdomains.id_from=domains.id AND
		domains.kunde=" . db_full_quote($PHP_AUTH_USER) );
		$la_Row = $lo_Query->nextrow();
		return $this->ms_Total = $la_Row[0];
	}
    /* -------------------- end additional methods -------------------- */

}
?>
