<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/../class.Pager.php" );
include_once ( dirname(__FILE__) . "/../class.CompoundColumn.php" );
include_once ( dirname(__FILE__) . "/../class.InputTextColumn.php" );
include_once ( dirname(__FILE__) . "/../class.MailtoColumn.php" );
include_once ( dirname(__FILE__) . "/class.SubscriptionDurationColumn.php" );
include_once ( dirname(__FILE__) . "/../class.SelectColumn.php" );
include_once ( dirname(__FILE__) . "/../class.URLColumn.php" );
include_once ( dirname(__FILE__) . "/../class.TimestampColumn.php" );
include_once ( dirname(__FILE__) . "/class.RegRequestsDomainsColumn.php" );





class RegRequestsPager extends Pager
{
    /* -------------------- Members -------------------- */
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function RegRequestsPager ( &$po_Source )
    {
	$this->Pager ( $po_Source );
	$this->setText ( "noresults", "" );
	$this->setText ( "deletes", ltext ("webshop_requests_delete") );
	$this->setText ( "select", ltext ("webshop_requests_select") );
	$this->setText ( "delete", ltext ("webshop_requests_select") );
	$this->setText ( "declines", ltext ("webshop_requests_declines") );
	$this->setText ( "declineconfirm", ltext ("webshop_requests_decline_confirm") );
	$this->setText ( "accepts", ltext ("webshop_requests_accepts") );
	$this->setText ( "acceptconfirm", ltext ("webshop_requests_accept_confirm") );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- "abstract" methods -------------------- */
    function ShouldShowSummary()
    {
	return TRUE;
    }

    function ShouldShowAddForm()
    {
	return FALSE;
    }

    function GetSummary()
    {
	$ls_Total = $this->mo_Source->CountNew();
	return $ls_Total>0 ? ltext ( "webshop_requests_summary1", array($ls_Total) ) :
		ltext ( "webshop_requests_summary2" );
    }

    function GetAddColumns()
    {
	return array();
    }

    function GetBrowseColumns()
    {
	$la_Result = array();

	$lo_NameColumn = new CompoundColumn ( NULL, "", "" );
	$lo_NameColumn->AddColumn ( new InputTextColumn ( "firstname", "", "" ) );
	$lo_NameColumn->AddColumn ( new InputTextColumn ( "name", "", "" ) );
	$lo_NameColumn->SetSeparator ( " " );

	$lo_Column = new CompoundColumn ( NULL, ltext("webshop_requests_from"), "", array(), "20%" );
	$lo_Column->AddColumn ($lo_NameColumn);
	$lo_Column->AddColumn ( new MailtoColumn ( "emailadresse", "", "" ) );
	$lo_Column->SetInput (FALSE);
	$la_Result[] = $lo_Column;

	$lo_Column = new CompoundColumn ( "info", ltext("webshop_requests_planinfo"), "", array(), "20%" );
	$lo_Column->SetWithLabel (TRUE);
	$lo_Column->AddColumn ( new InputTextColumn ( "aname", ltext("webshop_requests_aname"), "" ) );
	$lo_Column->AddColumn ( new InputTextColumn ( "identifier", ltext("webshop_requests_identifier"), "" ) );
	$lo_Column->AddColumn ( new InputTextColumn ( "price", ltext("webshop_requests_price"), "" ) );
	$lo_Column->AddColumn ( new SubscriptionDurationColumn ( "", ltext("webshop_requests_duration"), "" ) );
	$lo_Column->SetSeparator ( "<br>" );
	$lo_Column->SetInput (FALSE);
	$lo_Column->SetSortable (TRUE);
	$la_Result[] = $lo_Column;

	$la_Result[] = new RegRequestsDomainsColumn ( "", ltext("webshop_requests_domains"), "", array(), "15%" );

	$lo_Column = new SelectColumn ( array( "new"=>ltext("webshop_requests_status_new"),
		"accepted"=>ltext("webshop_requests_status_accepted"),
		"declined"=>ltext("webshop_requests_status_declined") ), "status", ltext("webshop_requests_status"), "",
		array(), "10%" );
	$lo_Column->SetInput (FALSE);
	$lo_Column->SetSortable (TRUE);
	$la_Result[] = $lo_Column;

	$lo_Column = new TimestampColumn ( "requesttimestamp", ltext("webshop_requests_date"), "", array(), "15%" );
	$lo_Column->SetInput (FALSE);
	$lo_Column->SetSortable (TRUE);
	$la_Result[] = $lo_Column;

	$lo_Column = new URLColumn ( new InputTextColumn ( NULL, "", ltext("webshop_requests_details") ),
		array( "id" ), NULL, "&nbsp;", "webshop_requests2.php", array(), "10%" );
	$lo_Column->SetInput (FALSE);
	$la_Result[] = $lo_Column;

	return $la_Result;
    }

    function GetEditColumns()
    {
	return array();
    }

    function GetSearchColumns()
    {
	return array();
    }

    function GetHiddenFields()
    {
	return array();
    }
    /* -------------------- end "abstract" methods -------------------- */





	/* -------------------- CreateDataObject -------------------- */
	// method that maps old classes to include/elements/*
	function CreateDataObject() {
		$lo_Data = Pager::CreateDataObject();
		$lo_Data->AppendHidden( new TextDataField( "", "Action" ) );
		$lo_Data->ClearButtons();
		$lo_Data->AppendButton( $this->texts["accepts"], "javascript:return askAccept()" );
		$lo_Data->AppendButton( $this->texts["declines"], "javascript:return askDecline()" );
		$lo_Data->AppendButton( $this->texts["deletes"], "javascript:return askDelete()" );
		return $lo_Data;
	}

	// method that maps old classes to include/elements/*
	function OutputHTML( $pm_Title, $ps_IncludeJS=FALSE ) {
		$lo_Page = $this->CreatePageObject( $pm_Title );
		$lo_Page->OutputHTML( $ps_IncludeJS,
				"
ToDelete = new Array();

function itemsSelected() {
	var i;
	for ( i in ToDelete )
		if ( ToDelete[i] )
			return true;
	return false;
}

function askDelete() {
	if ( itemsSelected() && " . js_confirm($this->texts["delquest"]) . " ) {
		document.forms['deleteform'].Action.value = 'delete';
		document.forms['deleteform'].submit();
	}
	return false;
}

function askDecline() {
	if ( itemsSelected() && " . js_confirm($this->texts["declineconfirm"]) . " ) {
		document.forms['deleteform'].Action.value = 'decline';
		document.forms['deleteform'].submit();
	}
	return false;
}

function askAccept() {
	if( itemsSelected() && " . js_confirm($this->texts["acceptconfirm"]) . " ) {
		document.forms['deleteform'].Action.value = 'accept';
		document.forms['deleteform'].submit();
	}
	return false;
}
				"
				);
	}
	/* -------------------- end CreateDataObject -------------------- */

}
?>
