<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.LongTextDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/class.HOStates.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "einstellungen_httpd_domain_aendern.php<br>\n";
}

db_master_connect();

$loDomain = new SQlString( $domain );
$loServerID = new SQLString( $server_id );

$lrId= db_query( "SELECT COUNT(id) FROM httpd_definitions" );
list( $liHttpdCount ) = db_fetch_array( $lrId, 'N');
db_free_query( $lrId );

$lbHttpdSpecial = 1;
$lbHttpdOptions = $liHttpdCount;

/**
 * Perfom action?
 */
if( isset($act) && $act == 'save' ){/*{{{*/
	//check domains from black list

	$id = safe_query2( "SELECT richtigedomain,kunde, id FROM domains ".
										 " WHERE domain = ? AND richtigedomain !=7  AND server_id=?", 
										 $loDomain, $loServerID );

  $liCount = db_num_rows( $id );

  if( $liCount ){
    list( $richtigedomain, $kunde, $domain_id ) = db_fetch_array( $id, 'N' );
  }

  db_free_query( $id );

  if( ! $liCount || $richtigedomain == 5 ){
		$fehlertitel = ltext("g_error");	
		include("einstellungen_httpd.php");
		exit;
	}

  if( $mode == 'advanced' ){
  	safe_query2( "UPDATE domains SET zusatz = ? WHERE domain = ? AND richtigedomain !=7 AND server_id=?", 
                 new SQLString( $zusatz ), $loDomain, $loServerID );
  }else{
    /**
     * Httpd options
     */
    $loHttpdOptions = new HOStates( $server_id );
    $loHttpdOptions->setForDomain( $domain_id, $httpd_ids );
  }

	safe_query2( "UPDATE kunden SET httpd=1 WHERE kunde=? AND server_id=?",
							 new SQLString($kunde), $loServerID );
	safe_query2( "UPDATE allgemein SET httpd=1, httpdupdate=0 WHERE server_id=?",
							 $loServerID );
	db_close();

	$fehlertitel = ltext( 'eihtdoaesp_errortitle');
	$fehlertext = ltext( 'eihtdoaesp_error1' );

	include("einstellungen_httpd_domain.php");
	exit();
 }/*}}}*/

if( !( isset( $zusatz ) && $zusatz ) ){

	$id = safe_query2( "SELECT zusatz FROM domains WHERE domain = ? AND server_id=?", 
										 new SQLString( $domain ), new SQlString($server_id) );
	list($zusatz) = db_fetch_array( $id, 'N');
	db_free_query( $id );
 }

$loData = new SetOfRowsData();

$loData->AppendRow(new HTMLDataField( '##user##' ),
	new HTMLDataField( ltext("eihtdoae_cell_username") ));
$loData->AppendRow(new HTMLDataField( '##domain##' ),
	new HTMLDataField( ltext("eihtdoae_cell_domain") ));

if( $lbHttpdOptions && $lbHttpdSpecial ){
  $loLinkBlock = new CompoundDataField(  new LinkDataField( "javascript:displayDiv('sim_mode',1);displayDiv('adv_mode',0);",
                                                          "",
	                                                        array( ),
                                                          ltext('simple_mode') ) ,
                                         new LinkDataField( "javascript:displayDiv('adv_mode',1);displayDiv('sim_mode',0);",
                                                           "",
	                                                        array( ),
                                                          ltext('advanced_mode') )             
                                                        );
  $loLinkBlock->SetSeparator(" / ");
  $loLinkBlock->AppendParentAttributes(array("colspan"=>2));
  $loData->AppendRow($loLinkBlock);
}  

$boxLegend = $loData->GetOutputPresentation(ltext('eihtdoae_title2')); // Infotable
$boxLegend->SetWidths('20%','80%');

$loData->ClearRows();

$lcTitle = ltext("eiht_cell_domain").' <strong>'.htmlspecialchars( $domain ).'</strong>';

if( $lbHttpdOptions ){
  $liFormIndex = 1;
}else{
  $liFormIndex = 0;
}
 
$loData->AppendRow( new HTMLDataField( ltext('eihtdoae_cell_title1',array($domain)) ), 
									new LongTextDataField( $zusatz, 'zusatz' ) );

$loData->AppendHidden(new TextDataField( $domain, 'domain' ) );
$loData->AppendHidden(new TextDataField( $server_id, 'server_id' ) );
$loData->AppendHidden(new TextDataField( 'save', 'act' ) );
$loData->AppendHidden( new TextDataField( 'einstellungen_httpd_domain_aendern.php', 'ret_path' ) );
$loData->AppendHidden( new TextDataField( 'domain', 'ret_field' ) );
$loData->AppendHidden( new TextDataField( 'advanced', 'mode' ) );
$loData->AppendButton( ltext('eihtdoae_button1'), "javascript:doChange($liFormIndex)", cc_IDOk );
$loData->AppendButton( ltext( 'eiht_test' ), 
                          "javascript: document.forms[$liFormIndex].action='settings_httpd_special.php';doChange($liFormIndex)" );
$form = $loData->GetInputPresentation( array( 'action'=>'einstellungen_httpd_domain_aendern.php','method'=>'post'),
																		 $lcTitle );
$form->SetWidths('20%','80%');

$laTmp = array( 'id'=>'adv_mode' ); 
if( $lbHttpdOptions ){
  $laTmp['style'] = 'display:none';
}
$loSpecial = new DivElement( $laTmp );
$loSpecial->AppendToContent( $form );


/**
 * Httpd options
 */
if( $lbHttpdOptions ){
  $loHttpdOptionsStates = new HOStates( $server_id );
  $loHttpdOptions = & $loHttpdOptionsStates->getSORDForDomain( $domain );
  $loHttpdOptions->AppendHidden( new TextDataField( $domain, 'domain' ) );
  $loHttpdOptions->AppendHidden( new TextDataField( $server_id, 'server_id' ) );
  $loHttpdOptions->AppendHidden(new TextDataField( 'save', 'act' ) );
  $loHttpdOptions->AppendHidden( new TextDataField( 'simple', 'mode' ) );
  $loHttpdOptions->AppendHidden( new TextDataField( 'einstellungen_httpd_domain_aendern.php', 'ret_path' ) );
  $loHttpdOptions->AppendHidden( new TextDataField( 'domain', 'ret_field' ) );
  $loHttpdOptions->AppendButton( ltext( 'eihtdoae_button1' ),
										 'javascript:doChange()',
   									 cc_IDOk );
 
  $form2 = $loHttpdOptions->GetInputPresentation( array(
                                             'action'=>'einstellungen_httpd_domain_aendern.php', 
                                             'method'=>'post' ),
                                     $lcTitle );

  $loOptions = new DivElement(array('id'=>'sim_mode'));
  $loOptions->AppendToContent($form2);
}

if( $lbHttpdOptions && $lbHttpdSpecial ){
  $loPage = new MainPageElement( $boxLegend, $loOptions, $loSpecial );
}elseif( $lbHttpdOptions ){
  $loPage = new MainPageElement( $boxLegend, $loOptions );
}elseif( $lbHttpdSpecial){
  $loPage = new MainPageElement( $boxLegend, $loSpecial );
}else{
  $loPage = new MainPageElement( $boxLegend );
}

$loPage->OutputHTML( array( '../../js/paged_form.js' ));

db_close();
?>
