<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php');
include_once( '../events.inc.php' );
include_once( '../include/event_functions.php' );

global $DEBUG;
//$DEBUG=1;

$time = time();

db_master_connect();

$loServerID = new SQLString( $server_id );

$id = safe_query2( "SELECT standardip FROM admin WHERE server_id=?", $loServerID );

list($oldstandardip) = db_fetch_array($id,'N');

db_free_query( $id );

$standardip = trim($standardip);
$usestd     = $usestd ? 0 : 1;

## domain checken
if( ( ! ereg("\.", $standarddomain ) ) || ereg( "[^a-z0-9.-]", $standarddomain ) || 
		    ereg( "^-", $standarddomain ) ){
	$fehlertext = ltext( 'eisd2_error1' );
	db_close();
	include('einstellungen_stddomain.php');
	exit();
 }

 ## ip checken
if( ! ereg("([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})", $standardip)){
	 $fehlertext = ltext( 'eisd2_error3' );
	 db_close();
	 include( 'einstellungen_stddomain.php' );
	 exit();
 }

$loIP = new SQLString( $standardip );
$id = safe_query2( "SELECT ip FROM ipadressen WHERE ip = ? AND status=1".
                   " AND anbieter = '' AND kunde = '' AND server_id=?", $loIP, $loServerID );
                   
$cnt = db_num_rows( $id );
db_free_query( $id );

if( $cnt != 1 ){
	 $fehlertext = ltext("eisd2_error4");
	 db_close();
	 include( 'einstellungen_stddomain.php' );
	 exit();
	}	 

safe_query2( "UPDATE admin SET standarddomain = ? , standardip = ? , stddomain = ? WHERE server_id=?", 
						 new SQLString( $standarddomain ), $loIP, new SQLInteger( $usestd ),
						 $loServerID );

eventAdd( $OBJECT_IP, $EVENT_CHANGE, $server_id, $server_id );

if ($all == 1){
	$id = safe_query2( "SELECT kunde,anbieter,domain FROM domains WHERE richtigedomain = 3 AND server_id=?", $loServerID );
	while( list($kunde,$anbieter,$olddomain ) = db_fetch_array( $id, 'N' ) ){
		 $newdomain = $kunde.".".$standarddomain;

	 	 domain_aendern( $olddomain, 'loeschen', $kunde, $server_id );
		 fpalias_aendern( $olddomain, 'loeschen', $kunde, $server_id );

		 $loKunde = new SQLString( $kunde );

		 safe_query2( "UPDATE domains SET domain = ? , lastchange = ?  WHERE domain = ?  AND richtigedomain = 3 AND kunde = ? AND server_id=?", 
									new SQLString( $newdomain ), new SQLInteger( $time ), new SQLString( $olddomain ), $loKunde, $loServerID );

		 safe_query2( "UPDATE kunden SET httpd=1 WHERE kunde=? AND server_id=?",
									$loKunde, $loServerID );

	 	 domain_aendern( $newdomain, 'anlegen', $kunde, $server_id );
		 fpalias_aendern( $newdomain, 'anlegen', $kunde, $server_id );
	}
	db_free_query( $id );
 }

safe_query2( "UPDATE anbieter SET standardip = ? WHERE standardip = ? AND server_id=? ", 
						 $loIP, new SQLString( $oldstandardip ), $loServerID );	 
safe_query2( "UPDATE kunden SET ip = ?, httpd=1  WHERE ip = ? AND server_id=? ", 
						 $loIP, new SQLString( $oldstandardip ), $loServerID );	 
safe_query2( "UPDATE allgemein SET httpd = 1 WHERE server_id=?", $loServerID);

$fehlertitel = ltext( 'eisd2_errortitle' );
$fehlertext = ltext( 'eisd2_error2' );

db_close();

include( 'einstellungen_stddomain.php' );
exit();

?>
