<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( 'defines.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/data_source/class.DataValue.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.ReadOnlyDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/elements/data/class.CheckDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/html/class.CompoundElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );
include_once( '../include/elements/html/class.ButtonURLElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/class.InputTextElement.php' );

global $DEBUG;
//$DEBUG=1;

if( $DEBUG ){
	echo "kunden_ssl.php: _POST<br><pre>\n";
	print_r( $_POST );
	echo "</pre><br>\n";
}

$gcUserSeparator = '@';

function chngActiveStatus( $pcKunde, $piActivate, $server_id ){
	global $fehlertext;
	global $lcUser;

	$liNeu = $piActivate ? 4 : 3;

	$loServerID = new SQLString( $server_id );
	$loKunde    = new SQLString( $pcKunde );

	safe_query2( "UPDATE cssl SET neu=$liNeu WHERE kunde=? AND server_id=?",
							 $loKunde, $loServerID);
	safe_query2( "UPDATE kunden SET httpd=1 WHERE kunde=? AND server_id=?", $loKunde, $loServerID );
	safe_query2( "UPDATE allgemein SET httpd=1, cssl=1 WHERE server_id=?", $loServerID );
}

switch( $action ){

 case 'create':
	 $action = '';
 case 'change':
	 include( 'kunden_ssl_erstellen.php' );
	 exit;
	 break;

 case 'activate':
	 $action = '';
	 chngActiveStatus( $kunde, 1, $server_id);
	 break;

 case 'deactivate':
	 $action = '';
	 chngActiveStatus( $kunde, 0, $server_id);
	 break;

 case 'gactivate':
 case 'gdeactivate':
 case 'delete':
	 if( is_array( $users) ){
		 include('kunden_ssl_group.php');
	 } else {
		 $fehlertext = ltext('ll_nothing');
	 }
	 break;
 }

db_master_connect();

initPagingSettings( $_POST, array( 'to_find' => $to_find ) );

$id = safe_query2( "SELECT COUNT(kunde) FROM ipadressen WHERE kunde != ''");
									 
list( $total_number ) = db_fetch_array( $id, 'N' );
db_free_query( $id );

if( ! $total_number ){
	$fehlertext = ltext( 'kuss_nouserwithip' );
	db_close();
	$url = "kunden_start.php?error_text=kuss_nouserwithip";
	header("Location: $url");
	newLocation( $url );
	exit();
 }

$laParams = array( );
$lcFields = "i.ip, MIN(k.kunde) as kunde, MIN(k.name) AS name,MIN(k.firstname) AS firstname,".
             " MAX(k.number) AS number, MAX(c.neu*4 + c.aendern*2 + c.loeschen) AS status, ".
      			 " s.name AS server, i.server_id, k.anbieter "; 

if( isset( $to_find ) && strlen( $to_find ) ){
	
	$lcSQL = " FROM ipadressen i ".
     			 " LEFT JOIN cssl c ON c.kunde=i.kunde  AND c.server_id=i.server_id".
           " LEFT JOIN admin a ON i.server_id=a.server_id".
           " LEFT JOIN server s ON i.server_id=s.server_id".
    			 " LEFT JOIN kunden k  ON i.kunde = k.kunde AND i.server_id=k.server_id".
     			 " LEFT JOIN domains d ON i.kunde = d.kunde AND i.server_id=d.server_id".
     			 " WHERE  d.richtigedomain=1 AND i.anbieter!='' AND i.kunde!='' AND i.status=1 ".
     			 " AND (i.ip LIKE '%?%' OR k.name LIKE '%?%' OR a.confixx_domain LIKE '%?%' OR s.name LIKE '%?%'".
     			 " OR k.kunde LIKE '%?%' OR d.domain LIKE '%?%') GROUP BY i.ip";

	array_push( $laParams, 
							new SQLValue($to_find,'S'), 
							new SQLValue($to_find,'S'), 
							new SQLValue($to_find,'S'), 
							new SQLValue($to_find,'S'), 
							new SQLValue($to_find,'S'), 
							new SQLValue($to_find,'S')
						 );

  $loQuery = new SQLQuery( "SELECT COUNT(i.ip) ".$lcSQL, $laParams );
	$loQuery->doQuery();
	list( $total_number ) = $loQuery->fetchArray( 'N' );
	$lcSQL = "SELECT ".$lcFields.$lcSQL;

}else{
	$lcSQL = "SELECT i.ip, i.server_id, k.kunde, k.name AS name, k.firstname AS firstname, k.number AS number,  ".
       		 " c.neu*4 + c.aendern*2 + c.loeschen AS status, s.name AS server, ".
     			 " k.anbieter FROM ipadressen i".
    			 " LEFT JOIN kunden k  ON i.kunde = k.kunde AND i.server_id=k.server_id".
     			 " LEFT JOIN admin a  ON i.server_id=a.server_id".
           " LEFT JOIN server s ON i.server_id=s.server_id".
     			 " LEFT JOIN cssl c ON c.kunde=i.kunde  AND c.server_id=i.server_id".
     			 " WHERE i.anbieter !='' AND i.kunde!=''";
 }

if( !isset( $order ) ){
	$order = 'user';
}

$laOrders = array( 'name'   => 'firstname',
                   'ip'     => 'ip',
                   'status' => 'status',
                   'user'   => 'number',
                   'server' => 'server',
                 );
                 
if( array_key_exists( $order, $laOrders ) ){
  $lcSQL .= " ORDER BY ".$laOrders[$order];
}else{
  $lcSQL .= " ORDER BY number";
}  

$lcSQL  .=  $direction == 'desc' ? " DESC" : "";
$loQuery = new SQLQuery( $lcSQL, $laParams );
$loDS    = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );

$loTemplate = new CompoundValue(                             // Status
                                new CompoundValue(new ValueFromArray('status'), 
                      												    new ValueFromArray('kunde'),
                      												    new ValueFromArray('server_id'),
                      												    new ValueFromArray('anbieter')
                												         ),
								                new ValueFromArray('ip'),    // IP address
								                new ValueFromArray('kunde'), // User
								                new CompoundValue(           // Name (if specified)
								                                  new ValueFromArray('firstname'),
												                          new ValueFromArray('name')
												                          ),
								                new ValueFromArray('server'), // Server 
							                  new CompoundValue(            // Domains
                  								                new ValueFromArray('kunde'), 
                  								                new ValueFromArray('server_id') 
                                                 ),    								                
							                  new CompoundValue(            // Change
 							                                    new ValueFromArray('status'),
												                          new ValueFromArray('kunde'),
												                          new ValueFromArray('server_id' ),
												                          new ValueFromArray('anbieter')
												                          ),
							                  new CompoundValue(            // Checkbox
                  								                new ValueFromArray( 'kunde' ),
                  								                new ValueFromArray( 'server_id' ),
                  								                new ValueFromArray('anbieter')
                  								                )
								                );

$laContent = array();
$lcDirIcon = $direction == 'desc' ? cc_DescIcon : cc_AscIcon;
$lcNewDir  = $direction == 'desc' ? 'asc' : 'desc';

$laHeaders = array( 'status'  => array( 'name' => 'kuss_cell_status',  'sort' => 1 ), 
                    'ip'      => array( 'name' => 'kussdo_cell_ip',    'sort' => 0 ),
                    'user'    => array( 'name' => 'kuss_cell_user',    'sort' => 1 ),
                    'name'    => array( 'name' => 'kuss_cell_name',    'sort' => 1 ),
                    'server'  => array( 'name' => 'kust_server',       'sort' => 1 ),
                    'domains' => array( 'name' => 'kuss_cell_domains', 'sort' => 0 ),
                    'change'  => array( 'name' => 'll_change',         'sort' => 0 )
                  );

$listFormIndex = 0;

foreach( $laHeaders as $lcKey => $laValue ){
  if( $laValue['sort'] ){
    if( $order == $lcKey ){
    	$loContent = new CompoundDataField( new HTMLDataField( ltext( $laValue['name'] ) ),
			       														 new IconDataField( $lcDirIcon ) );
	    $loContent->SetSeparator( '' );
    }else{
	    $loContent = new HTMlDataField( ltext( $laValue['name'] ) );
    }
    $laContent[] = new DataValue( $lcKey, NULL, 
																	new LinkDataField( "javascript:setValue('order', '$lcKey',$listFormIndex);".
																											"setValue('start_index',1,$listFormIndex);".
																											"submitForm('direction','$lcNewDir',$listFormIndex)",
																											'',
																											array(),
																											$loContent
																										) 
														     );
  }else{
    $laContent[] = new ValueLocale( $laValue['name'] );
  }
}

$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute('onclick', "javascript:checkedAll('users', this.checked)");
$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );

array_push( $laContent, $loSelValue );

$loTitle = new CompoundValue( $laContent );

$laWidths = array( '5%', '15%', '10%', '20%', '20%', '20%', '5%', '5%' );

$loDS->Template( $loTemplate );


//=====================================================================
//
// call back functions to make visible objects

function &createSslStatusIcon( $poSrc  ){

	global $DEBUG, $confixx_interface_version;
	global $gcUserSeparator;

	$loValue =& $poSrc->Value(0);
	$liStatus = $loValue->Value();
	$loValue =& $poSrc->Value(1);
	$lcKunde = $loValue->Value();
	$loValue =& $poSrc->Value(2);
	$lcServer = $loValue->Value();
  $loValue =& $poSrc->Value(3);
	$lcRes = $loValue->Value();
  
	if(is_null($liStatus)){
		return new HTMLDataField('&nbsp;');
	}

	$lcBin = decbin( $liStatus );

	$liDel = substr( $lcBin, -1, 1);
	$liEdt = substr( $lcBin, -2, 1);
	$liNeu = bindec( substr( $lcBin, 0, -2 ) );

	if( $liDel == 1){
		$lcIcon = cc_StateDeleteIcon;
		$lcTitle = ltext('kuss_to_delete');
		$lcText = ltext('kuss_to_delete');

	}elseif( $liEdt == 1 ){
		$lcIcon = cc_StateActivateIcon;
		$lcTitle = ltext('kuss_to_create');
		$lcText = ltext('kuss_to_create');

	}elseif( $liNeu == 2  ){
		$lcIcon = cc_SSLDeactiveIcon;
		$lcTitle = ltext('kuss_crt_activate');
		$lcText = ltext('kuss_crt_activate');
		$lcAction = 'activate';

	}elseif( $liNeu == 3  ){
		$lcIcon = cc_SSLStateDeactivateIcon;
		$lcTitle = ltext('kuss_to_deactivate');
		$lcText = ltext('kuss_to_deactivate');
		$lcAction = 'activate';

	}elseif( $liNeu == 4  ){
		$lcIcon = cc_SSLStateActivateIcon;
		$lcTitle = ltext('kuss_to_activate');
		$lcText = ltext('kuss_to_activate');
		$lcAction = 'deactivate';

	}else{
		$lcIcon = cc_SSLActiveIcon;
		$lcTitle = ltext('kuss_crt_deactivate');
		$lcText = ltext('kuss_crt_deactivate');
		$lcAction = 'deactivate';
	}

	if( $confixx_interface_version == 'powp' ){
		$loIcon = new IconDataField($lcIcon, array( 'alt' => $lcTitle, 'title' => $lcTitle));
	} else {
		$loIcon = new HTMLDataField($lcText);
	}
	if($lcAction){
		$loAction = new LinkDataField( "javascript:setValue('kunde','".$lcKunde."');".
		                               "setValue('server_id','".$lcServer."');".
		                               "setValue('anbieter','".$lcRes."');".
																	 "submitForm('action','$lcAction')", 
																	 '', 
																	 array(), 
																	 $loIcon);
		$loAction->ParentAttribute( 'align', 'center' );
		$loAction->ParentAttribute( 'valign', 'middle' );
		return $loAction;
	} else {
		$loIcon->ParentAttribute( 'align', 'center' );
		$loIcon->ParentAttribute( 'valign', 'middle' );
		return $loIcon;
	}
}

$goDomains = new CompoundDBValue( " SELECT domain, richtigedomain FROM domains ".
                                  " WHERE richtigedomain IN (1,7) AND kunde=? ".
                                  " AND server_id=? ORDER BY domain" );

$goFindDomains = new CompoundDBValue( " SELECT domain, richtigedomain FROM domains ".
                                      " WHERE richtigedomain IN (1,7) AND kunde=? AND ".
                                      " domain LIKE '%?%' AND server_id=? ORDER BY domain" );

function &createSslDomainList( $poSrc  ){
	global $goDomains, $goFindDomains;
	global $to_find;

	$loValue    =& $poSrc->Value(0);
	$lcKunde    =  $loValue->Value();
	$loValue    =& $poSrc->Value(1);
	$lcServerId =  $loValue->Value();

	if( isset( $to_find ) && strlen( $to_find ) ){
		$goFindDomains->doQuery( array( new SQLValue( $lcKunde, 'C' ), 
		                                new SQLValue( $to_find, 'S' ), 
		                                new SQLValue( $lcServerId, 'C' )
		                               )
		                       );
		$liCount =  $goFindDomains->getCount();
		$loDS    =& $goFindDomains;
	}else{ 
		$liCount = 0;
	}
	
	if( !$liCount ){
		$goDomains->doQuery( array( new SQLValue( $lcKunde,'C' ), 
		                            new SQLValue( $lcServerId,'C' ) 
		                          ) 
		                   );
		$loDS =& $goDomains;
	}

	$loColumn =& $loDS->getColumn( 0 );
	$loSecondColumn =& $loDS->getColumn( 1 );

	if( $loColumn->getCount() > 4 ){
		$loColumn->keepLeft( 4 );
		$loColumn->addValue( new KeyValue( 'domain', '...' ) );
	}
	$loList =  new CompoundDataField();
	$loIter =& $loColumn->getFirstIterator();
	$loTypeIter =& $loSecondColumn->getFirstIterator();
	
  while( $loItem =& $loIter->getNext() 
         && $loTypeItem = & $loTypeIter->getNext() ){
    if( $loTypeItem->Value() == 7 ){
      $loList->AppendToContent( new HTMLDataField( '<i>'.$loItem->Value().'</i>')); 
    }else{
      $loList->AppendToContent( new HTMLDataField( $loItem->Value())); 
    }
	}
	$loList->SetSeparator( ', ' );

	return $loList;
}

function &createSslAction( $poSrc  ){
	global $confixx_interface_version;
	global $gcUserSeparator;

	$loValue  =& $poSrc->Value(0);
	$liStatus =  $loValue->Value();
	$loValue  =& $poSrc->Value(1);
	$lcKunde  =  $loValue->Value();
  $loValue  =& $poSrc->Value(2);
	$lcServer =  $loValue->Value();
  $loValue  =& $poSrc->Value(3);
	$lcRes    =  $loValue->Value();
	if(is_null($liStatus)){
		$lcActionIcon = cc_CreateIcon;
		$lcTitle      = ltext('kuss_link_new');
		$lcText       = ltext('kuss_link_new');
		$lcAction     = 'create';
	}else{
		$lcActionIcon = cc_ChangeIcon;
		$lcTitle      = ltext('kuss_link_edit');
		$lcText       = ltext('kuss_link_edit');
		$lcAction     = 'change';
	}

	$loActions = new LinkDataField(
"javascript:setValue('kunde','".$lcKunde."');".
		                               "setValue('server_id','".$lcServer."');".
		                               "setValue('anbieter','".$lcRes."');".
																	 "submitForm('action','$lcAction')"	, 
																	'', 
																	array(), 
																	( $confixx_interface_version == 'powp' )
																	? new IconDataField( $lcActionIcon )
																	: $lcText );
	$loActions->Attribute( 'title', $lcTitle );
	$loActions->ParentAttribute( 'align', 'center' );
	$loActions->ParentAttribute( 'valign', 'middle' );

	return $loActions;


}
function &createSslName($poSrc) 
{
	$lo_firstName = & $poSrc->Value( 0 );
	$lc_firstName = $lo_firstName->Value();
	$lo_lastName  = & $poSrc->Value( 1 );
	$lc_lastName  = $lo_lastName->Value();

	return new HTMLDataField( $lc_firstName.' '. $lc_lastName );
}


function &createSslCheckbox( $poObject ){
  global $gcUserSeparator;
  
  $loKunde = & $poObject->Value( 0 );
	$lcKunde = $loKunde->Value();
	$loServerId  = & $poObject->Value( 1 );
	$lcServerId  = $loServerId->Value();
	$loServerId  = & $poObject->Value( 2 );
	$lcRes  = $loServerId->Value();
	
  $loBox = new YesNoDataField( array( $lcKunde.$gcUserSeparator.$lcServerId.$gcUserSeparator.$lcRes=>null ), 
                                 array( "0" => NULL ), "", "users[]" );
	return $loBox->GetInputPresentation();
}
	
// end call back functions
//
//============================================================


$loDS->Conversion( new CompoundValue( new ValueFormated( 'status', NULL, 'createSslStatusIcon' ),
																			NULL, ## IP
																			NULL, ## user
																	    new ValueFormated( 'name', NULL, 'createSslName' ),
																			NULL, 
																			new ValueFormated( 'domains', NULL, 'createSslDomainList' ),
																			new ValueFormated( 'action', NULL, 'createSslAction' ),
																			new ValueFormated( 'checkbox', NULL, 'createSslCheckbox' )
																			)
									 );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page );
$loPTV->setParameter( 'head_text', $head_text );

$loPTV->setParameter( 'action', '' );
$loPTV->setParameter( 'kunde', '' );
$loPTV->setParameter( 'server_id', '' );
$loPTV->setParameter( 'anbieter', '' );
$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );

if( isset( $to_find ) && strlen( $to_find ) ){
	$loPTV->NoItemsMessage( ltext( 'll_empty_search' ) );
}	else {
	$loPTV->NoItemsMessage( ltext( 'll_empty_list' ) );
}
$loPTV->Anchor( 'list' );
$loPTV->FormIndex( 0 );

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'kunden_ssl.php#list',
																						 'name' => 'list_ssl' ), 
																			ltext( "mk_ssl" ) );


$dsSearch = new CompoundValue( new ValueFromArray( 'to_find', $to_find ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );
$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'to_find', 
																																	'size' => '16',
																																	'value' => $to_find,
																																	'MAXLENGTH'=> '32' )
																													 ) 
																		 );


$loGroup = new DivElement( array( 'class'=>'buttons' ) );
	

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1)", 
																							 'bid-search' 
																							 )
														);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('to_find','');".
																							 "submitForm('start_index',1)", 
																							 'bid-show-all'
																							 ) 
													);

$head_text = ltext( 'll_activate' );
$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:setValue('menu_node_id','ssl_group');".
																								"setValue('cur_page','kunden_ssl_group.php');".
																								"setValue('head_text','$head_text');".
																								"submitForm('action','gactivate')",
																								'bid-ssl-activate'
																								)
													 );
$head_text = ltext( 'll_deactivate' );
$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:setValue('menu_node_id','ssl_group');".
																								"setValue('cur_page','kunden_ssl_group.php');".
																								"setValue('head_text','$head_text');".
																								"submitForm('action','gdeactivate')",
																								'bid-ssl-deactivate'
																								)
													 );

$head_text = ltext( 'll_delete' );
$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:setValue('menu_node_id','ssl_group');".
																								"setValue('cur_page','kunden_ssl_group.php');".
																								"setValue('head_text','$head_text');".
																								"submitForm('action','delete')",
																								'bid-delete' 
																								)
													 );

	
$loSearch->setDataSource( $dsSearch, array( 'to_find' => $to_find ) );


if( ( isset( $to_find ) && strlen( $to_find ) ) || $total_number > 0 ){
		$tbl->setSearchElement( $loSearch );
}
if( $total_number > 0 ){
	$tbl->setGroupActionElement( $loGroup );
}

$tbl->updateBodyContent();

$page = new MainPageElement( $tbl );

$page->OutputHTML( array( '../../js/paged_form.js' ) );


/* -------------------- end HTML -------------------- */
?>
