<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

include_once( 'auth.php' );

include_once( 'defines.php' );

include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );

include_once( '../include/elements/html/class.MainPageElement.php' );


## mysql verbindung aufbauen
db_master_connect();
## /mysql verbindung aufbauen

$loRows = new SetOfRowsData();

$loRows->AppendHeaderRow();
$loRows->AppendFields( new HTMLDataField( ltext( 'seed_cell_status' ) ), 
											 new HTMLDataField( ltext( 'seed_cell_name' ) ),
											 new HTMLDataField( ltext( 'seed_cell_descr' ) ),
											 new HTMLDataField( ltext( 'anaeli_cell_select' ) )
											 );


## anbieter in array
$loPat = new SQlString('%'.$server.'%');
$id = safe_query2( "SELECT a.hostname, a.confixx_domain, a.server_id, a.login, ".
									 " s.name, s.status, s.descr ".
									 " FROM admin a LEFT JOIN server s ON a.server_id=s.server_id ".
									 " WHERE a.server_id != '$masterServerID' AND ".
									 " ( a.hostname LIKE ? OR a.confixx_domain LIKE ? )".
									 " ORDER BY s.name", $loPat, $loPat );
if( !db_num_rows( $id ) ){
	db_free_query( $id );
	$id = safe_query2( "SELECT a.hostname, a.confixx_domain, a.server_id, a.login, ".
										 " s.name, s.status, s.descr ".
										 " FROM admin a LEFT JOIN server s ON a.server_id=s.server_id ".
										 " WHERE a.server_id != '$masterServerID' ".
										 " ORDER BY s.name" );

 }

while( $werte = db_fetch_array( $id ) )	{
	$lcName = "'".$werte['name']."' (".$werte['confixx_domain'].')';
	$lcDescr = strlen($werte['descr'])>40? substr($werte['descr'],0,37).'...': $werte['descr'];

	switch( $werte['status'] ){
	case 1:
		$lcTitle = ltext('seed_status_to_on');
		$lcIcon = cc_StateConnectIcon;
		break;
	case 2:
		$lcTitle = ltext('seed_status_active');		
		$lcIcon = cc_StateActiveIcon;
		break;
	case 3:
		$lcTitle = ltext('seed_status_to_off');
		$lcIcon = cc_StateDisconnectIcon;
		break;
	default:
		$lcTitle = ltext('seed_status_unknown');
		$lcIcon = cc_UnknownIcon;
		break;
	}

	$loIcon = new IconDataField( $lcIcon, array('title' => $lcTitle) );

  if( $werte['status'] == 2 ){ 
  	$loLink = new LinkdataField( "adminredirect.php",
  															 '',
  															 array( 'type' => USERTYPE_ADMIN,
  																			'admin' => $werte['login'],
  																			'server_id' => $werte['server_id'] ),
  															 new HTMLDataField( $lcName )
  															 );
  	$loLink->Attribute( 'target', '_blank');
  	$loLink->Attribute( 'title', ltext('seed_goto_server') );
  }else{
	  $loLink = new HTMLDataField( $lcName );
  }


	$loRows->AppendRow();

	if( isset( $action ) ){
		$laArgs = array( 'server'=> $werte['name'],
										 'server_id'=> $werte['server_id'],
										 'action' => $action );
	}else{
		$laArgs = array( 'server'=> $werte['name'],
										 'server_id'=> $werte['server_id'] );
	}
	if( isset( $ret_path ) ){
		$laArgs['ret_path'] = $ret_path;
	}

	$loRows->AppendFields( $loIcon,
												 $loLink,
												 new HTMLDataField( $lcDescr ),
												 new LinkDataField( 'server_edit.php',
																						'',
																						$laArgs,
																						new HTMlDataField(ltext("anaeli_cell_select"))
																						)
												 );

	
	}
db_free_query( $id );

$loRows->LabelIndex( -1 );
$loForm =& $loRows->GetOutputPresentation();

$page = new MainPageElement( $loForm );
$page->OutputHTML();


db_close();
?>
