<?php
########## Confixx(R) 3.2 Professional ###########
###### Copyright SWsoft, Inc. 2004-2006 ##########
#### http://www.swsoft.com - info@swsoft.com ##### 
  
include_once( 'auth.php' );
include_once( 'defines.php');
include_once( '../include/class.Traffic.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.IconDataField.php' );
include_once( '../include/elements/data/class.PagedTableView.php' );
include_once( '../include/data_source/class.SQLQuery.php' );
include_once( '../include/data_source/class.CompoundValue.php' );
include_once( '../include/data_source/class.ValueLocale.php' );
include_once( '../include/data_source/class.ValueFromArray.php' );
include_once( '../include/data_source/class.ValueFormated.php' );
include_once( '../include/data_source/class.ConversedDBValue.php' );
include_once( '../include/data_source/class.DataValue.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/class.SimpleSearchElement.php' );
include_once( '../include/elements/html/class.PPButtonElement.php' );


global $DEBUG;
//$DEBUG=1;

db_master_connect();

$jahr = date( 'Y' );
$monat = date( 'm' );
$tag = date( 'd' );

if( $monat == 1){
	$lmonat = 12;
	$ljahr = $jahr - 1;
 }else{
	$lmonat = $monat - 1;
	$ljahr = $jahr;
 }

initPagingSettings( $_POST, array( 'name' => $name ) );

$res = safe_query2( "SELECT COUNT(*) FROM admin WHERE server_id != '$masterServerID'" );
list( $total_number ) = db_fetch_array( $res, 'N' );
db_free_query( $res );

if ( isset($name) && strlen($name) ) {
	$loPat = new SQLString( '%'.$name.'%' );
	$res = safe_query2( "SELECT COUNT(a.server_id) FROM admin a, server s ".
											" WHERE s.server_id = a.server_id AND ".
											" ( a.hostname LIKE ? OR s.name LIKE ?)",
											$loPat,$loPat );
	list( $total_number ) = db_fetch_array( $res );
	db_free_query( $res );
 }


//=========================================================
//
// get traffic


$trf = new Traffic();
$trf->setLog( $trafficLog );
$trf->setGroup( 'server_id' );
$trf->setFields( array( 'ftp', 'web', 'email', 'pop' ) );

$trf->monthlyQuery( $monat, $jahr );
$traffik = $trf->getGroupTraffic( 'all' );

$trf->monthlyQuery( $lmonat, $ljahr );
$ltraffik = $trf->getGroupTraffic( 'all' );

// end get traffic
//
//===============================================

$lcFields = "a.server_id, a.hostname, s.name ";

$loQuery = new SQLQuery( "SELECT $lcFields FROM admin a, server s ".
												 " WHERE a.server_id=s.server_id AND a.server_id != '$masterServerID'" );

$lcQuery =& $loQuery->Query();

if( isset( $name ) && strlen( $name ) ) {
	$lcQuery .= " AND ( a.hostname LIKE '%?%' OR s.name LIKE '%?%' )";
	$loQuery->Parameters( array( new SQLValue( $name,'S' ), new SQLValue( $name,'S' ) ) );
 }

/**
 * ---------------------------------------------------------------
 * Sort settings
 * ---------------------------------------------------------------
 */
 
switch ($order) {
 case 'du':
	 $lcQuery = "SELECT $lcFields, ".
		 " SUM(k.kbhomedir) + SUM(k.kbdb) + SUM(IF(k.popmaxkb=0,kbpop,0)) AS du ".
		 " FROM (admin a, server s) LEFT JOIN kunden k ON k.server_id = a.server_id".
		 " WHERE a.server_id = s.server_id AND a.server_id != '$masterServerID'";
	 if( $name ) {
		 $lcQuery .= " AND ( a.hostanme LIKE '%?%' OR s.name LIKE '%?%' )";
	 }
	 $lcQuery .= " GROUP BY a.server_id ORDER BY du";
	 break;

 case 'traffic':
	 $lcQuery = "SELECT $lcFields, ".
		 " SUM(t.ftp) + SUM(t.web)+SUM(t.email)+SUM(t.pop) AS traffic ".
		 " FROM (admin a, server s) LEFT JOIN transfer t ON t.server_id = a.server_id ".
		 " AND t.monat=$monat AND t.jahr = $jahr AND t.geloescht=0 AND t.log=1".
		 " WHERE a.server_id = s.server_id AND a.server_id != '$masterServerID'";
	 
	 if( $name ) {
		 $lcQuery .= " AND (a.hostname LIKE '%?%' OR s.name LIKE '%?%')";
	 }
	 $lcQuery .= " GROUP BY a.server_id ORDER BY traffic";

	 break;

 case 'ltraffic':
	 $lcQuery = "SELECT $lcFields, ".
		 " SUM(t.ftp) + SUM(t.web)+SUM(t.email)+SUM(t.pop) AS ltraffic ".
		 " FROM (admin a, server s) LEFT JOIN transfer t ON t.server_id = a.server_id ".
		 " AND t.monat=$lmonat AND t.jahr = $ljahr AND t.geloescht=0 AND t.log=1".
		 " WHERE a.server_id = s.server_id AND a.server_id != '$masterServerID'";
	 
	 if( $name ) {
		 $lcQuery .= " AND (a.hostname LIKE '%?%' OR s.name LIKE '%?%')";
	 }
	 $lcQuery .= " GROUP BY a.server_id ORDER BY ltraffic";

	 break;

 case 'ucount':
	 $lcQuery = "SELECT $lcFields, ".
		 " COUNT(k.kunde) AS ucount ".
		 " FROM (admin a, server s) LEFT JOIN kunden k ON k.server_id = a.server_id".
		 " WHERE a.server_id = s.server_id AND a.server_id != '$masterServerID'";
	 if( $name ) {
		 $lcQuery .= " AND ( a.hostname LIKE '%?%' OR s.name LIKE '%?%'";
	 }
	 $lcQuery .= " GROUP BY a.server_id ORDER BY ucount";
	 
	 break;
 default:
	 $order  = 'server';
	 $lcQuery .= " ORDER BY s.name, a.hostname";
 }

if ($direction=='desc') {
	$lcQuery .= ' DESC';
}

$loSrvDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1);

$loSrvDS->TotalNumber( $total_number );
$loSrvDS->doQuery();


$loTemplate = new CompoundValue( new CompoundValue ( new ValueFromArray( 'name' ), 
																										 new ValueFromArray( 'hostname' ),
																										 new ValueFromArray( 'server_id' )
																										 ),
																 new CompoundValue ( new ValueFromArray( 'server_id' ),
																										 new ValueFromArray( 'ucount' )
																										 ),
																 new CompoundValue( new ValueFromArray( 'server_id' ), 
																										new ValueFromArray( 'ltraffic')
																									 ),
																 new CompoundValue( new ValueFromArray( 'server_id' ), 
																									 new ValueFromArray( 'traffic')
																									 ),
																new CompoundValue( new ValueFromArray( 'server_id' ), 
																									 new ValueFromArray( 'du')
																									 )
																);

$laContent = array();

$lcIcon = ($direction=='desc')? cc_DescIcon: cc_AscIcon;

if( $order == 'server'){
	$laContent['server'] = new CompoundDataField( new HTMlDataField( ltext( 'srst_cell_server' )),
																									new IconDataField( $lcIcon )
																									);
	$laContent['server']->SetSeparator('');
 }else{
	$laContent['server'] = new HTMlDataField( ltext( 'srst_cell_server' ) );
 }


if( $order == 'ucount'){
	$laContent['ucount'] = new CompoundDataField( new HTMlDataField( ltext( 'srst_cell_users' )),
																									new IconDataField( $lcIcon )
																									);
	$laContent['ucount']->SetSeparator('');
 }else{
	$laContent['ucount'] = new HTMlDataField( ltext( 'srst_cell_users' ) );
 }

if( $order == 'ltraffic'){
	$laContent['ltraffic'] = new CompoundDataField( new HTMlDataField( ltext( 'srst_cell_traffic' ).' '.$lmonat.'/'.$ljahr),
																									new IconDataField( $lcIcon )
																									);
	$laContent['ltraffic']->SetSeparator('');
 }else{
	$laContent['ltraffic'] = new HTMlDataField( ltext( 'srst_cell_traffic' ).' '.$lmonat.'/'.$ljahr );
 }

if( $order == 'traffic'){
	$laContent['traffic'] = new CompoundDataField( new HTMlDataField( ltext( 'srst_cell_traffic' ).' '.$monat.'/'.$jahr),
																									new IconDataField( $lcIcon )
																									);
	$laContent['traffic']->SetSeparator('');
 }else{
	$laContent['traffic'] = new HTMlDataField( ltext( 'srst_cell_traffic' ).' '.$monat.'/'.$jahr );
 }

if( $order == 'du'){
	$laContent['du'] = new CompoundDataField( new HTMlDataField( ltext( 'srst_cell_du' )),
																									new IconDataField( $lcIcon )
																									);
	$laContent['du']->SetSeparator('');
 }else{
	$laContent['du'] = new HTMlDataField( ltext( 'srst_cell_du' ) );
 }


$lcNewDir = ($direction =='desc') ? 'asc' : 'desc';

$loTitle = new CompoundValue( new DataValue ( 'server', NULL,
																						 new LinkDataField( "javascript:setValue('order','server');".
																																"setValue('start_index',1);".
																																"submitForm('direction','$lcNewDir')",
																																'',
																																array(),
																																$laContent['server']
																																)
																							),
															new DataValue ( 'ucount', NULL,
																							new LinkDataField( "javascript:setValue('order','ucount');".
																																"setValue('start_index',1);".
																																"submitForm('direction','$lcNewDir')",
																																'',
																																array(),
																																$laContent['ucount']
																																)
																							),

															new DataValue ( 'ltraffic', NULL,
																							new LinkDataField( "javascript:setValue('order','ltraffic');".
																																 "setValue('start_index',1);".
																																 "submitForm('direction','$lcNewDir')",
																																										'',
																																 array(),
																																 $laContent['ltraffic']
																																 )
																							),

															new DataValue ( 'traffic', NULL,
																							new LinkDataField( "javascript:setValue('order','traffic');".
																																 "setValue('start_index',1);".
																																 "submitForm('direction','$lcNewDir')",
																																										'',
																																 array(),
																																 $laContent['traffic']
																																 )
																							),
															new DataValue ( 'du', NULL,
																							new LinkDataField( "javascript:setValue('order','du');".
																																 "setValue('start_index',1);".
																																 "submitForm('direction','$lcNewDir')",
																																 '',
																																 array(),
																																 $laContent['du']
																																 )
																							)
															);


$laWidths = array(  '20%', '20%', '20%', '20%','20%' );

$loSrvDS->Template( $loTemplate );

//=============================================================
//
// call-back functions
$errorColor = array( "bgcolor" => $fehlerfarbe );
$gcSrvDetails = ltext( 'stde_title1_master' );

function &makeServerLink( $poSrc ){
	global $DEBUG;
	global $gcSrvDetails;

	list($lcName,$lcHostname,$lcServerID) = $poSrc->listValue();
	

	$linkSrv = new LinkDataField( 'statistik_details.php', '',
																array( 'server_id' => $lcServerID, 
																			 'menu_node_id' => 'stat_srv',
																			 'cur_page' => 'statistik_details.php', 
																			 'head_text' => $gcSrvDetails 
																			 ),
																$lcName
																);
	return $linkSrv;
}

$gaCountDSs = array();

$gaCountDSs['du'] = new CompoundDBValue( new SQLQuery( "SELECT SUM(kbhomedir)+SUM(kbdb) + SUM(IF(popmaxkb=0,kbpop,0)) ".
																											 " FROM kunden WHERE server_id=?",
																											 array( new SQLValue( '', 'C' ) ) ) );

$gaCountDSs['ucount'] = new CompoundDBValue( new SQLQuery( "SELECT COUNT(kunde) FROM kunden ".
																													 " WHERE server_id=?",
																													 array( new SQLValue( '', 'C' ) ) ) );

$trf = new Traffic();
$trf->setLog( $trafficLog );
$trf->setGroup( 'server_id' );
$trf->setFields( array( 'ftp', 'web', 'email', 'pop' ) );
$trf->monthlyQuery( $monat, $jahr );
$traffik = $trf->getGroupTraffic('all');

$trf->monthlyQuery( $lmonat, $ljahr );
$ltraffik = $trf->getGroupTraffic( 'all' );


function &makeDiskUsage( &$poSrc ){
	global $gaCountDSs;
	global $DEBUG;

	list($lcServerID, $liDu ) = $poSrc->listValue();
	if( ! is_numeric( $liDu ) ){
		$loDS =& $gaCountDSs['du'];
		$loQuery =& $loDS->SQLQuery();
		$loParam =& $loQuery->Parameter(0);
		$loParam->Value( $lcServerID );
		$loDS->doQuery();
		$loRow =& $loDS->Value(0);
		list( $liDu ) = $loRow->listValue();
	}

	$lcText = sinnv_kbwert($liDu);
	
	$duRes = new HTMLDataField( $lcText, array(), array( 'align' => 'right' ) );
	
	return $duRes;
}

$gcSrvTrf = ltext('stsrtr_head');

function &makeTrafficUsage( $poSrc ){
	global $traffik,$monat, $jahr;
	global $fehlerfarbe;
	global $gcSrvTrf;

	list( $lcServerID, $liTraffic ) = $poSrc->listValue();
	if( ! is_numeric( $liTraffic ) ){
		$liTraffic = $traffik[$lcServerID];
	}

	$lcText = sinnv_kbwert( $liTraffic );
	$trnsferSrv = new LinkDataField( "statistik_details_transfer.php",
																	 '',
																	 array('server_id'=>$lcServerID,
																				 'jahr' => $jahr,
																				 'monat' => $monat,
																				 'menu_node_id' => 'stat_srv_trf',
																				 'cur_page' => 'statistik_details_transfer.php',
																				 'head_text' => $gcSrvTrf 
																				 ),
																	 $lcText
																	 );

	$trnsferSrv->ParentAttribute('align','right');

	return $trnsferSrv;
}

function &makeLTrafficUsage( &$poSrc ){
	global $ltraffik, $lmonat, $ljahr;
	global $fehlerfarbe;
	global $gcSrvTrf;

	list( $lcServerID, $liTraffic ) = $poSrc->listValue();
	if( ! is_numeric( $liTraffic ) ){
		$liTraffic = $ltraffik[$lcServerID];
	}

	$lcText = sinnv_kbwert( $liTraffic );
	$trnsferSrv = new LinkDataField( "statistik_details_transfer.php",
																	 '',
																	 array('server_id'=>$lcServerID,
																				 'jahr' => $ljahr,
																				 'monat' => $lmonat,
																				 'menu_node_id' => 'stat_srv_trf',
																				 'cur_page' => 'statistik_details_transfer.php',
																				 'head_text' => $gcSrvTrf 
																				 ),
																	 $lcText
																	 );

	$trnsferSrv->ParentAttribute('align','right');

	return $trnsferSrv;
}

function &makeUsersCount( &$poSrc ){
	global $gaCountDSs;
	global $fehlerfarbe;

	list( $lcServerID, $liCount ) = $poSrc->listValue();
	if( ! is_numeric( $liCount ) ){
		$loDS =& $gaCountDSs['ucount'];
		$loQuery =& $loDS->SQLQuery();
		$loParam =& $loQuery->Parameter(0);
		$loParam->Value( $lcServerID );
		$loDS->doQuery();
		$loRow =& $loDS->Value(0);
		list( $liCount ) = $loRow->listValue();
	}

	$lcText = sinnv_intwert( $liCount );

	$kundenRes = new HTMLDataField( $lcText,
																	array(),
																	array( 'align' => 'right')
																	);
	return $kundenRes;
}

// end call-back functions
//
//=======================================================

$loConv = new CompoundValue( new ValueFormated( 'server', NULL, 'makeServerLink' ),
														 new ValueFormated( 'ucount', NULL, 'makeUsersCount' ),
														 new ValueFormated( 'ltraffic', NULL, 'makeLTrafficUsage' ),
														 new ValueFormated( 'traffic', NULL, 'makeTrafficUsage' ),

														 new ValueFormated( 'du', NULL, 'makeDiskUsage' )
														 );


$loSrvDS->Conversion( $loConv );

$loSrvDS->doQuery();

$loPTV = new PagedTableView( $loSrvDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page?$cur_page:'' );
$loPTV->setParameter( 'head_text', $head_text );
if( isset($name) && strlen( $name ) ){
	$loPTV->NoItemsMessage(ltext('ll_empty_search'));
}	else {
	$loPTV->NoItemsMessage(ltext('ll_empty_list'));
}

$loPTV->setParameter( 'order', "$order" );
$loPTV->setParameter( 'direction', "$direction" );

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'statistik_start.php',
																						 'method' => 'post',
																						 'name' => 'reslist' ), 
																			ltext( 'ms_resellerstats' ) 
																			);

$dsSearch = new CompoundValue( new ValueFromArray( 'name', $name ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );
$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'name', 
																																	'size' => '16',
																																	'value' => $name,
																																	'MAXLENGTH'=> '32' )
																													 ) 
																		 );

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1)", 
																							 'bid-search' 
																							 )
													);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('name','');".
																							 "submitForm('start_index',1)", 
																							 'bid-show-all'
																							 ) 
													);

$dsSearch = new CompoundValue( new ValueFromArray( 'name', $name ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );

$loSearch->setDataSource( $dsSearch, array( 'name' => $name ) );


$tbl->setSearchElement( $loSearch );

$tbl->updateBodyContent();


//
//
//==============================================================================


$page = new MainPageElement( $tbl );

$page->OutputHTML( array( '../js/paged_form.js' ) );


db_close();

?>
