<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/module.Database.php' );
include_once( '../include/class.SQLFieldSet.php' );
            
global $email_mode, $pop3;

global $DEBUG;
//$DEBUG=1;

function findNewPopId( $pcUser = null, $pcServerID = null ){
  global $ServerID;
  global $PHP_AUTH_USER;
  
  $lmTmp = '';
  
  if( ! is_string( $pcUser ) ){
  	$pcUser = $PHP_AUTH_USER;
  }
  
  if( ! is_string( $pcServerID ) ){
  	$pcServerID = $ServerID;
  }
  
  $loUser         = new SQLString( $pcUser );
  $loServerID     = new SQLString( $pcServerID );
  $laUsedAccounts = array();
  
	$lrId = safe_query2( "SELECT number FROM pop3 WHERE server_id=? AND kunde = ? ORDER BY number",
	                          $loServerID, $loUser );	 

	while( list( $lmTmp ) = db_fetch_array( $lrId ) ){	 
	  $laUsedAccounts[] = intval( $lmTmp );
	}	 
	
	db_free_query( $lrId );
	
	$lrId = safe_query2 ( "SELECT account FROM delaccs WHERE kunde = ? AND server_id=?", 
	                       $loUser, $loServerID);
  
  while( list( $lmTmp ) = db_fetch_array( $lrId ) ){
    $laUsedAccounts[] =  intval( substr( $lmTmp, strlen( $pcUser.'p' ) ) );
  }
  
  db_free_query( $lrId );
  sort( $laUsedAccounts );
	$liNumAccounts = count( $laUsedAccounts );
	$liMaxUsedId   = end( $laUsedAccounts ); 
	  
	for( $i = 1; $i < $liNumAccounts + 1; $i++ ){
	 if( ! in_array( $i, $laUsedAccounts ) ){	
	   return $i;
	  } 
	}
	
	return $liMaxUsedId + 1;
}

db_connect($db_host, $db_user, $db_pass);

$id = db_query( "SELECT popmaxkb, popmaxkbhard, quota  FROM admin WHERE server_id='$ServerID'");
list( $popmaxkb, $popmaxkbhard, $liAdminQuota ) = db_fetch_array( $id );
db_free_query( $id );


$loUser = new SQLString( $PHP_AUTH_USER );
$id = safe_query2( " SELECT maxpop, anbieter, popmaxkb, def_popmaxkb, def_popmaxkbhard  FROM kunden ".
                   " WHERE kunde = ? AND server_id='$ServerID'", $loUser );
list($maxpop,$anbieter, $liUserMailSpaceLimit, $liUserPopmaxkb, $liUserPopmaxkbhard )  = db_fetch_array( $id, 'N' );
db_free_query( $id );

if( $liAdminQuota && $liUserMailSpaceLimit ){
  $popmaxkbhard = $liUserPopmaxkbhard;
  $popmaxkb = $liUserPopmaxkb;
}

$id = safe_query2( " SELECT COUNT(account) AS pop FROM pop3 ".
                   " WHERE kunde = ? AND server_id='$ServerID'", $loUser);
list( $popCount ) = db_fetch_array($id);
db_free_query( $id );

$id = safe_query2( " SELECT SUM(maxkbhard) FROM pop3 ".
                   " WHERE kunde = ? AND server_id='$ServerID'", $loUser);
list( $liDefinedMailSpace ) = db_fetch_array( $id );
db_free_query( $id );

if( ( $popCount >= $maxpop ) && ( $maxpop <> -1 ) ){ 
	$fehlertext = ltext("empoan_error1");
	db_close();
	include("email_pop3.php");
	exit();
}
/**
 * Checks for mail space
 */
if( $liAdminQuota 
    && ( ( $liDefinedMailSpace + $popmaxkbhard ) > $liUserMailSpaceLimit )
    && $liUserMailSpaceLimit != -1    
    && $liUserMailSpaceLimit != 0 ){

  $laTmp = array( sinnv_kbwert( $popmaxkbhard ), 
                  sinnv_kbwert( $liUserMailSpaceLimit - $liDefinedMailSpace ) );
  $fehlertext = ltext( 'empoan_error_mailspace_2', $laTmp );
	db_close();
	include( 'email_pop3.php' );
	exit();
}

if( $liAdminQuota  && $liUserMailSpaceLimit > 0 && $popmaxkbhard == 0 ){
  $fehlertext = ltext( 'emquch_error6', sinnv_kbwert( $liUserMailSpaceLimit ) );
	db_close();
	include( 'email_pop3.php' );
	exit();
}



if( ($newpw1 || $newpw2)&&$specifyPassword) {
	if( $newpw1 != $newpw2 ) {
		 $fehlertext = ltext("empopw2_error2");
		 include("email_pop3.php"); 
		 popPathBar();
		 exit();
	} elseif( valid_pw( $newpw1 ) ) {
		$newpw = $newpw1;
	} else {
    $liMaxPwdLength = defined( 'MaxPwdLength' ) ? MaxPwdLength : 12;
    $fehlertext = ltext("short_pass_error", $liMaxPwdLength );
		 popPathBar();
		 include("email_pop3.php"); 
		 exit();
	}
} else {
	$newpw = mkpasswd(8);
}

if( $DEBUG ) {
	echo "email_pop3_anlegen.php: newpw=$newpw<br>\n";
}

$number = findNewPopId();
$newpop = $PHP_AUTH_USER."p".$number;

$newpw2 = crypt_pw($newpw);
$uid = getuid();

$timestamp = time();

$loFields = new SQLFieldSet( array( 'account' => array( $newpop, 'C' ), 
																		'number' => $number, 
																		'uid' => $uid, 
																		'passwort' => array( '', 'C' ), 
																		'longpw' => array( $newpw2, 'C' ), 
																		'kunde' => array( $PHP_AUTH_USER, 'C' ), 
																		'anbieter' => array( $anbieter, 'C' ), 
																		'quota' => 1, 
																		'maxkb' => $popmaxkb, 
																		'maxkbhard' => $popmaxkbhard, 
																		'language' => array( $lang_short, 'C' ), 
																		'kommentar' => array( $comment, 'C' ), 
																		'lastchange' => $timestamp,
																		'server_id' =>  array( $ServerID, 'C' ) )
														 );
list($lcFlds,$lcVals)= $loFields->getSQLInsert();
db_query ( "INSERT INTO pop3 ( $lcFlds ) VALUES ( $lcVals )" ); 
/* yet time
, drweb=1
*/ ## /yet time
db_query( "UPDATE allgemein SET addpop=1, quota=1 WHERE server_id='$ServerID'");
freeuid();

$fehlertitel = ltext( "empoan_error3" );
$fehlertext = ltext( "empoan_error4", array( $newpop, $newpw ) );
db_close();

if( !$email_mode ) {
	popPathBar();
	include("email_pop3.php");
	exit();
} else {
	$fehlertext .= "<br>\n";
	$pop3 = $newpop;
}
?>
