<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( "auth.php" );/*{{{*/
include_once( "../include/class.SQLString.php" );
include_once( "../include/data_source/class.SQLQuery.php" );
include_once( "../include/data_source/class.CompoundValue.php" );
include_once( "../include/data_source/class.ValueLocale.php" );
include_once( "../include/data_source/class.ValueFromArray.php" );
include_once( "../include/data_source/class.ValueFormated.php" );
include_once( "../include/data_source/class.CallBackValue.php" );
include_once( "../include/data_source/class.ConversedDBValue.php" );
include_once( "../include/data_source/class.DataValue.php" );
include_once( "../include/elements/data/class.SetOfRowsData.php" );
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/data/class.TextDataField.php" );
include_once( "../include/elements/data/class.LinkDataField.php" );
include_once( "../include/elements/data/class.PasswordDataField.php" );
include_once( "../include/elements/data/class.PagedTableView.php" );
include_once( "../include/elements/data/class.IconDataField.php" );
include_once( "../include/elements/data/class.CheckDataField.php" );
include_once( "../include/elements/html/class.CompoundElement.php" );
include_once( "../include/elements/html/class.PPButtonElement.php" );
include_once( "../include/elements/html/class.ButtonURLElement.php" );
include_once( "../include/elements/html/class.SimpleSearchElement.php" );
include_once( "../include/elements/html/class.MainPageElement.php" );
include_once( "defines.php" );/*}}}*/

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "email_quota: _POST<br><pre>\n";
	print_r($_POST);
	echo "</pre><hr>_GET<br><pre>\n";
	print_r($_GET);
	echo "</pre><hr>";
}

db_connect($db_host, $db_user, $db_pass);

$loUser = new SQLString( $PHP_AUTH_USER );

$lrId = safe_query2( "SELECT popmaxkb FROM kunden WHERE kunde = ? 
                      AND server_id='$ServerID'", $loUser );
list( $liTotalLimit ) = db_fetch_array( $lrId );
db_free_query( $lrId );

/**
 * You are not authorized to use this service?
 */
if( $liTotalLimit == 0 ){
  $fehlertext = ltext( 'service_is_disabled' );
  include 'allgemein_start.php';
  exit;
}

/**
 * Perform action?
 */
switch ($action ){/*{{{*/
  case 'change':
	   $action='';
  	 $ident = $email_ident;
  	 include('email_quota_change.php');
  	 exit;
     break;
   case 'def_mailspace':
     
     $condition = ( $maxkb >= 0 && $maxkbhard >= 0 ) 
             && ( ( $maxkb <= $maxkbhard && $maxkb !=0 ) || $maxkbhard == 0 );

    if( $condition ){
      // MB -> KB
      $maxkb     = $maxkb * 1024;
      $maxkbhard = $maxkbhard * 1024;

      $lrId = safe_query2( "SELECT popmaxkb FROM kunden WHERE kunde = ? 
                            AND server_id='$ServerID'",  new SQLString( $PHP_AUTH_USER ) );
      list( $liTotalLimit ) = db_fetch_array( $lrId );
      db_free_query( $lrId );
  
      if( $liTotalLimit != -1 && $maxkbhard == 0 ){
        $fehlertext  = ltext( 'emquch_error5', sinnv_kbwert( $liTotalLimit ) );
      }

      safe_query2( " UPDATE kunden SET def_popmaxkb = ?, def_popmaxkbhard = ? ".
                   " WHERE kunde = ? AND server_id='$ServerID'", 
                    new SQLInteger( $maxkb ), new SQLInteger( $maxkbhard  ), $loUser );
    }else{
      $fehlertitel = ltext( 'empopw2_error4' );
      $fehlertext  = ltext( 'emquch_error2' );
    }
    break;
}/*}}}*/

/**
 * Show add form & box list
 */
$id = db_query( "SELECT email FROM admin WHERE server_id='$ServerID'" );
list($skemail) = db_fetch_array($id);


$id = safe_query2( "SELECT COUNT(account) AS pop FROM pop3 WHERE kunde = ?  AND server_id='$ServerID'",  $loUser );
list($pop3Count) = db_fetch_array($id);

$id = safe_query2( "SELECT maxpop, anbieter FROM kunden WHERE kunde = ?  AND server_id='$ServerID'", $loUser );
list( $maxpop3, $anbieter ) = db_fetch_array( $id, 'N' );

/**
 * Default mail space form
 */
$lrId = safe_query2( " SELECT def_popmaxkb, def_popmaxkbhard ".
                     " FROM kunden WHERE kunde=? AND server_id='$ServerID'", $loUser );
$laRow = db_fetch_array( $lrId );
$liHardQuota = round( $laRow["def_popmaxkbhard"] / 1024 );
$liSoftQuota = round( $laRow["def_popmaxkb"] / 1024);

$loMailSpaceDef = new SetOfRowsData();
$loMailSpaceDef->AppendRow( new HTMLDataField( ltext( "emquch_soft" ) ), 
                  new TextDataField( $liSoftQuota, "maxkb", true, array( "size"=>"10" ),
                                    array( ) 
                                   ),
                  new HTMLDataField( $lang_format_mb_expr ) 
                 );
                 
$loMailSpaceDef->AppendRow( new HTMLDataField( ltext( "emquch_hard" ) ), 
                  new TextDataField( $liHardQuota, "maxkbhard", true, array( "size"=>"10" ),
                                    array( ) ),
                  new HTMLDataField( $lang_format_mb_expr ) );
                  
$loMailSpaceDef->AppendHidden( new TextDataField( 'def_mailspace', "action" ) );
$loMailSpaceDef->AppendButton( ltext("ll_change"), "javascript:doChange()", cc_IDOk );
$loMailSpaceDefForm = $loMailSpaceDef->GetInputPresentation( array( "action"=>"email_quota.php", 
                                                                    "method"=>"post", 
                                                                    "name"=>"form1" ), 
                                                             ltext("mail_space_def") );

$listFormIndex = 1;

//===============================================================
//
// list

initPagingSettings( $_POST, array( 'to_search' => $to_search ) );

$lcSQL = "SELECT COUNT(account) FROM pop3 WHERE kunde=? AND server_id='$ServerID'";
$res = safe_query2( $lcSQL, $loUser );
list( $total_number ) = db_fetch_array( $res );

$lcFields = "account, uid, gesperrt, neu, maxkb, maxkbhard, diskusage, kommentar, neu+10*gesperrt as state";

if (isset($to_search)&&strlen($to_search) ){
	$loPop3 = new SQLValue( $to_search, 'S' );
	$lcWhere = "(account LIKE '%?%' OR kommentar LIKE '%?%') AND kunde = ? AND server_id='$ServerID'";
	$lcSQL = "SELECT COUNT(account) FROM pop3 WHERE ".$lcWhere;

	$loQuery = new SQLQuery( $lcSQL, array( $loPop3, $loPop3, new SQLValue($PHP_AUTH_USER,'C') ) );

	$loQuery->doQuery();
	list($total_number) = $loQuery->fetchArray('N');

	$lcSQL = "SELECT ".$lcFields." FROM pop3 WHERE ".$lcWhere;
	$loQuery->Query( $lcSQL );

} else {

	$lcSQL = "SELECT ".$lcFields." FROM pop3 WHERE kunde=? AND server_id='$ServerID'";
	$loQuery = new SQLQuery( $lcSQL, array( new SQLValue($PHP_AUTH_USER,'C') ) );
}

$lcSQL =& $loQuery->Query();

if( !isset( $order ) ){
    $order = 'box';
}

$laOrders = array( 'box'   => 'number', 
                   'state' => 'state', 
                   'softquota' => 'maxkb', 
                   'hardquota' => 'maxkbhard', 
                   'usage' => 'diskusage', 
                 );

if( array_key_exists( $order, $laOrders ) ){ 
  $lcSQL .= " ORDER BY ".$laOrders[$order]; 
}else{ 
  $lcSQL .= " ORDER BY number"; 
} 

$lcSQL .= $direction == 'desc' ? " DESC" : "";




$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index - 1 );
$loDS->TotalNumber( $total_number );

$loTemplate = new CompoundValue( new CompoundValue( new ValueFromArray( 'neu'), /* state */
																										new ValueFromArray( 'gesperrt'),
																										new ValueFromArray( 'account')
																										),
																 new ValueFromArray( 'account'), 
																 new ValueFromArray( 'maxkb'),
																 new ValueFromArray( 'maxkbhard'),
																 new CompoundValue( new ValueFromArray( 'diskusage'),
																										new ValueFromArray( 'maxkb'),
																										new ValueFromArray( 'maxkbhard')
																										),
																 new ValueFromArray( 'account')
																 );

$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute('onclick', "javascript:checkedAll('pop3s',this.checked,$listFormIndex)" );
$loCheckBox->SetParentAttributes(array('align'=>'center'));
$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );

$laContent =array();

$lcDirIcon = $direction == 'desc' ? cc_DescIcon : cc_AscIcon; 
$lcNewDir  = $direction == 'desc' ? 'asc' : 'desc';

$laHeaders = array( 'state'      => array( 'name' => 'empo_cell_status',    'sort' => 1 ), 
                    'box'        => array( 'name' => 'empo_cell_pop3',      'sort' => 1 ), 
                    'softquota'  => array( 'name' => 'empo_cell_softquota', 'sort' => 1 ), 
                    'hardquota'  => array( 'name' => 'empo_cell_hardquota', 'sort' => 1 ), 
                    'diskusage'  => array( 'name' => 'empo_cell_diskusage', 'sort' => 1 ), 
                    'change'     => array( 'name' => 'll_change',           'sort' => 0 ) 
                   );

                    
foreach( $laHeaders as $lcKey => $laValue ){ 
  if( $laValue['sort'] ){ 
    if( $order == $lcKey ){ 
      $loContent = new CompoundDataField( new HTMLDataField( ltext( $laValue['name'] ) ), 
                                          new IconDataField( $lcDirIcon ) 
                                        ); 
      $loContent->SetSeparator( '' ); 
    }else{ 
      $loContent = new HTMlDataField( ltext( $laValue['name'] ) ); 
    } 
    $laContent[] = new DataValue( $lcKey, NULL, new LinkDataField( "javascript:setValue('order', '$lcKey',$listFormIndex);". 
                                                                   "setValue('start_index',1,$listFormIndex);". 
                                                                   "submitForm('direction','$lcNewDir',$listFormIndex)", 
                                                                  '', array(), $loContent ) 
                                ); 
  }else{ 
    $laContent[] = new ValueLocale( $laValue['name'] ); 
  } 
}



$loTitle = new CompoundValue( $laContent );

$laWidths = array( '5%','25%','20%','20%','20%','10%');

$loDS->Template( $loTemplate );

//==============================================================
//
// call-back functions to make visble objects

$gcNew = ltext( 'll_state_creating' );
$gcNormal = ltext( 'll_state_ok' );
$gcToDelete = ltext( 'll_state_removing' );
$gcLocked = ltext( 'll_state_locked' );

function makeStatus( $poSrc ){
	global $gcNew, $gcNormal, $gcToDelete, $gcLocked, $confixx_interface_version;
	
	$loVal =& $poSrc->Value(0);
	$liNeu= $loVal->Value();

	$loVal =& $poSrc->Value(1);
	$liLocked = $loVal->Value();

	$loVal =& $poSrc->Value(2);
	$lcPop3 = $loVal->Value();

	switch( $liNeu ){
	case 1:
		$lcTitle = $gcNew;
		$lcIcon = cc_StateNewIcon;
		break;
	case 2:
		$lcTitle = $gcToDelete;
		$lcIcon = cc_StateDeleteIcon;
		break;
	default:
		if( $liLocked ){
			$lcTitle = $gcLocked;
			$lcIcon = cc_StateLockedIcon;
		} else {
			$lcTitle = $gcNormal;
			$lcIcon = cc_StateOkIcon;
		}
	}
  if ($confixx_interface_version == 'powp' ){
	 $loIcon = new IconDataField( $lcIcon, 
															 array( 'alt' => $lcTitle, 'title' => $lcTitle ), 
															 array( 'align'=>'center') );
  } else {
    $loIcon = new HTMLDataField($lcTitle, FALSE, array(), array( 'align'=>'center'));
  }
	return $loIcon;
	
}

function makePop3Link( $poSrc ){
	global $user_prefix;

	$loLink = new LinkDataField( "/poplogin/", '', array('login'=>$poSrc), $poSrc );
	$loLink->SetAttributes (array( 'target' => 'webmail' ) );

	return $loLink;
}

function makeAction( $poSrc ){
	global $listFormIndex, $confixx_interface_version;
	$lcText = ltext('ll_change');
	$loActions = new LinkDataField( "javascript:setValue('pop3','$poSrc',$listFormIndex);".
																	"setValue('cur_page','email_quota_change.php',$listFormIndex);".
																	"setValue('menu_node_id','change_quota',$listFormIndex);".
																	"submitForm('action','change',$listFormIndex)", 
																	'', 
																	array(), 
																	($confixx_interface_version == 'powp')?new IconDataField( cc_ChangeIcon ):$lcText);
	$loActions->Attribute( 'title', ltext('ll_change')  );
	$loActions->ParentAttribute( 'align','center');
	return $loActions;
}

function makeSpamFilter($poSrc ){
	global $listFormIndex, $confixx_interface_version;
	$lcText    = ltext('ll_change');
	$loActions = new LinkDataField('email_spam_config.php', 
																	'', 
																	array('pop3'=>$poSrc), 
																	($confixx_interface_version == 'powp')
																	? new IconDataField(cc_SpamFilterIcon) 
																	: $lcText);
	$loActions->Attribute('title', ltext('ll_change'));
	$loActions->ParentAttribute('align','center');
	return $loActions;
}

function makeDiskUsage( $poSrc ){
  global $lang_format_mb_expr;
  global $fehlerfarbe;

  $lcClass = ''; 
  $loVal =& $poSrc->Value(0);
	$liDiskUsage = $loVal->Value();

	$loVal =& $poSrc->Value(1);
	$liSoftQuota = $loVal->Value();

	$loVal =& $poSrc->Value(2);
	$liHardQuota = $loVal->Value();

	if( $liDiskUsage >= $liHardQuota && $liHardQuota != 0 ){
		$lcClass = 'critical';
	}elseif( $liDiskUsage >= $liSoftQuota && $liSoftQuota != 0 ){
		$lcClass = 'overlimit';
	}
	
	$loField = new HTMLDataField( sinnv_kbwert( $liDiskUsage ) );
	
	if ( $lcClass ) {
  	$loField->ParentAttribute('class',$lcClass);
	}
	
//	$loField->ParentAttribute('align','center');
	return $loField;
}

function makeQuota( $piQuota ){
  global $lang_format_mb_expr;

  $piQuota = round( 	$piQuota / 1024 );
	$loField = new HTMLDataField( 	$piQuota.' '.$lang_format_mb_expr );
	
	return $loField;
}



// end call-back functions to make visble objects
//
//==============================================================


$loConv = new CompoundValue( new ValueFormated( 'status', NULL, 'makeStatus' ),
														 new ValueFormated( 'pop3', NULL, 'makePop3Link' ),
														 new ValueFormated( 'softquota', NULL, 'makeQuota' ),
														 new ValueFormated( 'hardquota', NULL, 'makeQuota' ),
														 new ValueFormated( 'diskusage', NULL, 'makeDiskusage' ),
														 new ValueFormated( 'action', NULL, 'makeAction' )
														 );

$loDS->Conversion( $loConv );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page?$cur_page:'' );
$loPTV->setParameter( 'head_text', $head_text );
 
$loPTV->setParameter( 'action', '' );
$loPTV->setParameter( 'pop3', '' );

$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );

if (isset($to_search)&&strlen($to_search) ){
	$loPTV->NoItemsMessage(ltext('ll_empty_search'));
} else {
	$loPTV->NoItemsMessage(ltext('ll_empty_list'));
}

$loPTV->Anchor( 'list' );
$loPTV->FormIndex( $listFormIndex );

$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'email_quota.php#list',
																						 'name' => 'list_pop3s' ), 
																			ltext( 'me_mailquota' ) );

$dsSearch = new CompoundValue( new ValueFromArray( 'to_search', $to_search ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );

$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'to_search', 
																																	'size' => '16',
																																	'value' => $to_search,
																																	'MAXLENGTH'=> '32' )
																													 ) 
																		 );
	
$loGroup = new DivElement(array('class'=>'buttons'));
	

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1,$listFormIndex)", 
																							 'bid-search' 
																							 )
													);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('to_search','',$listFormIndex);".
																							 "submitForm('start_index',1,$listFormIndex)", 
																							 'bid-show-all'
																							 ) 
													);

	
$loSearch->setDataSource( $dsSearch, array( 'to_search' => $to_search ) );

if ( ( isset( $to_search ) && strlen( $to_search ) ) || $total_number > 0 ){
	$tbl->setSearchElement( $loSearch );
}
if ($total_number>0 ){
	$tbl->setGroupActionElement( $loGroup );
}

$tbl->updateBodyContent();


// end list
//
//==============================================================


$page = new MainPageElement( $loMailSpaceDefForm, $tbl );
$page->OutputHTML( array( '../../js/paged_form.js', "../../js/common.js" ), js_f_call_help('', 'empo_desc1'));
/* -------------------- end HTML -------------------- */

db_close();
?>
