<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

include_once( "auth.php" );
include_once( "../include/cron_functions.php" );
include_once( "../include/elements/data/class.LikePagedRowsData.php" );
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/data/class.LinkDataField.php" );
include_once( "../include/elements/data/class.TextDataField.php" );
include_once( "../include/elements/data/class.CheckDataField.php" );
include_once( "../include/elements/data/class.ButtonData.php" );
include_once( "../include/elements/data/class.IconDataField.php" );
include_once( "../include/elements/data/class.CompoundDataField.php" );
include_once( "../include/elements/data/class.ToolsButtons.php" );
include_once( "../include/elements/data/class.ToolsButtonData.php" );
include_once( '../include/page_functions.php' );
include_once( "../include/elements/html/class.DivElement.php" );
include_once( "../include/elements/html/class.MainPageElement.php" );
include_once( "defines.php");
include_once('module.Informer.php');

global $DEBUG;
//$DEBUG = 1;

if( $DEBUG ){
	echo "tools_cron.php: _POST<br><pre>\n";
	print_r($_POST);
	echo "</pre><hr>\n";
 }

if( !defined('CONFIXX') ) {
	define('CONFIXX', 1);
}

## mysql verbindung aufbauen
db_connect($db_host, $db_user, $db_pass);
## /mysql verbindung aufbauen

$vars = array( "minute" => ltext("cron_minute"), 
							 "hour" => ltext("cron_hour"), 
							 "dom" => ltext("cron_day_of_month"),
							 "month" => ltext("cron_month"),
							 "dow" => ltext("cron_day_of_week"),
							 "cmd" => ltext("cron_cmd")
							 );
$var_values = array();
$bad_values = false;

$cron_rec = load_cron();
$cron_content = ($cron_rec == false) ? array('') : explode("\n", $cron_rec['cronfile']);
$crn = new Crontab($cron_content); 


// delete cronjob from the system
if( ($action == 'delete') && is_array( $keys ) ){
	if( $cron_rec['neu'] == 2 ){

		$js_confirmation .= js_f_confirm( ltext( 'cron_confirm_refuse_reread' ), 
																			js_f_goto( 'tools_cron.php' )
																			);		
	}

	foreach( $keys as $key ){
		if($DEBUG){
			echo "delete '$key'<br>\n";
		}
		if( $delent = &$crn->getEntry(base64_decode( $key ) ) ){
			$delent->Remove();
		}
	}

	save_cron( $crn->export() );

}


$loUser = new SQLString( $PHP_AUTH_USER );
$id = safe_query2("SELECT maxcronjobs FROM kunden WHERE kunde=? AND server_id='$ServerID'", $loUser);
list( $maxcronjobs ) = db_fetch_array( $id, 'N' );
db_free_query( $id );

$canAdd = ($maxcronjobs == -1 || $crn->count_jobs() < $maxcronjobs)? TRUE: FALSE; 

if( ! $canAdd && $new_job ) {
	message( NOTE, ltext( "cron_limit_error", array($maxcronjobs)));	
	$new_job = false;
	if( $crn->count_jobs() > $maxcronjobs && $edit ) {
		$edit = false;
	}
}

$loToolsData = new ToolsButtons();
$loButtons = new CompoundDataField();

$lcKey = 'cron';
$lcID = 'reread_'.$lcKey;
$lcCurPage = 'tools_cron.php';
$lcHeadText = ltext('cron_reread');

$listFormIndex = 0;

$loButtons->AppendToContent( new GenericButtonData( '',
																										$lcID, 
																										$lcHeadText, 
																										"javascript:setValue('read_jobs','1',$listFormIndex);".
																										"setValue('cur_page','$lcCurPage',$listFormIndex);".
																										"setValue('head_id','$lcKey',$listFormIndex);".
																										"setValue('head_text','$lcHeadText',$listFormIndex);".
																										"submitForm('menu_node_id','$lcKey',$listFormIndex)",
																										$lcID
																										)

														 );
	
$loButtons->SetSeparator(' ');

$loToolsData->AppendToContent( $loButtons );
$loToolsData->Hiddens( array( 'read_jobs' => 0) );

$loTools = $loToolsData->GetInputPresentation( array( 'action' => 'tools_cron.php',
																											'name' => 'tools'
																											)
																							 );
$listFormIndex++;


if( $canAdd ){
	$loData = new SetOfRowsData();
	$loHeader = new DataRow( TRUE );
	$loFlds = new DataRow();

	foreach( $vars as $lcKey => $lcTitle ){
		$loHeader->AppendFields( new HTMLDataField( $lcTitle, array(), array('align'=>'left') ) );
		if( $lcKey == 'cmd' ){
			$loFlds->AppendFields( new TextDataField( '', $lcKey, array('size'=>'32') ) );
		} else {
			$loFlds->AppendFields( new TextDataField( '', $lcKey, array('size'=>'5') ) );
		}
	}
	$loData->AppendRow( $loHeader	);
	$loData->AppendRow( $loFlds	);

	$loData->AppendHidden( new TextDataField( 'new', 'action' ) );

	$loData->AppendButton( ltext('cron_new_job'),"javascript:doChange(1);",cc_IDAdd );


	$loNew = $loData->GetInputPresentation( array( 'action' => 'tools_cron.php',
																												'name' => 'new_cron'
																								 ),
																					ltext('cron_new_job')
																					);

	$loNew->SetWidths(array('10%','10%','10%','10%','10%','50%'));

	$listFormIndex++;
 }
//
//
//=================================================================


// read cronjobs list from the system
if( $read_jobs ){	
  
	message(NOTE, ltext('cron_reread_note'));
	if ($cron_rec['neu'] == 1) {
		$js_confirmation .= js_f_confirm(ltext('cron_confirm_refuse_changes'), js_f_goto('tools_cron.php'));
	}
	read_cron($PHP_AUTH_USER);
}


// save cronjob to the system
if( $save || ( $action == 'new' ) ){ 
	if ($cron_rec['neu'] == 2) {
		$js_confirmation .= js_f_confirm(ltext('cron_confirm_refuse_reread'), js_f_goto('tools_cron.php'));		
	}

	if( $edkey ){
		$edent = &$crn->changeEntry(base64_decode($edkey), true, $minute, $hour, $dom, $month, $dow, $cmd);
	}	else {
		$edent = &$crn->addEntry(true, true, $minute, $hour, $dom, $month, $dow, $cmd);
	}
	
	if( $edent ){
		if( $bad_values = $edent->getBadValues() ) {
			if( ! $edkey ){
				$edent->Remove();
			}
			$new_job = true;
			foreach (array_keys($vars) as $k) {
				$var_values[$k] = $$k;
			}
		}	else {
			save_cron( $crn->export() );
		}
	}	else {
		message(NOTE, "System error!");
	}	
}

/* -------------------- HTML -------------------- */
$data = new LikePagedRowsData();
if($edit || $new_job) { // Edit or New CronJob
	
	if($edit && $job = $crn->getEntry( base64_decode($edit) )) {
		$edkey = $edit;
		foreach ( array_keys($vars) as $k ) {
			$var_values[$k] = $job->getValue($k);
		}
	}

	$data->AppendHidden( new TextDataField( $edkey, "edkey" ) );
	$data->AppendHidden( new TextDataField( "1", "save" ) );

	foreach( $vars as $k => $v ) { 
		$red_col = false;
		if($bad_values[$k]) {
			$red_col = true;
			$badval_alerts = "";
			foreach ($bad_values[$k] as $e) {
				$badval_alerts .= $vars[$k] . " : " . $e . "<br>";
			}
			message(NOTE, $badval_alerts);
    	}
    
    	if($red_col) $param_cell =  new HTMLDataField( '<font color="Red">'.$v.'</font>' );
    	else $param_cell =  new HTMLDataField( $v );

    	$data->AppendRow( $param_cell, new TextDataField(htmlspecialchars($var_values[$k]), $k) );
	}
	
	$data->AppendButton(ltext('tofeae_btn_send'), 'javascript:doChange()', cc_IDOk);
	$form = $data->GetInputPresentation( array( "action"=>"tools_cron.php", "method"=>"post", "name"=>"form1" ), ltext("m_cron") );
	$page = new MainPageElement( $form );
	$page->OutputHTML($js_confirmation."\n\n".js_f_call_help("cron_desc_title", "cron_desc2"));
}
else {	// List Cron Jobs
	include_once("../include/page_functions.php");
	$jobs = $crn->getEntryList();
	$JSscriptPart = "";
	
	$JSscriptPart .= "function new_job() {\n".
					 '    document.location = "tools_cron.php?new_job=1";'."\n".
					 "}\n\n".
					 "function read_jobs() {\n".
					 '    document.location = "tools_cron.php?read_jobs=1";'."\n".
					 "}\n\n".
					 "function edit_job(key) {\n".
					 '    document.location = "tools_cron.php?edit="+key;'."\n".
					 "}\n\n".
					 "function delete_job(key) {\n".
					 js_f_confirm(ltext('cron_delete_quest'), 'return;')."\n".
					 '    document.location = "tools_cron.php?delete="+key;'."\n".
					 "}\n\n";

	$loCheckBox = new CheckDataField( 1, 'selectAll' );
	$loCheckBox->Attribute('onclick', "javascript:checkedAll('keys',this.checked,$listFormIndex)");
	$loCheckBox->SetParentAttributes(array('align'=>'center'));
	

	$data->AppendHeaderRow( new HTMLDataField( $vars["minute"] ),
													new HTMLDataField( $vars["hour"] ),
													new HTMLDataField( $vars["dom"] ),
													new HTMLDataField( $vars["month"] ),
													new HTMLDataField( $vars["dow"] ),
													new HTMLDataField( $vars["cmd"] ),
													new HTMLDataField( ltext('ll_change' ) ),
													$loCheckBox
													);

							
	if( is_array( $jobs ) && sizeof( $jobs ) ) { 
		foreach( $jobs as $j ){ 
			if( ! $j->isRemoved() ) {
				$key = base64_encode( $j->getString() );

				$loAction = new LinkDataField( "javascript: edit_job('".$key."')", 
																			 "", 
																			 array(), 
																			 ($confixx_interface_version == 'powp')?
																			 new IconDataField( cc_ChangeIcon ) : 
																			 new HTMLDataField( ltext( 'cron_edit' ) )
																			 );
				$loAction->Attribute( 'title', ltext( 'cron_edit' )  );
				$loAction->ParentAttribute( 'align', 'center' );

				$data->AppendRow( new HTMLDataField( $j->getValue( "minute" ) ),
													new HTMLDataField( $j->getValue( "hour" ) ),
													new HTMLDataField( $j->getValue( "dom" ) ),
													new HTMLDataField( $j->getValue( "month" ) ),
													new HTMLDataField( $j->getValue( "dow" ) ),
													new HTMLDataField( htmlspecialchars( $j->getValue( "cmd" ) ) ),
													$loAction,
													new CheckDataField( $key, 'keys[]' )
													);				
			}
		}
	}

	$data->AppendHidden( new TextdataField( '', 'action' ) );
	$data->AppendHidden( new TextdataField( 'tools_cron.php', 'cur_page' ) );

	$form = $data->GetInputPresentation( array( 'action' => 'tools_cron.php',
																							'method' => 'post',
																							'name' => 'list' ),
																			 ltext( 'm_cron' ) 
																			 );

	$head_text = ltext('ll_delete');
	$lcNothing = ltext('ll_nothing');
	$lcConfirm = ltext('ll_confirm_delete');

	$loDelButton = new PPButtonElement( $head_text,
																			"javascript:setValue('cur_page','tools_cron.php',$listFormIndex);".
																			"setValue('action','delete',$listFormIndex);".
																			"deleteSelected('keys','$lcConfirm',$listFormIndex,'$lcNothing')",
																			'bid-delete' 
																			);
		
	$loGroup = new DivElement(array('class'=>'buttons'));
	$loGroup->AppendToContent( $loDelButton );

	$form->setGroupActionElement( $loGroup );


	if( $canAdd ){
		$page = new MainPageElement( $loTools, $loNew, $form );	

	} else {
		$page = new MainPageElement( $loTools, $form );	
	}


	$page->OutputHTML( array( '../../js/paged_form.js' ),
										 $js_confirmation."\n\n".$JSscriptPart."\n\n".js_f_call_help('cron_desc_title', 'cron_desc1'));
}
/* -------------------- end HTML -------------------- */

db_close();
?>
