<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

include_once( 'auth.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.ReadOnlyDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.DirIconDataField.php' );
include_once( '../include/elements/data/class.BackIconDataField.php' );
include_once( '../include/elements/data/class.ImageDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/module.soap.php' );
include_once( "../include/class.User.php" );

global $DEBUG;
//$DEBUG = 1;

if($DEBUG){
	echo "tools_pwschutz.php: dir: $dir, _GET: <br><pre>\n";
	print_r( $_GET );
	echo "</pre><hr>\n";
 }

db_connect($db_host, $db_user, $db_pass);

$loUser = new SQLString( $PHP_AUTH_USER );

$loConfixxUser = new User( $PHP_AUTH_USER, $ServerID );

if( ! $loConfixxUser->isServiceEnabled( 'password_protect' ) ){
  $fehlertext = ltext( 'service_is_disabled' );
  include 'allgemein_start.php';
  exit;
}

/* -------------------- HTML -------------------- */
$rows = new SetOfRowsData();
$rows->AppendHeaderRow( new HTMLDataField( ltext("topw_cell_dir") ),
												new HTMLDataField( ltext("topw_cell_action") ) );

$id = safe_query2( "SELECT pfad FROM pwschutz WHERE kunde = ? AND server_id='$ServerID'",
									 $loUser );
while( list($path) = db_fetch_array( $id, 'N' ) ){
	$pfade[] = $path;
}
db_free_query( $id );

if( ! is_string( $dir ) && is_string( $pfad ) ){
	$dir = $pfad;
 }

if( substr( $dir, 0, 1 ) != '/' ){
	$dir = '/'.$dir;
 }

$gcDir = $dir;

$data[0] = array( 'html' );

if( FALSE /* don't use soap - to slow */ && $aster_confixx == 2 ){
	$args = array( 'u' => $PHP_AUTH_USER,
								 'path' => 'html'.$dir,
								 'd' => NULL,
								 'tr' => 'html' );
	$listen = array( 'tr-', 'ls-' );
	
	$result = run_soap( '../cgi-bin/soap/ls_dir.pl', $args, $listen );

	
	if( array_key_exists('error-',$result ) ){
		$fehlertext = $result['error-']['error-string'];

	}else{
		$max_ind = 1;
		if( array_key_exists('tr-',$result ) ){
			foreach( $result['tr-'] as $group => $dir ){
				$ind = substr( $group, 3 );
				if( is_numeric( $ind ) ){
					$ind = (int) $ind;
					$data[$ind] = $dir;
					if( $max_ind <= $ind ){
						$max_ind = $ind + 1;
					}
				}
			}
		}
		if( array_key_exists( 'ls-', $result ) ){
			if( array_key_exists( 'ls-dir', $result['ls-'] ) ){
				$data[$max_ind] = $result['ls-']['ls-dir'];
			}
		}		
	}

 }else{
	$dirs = explode( '/', $dir );
	$path = "/$PHP_AUTH_USER/html";
	$max_ind = 0;
	while( count( $dirs ) ){
		$max_ind++;
		$name = array_shift( $dirs );
		if( $name ){
			$path .= "/$name";
		}
		$exec = $bindir."/lsdir.pl ".escapeshellarg( $path ); 
		$ls = array();
		exec( $exec, $ls, $return );
		$data[$max_ind] = $ls;
	}
 }


function makeOneRow( $name, $dir, $ind, &$rows, &$pfade ){
	global $confixx_interface_version, $strSkinName;
	global $DEBUG;

	if( $DEBUG ){
		echo "makeOneRow: $name, $dir, $ind<br>\n";
	}

	$leer =  $ind * 16;
	if( is_array( $pfade ) ){
		$protected = in_array( $dir, $pfade )? 1: 0;
	}else{
		$protected = 0;
	}
	if( $protected == 1 ){
		$actionlink = new LinkDataField( 'tools_pwschutz_aendern.php', 
																		 '', 
																		 array( 'pfad' => $dir ),
																		 ltext( 'topw_link_edit' ) );
	}else{
		$actionlink = new LinkDataField( 'tools_pwschutz_neu.php',
																		 '',
																		 array( 'pfad' => $dir),
																		 ltext( 'topw_link_protect' ) );
	}
	$dir_cell = new CompoundDataField();
	$dir_cell->SetSeparator( '' );
	if( $confixx_interface_version == 'powp' ){
		$dir_cell->AppendToContent( new ImageDataField( $strSkinName."/images/1x1.gif",
																										'' ,
																										array( 'width'=>$leer, 'height'=>'16')));
	}else{
		$dir_cell->AppendToContent( new ImageDataField( $strSkinName."/file_icons/1x1.gif", 
																										'' ,
																										array('width'=>$leer, 'height'=>'16')));
	}

	$dir_cell->AppendToContent( new DirIconDataField() );
	$dir_cell->AppendToContent( new HTMLDataField( '&nbsp;' ) );
	$dir_cell->AppendToContent( new LinkDataField( 'tools_pwschutz.php',
																								 '',
																								 array( 'dir' => $dir),
																								 $name 
																								 )
															);
			
	$rows->AppendRow( $dir_cell, $actionlink );
}


function showDirTree( $root, $ind, $dirs, &$data ){
	global $rows, $pfade;
	global $DEBUG;

	if( $DEBUG ){
		echo "showDirTree: $root, $ind<br><pre>\n";
		print_r( $dirs );
		echo "</pre><hr>\n";
	}

	if( ! is_array( $data[$ind] ) ){
		return 0;
	}
	$name = array_shift( $dirs );

	$ret = 0;

	foreach( $data[$ind] as $item ){
		$path = $root.$item;
			
		makeOneRow( $item, $path, $ind, $rows, $pfade );		
		$ret++;
 
		if( $name == $item ){
			$ret += showDirTree( $path.'/', $ind+1, $dirs, $data );
		}
	}

	return $ret;
}


$dirs = explode( '/', $gcDir );
array_shift( $dirs ); /* remove first slash */

makeOneRow( 'html', '/', 0, $rows, $pfade );

showDirTree( '/', 1, $dirs, $data, $pfade );


$page = new MainPageElement( $rows->GetOutputPresentation( ltext("mt_auth") ));

$page->OutputHTML(js_f_call_help('topw_desc1', 'topw_desc2'));
/* -------------------- end HTML -------------------- */

db_close();
?>
