package Modules::Apache::Config::DomainSet;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

# $id: DomainSet.pm, v 1.0 2003/11/11 $

my $class = 'Mdules::Apache::Config::DomainSet';

use strict;

sub new {
  my $class = shift;
  my $self = { '_set' => [],
							 '_index' => -1 };

  bless($self, $class);


  if( @_ ){
    $self->domain( @_ );
  }

  return $self;
}

sub copyfrom {
  my $self = shift;
  if( @_ ){
    my $src = shift;
    if( ref( $src ) =~ /\Q$class\E/ ){
      delete( $self->{_set} );
      foreach my $dom ( $src->domains ){
				push @{$self->{_set}}, $dom;
      }
    }
  }
}

sub clone {
  my $class = shift;
  my $self = {};

  if( @_ ){
    my $src = shift;
    if( ref($src) =~ /\Q$class\E/ ){
      bless( $self, $class );
      $self->copyfrom( $src );
      return $self;
    }
  }
}

sub totext {
  my $self = shift;
  my $prefix = shift||'';
  my $ret='';
  my ($key,$val,$rec,$ref,$cnt,$i,$vkey,$vval);
  while( ( $key,$val ) = ( each %$self ) ) {
    $ref = ref($val);
    if( $ref eq 'ARRAY' ){
      $cnt = @$val;
      $ret .= "$prefix$key (array) $cnt:\n";
      for( $i=0; $i<$cnt; $i++ ) {
				$ret.="$prefix\t[$i]:\t".$val->[$i]."\n";
      }

    } elsif( $ref eq 'HASH' ){
      $cnt = scalar( keys %$val );
      $ret .= "$prefix$key (hash) $cnt:\n";
      while( ( $vkey,$vval ) = ( each %$val ) ) {
				$ret .= "$prefix\t$vkey\t=>\t$vval\n";
      }

    } else {
      if( defined( $val ) ){
				$ret .= "$prefix$key\t=\t$val\n";
      } else {
				$ret .= "$prefix$key\t=\tundef\n";
      }
    }
  }
  return $ret;
}

sub domain {
  my $self = shift;
  my $ind = shift||0;
  my $newdomain = shift;
  unless( $ind =~ /^\d+$/ ){
    unshift @_,$newdomain if ($newdomain);
    $newdomain = $ind;
    $ind = -1;
  }
	if( $newdomain ){
		$newdomain =~ s/^\s*//;
		$newdomain =~ s/\s*$//;

		if( $newdomain ) {
			if( defined( $self->{'_set'} )
					&& ( $ind >= 0 )
					&& ( $ind < @{$self->{'_set'}} )
				 ) {
				$self->{'_set'}->[$ind] = $newdomain;
			} else {
				push @{$self->{_set}}, $newdomain;
				if( @_ ) {
					foreach $newdomain ( @_ ) {
						$newdomain =~ s/^\s*//;
						$newdomain =~ s/\s*$//;
						if( $newdomain ){
							push @{$self->{'_set'}}, $newdomain;
						}
					}
				}
			}
		}
		return $newdomain;

  }else{
    if( defined( $self->{'_set'} ) 
				 && ( $ind >= 0 ) 
				 && ( $ind < @{$self->{'_set'}} ) 
			 ) {
      return $self->{'_set'}->[$ind];
    }
  }
}

sub domains {
  my $self = shift;
  return @{$self->{'_set'}};
}

sub count {
  my $self = shift;
  return scalar( @{$self->{'_set'}} );
}

sub has {

  my $self = shift;
  unless( defined( $self->{'_set'} ) ){
    return 0;
  }
  if( @_ ){
    my $pattern = shift;
    my $start = shift || 0;
    my $stop = shift || scalar(@{$self->{'_set'}})-1;
    if ($stop >= @{$self->{'_set'}}){
      $stop = scalar(@{$self->{'_set'}}) - 1;
    }
    for( my $ind=$start; $ind <= $stop; $ind++ ){
      my $ali = $self->{'_set'}->[$ind];
      if( $ali =~ /$pattern/ ){
				return 1;
      }
    }
    return 0;
  } else {
    return 1;
  }
}

sub top {
  my $self = shift;
  $self->{'_index'}=-1;
}

sub cannext {
  my $self = shift;
  my $shift = shift || 1;
  my $index = $self->{'_index'} + $shift;
  if ( $index >= 0 && $index < @{$self->{'_set'}}){
    return 1;
  } else {
    return 0;
  }
}

sub next {
  my $self = shift;
  my $shift = shift || 1;
  my $newIndex = $self->{'_index'} + $shift;
  if( $newIndex >= -1 && $newIndex <  @{$self->{'_set'}}){
    $self->{'_index'} = $newIndex;
    return $self->{'_set'}->[$newIndex];
  } else {
    return undef;
  }
}

sub prev {
  my $self = shift;
  my $shift = shift || 1;

  return $self->next( -$shift );
}


sub index {
  my $self = shift;
  if( @_ ){
    my $newIndex = shift;
    $newIndex += 0;
    if ( $newIndex >= -1 && $newIndex < @{$self->{'_set'}}){
      $self->{'_index'} = $newIndex;
    }
  }
  return $self->{'_index'};
}

sub current {
  my $self = shift;

  my $ind = shift || $self->{'_index'};
  my $newdomain = shift || '';

  unless( $ind =~ /^\d+$/ ){
    $newdomain = $ind;
  } else {
    if( $ind != $self->{'_index'} ){
      $self->index($ind);
    }
    $ind = $self->{'_index'};
  }

  $newdomain =~ s/^\s*//;
  $newdomain =~ s/\s*$//;

  if( $ind >= 0 && $ind < @{$self->{'_set'}}){
    if( $newdomain ){
      $self->{'_set'}->[$ind] = $newdomain;
    }
    return $self->{'_set'}->[$ind];
  } else {
    return undef;
  }
}

sub stripIP {
	my $this = shift;
	my $i = 0;
	my @ipInd = ();
	map { 
		push @ipInd,$i if( /^(\d+\.){3}\d+$/ );
		$i++
	} @{$this->{'_set'}};

	if( @ipInd ){ ## there is IP
		my $cnt = @{$this->{'_set'}};
		
		if( $cnt > 1 ){
			unless( $cnt > @ipInd ){
				shift @ipInd; ## keep first IP
			}
		}

		map {
			$i = $_;
			$cnt--;
			for( ; $i < $cnt; $i++ ){
				$this->{'_set'}->[$i] = $this->{'_set'}->[$i+1];	## shift tail to begin
			}
			pop @{$this->{'_set'}}; ## decrease list of domains
		} reverse @ipInd;

	}
	return $this->{'_set'};
}

1;
