package Modules::Apache::Config::Replace;

########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
#### http://www.swsoft.com - info@swsoft.com ####

# $id: Replace.pm, v 1.0 2006/03/09 $

use strict;

sub new{
	my $class = shift;
	my $this = { '_start' => undef,
							 '_new' => '',
							 '_stop' => undef
						 };

	bless( $this, $class );

	my($start,$new,$stop) = @_;

	$this->Start( $start );
	$this->New( $new );
	$this->Stop( $stop );

	return $this;
}

sub Start{
	my $this = shift;
	if( @_ ){
		my $re = shift;

		if( ! defined $re || $re eq '' ){
			$this->{'_start'} = undef;

		}elsif( ref( $re ) =~ /Regexp/i ){
			$this->{'_start'} = $re;

		}else{
			eval {
				$re = qr/$re/;
			};
			if( $@ ){
				$this->{'_start'} = undef;
			}else{
				$this->{'_start'} = $re;
			}
		}
	}
	return $this->{'_start'};
}

sub Stop{
	my $this = shift;
	if( @_ ){
		my $re = shift;

		if( ! defined $re || $re eq '' ){
			$this->{'_stop'} = undef;

		}elsif( ref( $re ) =~ /Regexp/i ){
			$this->{'_stop'} = $re;

		}else{
			eval {
				$re = qr/$re/;
			};
			if( $@ ){
				$this->{'_stop'} = undef;
			}else{
				$this->{'_stop'} = $re;
			}
		}
	}
	return $this->{'_stop'};
}

sub New{
	my $this = shift;
	if( @_ ){
		$this->{'_new'} = shift;
	}
	return $this->{'_new'};
}

sub appendNew{
	my $this = shift;
	if( @_ ){
		$this->{'_new'} .= "\n".join( "\n", @_ );
	}
	return $this->{'_new'};
}

sub matchStart{
	my( $this, $toWork ) = @_;
	if( my $re = $this->{'_start'} ){
		if( $toWork =~ /$re/ ){
			return 1;
		}else{
			return 0;
		}
	}else{
		return undef;
	}
}

sub match{
	my $this = shift;
	return $this->matchStart( shift );
}


sub matchStop{
	my( $this, $toWork ) = @_;
	if( my $re = $this->{'_stop'} ){
		if( $toWork =~ /$re/ ){
			return 1;
		}else{
			return 0;
		}
	}else{
		return undef;
	}
}


1;
