package Modules::Backup::Version;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

BEGIN {
  use Exporter;
  @ISA = qw(Exporter);
  @EXPORT_OK = qw/&new &Version &Release &getMajor &getMinor 
									&compareVersion &compareRelease &parseVersion 
									&compare &getVersion &getRelease &lessThan &toText
									&lessThan &greatThan &notLessThan &notGreatThan &Text/;
}

use strict;

sub new {
  my $classname = shift;

  my $this = {'version'=>undef,
							'release'=>undef,
							'text'=>undef
						 };

  bless ($this,$classname);

  if ( @_ ) {
    my ($version,$release) = @_;

    if ( $release ) {
			$this->Text( $version.' - '.$release );
      $this->Version( $version );
      $this->Release( $release );
    }else{
			$this->Text( $version );
      $this->parseVersion( $version );
    }
  }
  return $this;
}

sub Version {
  my $this = shift;
  if (@_){
    my $version = shift;
    if ($version=~/(\d+\.\d+\.\d+)/){
      $this->{'version'} = $version = $1;
    }else{
      $this->{'version'} = undef;
    }
		if( $this->{'text'} ) {
			$this->{'text'} =~ s/\d+\.\d+\.\d+/$version/;
		}

  }
  return $this->{'version'};
}

sub Text {
  my $this = shift;
  if (@_){
		chomp( $this->{'text'} = shift );
  }
  return $this->{'text'};
}


sub Release {
  my $this = shift;
  if ( @_ ) {
    my $release = shift;
    if ($release =~ /(\d+(\.\d+)?)/){
      $this->{'release'} = $release = $1;
    }else{
      $this->{'release'} = undef;
    }
		if( $this->{'text'} ) {
			$this->{'text'} =~ s/-\s*\d+(\.\d+)?^/- $release/;
		}
  }
  return $this->{'release'};
}

sub parseVersion {
  my $this = shift;
  return undef unless @_;
  my ($version,$release) = split(/\s*-\s*/,shift,2);
  $this->Version($version);
  $this->Release($release);
  return $this->toText();
}

sub getMajor {
  my $this = shift;
  if($this->{'version'}=~/^(\d+)\./){
    return $1;
  }else{
    return undef;
  }
}

sub getMinor {
  my $this = shift;
  if($this->{'version'}=~/^\d+\.(\d+)\./){
    return $1;
  }else{
    return undef;
  }
}

sub getVersion {
  my $this = shift;
  return split(/\./,$this->{'version'});
}

sub getRelease {
  my $this = shift;
  return split(/\./,$this->{'release'});
}

sub compareVersion {
  my $this = shift;
  my $sec = shift;
  return undef unless (ref($sec)=~/Version/);
  my @secVer = $sec->getVersion();
  return undef if ( scalar(@secVer)<3);
  my @myVer = $this->getVersion();
  return undef if ( scalar(@myVer)<3);
  my $ret=0;
  for (my $i=0; $i<3; $i++){
    unless ($myVer[$i] == $secVer[$i] ){
     $ret = ($myVer[$i] > $secVer[$i])?1:-1;
     last;
   }
  }
  return $ret;
}

sub compareRelease {
  my $this = shift;
  my $sec = shift;
  return undef unless (ref($sec)=~/Version/);
  my @secRel = $sec->getRelease();
  return undef if ( scalar(@secRel)<1);
  my @myRel = $this->getRelease();
  return undef if ( scalar(@myRel)<1);

  my $ret=0;
  if ($myRel[0] == $secRel[0] ){
    if(defined($myRel[1]) && defined($secRel[1])){
      if ($myRel[0] == $secRel[0] ){
	$ret = 0;
      }else{
	$ret = ($myRel[1] > $secRel[1])?1:-1;
      }
    }else{
      $ret = 0;
    }
  }else{
    $ret = ($myRel[0] > $secRel[0])?1:-1;
  }
  return $ret;
}

sub compare {
  my $this = shift;
  my $sec = shift;
  return undef unless (ref($sec)=~/Version/);
  my $cmpVer = $this->compareVersion($sec);
  if (defined($cmpVer)){
    if ($cmpVer==0){
      my $cmpRel = $this->compareRelease($sec);
      if (defined($cmpRel)){
				return $cmpRel;
      }else{
				return $cmpVer;
      }
    }else{
      return $cmpVer;
    }
  }else{
    return undef;
  }
}

sub lessThan {
  my $this = shift;
  my $sec = shift;
  unless (ref($sec)=~/Version/){
    $sec = Modules::Backup::Version->new($sec);
  }
  my $ret = $this->compare($sec);
  return ($ret<0);
}

sub notGreatThan {
  my $this = shift;
  my $sec = shift;
  unless (ref($sec)=~/Version/){
    $sec = Modules::Backup::Version->new($sec);
  }
  my $ret = $this->compare($sec);
  return ($ret<=0);
}

sub greatThan {
  my $this = shift;
  my $sec = shift;
  unless (ref($sec)=~/Version/){
    $sec = Modules::Backup::Version->new($sec);
  }
  my $ret = $this->compare($sec);
  return ($ret>0);
}

sub notLessThan {
  my $this = shift;
  my $sec = shift;
  unless (ref($sec)=~/Version/){
    $sec = Modules::Backup::Version->new($sec);
  }
  my $ret = $this->compare($sec);
  return ($ret>=0);
}



sub toText {
  my $this = shift;
  my($prefix,$suffix)=@_;
  my ($text);

	if ( $this->{'text'} ) {
		$text = $this->{'text'};

	} else {
		$text = $this->{'version'};
		if($this->{'release'}){
			$text .= ' - '.$this->{'release'};
		}
		$this->{'text'} = $text;
	}

	$text = $prefix.$text if($prefix);
	$text .= $suffix if ($suffix);

  return $text;
}

1;
