package Modules::Excp;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

BEGIN {
	use Exporter ();
    @ISA = qw(Exporter);
    @EXPORT = qw(&exception $LAST);
}

use strict 'vars';

my $LAST;

sub new {
	my ($sevr, $code, $desc, $cref) = @_;
	my $this = {};
	
	$$this{'sevr'} = $sevr;
	$$this{'code'} = $code;
	$$this{'desc'} = $desc;
	$$this{'cref'} = $cref;
	
	my $obj_ref = bless($this);
	$LAST = $obj_ref;
	return $obj_ref;
}

sub output {
	my $this = shift;
	return "($$this{'sevr'} ; $$this{'code'}) $$this{'desc'}" . 
		(defined $$this{'cref'} ? " : $$this{'cref'}->output" : '' );
}

use overload (
	'""'	=> \&as_string,
	'bool'	=> \&as_bool,
	'0+'	=> \&as_int,
);

sub as_bool { warn "as bool\n"; return 0; }
sub as_string { warn "as str\n"; return $$_{'descr'}; }
sub as_int { warn "as int\n"; return 0; }

#
#
#

sub exception(;@) {
	&new(@_);
}

sub last_error() {
}

return 1;

END {}
