package Modules::Restore::Service;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

use locale;
use XML::DOM;

use strict;
#no strict "vars";

use Modules::Restore::Flag;
use Modules::Restore::Limit;
use Modules::Restore::Field;


sub new {
  my $classname = shift;
  my $xmlServ = shift;

  unless  (ref($xmlServ)=~/XML/){
    unshift @_,$xmlServ;
    undef $xmlServ;
  }
  my %args = (
	   'name'=>'',
	   'on'=>'1',
	   'off'=>'0',
	   @_ );

  my $this = {'name'=> $args{'name'},
	      'on'=> $args{'on'},
	      'off'=> $args{'off'},
	      'state'=>undef,
	      'flag'=>undef,
	      'limit'=>undef,
	      'service'=>'',
	      'fields'=>{}
	     };
  bless ($this,$classname);

  if(ref($xmlServ)=~/XML/){
    $this->ParseXML($xmlServ);
  }
  return $this;
}

sub ParseXML {
  my $this=shift;
  my $xmlSrc = shift;
  return 0 unless (ref($xmlSrc) =~/XML/);

  my ($name,$fldName,$fldLink,$fld,$flag,$val,$oldAttr,$ptrFlag);

  $val=$xmlSrc->getAttribute('on');
  $this->{'on'}=$val if ($val);
  $val=$xmlSrc->getAttribute('off');
  $this->{'off'}=$val if ($val);
  $this->{'name'}=$xmlSrc->getAttribute('name');
  $this->{'service'}=$xmlSrc->getAttribute('service');

  my $dbIsPg = ($::dbType eq 'Pg');
  foreach my $kid ($xmlSrc->getChildNodes()){
    next unless ($kid->getNodeType==ELEMENT_NODE);
      $name=$kid->getNodeName();
    if ($name eq 'flag'){
      $fldName=$kid->getAttribute('field');
      if($dbIsPg){
	$fldName=&::toLowCase($fldName,$kid,'field');
      }
      next unless $fldName;
      unless ($fld=$this->Field($fldName)){
	$fld=Modules::Restore::Field->new('name'=>$fldName);
	$this->AddField($fld);
      }
      if ($fldName=$kid->getAttribute('link')){
	if($dbIsPg){
	  $fldName=&::toLowCase($fldName,$kid,'link');
	}
	unless ($fldLink=$this->Field($fldName)){
	  $fldLink=Modules::Restore::Field->new('name'=>$fldName);
	  $this->AddField($fldLink);
	}
	$fld->Link($fldLink);
      }
      unless($flag=$this->{'flag'}){
	$ptrFlag=Modules::Restore::Flag->new($fld);
	$this->{'flag'}=$ptrFlag;
      }else{
	$flag->AddField($fld)
      }
      if($val=$kid->getAttribute('on')){
	$flag->On($val);
      }
      if($val=$kid->getAttribute('off')){
	$flag->Off($val);
      }

    }elsif($name eq 'limit'){

    }
  }

}

sub Name {
  my $this = shift;
  if (@_){
    $this->{'name'}=shift;
  }
  return $this->{'name'};
}

sub Service {
  my $this = shift;
  if (@_){
    $this->{'service'}=shift;
  }
  return $this->{'service'};
}

sub Flag {
  my $this = shift;
  if (@_){
    my $flag=shift;
    if (ref($flag)=~/Flag/){
      $this->{'flag'}=$flag;
    }
  }
  return $this->{'flag'};
}

sub Field {
  my $this = shift;
  my $name = shift;
  if (@_){
    $name .= shift;
  }
  return $this->{'fields'}->{$name};
}

sub AddField {
  my $this = shift;
  my $fld = shift;
  return 0 unless (ref($fld)=~/Field/);
  my $name = $fld->Name;
  my $oldFld;
  if ($oldFld=$this->Field($name)){
    $oldFld.CopyFrom($fld);
  }else{
    $this->{'fields'}->{$name}=$fld;
  }
}

sub On {
  my $this=shift;
  if (@_){
    $this->{'on'}=shift;
  }
  return $this->{'on'};
}

sub Off {
  my $this=shift;
  if (@_){
    $this->{'off'}=shift;
  }
  return $this->{'off'};
}
sub State {
  my $this=shift;
  if (@_){
    $this->{'state'}=shift;
  }
  return $this->{'state'};
}

sub isStateOn {
  my $this=shift;
  return ($this->{'state'} eq $this->{'on'});
}

sub isStateOff {
  my $this=shift;
  return ($this->{'state'} eq $this->{'off'});
}


return 1;
