package Modules::Restore::Tables::Table_cstm_skins;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

use XML::DOM;
use XML::DOM::NodeList;

use Modules::Restore::Map;
use Modules::Restore::Table;
use Modules::Restore::DumpConfXML;
use Modules::Restore::DumpDoc;

use Modules::Restore::Tables::Common;
use Modules::Restore::Tables::Common qw(&update_query &insert_query);

use strict;

my %preinstSkins;

sub clean_tab($$){
  my ($table_name, $ptrConfXML) = @_;
  unless ($table_name && ref($ptrConfXML)=~/DumpConfXML/){
    print STDERR "Table_cstm_skinss::clean_tab : wrong arguments ($table_name,..)\n";
    return 1;
  }
  my ($table,$id);
  unless($table=$ptrConfXML->getTable($table_name)){
    return 1;
  }

#
# clean tables
#
  my @deletedIDs;
  my $sql = "SELECT id,path FROM $table_name WHERE NOT (owner_type IN ('admin','preinstalled')) AND server_id='$::ServerID'";
  my $sth = $::dbh->prepare( $sql );
  my( $path );
  if( $sth->execute && $sth->rows ){
    while( ( $id, $path ) = $sth->fetchrow ){

      push @deletedIDs, $id;

      $path = '/'.$path unless $path =~ /^\//;

			next if $path =~ /\.\./; ## skip bad path
			next if $path !~ /skins\//;

      $path = $::confixx_htmlDir.$path;
      if( -d $path ){
				unless( system ( "rm -rf $path" ) == 0 ){
					print STDERR "Error: unable to delete dir: $path\n";
				}
      }
    }
    $sth->finish;
  }

  if( @deletedIDs ){

    $sql = "DELETE FROM $table_name WHERE NOT (owner_type IN ('admin','preinstalled')) AND server_id='$::ServerID'";
    unless( $::dbh->do( $sql ) ){
      print STDERR "Error: Table_cstm_skins::clean_tab: unable to execute: $sql\n".
				$::dbh->errstr."\n";
      return 0;
    }
    $table->StateClean(1);

#
# set to default skin
#
    $sql = "UPDATE skins SET skin_id=0 WHERE skin_id IN (".join(',',@deletedIDs).") AND server_id='$::ServerID'";
    unless($::dbh->do($sql)){
      print STDERR "Error: Table_cstm_skins::clean_tab: unable to execute: $sql\n".
				$::dbh->errstr."\n";
    }
  }

  return 0;
}


sub pre_restore_tab($$$$) {
  my ($table_name, $ptrConfXML, $clean, $xmlTable ) = @_;
  unless ($table_name && ref($ptrConfXML)=~/DumpConfXML/){
    print STDERR "Modules::Restore::Tables::Common::pre_restore_tab : wrong arguments ($table_name,..)\n";
    return 1;
  }

#  print "pre restore table '$table_name'\n" if $::DEBUG;
  my ($table,$tblName,$tbl);

  return 1 unless $table = $ptrConfXML->getTable($table_name);
  return 1 unless( ref( $table ) =~ /Table/ );

  my $key = "$table_name(*).default";

  if( $table->Attribute( 'insert' ) ){
#
# expand attribute 'insert' 
#
    $main::map->add_rule( $key, $APPEND_DUMPED );

    foreach $tblName ( $ptrConfXML->getTablesList ){
      $tbl = $ptrConfXML->getTable($tblName);
      next unless (ref($tbl) =~ /Table/ );
      if ((!$tbl->Attribute( 'insert' ) ) && $tbl->getLinks($table_name)){
				$tbl->Attribute( 'insert', 1 );
      }
    }
  }
#
# calc maximum of id
#
  my $sql;
  $sql = "SELECT MAX(id) FROM $table_name";

  if( $clean ){
    $sql .= " WHERE server_id='$::ServerID' AND owner_type='preinstalled'";
  }
  my $sth = $main::dbh->prepare( $sql );
  $sth->execute;
    
  my( $maxID ) = $sth->fetchrow if $sth->rows;
  $sth->finish;
  $table->MaxID( $maxID || 14 ); ## build-in skins

	my $srcMaxID = 0;
	my( $kid, %srcSkins, $ptrRow );

	foreach $kid ( $xmlTable->getChildNodes() ) {

    next unless ( $kid->getNodeType == ELEMENT_NODE ); ## check xml-entry
    next unless ( $kid->getNodeName() eq 'row' );

    $ptrRow = $main::objDumpDoc->decode_row( $kid );
    next unless (ref($ptrRow)=~/HASH/);
		
		next unless $ptrRow->{'owner_type'} eq 'preinstalled';
		
		$srcSkins{$ptrRow->{'name'}} = $ptrRow->{'id'};
		$srcMaxID = $ptrRow->{'id'} if $ptrRow->{'id'} > $srcMaxID;
	}

  my( $id, $path, $name, $oldId );
  $sql = "SELECT id,path,name FROM custom_skins WHERE owner_type='preinstalled' AND server_id='$::ServerID'";
  $sth = $main::dbh->prepare($sql);
  $sth->execute;
  %preinstSkins = ();

  $key = 'skins(*).default';
  my $restoreDumped = ( $::map->get_rule($key) == $RESTORE_DUMPED );

  while( ( $id, $path, $name ) = $sth->fetchrow ){

		if( $srcSkins{$name} && $srcSkins{$name} != $id ){
			$oldId = $srcSkins{$name};
		} else {
			$oldId = $id;
		}

    $preinstSkins{$id} = $path;
    if( $restoreDumped ){
      $table->addToMap( 'path', $path, $path );
      $::map->add_attr( "$table_name($path).path", $path );
      $table->addToMap( 'id', $oldId, $id );
      $::map->add_attr( "$table_name($oldId).id", $id );
    }
  }
  $sth->finish;
  return 0; 
}

sub restore_row($$$){
  my ($table_name, $ptrRow, $ptrTable) = @_;

  my $key = 'skins(*).default';
  my $restoreDumped = ($::map->get_rule($key)==$RESTORE_DUMPED);
  my $clean = $::objDumpDoc->AttrClean;

  my ($oldPath,$newPath,$oldId,$oldRes,$newRes,$newId);
  $oldPath = $ptrRow->{'path'};
  $oldId = $ptrRow->{'id'};

  if( $ptrRow->{'owner_type'} =~/preinstalled/ ){

		$newId = $ptrTable->getMappedValue( 'id', $oldId ) || $oldId;

    if( $restoreDumped && ( $newPath = $preinstSkins{$newId} ) ){ 
      $::map->add_attr( "$table_name($oldPath).path", $newPath);
      $::map->add_attr( "$table_name($oldId).id", $newId);
      $ptrTable->addToMap( 'path', $oldPath, $newPath );
      $ptrTable->addToMap( 'id', $oldId, $newId );
    }

    unless( exists( $preinstSkins{$newId} ) ){

			$ptrRow->{'id'} = $newId;

      $::map->add_attr( "$table_name($oldPath).path", $oldPath);
      $::map->add_attr( "$table_name($oldId).id", $newId);
      $ptrTable->addToMap( 'path',$oldPath, $oldPath);
      $ptrTable->addToMap( 'id', $oldId, $newId);
      
      &Modules::Restore::Tables::Common::insert_query($table_name,$ptrRow);
			
			$ptrTable->MaxID( $newId );
    }

  }else{
    if( $clean && ( $oldId > $ptrTable->MaxID ) ){
#
# register changes
#
			
      $::map->add_attr( "$table_name($oldId).id", $oldId );
      $ptrTable->addToMap('id', $oldId, $oldId );
      $::map->add_attr( "$table_name($oldPath).path", $oldPath );
      $ptrTable->addToMap( 'path', $oldPath, $oldPath );

			$ptrTable->MaxID( $oldId, 'nocheck' );

    }else{
      $oldRes = $ptrRow->{'anbieter'};
      if( $newRes = $::map->get_attr("reseller($oldRes).name" ) ){
				$ptrRow->{'anbieter'} = $newRes;
      }
      $newId = $ptrTable->getNextID;
      $::map->add_attr( "$table_name($oldId).id", $newId );
      $ptrTable->addToMap( 'id', $oldId, $newId );

      $ptrRow->{'id'} = $newId;
      $newPath = $oldPath;
      $newPath =~ s/_\d+$/_$newId/;
      $::map->add_attr( "$table_name($oldPath).path", $newPath );
      $ptrTable->addToMap( 'path', $oldPath, $newPath );
      $ptrRow->{'path'} = $newPath;
    }

    &Modules::Restore::Tables::Common::insert_query( $table_name, $ptrRow );

  }
  return 0;
}

1;
