package Modules::Restore::Tables::Table_ereignisse;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

BEGIN {
  use Exporter;
  @ISA = qw(Exporter);
  @EXPORT = qw(&pre_restore_tab($$$$) &clean_tab($$) &restore_row($$$) );	
}

use DBI;

use strict;
no strict "vars";

use Modules::Restore::Table;
use Modules::Restore::DumpConfXML;
use Modules::Restore::DumpDoc;

use Modules::Restore::Map;
use Modules::Restore::Map qw($RESTORE_DUMPED $ASSIGN_CURRENT);

use Modules::Restore::Tables::Common;
use Modules::Restore::Tables::Table_kunden;

sub pre_restore_tab($$$$) {
  my ($table_name, $ptrConfXML,$clean,$xmlTable) = @_;
  unless ($table_name && ref($ptrConfXML)=~/DumpConfXML/){
    print STDERR "Table_ereignisse::pre_restore_tab : wrong arguments ($table_name,..)\n";
    return 1;
  }

  my ($table,$tblName);
  return 1 unless $table=$ptrConfXML->getTable($table_name);
  return 1 unless (ref($table)=~/Table/);
  
#  $table->AttrNoClean(1);

  my $sql="SELECT MAX(ident) FROM $table_name WHERE server_id='$::ServerID'";
  my ($where,$prefix,$user0,$maxID);
    $where = '';
  if( $clean ){
    $where = "(kunde IN ('',?) OR anbieter IN ('','res0')) OR ".
            "(nachricht LIKE ? AND NOT (nachricht LIKE ?))";

    $sql.=' AND '.$where;

    $prefix = $::user_prefix||'web';
    $user0 = $prefix.'0';

    
  }
  my $sth = $::dbh->prepare($sql);
  if( $clean ){
    $sth->execute( $usr0, '%'.$prefix.'%', '%'.$user0.'%' );
  }else{
    $sth->execute;
  }
  ( $maxID ) = $sth->fetchrow if $sth->rows;
  $sth->finish;
  $table->MaxID($maxID || 0);

  return 0;
}


sub clean_tab($$){
  my ($table_name, $ptrConfXML) = @_;
  unless ($table_name && ref($ptrConfXML)=~/DumpConfXML/){
    print STDERR "Table_ereignisse::clean_tab : wrong arguments ($table_name,..)\n";
    return 1;
  }
  
  my $sql = "delete from $table_name ".
            "where not (kunde in ('',?) or anbieter in ('','res0')) or ".
            "(nachricht like ? and not(nachricht like ?))";
  my $sth=$::dbh->prepare($sql);
  my $prefix =$::user_prefix||'web'; 
  my $user0 = $prefix.'0';
  $sth->execute($usr0,'%'.$prefix.'%','%'.$user0.'%');

  return 0;
}

sub restore_row($$$){
  my ($table_name, $ptrRow, $ptrTable) = @_;

  return 1 unless (ref($ptrTable)=~/Table/);
  my ($sth,$maxID);
  if( $time = $ptrRow->{'timestamp'} ){
    $sth=$::dbh->prepare( "SELECT MAX(ident) FROM $table_name WHERE server_id='$::ServerID' AND timestamp=$time");
    if( $sth->execute && $sth->rows ){
      ($maxID) = $sth->fetchrow;
      if( defined( $maxID ) && ( $maxID < $ptrTable->MaxID ) ){
				return 0; ## already there is
      }
    }
  }
  

  my $oldPrefix = $Modules::Restore::Tables::Table_admin::oldUserPrefix || $::map->oldUserPrefix;
;

#
# map field 'nachricht'
#
  my $nachricht = $ptrRow->{'nachricht'};

#
# map reseller
#
  my ($oldRes,$oldUser,$newRes,$newUser,$key,$edt);
  if ($nachricht=~/\|(res\d+)\|/){
    $oldRes=$1;
  }elsif($nachricht=~/\|(res\d+)$/){
    $oldRes=$1;
  }
  if ($oldRes){
    $key="reseller($oldRes).name";
    if (($newRes=$::map->get_attr($key)) && ($newRes ne $oldRes)){
      $nachricht=~s/$oldRes/$newRes/g;
      $edt=1;
    }
  }
  if($oldPrefix){

#
# map user
#
    if ($nachricht=~/\|($oldPrefix\d+)\|/){
      $oldUser=$1;
    }elsif($nachricht=~/\|($oldPrefix\d+)$/){
      $oldUser=$1;
    }
    if ($oldUser){
      $key="user($oldUser).name";
      if (($newUser=$::map->get_attr($key)) && ($newUser ne $oldUser)){
	$nachricht=~s/$oldUser/$newUser/g;
	$edt=1;
      }
    }
  }
  if ($edt){
    $ptrRow->{'nachricht'}=$nachricht;
  }
#
# /map field 'nachricht'
#
 
  $oldUser = $ptrRow->{'kunde'};
  $key="user($oldUser).name";
  if($newUser = $::map->get_attr($key)){
    $ptrRow->{'kunde'}=$newUser;
  }
  $oldRes = $ptrRow->{'anbieter'};
  $key="reseller($oldRes).name";
  if($newRes = $::map->get_attr($key)){
    $ptrRow->{'anbieter'}=$newRes;
  }
  delete $ptrRow->{'ident'};
  
  &Modules::Restore::Tables::Common::insert_query($table_name,$ptrRow);

  $sth = $::dbh->prepare( "SELECT MAX(ident) FROM $table_name");
  if( $sth->execute ){
    ( $maxID ) = $sth->fetchrow;
    $ptrTable->MaxID( $maxID );
  }

  return 0; 
}

return 1;
