package Modules::Restore::Tables::Table_maillist;

########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####

BEGIN {
  use Exporter;
  @ISA = qw(Exporter);
  @EXPORT = qw(&restore_row($$$) &pre_restore_tab($$$$) &clean_tab($$));	
}

use XML::DOM;
use XML::DOM::NodeList;

use strict;
#no strict "vars";

use Modules::Restore::Map;
use Modules::Restore::Table;
use Modules::Restore::DumpConfXML;
use Modules::Restore::DumpDoc;

use Modules::Restore::Tables::Common;
use Modules::Restore::Tables::Table_admin;

use Modules::Restore::Tables::Table_admin;


use DBI;


my %maillistSettings;
my $href_admin;

sub clean_tab($$){
  my ($table_name, $ptrConfXML) = @_;
  unless ($table_name && ref($ptrConfXML)=~/DumpConfXML/){
    print STDERR "Table_cstm_skinss::clean_tab : wrong arguments ($table_name,..)\n";
    return 1;
  }
  my ($table,$id);
  unless($table=$ptrConfXML->getTable($table_name)){
    return 1;
  }
  my ($sql,$sth,$path);
  if(-d $::majordomo_ldir){
    $sql = "SELECT DISTINCT domain_id FROM $table_name WHERE server_id='$::ServerID'";
    $sth = $::dbh->prepare( $sql );
    if( $sth->execute && $sth->rows ){
      while( ( $id ) = $sth->fetchrow ){
				$path = $::majordomo_ldir."/$id";
				if( -d $path ){
					unless (system ("rm -rf $path")==0){ 
						print STDERR "Error: unable to delete dir: $path\n";
					}
				}
      }
      $sth->finish;
    }
  }
  $sql = "DELETE FROM $table_name WHERE server_id='$::ServerID'";
  if( $::dbh->do( $sql ) ){
    $table->MaxID( 0 );
    if( $::dbType eq 'Pg' ){
      my $seqName = $table_name.'_id_seq';
      $sql = "SELECT SETVAL('$seqName',1,false)";
      unless( $::dbh->do( $sql ) ){
				if ($::DEBUG>1){
					print STDERR "Error:  Table_maillist: Error execute query: $sql\n".
						"$DBI::errstr\n";
				}
      }
    }
  }else{
    print STDERR "Error: Table_maillist: execute SQL-request: $sql\n$::dbh->errstr\n";
  }

  return 0;
}

sub pre_restore_tab($$$$) {
  my ($table_name, $ptrConfXML,$clean,$xmlTable) = @_;

#  print STDERR "pre restore table '$table_name'\n" if $::DEBUG;

  my ($table,$sth);
  return 1 unless $table=$ptrConfXML->getTable($table_name);
  return 1 unless (ref($table)=~/Table/);


  $href_admin=$Modules::Restore::Tables::Table_admin::ptrAdmin;
  unless (ref($href_admin)=~/HASH/){
    $sth = $main::dbh->prepare( "SELECT majordomo,majordomohome,majordomoml ".
																" FROM admin WHERE server_id='$::ServerID'");
    $sth->execute
      or die("Error #0201: Can not restore '$table_name' table: $DBI::errstr\n");
    $href_admin = $sth->fetchrow_hashref;
    $sth->finish;
  }
  %maillistSettings=();
  $maillistSettings{'majordomo'}=$href_admin->{'majordomo'};
  if(-d $::majordomo_home){
    $maillistSettings{'home'}=$::majordomo_home;
  }elsif(-d $href_admin->{'majordomohome'}){
    $maillistSettings{'home'}=$href_admin->{'majordomohome'};
  }else{
    $maillistSettings{'home'}=undef;
  }

  if(-x $::majordomo_wrapper){
    $maillistSettings{'wrapper'}=$::majordomo_wrapper;
  }elsif(-x $maillistSettings{'home'}.'/wrapper'){
    $maillistSettings{'wrapper'}=$maillistSettings{'home'}.'/wrapper';
  }else{
    $maillistSettings{'wrapper'}=undef;
  }

  $maillistSettings{'user'}=$::majordomo_user;

  if(-d $::majordomo_ldir){
    $maillistSettings{'ldir'}=$::majordomo_ldir;
  }elsif(-d $href_admin->{'majordomoml'}){
    $maillistSettings{'ldir'}=$href_admin->{'majordomoml'};
  }else{
    $maillistSettings{'ldir'}=undef;
  }

  my $all=1;
  while (my($key,$val)=each(%maillistSettings)){
    unless ($val){
      $all=0;
      last;
    }
  }
  $maillistSettings{'majordomo'}=$all;

  $sth=$main::dbh->prepare( "SELECT MAX(id) FROM $table_name");
  if($sth->execute){
    my($maxID)=$sth->fetchrow;
    $sth->finish;
    $table->MaxID($maxID||0);
  }
  
  my($key,$defaultRule);

  $key="$table_name(*).default";
  unless($defaultRule=$main::map->get_rule($key)){
    $main::map->add_rule($key,$APPEND_DUMPED);
  }


  return 0; 


}

sub restore_row($$$){
  my ($table_name, $ptrRow, $ptrTable) = @_;

  return 0 unless $maillistSettings{'majordomo'};

  my ($oldEmail,$key,$newKunde,$oldDomain,$numb,$oldBox,$newDomain,$newBox);
  $oldEmail=$ptrRow->{'owner_mail'};
  if($oldEmail=~/(.+)\@([\w\d\-\.]+)$/){
    $oldBox = $1;
    $oldDomain = $2;
    
    $key="domain($oldDomain).name";
    if($newDomain=$::map->get_attr($key)){
      $key="user($oldBox).name";
      if($newBox=$::map->get_attr($key)){
	$ptrRow->{'owner_mail'}="$newBox\@$newDomain";
      }
    }
  }

  unless( $::objDumpDoc->AttrClean){
#
# map id-field
#
    my($oldID,$newID);
    $oldID=$ptrRow->{'id'};
    $key="maillist($oldID).id";
    unless($main::map->get_attr($key)){
      if($newID=$ptrTable->getNextID()){
	$main::map->add_attr($key,$newID);
      }			
    }
  }
  
  return 1;  ## next common part
}

1;
