#!/usr/bin/perl


use FindBin;

use File::Basename;
use File::Temp;
use Cwd;

use Getopt::Long;

use strict;

my @config_opts = (
									 'cpan|c=s',
									 'ret|r=s'
									);

my %arguments = ();
unless (&GetOptions(\%arguments, @config_opts)) {
	warn "Error in the command line found. Use the format described below.\n";
	print STDERR &help_text();
	exit 1;
}

warn("Warning: Found unrecognized options in the arguments near \"@ARGV\"") if(@ARGV);

my ( $dirCPAN );
if( $arguments{'cpan'} && -d $arguments{'cpan'} ){
	$dirCPAN = $arguments{'cpan'};
}else{
	$dirCPAN = dirname( $FindBin::Bin ).'/CPAN';
}
unless(-d $dirCPAN ){
	print STDERR "Error: CPAN dir is not found. PLease specify by --cpan argument\n";
	exit 2;
}

unless( opendir( CPAN, $dirCPAN ) ){
	print STDERR "Error: can't open dir '$dirCPAN': $!\n";
	exit 3;
}

my @list = grep{ /^Updater-/ && -f "$dirCPAN/$_" } readdir( CPAN );

closedir( CPAN );

unless( @list ){
	print STDERR "Error: Updater is nod found in '$dirCPAN'\n";
	exit 4;
}


my $maxVer = 0;
my ( $ver, $src, $srcDir );

foreach my $file ( @list ){
	unless( $file =~ /^Updater-(\d+)\.(\d+)\.(\d+)(_?)/ ){
		next;
	}
	$ver = $1 + $2 * 0.001 + $3 * 0.000001;
	unless( $4 ){
		$ver += 0.0000001;
	}
	if( $ver > $maxVer ){
		$src = $file;
		$maxVer = $ver;
	}
}

unless( $src ){
	$src = shift @list;
}

if( $src =~ /^(Updater-[0-9.]+)\./ ){
	$srcDir = $1;
}

my $cwd = getcwd();
my $wDir = dirname( $FindBin::Bin );
my $makeDir = "$wDir/install_packages";

my %bin = ( 'tar' => 'tar',
						'rm' => 'rm',
						'perl' => 'perl' );

&findBins( \%bin );

my $bin_tar ||= $bin{'tar'}||'tar';
my $bin_rm ||= $bin{'rm'} || 'rm'; 
my $bin_perl = ( $^X =~ /perl/ )? $^X: $bin{'perl'}||'perl';

print "\nInstall package 'Confixx::Filter' ...";

unless( -d $makeDir ){
	mkdir $makeDir or
		die "Can't create work dir '$makeDir': $!\n";
}

#
# uncompress source
#


my $cmd = "$bin_tar -xzf $dirCPAN/$src -C $makeDir";
my $sysRet = system( $cmd );
if ( $sysRet != 0 ) {
	print STDERR "Error: Can't execute '$cmd': $!\n";
	next;
}

my $path = "$makeDir/$srcDir";
unless ( chdir( $path ) ) {
	die "Error: Can't change dir '$path': $!\n";
}

#
# /uncompress source
#

#
# make & make install
#


$sysRet = system( "$bin_perl Makefile.PL" );

if ( $sysRet != 0 ){
	$sysRet >>= 8;			
	print STDERR "Error: Makefile.PL returned status $sysRet\n";
} else {
	$sysRet = system( "make && make install UNINST=1" );
	if ( $sysRet != 0 ) {
		$sysRet >>= 8;							
		print STDERR "Error: make returned status $sysRet\n";
	}
}

#
# /make & make install
#
chdir( $cwd ) or
	warn "Can't chdir '$cwd': $!\n";
#
# clean source dir
#

system( "$bin_rm -rf $path" );
system ( "$bin_rm -rf $makeDir" );

$cmd =  "$FindBin::Bin/Confixx_Filter_VERSION.pl 2>/dev/null";

$ver = `$cmd`;

chomp $ver;
if( $ver =~ /^[0-9.]+$/ ){

	print "Package 'Confixx::Filter' is successfuly installed\n";

	if( $arguments{'ret'} && -x $arguments{'ret'} ){
		exec( $arguments{'ret'} );
	}
}else{
	print STDERR "Package 'Confixx::Filter' is NOT successfuly installed\n";
	exit 5;
}


sub findBins{
	my $ptrBin = shift;
	unless( ref( $ptrBin ) =~ /HASH/ ){
		unshift @_, $ptrBin;
		$ptrBin = {};
		map{ $ptrBin->{$_} = $_ } @_;
	}

	my @dirs = qw|/local/usr/bin /local/usr/sbin /bin /sbin /usr/bin /usr/sbin|;

	my($dir,$path);
	foreach my $key ( keys %{$ptrBin} ){
		foreach $dir ( @dirs ){
			$path = "$dir/$key";
			if( -x $path ){
				$ptrBin->{$key} = $path;
				last;
			}
		}
	}

	return $ptrBin;
}


sub help_text {
	print <<"EOF"

usage:
  installConfixxFilter.pl [arguments]

arguments:
  --cpan|-c <dir>   CPAN-dir
  --ret |-r <path>  run after successfuly installation of Confixx:;Filter

EOF
}
