#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

#
# chackMTAConfig  - validate MTA config
# arguments:
#            $mta    - MTA-key: 'postfix','qmail','sendmail'
#            $config - path to main config (optional)
#
# returns:
#            1 - success (default)
#            0 - fail
#
sub checkMTAConfig {
  my ($mta,$config) = @_;

  my $ret=1; ## default success

  if ($mta eq 'sendmail'){
    $config = '/etc/mail/sendmail.cf' unless $config;
    $config = '/etc/sendmail.cf' unless -T $config;
    unless(-T $config){
      $config = &FileQuestion ( &ltext('install_sendmail_conf'),$config,1);
    }
    return 0 unless -T $config;
    unless (open(CONFIG,"< $config")){
      print "Error: unable to open '$config': $!\n"; 
      return 0;
    } 
	my %toCheck=('virtuser'=>qr/^[^#].+\$\(\s*virtuser/,
	  'smrsh'=>qr/^\s*A=smrsh/,
	  'daemon'=>qr/^O\sDaemonPortOptions=.*Port=/	);

    my ($line,$last,$key,$pat);

    while (<CONFIG>){
      $line = $_;
      $last = 1;
      while (($key,$pat) = each(%toCheck)) {
	if($pat){
	  if($line =~ /$pat/){
	    $toCheck{$key} = undef;
	  }else{
	    $last = 0;
	  }
	}	
      }	
      if($last){
	last;
      }
    }
    close (CONFIG);
		
	
	if($toCheck{'smrsh'}){
	  my $msg = "\nYour sendmail configuration has not 'smrsh' feature.\n".
"Please insert FEATURE(\`smrsh',...) (see manual) into sendmail.mc and re-build sendmail.cf\n\n";
	  
	  &report_error ($msg);
	  $ret=0;
	}
	if($toCheck{'daemon'}){
	  my $msg = "\nYour sendmail configuration has not 'DaemonPortOptions'.\n".
"Please insert DAEMON_OPTIONS(...) (see manual) into sendmail.mc and re-build sendmail.cf\n\n";

	  &report_error ($msg);
	  $ret=0;
	}
	
    if($toCheck{'virtuser'}){
      &report_error( &ltext('install_sendmail_novirtuser'));
	  $ret=0;
    }
	
  }
  return $ret;
}

sub report_error($) {
	my ($str) = @_;

	warn "PROBLEM FOUND: $str\n";
	my $logFile;
	if($installDir && (-d $installDir)){
		$logFile = "$installDir/INSTALLATION_PROBLEMS.LOG";
	}else{
		$logFile = "INSTALLATION_PROBLEMS.LOG";
	}
	unless( open( FILE, '>>', $logFile ) ){
		warn "Warning: can not save problem description to '$logFile': can not open file '$logFile': $!\n";
		return;
	}
	print FILE "$str\n";
	unless (close(FILE)) {
		warn "Warning: can not save problem description to $logfile: can not close file $logfile: $!\n";
		return;
	}
}

#
# sub checkApacheConfig - parse apache's configs to get global parametrs 
#                         'User' & 'Group'
# argumets: $pathConfig - path to the apache's config file (httpd.conf)
#                         or path to the dir with apache's config (/etc/httpd/conf)
#           $ptrHash    - pointer to hash for return of the found parameters
#
# return:   1           - both parameters ('User', 'Group') are found     
#           0           - otherwise
#
sub checkApacheConfig {
  my $pathConfig = shift || $::httpd_conf;
  my $ptrHash = shift || {};
  unless(-d $pathConfig){
    $pathConfig=~s/\/[^\/]+$//;
  }
  unless(-d $pathConfig){
    warn "Warning: dir of apache's configs is not found ('$pathConfig')\n";
    return 0;
  }

#
# find User & Group in config files of Apache 
#
  $::bin_grep ||= $::bin{'grep'}||'grep';
  my $found=0;
  if(-x $::bin_grep){
    my @lines = `$::bin_grep -e '^[:blank:]*\\(User\\|Group\\|<Virtual\\|</Virtual\\)' $pathConfig/*.conf`;
    my $state=0;
    my ($file,$line,$cmd,$prevFile);
    foreach $line (@lines){
      ($file,$cmd)=split(/\s*:\s*/,$line,2);
      unless($prevFile eq $file){
	$prevFile = $file;
	$state = 0;
      }
      if($state){
	if($cmd =~ /^<\/Virtual/){
	  $state=0;
	}
      }else{
	if($cmd =~ /^User\s+(\S+)/){
	  $ptrHash->{'User'}=$1;
	  $found++;
	}elsif($cmd =~ /^Group\s+(\S+)/){
	  $ptrHash->{'Group'}=$1;
	  $found++;
	}elsif($cmd =~ /^<Virtual/){
	  $state=1;
	}
      }
    }
  }

  return $found>=2?1:0;
}

1;
