#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

# help script to find its local modules
BEGIN {
  use FindBin;
  use lib "$FindBin::Bin";
}
# end 

use File::Basename;
use File::Copy;

use DBI;

# include common functions
use lib_module_common;
use lib_module_messaging;
use lib_module_services;

&initConfig;

my $wDir = &dirname($0);
if (-e "$wDir/subs/subs_include_spamassassin.pl"){
  $wDir.='/subs';
}

do "$wDir/subs_include_files.pl";

unless ($spamassassinConfig) {
  &hard_error("mod_spamassassin: \$spamassassinConfig parameter in confixx_main.conf is empty");
}

my ($spamAssVersion);

if ( eval "require Mail::SpamAssassin" ) {
	$spamAssVersion = $Mail::SpamAssassin::VERSION;
}


&CreateSpamAssassinConfigFile($spamassassinConfig);

sub CreateSpamAssassinConfigFile() {
	my ($sa_file) = @_;
	my $time = localtime();
	
	my $sa_include_file = "$installDir/safe/spamassassin.inc";
	my $include_content = '';
	
	if (-e $sa_include_file) {
		$include_content = &readFile($sa_include_file);
	}

	my $dbh = DBI->connect($db_address, $dbUser, $dbPw)
		or &die( &ltext('db_connect', '#XXX', $DBI::errstr) );

	my $sth;
	$sth = $dbh->prepare("SELECT spamfilter FROM admin WHERE server_id='$ServerID'");
	$sth->execute;

	unless ( ($sth->fetchrow())[0] ) {
		open ( FILE, ">", "$sa_file.tmp" ) or
			&hard_error("mod_spamassassin: Unable to open '$sa_file.tmp' file: $!");
		print FILE $include_content;
		close (FILE) or
			&hard_error("mod_spamassassin: Unable to close '$sa_file.tmp' file: $!");

	}	else {
		$sth = $dbh->prepare("SELECT DISTINCT e.domain FROM email e, kunden k,domains d WHERE k.spamfilter = 0".
		" AND e.kunde=k.kunde AND d.kunde=k.kunde".
		" AND e.domain = d.domain AND d.richtigedomain != 7".
		" AND e.server_id='$ServerID' AND k.server_id='$ServerID' AND d.server_id='$ServerID'" );
		$sth->execute;

		open FILE, ">$sa_file.tmp" or 
			&hard_error("mod_spamassassin: Unable to open '$sa_file.tmp' file: $!");
	
		print FILE << "HEADER_INC";
################### CONFIXX SPAMASSASSIN CONFIG FILE #####################
# created at $time
#
#            !!! Do not make any changes in this file !!!
# All your changes will be lost after the file is auto updated next time.
#
#   If you want to add here any custom directive, you should include it
#   to '$sa_include_file' file. Its content will be automatically
#   included during the file is autoupdated.
##########################################################################

# START CUSTOM INCLUSION (see $sa_include_file)

$include_content

# END OF CUSTOM INCLUSION

# START CONFIXX GENERATED SECTION

HEADER_INC

		while ( my $domain = $sth->fetchrow() ) {
			print FILE "all_spam_to                     *\@$domain\n";
		}

		my ($allowUserRules,$sqlQuery);
		if ( $spamAssVersion >= 3 ){
			$allowUserRules = 'allow_user_rules 1';
			$sqlQuery = 'user_scores_sql_custom_query SELECT preference, value FROM spampref '.
				"WHERE (username = _USERNAME_ OR username = '\@GLOBAL')".
					" AND server_id='$ServerID' ORDER BY username ASC";	
		} else {
			$allowUserRules = '';
			$sqlQuery = 'user_scores_sql_table           spampref';
		
		}
		my( $lcDSN, $lcUser, $lcPw ) = ( $db_address, $dbUser, $dbPw );
		if( $master_confixx ){
			&useModule( 'lib_module_master' );

			lib_module_master::readMasterConfig();

			( $lcDSN, $lcUser, $lcPw ) = ( $db_local_dsn, $dbLocalUser, $dbLocalPw );

		}

		print FILE << "FOOTER";
	
###

$allowUserRules

user_scores_dsn                 $lcDSN
user_scores_sql_username        $lcUser
user_scores_sql_password        $lcPw

$sqlQuery

# END OF CONFIXX GENERATED SECTION
FOOTER

		close FILE or
			&hard_error("mod_spamassassin: Unable to close '$sa_file.tmp' file: $!");
	}

	my $mode = 0400;
	chmod( $mode, "$sa_file.tmp" );

	&move( $sa_file, "$sa_file.sav" ) or
		&soft_error("mod_spamassassin: Unable to make reserve copy ('$sa_file.sav') of '$sa_file': $!");
	&move( "$sa_file.tmp", $sa_file ) or
		&hard_error("mod_spamassassin: Unable to install '$sa_file' config (from '$sa_file.tmp'): $!");

	chmod( $mode, $sa_file );
	if( defined $spamassassinUid && $spamassassinUid =~ /^\d+$/ ){
		chown( $spamassassinUid, -1, $sa_file ) or
			&soft_error("mod_spamassassin: Unable to chown ('$sa_file') to $spamassassinUid uid: $!");
	}
	chmod( $mode, "$sa_file.sav" );

	&reload_daemon('spamassassin', 'spamd', 'root');
}

