#!/usr/bin/perl 

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.swsoft.com - info@swsoft.com ####


BEGIN {
  use FindBin;
	use File::Basename;

  use lib $FindBin::Bin;
  use lib dirname($FindBin::Bin).'/scripts';
}

## Pre-Main
use File::Copy;
use File::Path;
use File::Find;
use Cwd;
use Fcntl ':mode';


use lib_module_common;
use lib_module_db;

use strict;

use vars qw/$wDir/;

my ($baseDir);

if ( $wDir ) {
	if ( $confixxState =~ /conf|install/ ) {
		$baseDir = $wDir.'/subs';
	}elsif( $confixxState =~ /remake/ ) {
		$baseDir = $wDir.'/admin/subs';
	} else {
		$baseDir = $wDir.'/../subs';
	}
} else {
	&initConfig();
	$baseDir = $wDir = "$installDir/admin/subs";
}
unless ( $baseDir =~ /\/subs$/ ){
	my $path;
	foreach my $dir ('/subs','../subs'){
		$path = $baseDir.$dir;
		if ( -d $path ) {
			$baseDir = $path;
			last;
		}
	}
}

safe_do "$baseDir/subs_include_questions.pl";
safe_do "$baseDir/subs_include_writeConfig.pl";
safe_do "$baseDir/subs_include_files.pl";
safe_do "$baseDir/subs_include_webInstall.pl";

$baseDir =~ s/\/[^\/]+$//;

my $htmlDir = "$baseDir/html";
my $scriptDir = "$baseDir/scripts";
my $subsDir = "$baseDir/subs";
my $langDir = "$baseDir/languages";


unless ($ENV{'ONLYFILES'}){
&initConfig;

&ReadMainConfigFile;
}
&header2( &ltext('install_header_web') );
## Pre-Main

$bin_cp ||= $bin{'cp'} || 'cp';
$bin_chown ||= $bin{'chown'} || 'chown';
$bin_chmod ||= $bin{'chmod'} || 'chown';
$bin_find ||= $bin{'find'} || 'find';

## Main
unless( $confixxState =~ /remake/ ){
	&installWebPages unless ($ENV{'NOFILES'});
	&installScripts;
	&installSoap unless ($ENV{'NOFILES'});
	unless($ENV{'ONLYFILES'}){
	&WriteMainConfigFile;
	&WritePHPConfigFile;
	}
	&fixPerlSystemMode() unless ($ENV{'NOFILES'});
}
## /Main


## UNTERPROGRAMME

sub installWebPages{
  my (@dirs, $safeDir);
  if($confixx_htmlDir =~ /^\/\S+\/\S*/){

    if(-d "$ENV{'DESTDIR'}$confixx_htmlDir/reg"){
      print &ltext('install_do_dir_del_rec', "$confixx_htmlDir/reg");
      rmtree("$ENV{'DESTDIR'}$confixx_htmlDir/reg");
    }
    if(-d "$ENV{'DESTDIR'}$confixx_htmlDir/anbieter"){
      print &ltext('install_do_dir_del_rec', "$confixx_htmlDir/anbieter");
      rmtree("$ENV{'DESTDIR'}$confixx_htmlDir/anbieter");
    }
    if(-d "$ENV{'DESTDIR'}$confixx_htmlDir/kunde"){
      print &ltext('install_do_dir_del_rec', "$confixx_htmlDir/kunde");
      rmtree("$ENV{'DESTDIR'}$confixx_htmlDir/kunde");
    }
    if(-d "$ENV{'DESTDIR'}$confixx_htmlDir/admin"){
      print &ltext('install_do_dir_del_rec', "$confixx_htmlDir/admin");
      rmtree("$ENV{'DESTDIR'}$confixx_htmlDir/admin/business_inc");
      system("rm $ENV{'DESTDIR'}$confixx_htmlDir/admin/*.php");
    }
    if(-d "$ENV{'DESTDIR'}$confixx_htmlDir/user"){
      print &ltext('install_do_dir_del_rec', "$confixx_htmlDir/user");
      rmtree("$ENV{'DESTDIR'}$confixx_htmlDir/user/ftplogin");
      rmtree("$ENV{'DESTDIR'}$confixx_htmlDir/user/poplogin");
      rmtree("$ENV{'DESTDIR'}$confixx_htmlDir/user/cron_inc");
      system("rm $ENV{'DESTDIR'}$confixx_htmlDir/user/*.php");
    }
    if(-d "$ENV{'DESTDIR'}$confixx_htmlDir/reseller"){
      print &ltext('install_do_dir_del_rec', "$confixx_htmlDir/reseller");
      system("rm $ENV{'DESTDIR'}$confixx_htmlDir/reseller/*.php");
    }
	
	if(-d "$ENV{'DESTDIR'}$confixx_htmlDir/include"){
      print &ltext('install_do_dir_del_rec', "$confixx_htmlDir/include");
      rmtree("$ENV{'DESTDIR'}$confixx_htmlDir/include");
	}
	if(-d "$ENV{'DESTDIR'}$confixx_htmlDir/poplogin"){
      print &ltext('install_do_dir_del_rec', "$confixx_htmlDir/poplogin");
			#workaround for horde 
			if (-d "$ENV{'DESTDIR'}$confixx_htmlDir/poplogin.orig"){
			system "mv $ENV{'DESTDIR'}$confixx_htmlDir/poplogin $ENV{'DESTDIR'}$confixx_htmlDir/poplogin.backup";
			system "mv $ENV{'DESTDIR'}$confixx_htmlDir/poplogin.orig $ENV{'DESTDIR'}$confixx_htmlDir/poplogin";	
			}
      rmtree("$ENV{'DESTDIR'}$confixx_htmlDir/poplogin");
	}
	if(-d "$ENV{'DESTDIR'}$confixx_htmlDir/ftplogin"){
      print &ltext('install_do_dir_del_rec', "$confixx_htmlDir/ftplogin");
      rmtree("$ENV{'DESTDIR'}$confixx_htmlDir/ftplogin");
  }
  unless(-d "$ENV{'DESTDIR'}$confixx_htmlDir"){
    print &ltext('install_do_dir_create', "$confixx_htmlDir");
    &RecCreateDir("$ENV{'DESTDIR'}$confixx_htmlDir", 0755);
  }
  unless(-d "$ENV{'DESTDIR'}$confixx_htmlDir/webalizer"){
    print &ltext('install_do_dir_create', "$confixx_htmlDir/webalizer");
    mkdir("$ENV{'DESTDIR'}$confixx_htmlDir/webalizer", 0755); # fur die Statistiken der Kunden
  }
  unless(-d "$ENV{'DESTDIR'}$confixx_htmlDir/skins") {
    print &ltext('install_do_dir_create', "$confixx_htmlDir/skins");
    mkdir("$ENV{'DESTDIR'}$confixx_htmlDir/skins", 0775);
  }
	chmod (0775,"$ENV{'DESTDIR'}$confixx_htmlDir/skins"); ## allow group rights to write for apache
  }
  print "\n";

  &rescueIMG("$ENV{'DESTDIR'}$confixx_htmlDir/back.gif", '1');
  &rescueIMG("$ENV{'DESTDIR'}$confixx_htmlDir/file.gif", '1');
  &rescueIMG("$ENV{'DESTDIR'}$confixx_htmlDir/folder.gif", '1');
  &rescueIMG("$ENV{'DESTDIR'}$confixx_htmlDir/ftptransf.gif", '1');
  &rescueIMG("$ENV{'DESTDIR'}$confixx_htmlDir/webtransf.gif", '1');
  &rescueIMG("$ENV{'DESTDIR'}$confixx_htmlDir/logo.gif", '1');
  &rescueIMG("$ENV{'DESTDIR'}$confixx_htmlDir/logogross.gif", '1');
  &rescueIMG("$ENV{'DESTDIR'}$confixx_htmlDir/style.css", '1');
  print "\n";

  print &ltext('install_webpages_copy', $confixx_htmlDir);
  system( "$bin_cp -rf $htmlDir/* $ENV{'DESTDIR'}$confixx_htmlDir/" );
  system( "$bin_cp -rf $htmlDir/admin/skins/* $ENV{'DESTDIR'}$confixx_htmlDir/skins" );
  print "\n";
	#workaround for horde
  if (-d "$confixx_htmlDir/poplogin.backup"){
		system "mv $confixx_htmlDir/poplogin $confixx_htmlDir/poplogin.orig";
		system "mv $confixx_htmlDir/poplogin.backup $confixx_htmlDir/poplogin";
	}
	
	system( "$bin_cp -rf $htmlDir/tmp $ENV{'DESTDIR'}".dirname( $confixx_htmlDir ) );
	rmtree( "$confixx_htmlDir/tmp" );
	my $tmpConfDir = dirname( $confixx_htmlDir ).'/tmp/conf';
	chown( $confixx_uid, $gidapache, "$ENV{'DESTDIR'}$tmpConfDir" );
	chmod( 0770, "$ENV{'DESTDIR'}$tmpConfDir" );
	chown( $confixx_uid, $gidapache, "$ENV{'DESTDIR'}".$tmpConfDir.'/web0.conf' );
	chmod( 0440, "$ENV{'DESTDIR'}".$tmpConfDir.'/web0.conf' );


  print &ltext('install_languages_copy', $confixx_htmlDir);
  system( "$bin_cp -rfv $langDir $ENV{'DESTDIR'}$confixx_htmlDir/");
  print "\n";

  unless(-d "$ENV{'DESTDIR'}$confixx_htmlDir/include/template/templates_c"){
		mkdir("$ENV{'DESTDIR'}$confixx_htmlDir/include/template/templates_c", 0777);
  }

  &rescueIMG("$confixx_htmlDir/back.gif");
  &rescueIMG("$confixx_htmlDir/file.gif");
  &rescueIMG("$confixx_htmlDir/folder.gif");
  &rescueIMG("$confixx_htmlDir/ftptransf.gif");
  &rescueIMG("$confixx_htmlDir/webtransf.gif");
  &rescueIMG("$confixx_htmlDir/logo.gif");
  &rescueIMG("$confixx_htmlDir/logogross.gif");
  &rescueIMG("$confixx_htmlDir/style.css");
  print "\n";

  
  print &ltext('install_webpages_perms', $confixx_htmlDir);

	find ( sub {
					 my ($mode);
					 unless ( -l $File::Find::name ) {

						 if ( -d $File::Find::name ) {
							 $mode = 0755;

						 } elsif ( -f $File::Find::name ) {
							 $mode = /\.cgi$/? 0755: 0644;
						 }

						 if ( $mode ){
							 chmod ( $mode, $File::Find::name );
							 chown ( $confixx_uid, $confixx_gid, $File::Find::name );
						 }
					 }
				 },
				 "$ENV{'DESTDIR'}$confixx_htmlDir" );
#
# extra case
#
	chmod ( 0777, "$ENV{'DESTDIR'}$confixx_htmlDir/include/template/templates_c" );

	chmod ( 0775, "$ENV{'DESTDIR'}$confixx_htmlDir/skins" );
	chown ( $confixx_uid, $gidapache, "$ENV{'DESTDIR'}$confixx_htmlDir/skins" );

	print "\n";
}


sub rescueIMG{
  my ($img, $backup) = @_;
  if(($backup) && (-e "$img")){
    print &ltext('install_do_file_copy', $img, "$img.old");
    copy("$img", "$img.old");
  }
  elsif(-e "$img.old"){
    print &ltext('install_do_file_mv', "$img.old", $img);
    copy("$img.old", "$img");
    unlink("$img.old");
  }
}


sub installScripts {
	my($dst,$src);
  my (@Script, $i);
  unless ( $confixx_binDir ) {
    $confixx_binDir = dirname($confixx_htmlDir) . "/bin";
  }
  unless( $confixx_sbinDir ) {
    $confixx_sbinDir = dirname($confixx_htmlDir) . "/sbin";
  }
  unless( $confixx_tmpDir ) {
    $confixx_tmpDir = dirname($confixx_htmlDir) . "/tmp";
  }

unless($ENV{'NOFILES'}){
  unless(-d "$ENV{'DESTDIR'}$confixx_binDir" ) {
    print &ltext('install_do_dir_create', $confixx_binDir );
    mkdir( "$ENV{'DESTDIR'}$confixx_binDir", 0755);
  }
  unless(-d "$ENV{'DESTDIR'}$confixx_sbinDir" ) {
    print &ltext('install_do_dir_create', $confixx_sbinDir );
    mkdir( "$ENV{'DESTDIR'}$confixx_sbinDir", 0750);
  }
  chown( $confixx_uid, $confixx_gid, "$ENV{'DESTDIR'}$confixx_binDir" );
  chown( $confixx_uid, $gidapache, "$ENV{'DESTDIR'}$confixx_sbinDir"  ) or 
		warn("Can not chown $confixx_sbinDir: $!\n");

  unless(-d "$ENV{'DESTDIR'}$confixx_tmpDir" ) {
    print &ltext('install_do_dir_create', $confixx_tmpDir );
    mkdir( "$ENV{'DESTDIR'}$confixx_tmpDir", 0777);
  }
  chown($confixx_uid, $confixx_gid, "$ENV{'DESTDIR'}$confixx_tmpDir");
  chmod(0777, "$ENV{'DESTDIR'}$confixx_tmpDir");

	my $tmpConfDir = $confixx_tmpDir.'/conf';
	unless( -d "$ENV{'DESTDIR'}$tmpConfDir" ){
    mkdir( "$ENV{'DESTDIR'}$tmpConfDir", 0770 );
	}
  chown( $confixx_uid, $gidapache, "$ENV{'DESTDIR'}$tmpConfDir" );
  chmod( 0770, "$ENV{'DESTDIR'}$tmpConfDir" );

  unless(-d "$ENV{'DESTDIR'}$confixx_homeDir/awstats" ) {
    print &ltext('install_do_dir_create', "$confixx_homeDir/awstats" );
    mkdir( "$ENV{'DESTDIR'}$confixx_homeDir/awstats", 0755);
  }
  chown($confixx_uid, $confixx_gid, "$ENV{'DESTDIR'}$confixx_homeDir/awstats");
  chmod(0755, "$ENV{'DESTDIR'}$confixx_homeDir/awstats");


  print &ltext('install_do_file_create', "$confixx_binDir/lsdir.pl");
	$src = "$scriptDir/lsdir.pl";
  if( open( FILE, $src ) ){
		@Script = ();
		my $notFound = 1;		
		while( <FILE> ){
			if ( $notFound && 
					 $_ =~ s/^\$root =[^~].*$/\$root = \'$user_homeDir\';\n/ ){
				$notFound = 0;					
			}
			push @Script, $_;
		}
		close(FILE);

		$dst = "$ENV{'DESTDIR'}$confixx_binDir/lsdir.pl";
		if( open(FILE, '>', $dst ) ){
			print FILE @Script;
			close(FILE);
			chmod(0755, $dst );
			chown($confixx_uid, $confixx_gid, $dst);
		}else{
			warn "Error open file '$dst': $!\n";
		}
	}else{
		warn "Error open file '$src': $!\n";
	}
}
unless ($ENV{'ONLYFILES'}){
  if( -f "$scriptDir/sslgen.pl" ){
    print &ltext('install_do_file_create', "$confixx_binDir/sslgen.pl");
		$src = "$scriptDir/sslgen.pl";
    if( open( FILE, $src ) ){
			@Script = ();
			my %trans = ( 'db_address' => $db_address,
										'dbUser' => $dbUser,
										'dbPw' => $dbPw,
										'ServerID' => $ServerID,
										'bin_openssl' => $bin{'bin_openssl'}||$bin_openssl,
										'tmpdir' => $confixx_tmpDir
									);

			my $list = join('|',keys %trans);
			my $re = qr/^\s*\$($list)\s*=.*;(.*?)$/;
			
			while (<FILE>){
				chomp;
				if( /$re/ ){
					$_ = '$'."$1 = '".$trans{$1}."';$2";
				}
				push @Script,$_;
			}
			close(FILE);

#
# save result
#    
			$dst = "$ENV{'DESTDIR'}$confixx_binDir/sslgen.pl";
			if( open(FILE, '>', $dst) ){
				map { print FILE $_,"\n" } @Script;
				close(FILE);
				
				chmod( 0755, $dst );
				chown($confixx_uid, $confixx_gid, $dst );
			}else{
				warn "Error open file '$dst': $!\n";
			}
		}else{
			warn "Error open file '$src': $!\n";
		}
  }
}
unless ($ENV{'NOFILES'}){
  if( -f "$scriptDir/perldebug.pl" ){
    print &ltext('install_do_file_create', "$confixx_binDir/perldebug.pl");
		$src = "$scriptDir/perldebug.pl";
    if( open( FILE, $src ) ){
			@Script = ();
			while (<FILE>){
				$_ =~ s/^\$base =.*$/\$base = \'$user_homeDir\';/;
				push @Script, $_;
			}
			close(FILE);
			$dst = "$ENV{'DESTDIR'}$confixx_binDir/perldebug.pl";
			if( open(FILE, '>', $dst) ){
				print FILE @Script;
				close(FILE);
				chmod( 0755, $dst );
				chown( $confixx_uid, $confixx_gid, $dst );
			}else{
				warn "Error open file '$dst': $!\n";
			}
		}else{
			warn "Error open file '$src': $!\n";
		}
  }
}
	&installScript( 'skinmng.pl', $confixx_uid, $gidapache, 0750, $confixx_sbinDir, &skinmng_opt ) unless ($ENV{'ONLYFILES'});

	# work around suidperl
#	&checkSuidPerl;

	
	my %idn_opt = ( 
								 'idn_shell'		=> $idn_shell,
								 'idn_vendor'	=> $idn_vendor,
								 'iconv_shell' => $iconv_shell,
								 'iconv_utf8'  => $iconv_utf8,					 
	);
	&installScript( 'idn_translate.pl', $confixx_uid, $confixx_gid, 0755, $confixx_binDir, %idn_opt ) unless ($ENV{'NOFILES'});

	&installScript( 'test_httpd_special.pl', $confixx_uid, $gidapache, 0750, $confixx_sbinDir ) unless ($ENV{'ONLYFILES'});

	$bin_cp ||= $bin{'cp'}||'cp';
unless ($ENV{'NOFILES'}){
	my $srcModules = "$scriptDir/Modules";
	my $dstModules = "$ENV{'DESTDIR'}$confixx_sbinDir/Modules";
	if ( opendir( SRC, $srcModules ) ) {

		unless ( -d $dstModules ) { ## create dir if it is not exists
			unlink $dstModules if -e $dstModules;
			mkdir $dstModules,0750;
		}

		my %srcDirs = ( 'File' => 1,
		                'Apache' => 1 ); ## list of dirs to copy

		my ($srcPath,$dstPath,$name);

		while ( $name = readdir( SRC ) ) {
			next if $name =~ /^\.\.?$/; ## skip . & ..
			$srcPath = "$srcModules/$name";
			$dstPath = "$dstModules/$name";
			if ( -d $srcPath ){
				if ( $srcDirs{$name} ) {
					system("$bin_cp -rf \"$srcPath\" \"$dstModules\"");
				}
			} else {
				copy( $srcPath, $dstPath);
			}
		}
		closedir (SRC);

	}else{
		system("$bin_cp -rf \"$srcModules\" \"$ENV{'DESTDIR'}$confixx_sbinDir\"");
	}

	copy( "$subsDir/lib_module_common.pm", "$ENV{'DESTDIR'}$confixx_sbinDir" );
	system("$bin_cp -rf \"$subsDir/Common\" \"$ENV{'DESTDIR'}$confixx_sbinDir\"");

#
# restore ownership
#
	find ( sub {
					 unless ( -l $File::Find::name ) {
						 my ($mode);
						 if ( -f $File::Find::name ) {
							 if ( /\.(pl|cgi)$/ ) {
								 $mode = 0755;
							 } else {
								 $mode = 0644;
							 }
						 } elsif ( -d $File::Find::name ) {
							 $mode = 0755;
						 }
						 if ( $mode ) {
							 chmod ( $mode, $File::Find::name );
							 chown ( $confixx_uid, $gidapache, $File::Find::name );
						 }
					 }
				 },
				 $dstModules,"$ENV{'DESTDIR'}$confixx_sbinDir/Common"
			 );

	chmod( 0644, "$ENV{'DESTDIR'}$confixx_sbinDir/lib_module_common.pm" );
	chown($confixx_uid, $gidapache, "$ENV{'DESTDIR'}$confixx_sbinDir/lib_module_common.pm");
}
}

sub installSoap{
	my $cgi_bin = $confixx_htmlDir.'/cgi-bin/soap';
	unless( -d "$ENV{'DESTDIR'}$cgi_bin" ){
		return;
	}
	my( $dstName, $name);
	if( opendir( SOAP, "$ENV{'DESTDIR'}$cgi_bin" ) ){
		while( $name = readdir(SOAP)){
			next unless $name =~ /.\.(cgi|pl)$/;
			$dstName = "$ENV{'DESTDIR'}$cgi_bin/$name";
			next unless -f $dstName;
			chmod 0755, $dstName or
				warn "Chnage mode of file '$dstName' error: $!\n";
		}
		closedir(SOAP);
	}else{
		warn "Error open dir '$cgi_bin': $!\n";
	}

	my $mod_dir = $cgi_bin.'/modules';

	if( -d "$ENV{'DESTDIR'}$mod_dir" ){
		my( $srcName, $dir);
		foreach my $lib ( qw( lib_module_common.pm
													lib_module_db.pm
													lib_module_events.pm
													Common/Config.pm ) ){

			$srcName = "$subsDir/$lib"; 

			next unless -f $srcName;

			$dstName = "$ENV{'DESTDIR'}$mod_dir/$lib";
			
			$dir = dirname($dstName);
			unless( -d $dir ){
				if( mkdir $dir ){
					chmod 0755, $dir;
					chown $confixx_uid, $gidapache, $dir;
				}else{
					warn "Create dir '$dir' error: $!\n";
				}
			}

			if( copy( $srcName , $dstName ) ){
				chmod 0644, $dstName;
				chown $confixx_uid, $gidapache, $dstName;
			}else{
				warn "Error copy file '$lib': $!\n";
			}
		}
	}
}

sub fixPerlSystemMode{
	my @dirs = @_;

	print "check permissions of perl modules ...\n";	

	my (@at,@bt, @pref, $dir, $skip, @toWork, $re );
	
	unless( @dirs ){
		my $dir2 = dirname($FindBin::Bin).'/scripts';
		my $cwd = getcwd();
		
		if($::installDir && -d $::installDir){
		    if( $cwd eq '/' ){
			$re = qr[^(\Q$::installDir\E|\Q$::user_homeDir\E|/$|/etc|\.)];
		    }else{
			$re = qr[^(\Q$::installDir\E|\Q$::user_homeDir\E|\Q$cwd\E|/$|/etc|\.)];
		    }
		}else{    
		    if( $cwd eq '/' ){
			$re = qr[^(\Q$FindBin::Bin\E|\Q$dir2\E|/$|/etc|\.)];
		    }else{
			$re = qr[^(\Q$FindBin::Bin\E|\Q$dir2\E|\Q$cwd\E|/$|/etc|\.)];
		    }	
		}
		@dirs =	grep{ !/$re/ && -d $_ } @INC;
	}

	
	foreach $dir ( sort{
		scalar(@at = $a =~ m[/]g) <=> scalar( @bt = $b =~ m[/]g )	}	@dirs )
		{
			$skip = 0;
			foreach $re ( @pref ){
				if( $dir =~ /$re/ ){
					$skip = 1;
					last;
				}
			}
			next if $skip;
			push @pref, qr[^\Q$dir\E/];
			push @toWork, $dir;
		}

	my( $mode, $otherRX );
	$otherRX = S_IROTH | S_IXOTH;

	find( sub {
					if(-f $File::Find::name ){
						if( /\.(so|pm)$/ ){
							$mode = ( stat( $File::Find::name ))[2];
							$mode &= 07777;
							unless( $mode & S_IROTH ){
								$mode |= S_IROTH;
								chmod $mode, $File::Find::name;
							}
						}
					}elsif( -d $File::Find::name ){
						$mode = ( stat( $File::Find::name ))[2];
						$mode &= 07777;
						unless( $mode & $otherRX ){
							$mode |= $otherRX;
							chmod $mode, $File::Find::name;
						}
					}
				},
		map{ print "$_ ...\n"; $_ } @toWork ) if @toWork;

	print " finished\n";
}

sub checkSuidPerl {
	my $suidperl = "/usr/bin/suidperl";
	my @ver = unpack('C3',$^V);
	my $sperl = dirname($suidperl).'/sperl'.join('.',@ver);  

	my  $verN = $ver[0] + $ver[1]*0.001 + $ver[2]*0.000001;
	my( $mode );
	if ( ( $verN >= 5.006002 && $verN < 5.007 ) || $verN >= 5.008004 ) { ## new shema
	  unless ( -e $sperl) {
			# mostly for Debian: no suidperl installed
			&report_error("You do not have suidperl installed: file $sperl is not found.\n".
										" Some features like skin editing will not be available until".
										" you will enable suidperl.");
		} else {
			my $perl = '/usr/bin/perl';
			if ( -f $perl ) {
				if ( -f $suidperl ) {
					if ( ( -l $suidperl ) ||  ( (stat( $suidperl ))[1] != (stat( $perl ))[1] ) ) {
						unlink $suidperl;
					}
				}
				unless ( -f $suidperl ) {
					symlink $perl, $suidperl;
				}	
			}
	  }	
	  $mode = ( stat( $sperl ) )[2];
	  if (($mode & 06000) == 0) {	## check suid bit
			chmod( 06755, $sperl ) or 
				&report_error("You suidperl installed, but not enabled: ".
											"file '$sperl' ass no SUID bit found.\n".
											" Some features like skin editing will not be available".
											" until you will enable suidperl.");
	  }

	} else { ## old shema
	  unless ( -e $suidperl) {
			# mostly for Debian: no suidperl installed
			&report_error("You do not have suidperl installed: file $suidperl is not found.\n".
										" Some features like skin editing will not be available until ".
										"you will enable suidperl.");
	  } else {
		#
		# get name of sperl5.8.0
		#

			unless ( ( -f $sperl ) && ## there is the file
							 ( (stat( $suidperl ))[1] == (stat( $sperl ))[1] ) ) { ## inods are not same
				if ( -f $sperl ) {
					unlink $sperl;
				}
		#
		# make hard link
		#  
				link $suidperl,$sperl or
					&report_error("Unbale to make hard link to '$suidperl' ('$sperl'): $!\n");
				chmod(04755,$sperl) or
					&report_error("Unable to chnage mode of '$sperl' (hard link of '$suidperl'): $!\n");		
				
		# mostly for SuSE: no suid bit set
				$mode = (stat( $suidperl ))[2];
				if (($mode & 04000) == 0) {	## check suid bit
					chmod( 04755, $suidperl ) or 
						&report_error("You suidperl installed, but not enabled: ".
													"file '$suidperl' ass no SUID bit found.\n".
													" Some features like skin editing will not be available".
													" until you will enable suidperl.");
				}
			}	
	  }	
	}
#
#================================================================
#		
	if ( -f $suidperl ) {
		my $file = '/etc/permissions.local';
		if ( -T $file ) {
			if ( open (CONF, '<'.$file ) ) {
				my ($ok,$head,$pat);
				$pat = qr/^\s*\Q$suidperl\E\s+(\w+\.\w+)\s+(\d+)$/;
				while ( <CONF> ) {
					chomp;
					if ( !/^\s*(?:#|$)/ && /$pat/ ) {
						$ok = ($1 eq 'root.root' && $2 eq '4755');
					}else{
						$head .= $_;
						$head .= "\n";
					}
				}
				close CONF;
				unless($ok){
					system("cp -f $file $file.confixx_backup");
					if ( open( CONF, '>'.$file ) ) {
						print CONF $head;
						print CONF "\n$suidperl\troot.root\t4755\n";
						close(CONF);
					}else{
						&report_error("Error: can not open '$file' to write: $!\n");
					}
				}
			}else{
				&report_error("Error: can not open '$file' to read: $!\n");
			}
		}
	}
}

sub report_error($) {
	my ($str) = @_;

	warn "PROBLEM FOUND: $str\n";
	my $logfile = "$installDir/INSTALLATION_PROBLEMS.LOG";
	unless (open(FILE, ">>$logfile")) {
		warn "Warning: can not save problem description to $logfile: can not open file $logfile: $!\n";
		return;
	}
	print FILE "$str\n";
	unless (close(FILE)) {
		warn "Warning: can not save problem description to $logfile: can not close file $logfile: $!\n";
		return;
	}
}
## /UNTERPROGRAMME
