package Parser::Css::Style;

use strict;

sub new {
	my $class = shift;
	my $this = { 'text' => undef,
							 'keys' => [],
							 'attrs' => {}
						 };
	bless( $this, $class );

	if( @_ ){
		my $src = shift;
		if( ref( $src ) ){
			$this->copyFrom( $src );
		} else {
			$this->Text( $src );
		}
	}

	return $this;
		
}

sub Text {
	my $this = shift;
	if( @_ ){
		$this->{'text'} = shift;
		$this->parse();
	}else{
		if( $this->{'remake'} ){
			$this->remake();
		}
	}
	return $this->{'text'};
}

sub parse {
	my $this = shift;
	my $text = $this->Text();

	$text =~ s/(\r\n|\r|\n)/ /g;

	my( $keyList, $attr_name, $attr_value );

	( $keyList, $text ) = split( /\s*{\s*/, $text, 2 );

	$keyList =~ s/^\s+//;
	@{$this->{'keys'}} = map{ s/\s+/ /; $_ } split( /\s*,\s*/, $keyList );
	$this->{'keys_hash'} = {};
	map{ $this->{'keys_hash'}->{$_} = 1 } @{$this->{'keys'}};

	$text =~ s/}.*?$//;

	map {
		if( $_ ){
			($attr_name, $attr_value) = split(/\s*:\s*/,$_,2);
			if( $attr_name ){
				$this->{'attrs'}->{$attr_name} = $attr_value;
			}
		}
	} split( /\s*;\s*/, $text );

	$this->{'remake'} = 0 if $this->{'remake'} ;
}

sub inKeys{
	my $this = shift;
	my $key = shift;
	unless( $this->{'keys_hash'} ){
		$this->{'keys_hash'} = {};
		map{ $this->{'keys_hash'}->{$_} = 1 } @{$this->{'keys'}};
	}
	return exists $this->{'keys_hash'}->{$key}? 1: 0;
}

sub isKeysEquiv{
	my $this = shift;
	my $ptrKey = shift;
	unless( ref( $ptrKey ) =~ /ARRAY/ ){
		$ptrKey = [ $ptrKey, @_ ];
	}
	my %keys = ();

#
# work hash
#
	map{ $keys{$_} = 1 } @{$this->{'keys'}};
	
#
# there are all right keys
#
	map{
		return 0 unless $keys{$_};
		$keys{$_} = 0;
	} @{$ptrKey};

#
# there are all left keys
#
	map{
		return 0 
	} grep{ $keys{$_} } keys %keys;

#
# OK
#
	return 1;
}

sub getAttribute{
	my $this = shift;
	my $attr = shift;
	unless( exists $this->{'attrs'}->{$attr} ) {
		return undef;
	}
	return $this->{'attrs'}->{$attr};
}

sub getAttributes{
	my $this = shift;
	return $this->{'attrs'};
}

sub getKeys{
	my $this = shift;
	return $this->{'keys'};
}

sub setAttribute{
	my( $this, $attr_name, $attr_value ) = @_;
	$this->{'attrs'}->{$attr_name} = $attr_value;
	$this->{'remake'} = 1;
	return $this->{'attrs'}->{$attr_name};
}

sub delAttributes{
	my( $this, $attr, @attrs ) = @_;

	if( ref( $attr ) =~ /ARRAY/ ){
		@attrs = @{$attr};
	}else{
		unshift @attrs, $attr;
	}

	my( @deleted );

	foreach $attr ( @attrs ){
		if( exists $this->{'attrs'}->{$attr} ){
			push @deleted, $this->{'attrs'}->{$attr};
			delete $this->{'attrs'}->{$attr};
			$this->{'remake'} = 1;
		}
	}

	if( wantarray() ){
		return @deleted;
	}else{
		return scalar @deleted;
	}
}

sub needRemake{
	my $this = shift;
	return $this->{'remake'};
}

sub remake{
	my $this = shift;

	$this->{'text'} = "\n".join( ', ', @{$this->{'keys'}})." {\n";

	map{
		$this->{'text'} .= "\t$_:\t".$this->{'attrs'}->{$_}.";\n";
	} sort keys %{$this->{'attrs'}};

	$this->{'text'} .= "}\n";

	$this->{'remake'} = 0;
}

sub copyFrom{
	my ( $this, $src ) = @_;
	if( ref( $src ) =~ /Style/ ){
		$this->{'text'} = $src->Text();

		if( $src->needRemake() ){
			$this->{'remake'} = 1;
		}else{
			$this->{'remake'} = 0 if exists $this->{'remake'};
		}

		$this->{'keys'} = [ @{$src->getKeys()} ];
		$this->{'keys_hash'} = {};
		map{ $this->{'keys_hash'}->{$_} = 1 } @{$this->{'keys'}};
		$this->{'attrs'} = { %{$src->getAttributes()} };

	}else{
		$this->Text( ${$src} );
	}
	return $this;
}

sub mergeAttributes{
	my $this = shift;
	my $src = shift;
	my $ref = ref($src);

	my($ptrAttrs,$attr,$value, $srcValue);

	if( $ref =~ /Style/ ){
		$ptrAttrs = $src->getAttributes();
	}elsif( $ref =~ /HASH/ ){
		$ptrAttrs = $src;
	}else{
		$ptrAttrs = { $ref, @_ };
	}

	my $ret = 0;
	while( ($attr,$srcValue) = each(%{$ptrAttrs})){
		if( $value  = $this->getAttribute( $attr ) ){
			unless( $value eq $srcValue ){
				$this->setAttribute( $attr, $srcValue );
				$ret++;
			}
		} else {
			$this->setAttribute( $attr, $srcValue );
			$ret ++;
		}
	}
	return $ret;
}

1;
