#!/usr/bin/perl

########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####


BEGIN {
	use FindBin qw($Bin);
	use File::Basename;

  use lib $Bin=~s%(?<=.)/$%%?$Bin:$Bin;
  use lib dirname( $Bin ).'/scripts';
  use lib dirname( $Bin ).'/subs';
}


use DBI;
use File::Basename;
use File::Path;

use lib_module_common;
use lib_module_common 'loadConfFile';
use lib_module_db;
use lib_module_events;

use sql::Table;
use sql::Index;

use strict;

use vars qw/$wDir $DEBUG $mysql_sock $checkMasterDb $oldVersion $newVersion/;
&initConfig;

($wDir ||= $FindBin::Bin) =~ s%(?<=.)/$%%; ## trim last slash

my $base = "$installDir/admin/updates";

if ( $0 =~ /db_update/ ) {
	safe_do "$installDir/admin/subs/subs_include_writeConfig.pl";
}

my ($dbh, $lcDb );




if( $master_confixx ){

	&loadConfFile( "$::installDir/confixx_master.conf" );

	if( ( $master_confixx == 2 ) && $checkMasterDb ){

		print "Check matser database ...\n";

		$dbh = DBI->connect ( $db_master_dsn, $dbMasterUser, $dbMasterPw, { 'PrintError' => 0 } )
			or die( &ltext('db_connect', '#XXX', $DBI::errstr) );

		$lcDb = $dbMasterDB;

	}else{

		print "Check local database ...\n";

		&fixMysqlPrivs( 'type' => $dbLocalType,
										'server' => $dbLocalServer,
										'db' => $dbLocalDB,
										'user' => $dbLocalUser,
										'password' => $dbLocalPw,
										'port' => $dbLocalPort
									);

		$dbh = DBI->connect ( $db_local_dsn, $dbLocalUser, $dbLocalPw, { 'PrintError' => 0 } )
			or die( &ltext('db_connect', '#XXX', $DBI::errstr) );

		$lcDb = $dbLocalDB;
		
	}

}else{

	&fixMysqlPrivs( 'type' => $dbType,
									'server' => $dbServer,
									'db' => $dbDB,
									'user' => $dbUser,
									'password' => $dbPw,
									'port' => $dbPort 
								);

	$dbh = DBI->connect ( $db_address, $dbUser, $dbPw, { 'PrintError' => 0 } )
		or die( &ltext('db_connect', '#XXX', $DBI::errstr) );

	$lcDb = $dbDB;

}

&header2( &ltext( 'update_db_db_check', $lcDb ) );


my ($ptrTables, $ptrNames, $dbTables, $sql);

( $ptrTables, $ptrNames ) = &loadTablesFromCreate();

&dropForeignKey( $dbh, $ptrTables, 'idn_aliases' => 'domain_id' );

$dbTables = &checkDB( $dbh, $ptrTables, $ptrNames );


unless( $master_confixx){
	my $sqlCreate = ($dbType =~ /mysql/)?
		"$installDir/admin/subs/mysqltables":
			"$installDir/admin/subs/psqltables";
			
	#3.2 restore leaves entries in delaccs with wrong ServerID
	$dbh->do("DELETE FROM delaccs WHERE server_id != '' AND server_id != '$ServerID'") or warn "Error sql query: $DBI::errstr\n";
	
	my( $tblName );
	if( open( DUMP, '<', $sqlCreate ) ){
		while( <DUMP> ){
			if( /(?:;|^)\s*CREATE\s+TABLE\s+(\S+)(?:\(|\s)/i ){
				$tblName = $1;
				my $sql = "ALTER TABLE $tblName ALTER server_id SET DEFAULT '$ServerID'";
				$dbh->do( $sql ) or
					warn "Error sql query: $DBI::errstr\n";
				$dbh->do( "UPDATE $tblName SET server_id='$ServerID'") or
					warn "Error sql query: $DBI::errstr\n";
			}
		}
		close( DUMP );
	}else{
		warn "Open file '$sqlCreate' error: $!\n";
	}
}


&postUpdateDB ( $dbh ); 

&StoreBin ($dbh);


print "\n";

&fix_backup_restore();

&fix_ssl();

&fix_locked_users();

&fix_skins();

&upgradeSkins();

&fill_columns();

&fix_frontpage(); ## bug #35858

&fix_email_forward();

&fix_menuitems();

&fix_domain_grp();

&defaultUsers();

&fix_dnstemplate();

&fixPop3Quota();

&webapp_knowledge();

&fix_shared_domains;

&fillTables();

$dbh->disconnect;

#
#
#=========================================================
#
#
sub fix_shared_domains {
	my $sth = $dbh->prepare('desc domains');
	$sth->execute;
$sth->execute;
while (my $row = $sth->fetchrow_hashref){
  if ($row->{'Field'} eq 'domain'){
    if ($row->{'Key'} eq 'UNI'){
      $dbh->do("alter table domains drop index domain") or warn "$DBI::errstr\n";
			last;
    }
  }
}
$sth->finish;
}
sub webapp_knowledge{
	my $sql_script = $installDir.'/admin/install/webapp_knowledge.sql';
	unless( -f $sql_script ){
		return;
	}
	unless( open( SQL, '<', $sql_script ) ){
		warn "Error open file '$sql_script': $!\n";
	}
	my( @filds,$webapp_ind,@vals,$line,$val,$cnt,$sql,$webapp );
	my $state = 0;


	my $sth = $dbh->prepare( "SELECT COUNT(*) FROM webapp_knowledge ".
													 " WHERE webapp=?" );

	while( <SQL> ){
		if( /^\s*INSERT\s+INTO\s+webapp_knowledge\s*\((.+)\)/i ){
			@filds = split( /\s*,\s*/, $1 );
			my $ind=0;
			foreach my $fld (@filds ){
				if( $fld eq 'webapp'){
					$webapp_ind = $ind;
					last;
				}
				$ind++;
			}
			$state = 1 if defined( $webapp_ind );
		}

		if( $state == 1 && /VALUES\s*(.*)/i ){
			$_ = $1;
			$state = 2;
		}
		if( $state == 2 ){
			if( /^\s*\((.+)\),?$/ ){
				$line = $1;
				@vals = ();
				while( $line ){
					$line =~ s/^\s*,?\s*//; ## left trim

					if( $line =~ s/^'// ){ ## start with '
						$line =~ s/(.*?)(?!\\)'//;
						$val = "'$1'";
					}else{
						( $val, $line ) = split( /\s*,\s*/, $line, 2 )
					}
					push @vals,$val;
				}
				if( @vals == @filds ){ ## numbers are equivalence
					$webapp = $vals[$webapp_ind];
					$webapp =~ s/^('|")(.*)\1$/$2/; ## trim quotes
					$sth->execute( $webapp );
					( $cnt ) = $sth->fetchrow;
					$sth->finish;
					unless( $cnt ){

						$sql = "INSERT INTO webapp_knowledge (".
							join( ',', @filds ).") VALUES (".
								join( ',', @vals ).")";

						$dbh->do( $sql );
					}
				}
			}
		}
	}
	close( SQL );
}

sub fillTables{
	my $srcDir = $installDir.'/admin/install';	
	if( opendir( INSTALL, $srcDir ) ){
		my( $srcSQL, $cmd, $table, $return, $sth, $cnt );
		my $cmdPrefix =  $bin_mysql.' '.&makeCmdLine( { 'server' => $dbServer, 
																										'port' => $dbPort,
																										'user' => $dbUser,
																										'password' => $dbPw}
																								);
		
		while( my $file = readdir( INSTALL ) ){
			next unless $file =~ /(.+)\.sql$/;
			$table = $1;

			$srcSQL = "$srcDir/$file";
			next unless -f $srcSQL;

			$sth = $dbh->prepare( "SELECT COUNT(*) FROM $table" );
			$sth->execute();
			( $cnt ) = $sth->fetchrow;
			$sth->finish();

			next if $cnt && $table ne 'webapp2confixx';

			if ( $dbType eq 'mysql' ) {
				$cmd = "$cmdPrefix $dbDB <$srcSQL";

			}else{
				if( $dbServer eq 'localhost' ){
					$cmd = "$bin_psql $dbDB -U $dbUser -f $srcSQL";
				} else {
					$cmd = "$bin_psql -h $dbServer $dbDB -U $dbUser -f $srcSQL";
				}
			}
			if( $return = system( $cmd ) ) {
				&soft_error("Error: insert into atble '$table'" );
			}else{
				$dbh->do( "UPDATE $table SET server_id='$ServerID'" ) unless $checkMasterDb;
			}
		}
		closedir( INSTALL );
	}

}

sub fixPop3Quota {
  my @ver = split /\./, $oldVersion;
	$ver[1] = 0 unless (defined $ver[1]);
	$ver[2] = 0 unless (defined $ver[2]);
	my $v = join "" , @ver;
  #make admins hard quota = 3x softquota
	if ($v < 320){
	
	$sql = "UPDATE admin SET popmaxkbhard = popmaxkb * 3 WHERE server_id='$ServerID'";

	$dbh->do( $sql ) or
		warn "sql-query error '$sql': $DBI::errstr\n";
	}

	#in 3.2.0 mailquota is a service but in older versions it is a limit
	#so if mailquota=1 set limit to '-1' , 0 otherwise
  if ($v == 320){
	  my @sqls = (
		"UPDATE anbieter SET popmaxkb = '-1' , popmaxkblimit ='0' WHERE mailquota = 1 AND server_id='$ServerID'",
		"UPDATE kunden SET popmaxkb = '-1' WHERE mailquota = 1 AND server_id='$ServerID'",
	  "UPDATE kunden SET popmaxkb = '0' WHERE mailquota = 0 AND server_id='$ServerID'",
		"UPDATE anbieter SET popmaxkb = '0' , popmaxkblimit ='0' WHERE mailquota = 0 AND server_id='$ServerID'",
		"UPDATE angebote SET popmaxkb = '0' WHERE mailquota =0 AND server_id='$ServerID'",
		"UPDATE angebote SET popmaxkb = '-1' WHERE mailquota = 1 AND server_id='$ServerID'"
		);
		map {	$dbh->do($_) or warn "sql-query error '$_': $DBI::errstr\n"; } @sqls;
	}	
	
}

sub fixMysqlPrivs {
	my %args = @_;

	unless( $args{'type'} eq 'mysql' ){
		return 0;
	}
	my @items = ();

	
	if( $mysqlUserServer &&	$mysqlUserUser ){
		push @items,[ $mysqlUserServer,
									$mysqlUserUser,
									$mysqlUserPw,
									$mysqlUserPort ];
	}
	
	unless( $mysqlUserServer eq $args{'server'} ){
		push @items, [ $args{'server'},
									 $args{'user'},
									 $args{'password'},
									 $args{'port'} ];
	}

	my $userHost = getMysqlHost( $args{'server'},
															 $args{'db'},
															 $args{'port'},
															 $args{'user'},
															 $args{'password'}
														 );

	my( $adminDSN, $adminDbh, $adminPort, $adminServer, $sql, $adminUser, $adminPw );
	my $userDb = $args{'db'};
	my $userPw = $args{'password'};
	my $userUser = $args{'user'};

	foreach my $ptrItem (@items){

		($adminServer,$adminUser, $adminPw, $adminPort ) = @{$ptrItem};

		$adminDSN = makeDSN( 'mysql', $adminServer, 'mysql', $adminPort );

		$adminDbh = DBI->connect ( $adminDSN, $adminUser, $adminPw,
															 { 'PrintError' => 0 } );
		unless( $adminDbh ){
			next;
		}


		$sql = "GRANT ALL PRIVILEGES ON $userDb.* TO $userUser\@$userHost".
			" IDENTIFIED BY '$userPw'";

		if( $adminDbh->do( $sql ) ){
			$sql = "UPDATE user set Password = Password('$userPw') ".
				" WHERE User='$userUser'";

			$adminDbh->do( $sql );

			$adminDbh->do( "FLUSH PRIVILEGES" );
		}

		$adminDbh->disconnect;
	}
}

sub dropForeignKey{
	my( $dbh, $ptrTables, %tables ) = @_;
	my($table,$field,$fldName,$sql,$tableName);

	foreach $tableName (keys %tables) {
		if( $DEBUG > 1 ){
			print STDERR "Drop triggers on table '$table' ...";
		}
		if( $dbType eq 'Pg' ){
			my $sth = $dbh->prepare("SELECT t.tgname, t.tgargs FROM pg_trigers t, pg_class c WHERE c.relname='$tableName' AND .oid=t.tgrelid" );
			if( $sth->execute ){
				while( my( $name, $args ) = $sth->fetchrow ){
					$dbh->do( "DROP TRIGGER \"$name\" on $tableName" ) or
						warn "Error sql query: $DBI::errstr\n";
				}
			}
		}else{
			unless( ref( $ptrTables ) =~ /HASH/ ){
				next;
			}
			unless( $table = $ptrTables->{$tableName} ){
				next;
			}
			$fldName = $tables{$tableName};
			unless( $field = $table->Field( $fldName ) ){
				next;
			}	
			$sql = "ALTER TABLE $tableName MODIFY ".$field->getSQL();
			unless( $dbh->do( $sql ) ){
				print STDERR "error: dropForeignKey: $DBI::errstr\n";
			}		
		}
		if( $DEBUG > 1 ){
			print STDERR " finished\n";
		}		
	}
}

sub fix_dnstemplate{

	my $external = ( !$mail_server && $mail_pop3Server &&
									 ( $mail_pop3Server ne 'localhost' ) &&
									 ( $mail_pop3Server ne '127.0.0.1' )
								 )? 1: 0;

	return unless $external;

	my $sth = $dbh->prepare("SELECT dnstemplate FROM admin WHERE server_id='$ServerID'");

	if( $sth->execute() ) {
		my($dnstemplate) = $sth->fetchrow();
		$sth->finish();
		my $toSave = 0;

#
#		"##domain##.     86400   IN   MX 10   mail.##domain##.\n\n"
#
		my @newdns = map {
			if( /^(##domain##\.\s+\d+\s+IN\s+MX\s+\d+\s+)(\S+)(.*)/ ){
				if( $external ){
					if( $2 eq 'mail.##domain##.' ){
						$toSave = 1;
						$_ = $1.$mail_pop3Server.'.'.$3;
					}
				} else {
					
				}
			};
			$_
		} split( "\n", $dnstemplate);
		if( $toSave ){
			$dnstemplate = join( "\n", @newdns );
			$dbh->do( "UPDATE admin SET dnstemplate='$dnstemplate' WHERE server_id='$ServerID'" );
		}
	}
}

sub fix_backup_restore {

	my @type = ('html','files','mysql');
	my (@row, $i, $id, $kunde, $src);

	my $sth = $dbh->prepare("SELECT id,kunde, html,files,mysql FROM backup ".
													" WHERE server_id='$ServerID'" );
	$sth->{'PrintError'} = 0;
	if( $sth->execute() ) {
		while( ($id,$kunde,@row) = $sth->fetchrow_array()){
			for($i=0; $i<3; $i++){
				if($row[$i]){
					$dbh->do( "INSERT INTO backup (kunde,src,server_id) VALUES ('$kunde','$type[$i]','$ServerID' )" );
				}
			}
			$dbh->do( "DELETE FROM backup WHERE id=$id AND server_id='$ServerID'" );
		}
		$sth->finish();
		if ( $dbType eq 'mysql' ) {
			foreach my $field ( @type ) {
				$dbh->do( "ALTER TABLE backup DROP COLUMN $field" );
			}
		}
	}



	$sth = $dbh->prepare("SELECT id,kunde,src, html,files,mysql FROM restore ".
											 " WHERE server_id='$ServerID'");
	$sth->{'PrintError'} = 0;
	if( $sth->execute() ) {
		while( ($id,$kunde,$src,@row) = $sth->fetchrow_array()){
			for($i=0; $i<3; $i++){
				if($row[$i]){
					$dbh->do( "INSERT INTO restore (kunde,dst,src,server_id)".
										" VALUES ('$kunde','$type[$i]'),'$src','$ServerID'" );
				}
			}
			$dbh->do( "DELETE FROM restore WHERE id=$id AND server_id='$ServerID'" );
		}
		$sth->finish();
		if ( $dbType eq 'mysql' ) {
			foreach my $field ( @type ) {
				$dbh->do( "ALTER TABLE restore DROP COLUMN $field" );
			}
		}
	}

}

sub fix_domain_grp {

	my $sql = "SELECT id,domain,kunde,richtigedomain FROM domains ".
		"WHERE grp=0 AND server_id='$ServerID' ORDER BY kunde";
	my $sth = $dbh->prepare( $sql );	
	unless( $sth->execute() ){
		print "error: sql: $sql\nDBI::errstr\n";
		return 0;
	}
	my($subId, $subDomain, $kunde, $sthDom, $curKunde, %kundeDom,
		$dom,$domId, $grp, $type );

	while (( $subId, $subDomain, $kunde, $type ) = $sth->fetchrow_array() ) {
		$grp=0;
		if( $type ){
			$grp = $subId;
		}else{

			unless( $curKunde eq $kunde ){ ## get list of domains
				%kundeDom = ();
				$sthDom = $dbh->prepare( "SELECT id,domain FROM domains ".
																 "WHERE kunde='$kunde' AND richtigedomain=1 AND server_id='$ServerID'");
				if ( $sthDom->execute() ) {
					while( ( $domId, $dom ) = $sthDom->fetchrow_array()){
						$kundeDom{$dom} = $domId;
					}
				}
				$curKunde = $kunde;
			}

			foreach $dom ( keys %kundeDom ) { ## find parent domain
				if ( $subDomain =~ /.+\.\Q$dom\E$/ ) {
					$grp = $kundeDom{$dom};
					last;
				}
			}
		}
		if($grp){
			$dbh->do( "UPDATE domains SET grp=$subId where id=$subId AND server_id='$ServerID'" );
		}
	}
	$sth->finish;
}

sub fix_menuitems {

	my (%blocks,$menublock_id,$min,$cnt);

	my $sql = "SELECT menublock_id, min(id) FROM menuitem ".
		" WHERE server_id='$ServerID' GROUP BY menublock_id";
	my $sth = $dbh->prepare( $sql );	
	if( $sth->execute() ){
		while(($menublock_id,$min)= $sth->fetchrow_array()){
			$blocks{$menublock_id} = $min;
		}
	}
	$sth->finish();

#
# get error blocks
#
	if($::dbType eq 'Pg'){
		$sql = "SELECT menublock_id, COUNT(ind) AS cnt FROM menuitem WHERE server_id='$ServerID' ".
			"GROUP BY menublock_id,ind HAVING COUNT(ind)>1";
	}else{
		$sql = "SELECT menublock_id, COUNT(ind) AS cnt FROM menuitem WHERE server_id='$ServerID' ".
			"GROUP BY menublock_id,ind HAVING cnt>1";
	}
	
	$sth = $dbh->prepare( $sql );	

	if ( $sth->execute() ) {
		while (( $menublock_id, $cnt ) = $sth->fetchrow_array() ) {

			next unless( exists( $blocks{$menublock_id} ) ); ## don't fix again

			$min = $blocks{$menublock_id} - 1;

#
# fix error block
#
			$dbh->do( "UPDATE menuitem SET ind=id-$min WHERE menublock_id = menublock_id AND server_id='$ServerID'" );

			delete $blocks{$menublock_id}; ## don't fix again
		}
	}
}

sub fix_frontpage {
	unless($bin_fpsrvadm && -x $bin_fpsrvadm){ 
		my $sql = "UPDATE allgemein SET frontpageadd = 0, frontpagedel = 0, frontpagepw = 0 WHERE server_id='$ServerID'";
		$dbh->do( $sql ) or 
			&soft_error("Error exequte sql: $sql\nDBI::errstr\n");
	}
}


## Unterprogramme

sub loadTablesFromCreate {
  my $sqlCreate=$dbType=~/mysql/?
    "$installDir/admin/subs/mysqltables":
    "$installDir/admin/subs/psqltables";

  my ($table,%tableSet,$name, @tableNames, $type, $index, $sqlItem, $itemType);
  if ( open (SQL,'<',  $sqlCreate ) ) {

    if ( $DEBUG ) {
      print STDERR "Parse database info\n";
    }

    while (<SQL>){
      if ( /^\s*create\s+(table|(?:unique\s+)?index)\s+/i ) {

				$type = ($1=~/table/i)? 'table':' index';

				if( ($itemType = ref($sqlItem)) && $sqlItem->parseSQL() ) {
					if ( $itemType =~ /Table/ ) {
						$name = $sqlItem->Name;
						if ( exists( $tableSet{$name} ) ) {
							print STDERR "error: duplicate table '$name'. Skiped\n"
						} else {
							$tableSet{$name} = $sqlItem;
							push @tableNames, $name;
						}

					}elsif( $itemType =~ /Index/ ){
						#
						# skip index
						#
					}
				}
				if( $type eq 'table' ){
					$sqlItem = sql::Table->new( $_ );
				}else{
					$sqlItem = sql::Index->new( $_ );
				}
      } else {
				$sqlItem->appendFullSQL( $_ ) if $sqlItem;
      }
      chomp;
      next unless $_;
      next if /^\s*--/;
      s/(,)\s*(--.*)$/$1/;
			$sqlItem->appendSQL( $_ );
    }
    close (SQL);
		if( ($itemType = ref($sqlItem)) && $sqlItem->parseSQL() ) {
			if ( $itemType =~ /Table/ ) {
				$name = $sqlItem->Name();
				if ( exists( $tableSet{$name} ) ) {
					print STDERR "error: duplicate table '$name'. Skiped\n"
				} else {
					$tableSet{$name} = $sqlItem;
					push @tableNames,$name;
				}
      }elsif( $itemType =~ /Index/ ) {
				#
				# skip index
				#
			}
    }
  }else{
    die "Can not open $sqlCreate: $!\n";
  }
  return (\%tableSet,\@tableNames);
}

sub checkDB {

  my ($dbh,$ptrTables,$ptrNames) = @_;

  unless( ( ref($dbh) =~ /DBI/ ) && ( ref($ptrTables) =~ /HASH/ ) ) {
    print STDERR "error: checkDB: wrong arguments\n";
    return 0;
  }
  my ($tblName,$table,$sql,$sthCheck,$sthDrop,$drop,$create,$sqlCreate,
			%dbTables,$dbTable,$fldName,$field,$dbField,$tblOK,$fldID,
			$fldType,$fldDefault,$fldNotNull,$seqName,$fldSerial,$notEmpty,
			$add,$update,$bakFieldName,$sqlCreateTable);

  my $dbIsPg = ($dbType eq 'Pg');
  unless ( ref($ptrNames) =~ /ARRAY/ ) {
    $ptrNames = \@{keys %{$ptrTables}};
  }
  foreach $tblName (@{$ptrNames}){
    if ( $DEBUG>1 ) {
      print STDERR "Check table '$tblName'\n";
    }
    $table = $ptrTables->{$tblName};
    unless( ref($table) =~ /Table/ ) {
      print STDERR "Error: table '$tblName' is not found\n";
      next;
    }

    $drop = $create = 0;
    if ( $dbIsPg ) {
      $sql = "select * from \"$tblName\" limit 1";
    } else {
      $sql = "select * from `$tblName` limit 1";
    }

    unless ( $sthCheck = $dbh->prepare( $sql ) ) {
      print STDERR "error: checkDB: prepare sql-request error\n$DBI::errstr\n";
      next;
    }

    $sthCheck->{'PrintError'} = 0;
    if ( $sthCheck->execute() ) {
      $dbTable = sql::Table->new( 'name' => $tblName );
      $dbTable->fillFromDB( $sthCheck );

      if ( $sthCheck->rows() ) {
				$notEmpty = 1;
			} else {
				if ( $DEBUG > 1 ) {
					print STDERR "Table '$tblName' is empty\n";
				}
				$drop = 1; ## It is possible to drop the table
      }
      $sthCheck->finish();
      $dbTables{$tblName} = $dbTable;
    }else{
      $create = 1; ## need to create the table
    }

    $sqlCreateTable = $table->getSQL();

    $tblOK = 1;
    if ( $create && $sqlCreateTable ) {
			print STDERR "Create table '$tblName'\n";

      if ( $dbh->do( $sqlCreateTable ) ) {
				$table->Correct( 1 );
      } else {
				$tblOK = 0;
				print STDERR "error: checkDB: error create table '$tblName' ($sqlCreate)\n$DBI::errstr\n";
      }
    } else {

      if ( $DEBUG > 1 ) {
				print STDERR "Check fields of table '$tblName'\n";
      }

      foreach $fldName ( @{$table->NamesOfFields} ) {
				unless ( $field = $table->Field( $fldName ) ) {
					print STDERR "error: checkDb: field '$fldName' not found in table '$tblName'\n";
					next;
				}
				$add = 0;
				$update = 0;
				if ( $dbField = $dbTable->Field( $fldName ) ) {
					if ( $update = $dbField->needUpdate( $field ) ) {

						if ( $dbIsPg ) { ## PostgreSQL
							$bakFieldName = $fldName.'_bak';
							$sql = "ALTER TABLE $tblName RENAME $fldName TO $bakFieldName";
							if ( $dbh->do( $sql ) ) {
								$update = $bakFieldName;
								$add = 1;
							} else {
								print STDERR "error: checkDB: unable to rename field '$fldName' ($sql)\n".
									"$DBI::errstr\n";
							}
							## /PostgreSQL

						} else { ## MySQL
							if ( $DEBUG ) {
								print STDERR "Modify field '$fldName'\n";
							}
							$sqlCreate = $field->getSQL;
							$sql = "ALTER TABLE $tblName MODIFY ".$sqlCreate;
							unless ( $dbh->do( $sql ) ) {
								print STDERR "error: checkDB: unable to modify field '$fldName' ($sql)\n".
									"$DBI::errstr\n";									
							}
							## /MySQL
						}
						
					}
				} else {
					$add = 1;
				}	
				if ( $add ) {
					if ( $drop && $sqlCreateTable ) { ## if it is possible to drop the table then drop & re-create
						if ( $DEBUG > 1 ) {
							print STDERR "Re-create table '$tblName'\n";
						}
						$sql = "DROP TABLE $tblName";
						if ( $dbh->do( $sql ) ) {
							if ( $dbh->do( $sqlCreateTable ) ) {
								$table->Correct( 1 );
							} else {
								$tblOK = 0;
								print STDERR "error: checkDB: error create table '$tblName' ($sqlCreate)\n$DBI::errstr\n";
							}
							last;
						} else {
							print STDERR "error: checkDB: error drop table '$tblName'\n$DBI::errstr\n";
							$drop = 0;
						}
					}
					

					print STDERR "Add field '$fldName' into table '$tblName'\n";
#
# PosgreSQL
#
					if ( $dbIsPg ) {
						$fldType = $field->Type;
						$fldDefault = $field->Default;
						$fldNotNull = $field->NotNull;
						if ( $fldType =~ /serial/i ) {
							$seqName = $tblName.'_'.$fldName.'_seq';
							$sql = "create sequence $seqName";
							unless ( $dbh->do( $sql ) ) {
								$tblOK = 0;
								print STDERR "error: checkDB: create sequence ($sql)\n$DBI::errstr\n";
							}
							$fldType = 'int';
							$fldNotNull = 1;
							$fldSerial = 1;
						} else {
							$seqName = '';
							$fldSerial = 0;
						}

						$sqlCreate = $field->getSQL;
						if ( defined($fldDefault) ){
							$sqlCreate =~ s/\s+DEFAULT\s+\Q$fldDefault\E//i;
						}
						if( $fldNotNull ){
							$sqlCreate =~ s/\s+NOT\s+NULL//;
						}
						$sql = "ALTER TABLE $tblName ADD COLUMN ".$sqlCreate;
						if ( $dbh->do($sql) ) {
							if ( $update ) {
								$sql = "UPDATE $tblName SET $fldName = $update";
								$dbh->do($sql) ||
									print STDERR "Error: checkDB: unable to update field '$fldName' ($sql)".
										"\n$DBI::errstr\n";
							}
						} else {
							$tblOK = 0;
							print STDERR "error checkDB: error add field '$fldName' into table '$tblName'\n".
								"$DBI::errstr\n";
						}
						if ( $seqName ) {
							unless($dbh->do("ALTER TABLE $tblName ALTER COLUMN $fldName ".
															"SET DEFAULT nextval('$seqName')") ){
								$tblOK = 0;
								print STDERR "Error: $DBI::errstr\n";
							}
							unless($dbh->do("update TABLE $tblName set $fldName = nextval('$seqName')")){
								$tblOK = 0;
								print STDERR "Error: $DBI::errstr\n";
							}
						} else {
							if ( defined($fldDefault) ){
								$sql = "ALTER TABLE $tblName ALTER COLUMN $fldName ".
									"SET DEFAULT $fldDefault";
								unless( $dbh->do( $sql ) ){
									$tblOK = 0;
									print STDERR "Error sql: $sql\n$DBI::errstr\n";
								}
								$sql = "UPDATE $tblName SET $fldName = $fldDefault".
									" WHERE $fldName IS NULL";
								unless( $dbh->do( $sql ) ) {
									$tblOK = 0;
									print STDERR "Error sql: $sql\n$DBI::errstr\n";
								}
							}
						}
						if ( $fldNotNull ) {
							unless($dbh->do("UPDATE pg_attribute SET attnotnull='t'".
															" WHERE attrelid=(SELECT oid FROM pg_class WHERE relname='$tblName')".
															" AND attname='$fldName'") ){
								$tblOK = 0;
								print STDERR "Error: $DBI::errstr\n";
							}
							if ( $fldSerial ) {
								unless($dbh->do("alter table $tblName add primary key($fldName)")){
									$tblOK=0;
									print STDERR "Error: $DBI::errstr\n";
								}
							}
						}
#
# /PostgreSQL
#
					} else {
#
# MySQL
#
						$sqlCreate = $field->getSQL;
						$fldID = $table->ID();
						
						my $hasPrimaryKey = ( $sqlCreate =~ /\s+primary\s+key(?=\s+|$)/i )? 1: 0;
						my $hasAutoIncrement = ( $sqlCreate =~ /\s+auto_increment(?=\s|$)/i )? 1: 0;

						if( $hasAutoIncrement ){
							if( $hasPrimaryKey ){
								$sqlCreate.=", ADD PRIMARY KEY ($fldName)";
							}else{
								$sqlCreate.=", ADD INDEX ($fldName)";
							}
						}

						$sql = "ALTER TABLE $tblName ADD COLUMN $sqlCreate";
						unless($dbh->do($sql) ){
							$tblOK = 0;
							print STDERR "error: checkDB: error add field '$fldName' into table '$tblName'\n".
								"$sql\n$DBI::errstr\n";
						}
					}
#
# /MySQL
#
					$dbTable->appendField( $field->clone() );
				}

			}
		}

#
# primary key
#
		if( $fldID = $table->ID() ){

			my $reindex = 1;

			if( $dbType eq 'Pg' ){
				my $indexname = $tblName.'_pkey';
				my $sth = $dbh->prepare( "SELECT pg_get_indexdef(oid) FROM pg_class ".
																 " WHERE relname='$indexname'" );
				if( $sth->execute ){
					if ( $sth->rows ) { ## there is the primary key
						$sql = $sth->fetchrow();
						if( $sql =~ /ON\s.*\Q$tblName\E.*\((.*)\)/ ){ ## get list of indexes
							if( $table->isValidKey( $1 ) ){
								$reindex = 0;
							}else{
								$dbh->do( "ALTER TABLE $tblName DROP CONSTRAINT $indexname" ) or
									warn "Error sql query: $DBI::errstr\n";
								
							}
						}
					}
					if( $reindex ){
						$dbh->do( "CREATE UNIQUE INDEX $indexname ON $tblName (".$table->getListKey().")") or
							warn "Error sql query: $DBI::errstr\n";
					}
				}else{
					warn "Error sql query: $DBI::errstr\n";
				}
			}else{
# MySQL
				my ($key,$col,$row,%has_index,$extra,%prim);
				my $sth = $dbh->prepare( "SHOW INDEX FROM $tblName" );
				if( $sth->execute ){
					while( $row = $sth->fetchrow_hashref ){
						$col = $row->{'Column_name'} || $row->{'column_name'};
						$key = $row->{'Key_name'} || $row->{'key_name'};

						if( $key =~ /PRIMARY/i ){ ## select primary key
							$prim{$col} = 1;
						}else{
							unless(exists($has_index{$col})){
								$has_index{$col} = [];
							}
							push @{$has_index{$col}},$key; ## store index info
						}
					}
					$sth->finish;

					if( $table->isValidKey( keys %prim ) ){
						$reindex = 0;
					}else{

						if( keys %prim ){
							$sth = $dbh->prepare( "SHOW FIELDS FROM $tblName" );
							if( $sth->execute ){
								while( $row = $sth->fetchrow_hashref ){

									$extra = $row->{'Extra'} || $row->{'extra'};
									next unless $extra =~ /auto_increment/i; ## select auto_increment

									$col = $row->{'Field'} || $row->{'field'};
									next unless $prim{$col}; ## select fields of the primary key
									next if $has_index{$col}; ## select fields without index

#
# create temporary index
#
									$dbh->do( "ALTER TABLE $tblName ADD INDEX ($col)") or
										warn "Error sql query: $DBI::errstr\n";
								}
								$sth->finish();
							}

#
# drop primary index
#							
							$dbh->do( "ALTER TABLE $tblName DROP PRIMARY KEY" ) or
								warn "Error sql query: $DBI::errstr\n";
						}
					}
					if( $reindex ){
#
# craete new primary key
#
						$dbh->do( "ALTER TABLE $tblName ADD PRIMARY KEY (".
											$table->getListKey().")" ) or
												warn "Error sql query: $DBI::errstr\n";
					}
				} else {
					warn "Error sql query: $DBI::errstr\n";
				}
			}
		}

#
# end primary key
#

#
# unique
#
		if( my @unique = $table->Unique() ){
			my $reindex = 1;
			if( $dbType eq 'Pg' ){
#
# to do
#
			}else{
#
# MySQL
#
				my ($uni,$col,$row,%unique, $key);

				my $sth = $dbh->prepare( "SHOW INDEX FROM $tblName" );
				if( $sth->execute ){
					while( $row = $sth->fetchrow_hashref ){
						$col = $row->{'Column_name'} || $row->{'column_name'};
						$uni = $row->{'Non_unique'} || $row->{'non_unique'};
						$key = $row->{'Key_name'} || $row->{'key_name'};

						next if $key =~ /PRIMARY/i;
						next if $uni;
						
						if( exists( $unique{$col} ) ){
							push @{$unique{$col}}, $key;
						}else{
							$unique{$col} = [$key];
						}
					}

					$sth->finish;
					unless( $table->isValidUnique( keys %unique ) ){
						my %keys = ();
						map{ map{ $keys{$_} = 1 } @{$_} } values %unique;
#
# drop all unique keys
#
						foreach $key ( keys %keys ){
							$dbh->do( "ALTER TABLE $tblName DROP INDEX $key" ) or
								warn "Error sql query: $DBI::errstr\n";
						}
#
# create new unique index
#
						$sql = "ALTER TABLE $tblName ADD UNIQUE (".join(',',@unique).")";
						$dbh->do( $sql ) or
								warn "Error sql query: $DBI::errstr\n";
					}
				}
			}
		}
#
# end unique
#

    if(($DEBUG>1) && $tblOK){
      print STDERR "Table '$tblName' - OK\n";
    }

  }
  return \%dbTables;
}

sub postUpdateDB {
	my $dbh = shift;

#
# fix update intervales
#
	
	my @prefixList = ('httpdtraffik','ftptraffik','speicher');

	$sql = 'SELECT confixxfaktor,'.
		join(',',map{$_.'faktor'}@prefixList).
		" FROM zeiten WHERE server_id='$ServerID'";

	$dbh->{'PrintError'} = 0;
  my $sth = $dbh->prepare( $sql );
	$dbh->{'PrintError'} = 1;

  if ( $sth->execute ) { ## there are this fields

		my %faktor = %{$sth->fetchrow_hashref};
		$sth->finish;

		my ( @sets,$freq,$prefix );
		foreach my $prefix ( @prefixList ) {
			$freq = $faktor{$prefix.'faktor'} * $faktor{'confixxfaktor'};
			if ( $freq ){
				push @sets,' '.$prefix.'freq = '.$freq;
			}
		}
		if ( @sets ) {
			$sql = 'UPDATE zeiten SET '.join(',',@sets)." WHERE server_id='$ServerID'";
			$dbh->do($sql);
		}
		if ( $dbType eq 'mysql' ) {
			foreach my $prefix ( @prefixList ) {
				$sql = 'ALTER TABLE zeiten DROP COLUMN '.$prefix.'faktor';
				$dbh->do( $sql );
			}
		} else {
			$sql = 'UPDATE zeiten SET '.join(',',map{ $_.'faktor=0'} @prefixList).
				" WHERE server_id='$ServerID'";
			$dbh->do( $sql );
		}
	}


}



sub fix_ssl{
  my ($sth, @row, $row);
	$dbh->{'PrintError'} = 0;
  $sth = $dbh->prepare("SELECT kunde, anbieter, privatekey, crt, csr, neu,".
											 " loeschen, aendern,".
											 " countrycode, state, city, firm, unit, common, email,".
											 " challenge, optional FROM ssl" );
	$dbh->{'PrintError'} = 1;
  if ( $sth->execute ) {

    while ( @row = $sth->fetchrow_array ) {
      $dbh->do( "INSERT INTO cssl (kunde, anbieter, privatekey, crt, csr, neu,".
								" loeschen, aendern,".
								" countrycode, state, city, firm, unit, common, email,".
								" challenge,optional,server_id) ".
							 " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,'$ServerID')", undef, @row);
    }
    $sth->finish;

    $dbh->do("DROP TABLE ssl");
	}

  undef $row;
	$dbh->{'PrintError'} = 0;
  $sth = $dbh->prepare("SELECT ssl FROM admin WHERE ssl != 0");
	$dbh->{'PrintError'} = 1;

  if($sth->execute){

    $row = $sth->fetchrow;
    if($row eq '1'){
      $dbh->do("UPDATE admin SET cssl = 1 WHERE cssl = 0 AND server_id='$ServerID'");
    }
    if($dbType eq 'mysql'){
      $dbh->do("ALTER TABLE admin DROP COLUMN ssl");
    }
    else{
      $dbh->do("UPDATE admin SET ssl = 0 WHERE server_id='$ServerID'");
    }
	}

  undef @row;
	$dbh->{'PrintError'} = 0;
  $sth = $dbh->prepare( "SELECT anbieter,ssl FROM anbieter WHERE ssl != 0 AND server_id='$ServerID'" );
	$dbh->{'PrintError'} = 1;
  if($sth->execute){
    while(@row = $sth->fetchrow_array){
      if($row[1] eq '1'){
        $dbh->do( "UPDATE anbieter SET cssl = 1 WHERE cssl = 0 AND anbieter = '$row[0]' AND server_id='$ServerID'");
      }
    }
    if($dbType eq 'mysql'){
      $dbh->do("ALTER TABLE anbieter DROP COLUMN ssl");
    }
    else{
      $dbh->do("UPDATE anbieter SET ssl = 0");
    }
	}

  undef @row;
	$dbh->{'PrintError'} = 0;
  $sth = $dbh->prepare("SELECT domain,ssl FROM domains WHERE ssl != 0 AND server_id='$ServerID'");
	$dbh->{'PrintError'} = 1;
  if($sth->execute){
    while( @row = $sth->fetchrow_array ) {
      if ( $row[1] == 1 ) {
        $dbh->do("UPDATE domains SET cssl = 1 WHERE cssl = 0 AND domain = '$row[0]' AND server_id='$ServerID'");
      }
    }
    if($dbType eq 'mysql'){
      $dbh->do("ALTER TABLE domains DROP COLUMN ssl");
    }
    else{
      $dbh->do("UPDATE domains SET ssl = 0 WHERE server_id='$ServerID'");
    }
	}
  
  $dbh->do( "UPDATE anbieter SET cssl = 1 WHERE cssl = -1 AND anbieter = 'res0' AND server_id='$ServerID'"); # bug #25131


#
# add field kunden.cssl
#
	$sth = $dbh->prepare( "SELECT MAX(cssl) FROM kunden WHERE server_id='$ServerID'");
	$sth->execute();
	my($maxCssl) = $sth->fetchrow();
	$sth->finish;
	
	unless($maxCssl){ 
		$sth = $dbh->prepare( "SELECT c.kunde FROM cssl c, kunden k, anbieter a ".
													" WHERE k.kunde=c.kunde AND a.anbieter=c.anbieter ".
													" AND c.aendern=0 AND c.neu=0 AND c.loeschen=0 ".
													" AND a.cssl=1 AND k.server_id='$ServerID' ".
													" AND c.server_id='$ServerID' AND a.server_id='$ServerID'" );
		$sth->execute();
		while( my( $kunde ) = $sth->fetchrow ){ 
			## there is an active certificate & reseller has ssl-feature
			$dbh->do( "UPDATE kunden SET cssl=1 WHERE kunde='$kunde' AND cssl=0 AND server_id='$ServerID'" );
		}
	}
	$sth->finish;

#
# to run reconfiguration of httpd
#
	$dbh->do("UPDATE allgemein SET httpd=1, cssl=1 WHERE server_id='$ServerID'");

}

sub fix_locked_users{
  my ($sth, @row, $row);
  
	if($mysqlUserUser && $mysqlUserServer){
		my $mysql_db_address = &makeDSN( 'mysql',
																		 $mysqlUserServer,
																		 'mysql',
																		 $mysqlUserPort || $mysql_sock );

		my $dbh2 = DBI->connect($mysql_db_address, $mysqlUserUser, $mysqlUserPw)
			or return ("\n$DBI::errstr\n");

		$sth = $dbh->prepare("SELECT kunde FROM kunden WHERE gesperrt = 1 AND maxmysql != 0 ".
												 " AND server_id='$ServerID'");

		if( $sth->execute ){
			while( @row = $sth->fetchrow_array ){
				$dbh2->do("UPDATE db SET Select_priv = 'N', Insert_priv = 'N', Update_priv = 'N', Delete_priv = 'N', Create_priv = 'N',
 	    						Drop_priv = 'N', Grant_priv = 'N', References_priv = 'N', Index_priv = 'N', Alter_priv = 'N'
								WHERE Host = '%' AND User = '$row[0]'") or &soft_error("$DBI::errstr");
			}
			$dbh2->do( 'FLUSH PRIVILEGES' ) or
				&soft_error( $DBI::errstr);
			$sth->finish;    
		}
		$dbh2->disconnect;
	}
}

sub fix_skins{
	
	my $sql = $::dbType eq 'mysql'? "SELECT user FROM skins": 'SELECT "user" FROM skins';
	$sql .= " WHERE server_id='$ServerID'";

	$dbh->{'PrintError'} = 0;
	unless ( $dbh->do( $sql ) ) {
		$dbh->{'PrintError'} = 1;
		return; ## already fixed
	}
	$dbh->{'PrintError'} = 1;

  $dbh->do("UPDATE skins SET cuser = user WHERE user != ''");
  if( $dbType eq 'mysql' ){
    $dbh->do("ALTER TABLE skins DROP COLUMN user");
    $dbh->do("ALTER TABLE skins ADD PRIMARY KEY (cuser,server_id)");
  } else {
    $dbh->do("UPDATE skins SET user = '' WHERE server_id='$ServerID'");
    $dbh->do("CREATE UNIQUE INDEX skins_pkey ON skins (cuser,server_id)");
  }
}

sub fix_email_forward{
	my( $sth, $sth1, $ident, $pop3, $pop3x, %forward, $email_ident, $kunde );
	$dbh->{'PrintError'} = 0;
  $sth = $dbh->prepare( "SELECT ident, pop3, pop3x, kunde FROM email WHERE server_id='$ServerID'" );
	$dbh->{'PrintError'} = 1;
  if( $sth->execute ) {
	$sth1 = $dbh->prepare( "SELECT pop3 FROM email_forward WHERE email_ident=? AND server_id='$ServerID'" );
		while( ($email_ident, $pop3, $pop3x, $kunde) = $sth->fetchrow_array){
			%forward = ( $pop3 => 1);
			map{ $forward{$_} = 1} split( /\s*:\s*/, $pop3x);
			$sth1->execute( $email_ident );
			while( ( $pop3 ) = $sth1->fetchrow_array ) {
				if( exists( $forward{$pop3} ) ) {

					delete $forward{$pop3};
				}
			}
			$sth1->finish();
			foreach $pop3 ( keys( %forward ) ) {
				$dbh->do("INSERT INTO email_forward( email_ident, pop3, kunde, server_id) ".
				    " VALUES ( $email_ident, '$pop3', '$kunde', '$ServerID' )");
			}
		}
		if($dbType eq 'mysql'){
			$dbh->do("ALTER TABLE email DROP COLUMN pop3");
			$dbh->do("ALTER TABLE email DROP COLUMN pop3x");
		}
	}	
}


sub fill_columns {
  my ($sth, $line, $path, $table);

  ## passwort -> longpw
  foreach $table ('admin', 'anbieter', 'ftp', 'kunden', 'pop3'){
    $dbh->do( "UPDATE $table SET longpw = passwort WHERE longpw = '' ".
							" AND passwort != '' AND server_id='$ServerID'");
  }
  $dbh->do( "UPDATE admin SET mysqlshelllongpwcrypt = mysqlshellpasswortcrypt".
						" WHERE mysqlshelllongpwcrypt = '' AND mysqlshellpasswortcrypt != '' AND server_id='$ServerID'");

  $dbh->do( "UPDATE kunden SET statistiklongpw = statistikpasswort WHERE statistiklongpw = '' AND statistikpasswort != '' AND server_id='$ServerID'" );
  $dbh->do( "UPDATE users SET longpw = pass WHERE longpw = '' AND pass != '' AND server_id='$ServerID'");
  ## // passwort -> longpw


  ### 1.1
  ## neuer Hilfecode fur bestehende Anbieter
  my $hilfecode = &ltext('install_hilfecode');
  $dbh->do( "UPDATE anbieter SET hilfecode = ? WHERE hilfecode='' AND server_id='$ServerID'", undef, $hilfecode );
  ## /neuer Hilfecode fur bestehende Anbieter


  ## setze Webalizer-Statiskpasswort = Kundenpasswort
  print &ltext('update_feature_check', 'WebalizerPw');
  $dbh->do( "UPDATE kunden SET statistiklongpw = longpw WHERE statistiklongpw = '' AND longpw != '' AND server_id='$ServerID'" );
  print "\n\n";
  ## /setze Webalizer-Statiskpasswort = Kundenpasswort

	my (@row,$sql,$sthdl,$domain,$kunde, $count);

	$sthdl = $dbh->prepare( "SELECT COUNT(domain) FROM domainlog WHERE domain=? AND kunde=? AND server_id='$ServerID'");

  ## erstelle alle Logfile-Symlinks neu (#1111 - Error)
  $sth = $dbh->prepare( "SELECT domain,kunde FROM domains WHERE domain not like '*%' AND server_id='$ServerID'");
  $sth->execute;
  while ( ($domain,$kunde ) = $sth->fetchrow_array ) {
    if ( $kunde ) {
			$sthdl->execute($domain,$kunde);
			($count) = $sthdl->fetchrow;
			if ( $count ) {
				$sql = "UPDATE domainlog SET neu=1 WHERE domain='$domain' AND kunde='$kunde' AND server_id='$ServerID'";
			} else {
				$sql = "INSERT INTO domainlog (domain, kunde, neu, server_id) VALUES ('$domain','$kunde',1, '$ServerID')";
			}
			$sthdl->finish;
      $dbh->do($sql) or
				print STDERR "Error execute SQL: '$sql'\n$DBI::errstr\n";

		} else {
      if(-l "$apacheLogDir/domains/access/$domain"){
        unlink("$apacheLogDir/domains/access/$domain");
      }
    }
  }
  $sth->finish;
  ## /erstelle alle Logfile-Symlinks neu (#1111 - Error)

  ## erstelle neue Webalizer.conf
  $dbh->do( "UPDATE kunden SET changedomains=1, pw=1 WHERE server_id='$ServerID'" );
  ## /erstelle neue Webalizer.conf
  ### //1.1


  ### 1.2
  # stdDomain .conf -> db
  $sth = $dbh->prepare( "SELECT standarddomain FROM admin WHERE server_id='$ServerID'" );
  $sth->execute;
  $line = $sth->fetchrow;
  if($line !~ /\S+\.\S+/){
    $dbh->do( "UPDATE admin SET standarddomain='$stdDomain' WHERE server_id='$ServerID'" );
  }
  # /stdDomain .conf -> db

  # countdomains
  print &ltext('update_feature_check', 'countdomains');
  $sth = $dbh->prepare("SELECT count(domain), kunde FROM domains WHERE kunde != '' AND server_id='$ServerID' GROUP BY kunde");
  $sth->execute;
  while(@row = $sth->fetchrow_array){
    print &ltext('update_user_countdomains', $row[1], $row[0]);
    $dbh->do("UPDATE kunden SET countdomains='$row[0]' WHERE kunde='$row[1]' AND server_id='$ServerID'" );
  }
  print "\n\n";
  # /countdomains

  # register
  $sth = $dbh->prepare( "SELECT COUNT(hinweis) FROM register WHERE server_id='$ServerID'");
  $sth->execute;
  $line = $sth->fetchrow;
  unless($line){
    $dbh->do( "INSERT INTO register (hinweis,server_id) VALUES ('','$ServerID')");
  }
  # /register
  ### //1.2


  ### 1.5.6
  #
  # quota for emailusers
  $sth = $dbh->prepare( "SELECT quota FROM admin WHERE server_id='$ServerID'" );
  $sth->execute;
  $line = $sth->fetchrow;
  if($line){
    for ('pop3', 'kunden', 'ftp', 'allgemein') {
      $dbh->do("UPDATE $_ SET quota = 1 WHERE server_id='$ServerID'");
    }
  }
  # /quota for emailusers
  #
  ### //1.5.6

  # autoresponder bug
  $dbh->do( "UPDATE email SET neu=1 WHERE server_id='$ServerID'" );
  # //autoresponder bug

  ### 1.6.2
  #
  ## update all .htaccess files

	my ( %pfads,$pfad );

	foreach $table ('pwschutz','fehlermeldungen') {
		$sth = $dbh->prepare( "SELECT pfad, kunde FROM $table WHERE server_id='$ServerID'" );
		$sth->execute;
		while ( ($pfad,$kunde) = $sth->fetchrow_array){
			if ( exists ( $pfads{$kunde} ) ){
				$pfads{$kunde}->{$pfad} = 1;
			} else {
				$pfads{$kunde} = {$pfad => 1};
			}
		}
		$sth->finish;
	}

	$sth = $dbh->prepare( "SELECT COUNT(pfad) FROM htaccess WHERE pfad=? ".
												" AND kunde=? AND server_id='$ServerID'" );
	foreach $kunde ( keys %pfads ) {
		foreach $pfad ( keys %{$pfads{$kunde}} ) {
			$sth->execute( $pfad, $kunde );
			($count) = $sth->fetchrow;
			unless ( $count ) {
				print "Updating $user_homeDir/$kunde/html$pfad/.htaccess\n";
				$dbh->do( "INSERT INTO htaccess (pfad, kunde, server_id) ".
									" VALUES ('$pfad', '$kunde', '$ServerID' )");
			}
		}
	}
  ## //update all .htaccess files

  ## set version to 'Pro' if $installDir/admin/subs/autoresponder.pl exists.
  if(-e "$installDir/admin/subs/autoresponder.pl"){
    $dbh->do( "UPDATE register SET version='Pro' AND server_id='$ServerID'" );
  }
  ## // set version to 'Pro' if $installDir/admin/subs/autoresponder.pl exists.

  ## remove mysqlshelluser
  $dbh->do( "UPDATE admin SET mysqlshellhost = '', mysqlshelluser = '', mysqlshelllongpwcrypt = '' WHERE server_id='$ServerID'" );
  ## //remove mysqlshelluser
  #
  ### //1.6.2

  ## 2.0.0
  $dbh->do( "UPDATE admin SET dnstemplate = '##domain##.      86400  IN   A         ##ip##\n*.##domain##.   86400  IN   A         ##ip##\n\n##domain##.     86400   IN   MX 10   mail.##domain##.\n\n##domain##.     86400   IN   NS        ##ns1##.\n##domain##.     86400   IN   NS        ##ns2##.' WHERE dnstemplate='' AND server_id='$ServerID'" );
  ## /2.0.0

  ## 2.0.8
  $dbh->do("UPDATE dns SET neu = 1 WHERE neu = 0 AND server_id='$ServerID'");
  ## /2.0.8

	$sth = $dbh->prepare( "SELECT dns.domain FROM dns, domains WHERE dns.domain=domains.domain".
												" AND domains.dns=0 AND dns.neu IN (0,1) AND dns.server_id='$ServerID' AND domains.server_id='$ServerID'" );
	if( $sth->execute ) {
		while( ( $domain ) = $sth->fetchrow ){
			$dbh->do( "UPDATE domains SET dns=1 WHERE domain='$domain' AND server_id='$ServerID'" );
		}
		$sth->finish;
	}

  $dbh->do("UPDATE allgemein SET newpwd=1, httpdupdate=0, aliasesupdate=0,".
					 " webalizerpw=1, domains=1, adduser=1, frontpageadd=1, htaccess=1,".
					 " confixxupdate=0, dns=1 WHERE server_id='$ServerID'" );
  $dbh->do( "UPDATE frontpage SET email=1 WHERE server_id='$ServerID'" );
  $dbh->do( "UPDATE admin SET fehlerseiten=1, pwschutz=1, php=1, phpupload=1, dirlist=1 WHERE server_id='$ServerID'");

  ## 2.0.8 add user_prefix to db (for external mailserver)
  $dbh->do( "UPDATE admin SET userprefix = ? WHERE server_id='$ServerID'", 
						undef, $user_prefix );
  ## /2.0.8 add user_prefix to db (for external mailserver)
  
  ## 2.0.11
  $dbh->do( "UPDATE admin SET hostname = '$hostname', business = 0, postconf=1 WHERE server_id='$ServerID'");
	$sth = $dbh->prepare("SELECT COUNT(*) FROM bdefault WHERE server_id='$ServerID'");
	my $cnt = 0;
	if( $sth->execute() ){
		($cnt) = $sth->fetchrow;
		$sth->finish();
		if( $cnt > 1 ){
			$dbh->do( "DELETE FROM bdefault WHERE server_id='$ServerID'" );
			$cnt = 0;
		}
	}
	unless( $cnt ){											
		$dbh->do( "INSERT INTO bdefault(defaultserver,server_id) ".
							" VALUES(0,'$ServerID')" );
	}
  ## /2.0.11

  $sth = $dbh->prepare( "SELECT COUNT(*) FROM types WHERE server_id='$ServerID'" );
  if( $sth->execute ){
		($cnt) = $sth->fetchrow;
		unless( $cnt){
			installTypes( $dbh );
		}
		$sth->finish;
  }

  $sth = $dbh->prepare ( "SELECT phpmyadminpfad FROM admin WHERE server_id='$ServerID'" );
  $sth->execute;
  $path = ($sth->fetchrow())[0];
  if ( $path =~ /^\.\.\/[^\.][^\.]/ ){
    $dbh->do ( "UPDATE admin SET phpmyadminpfad = CONCAT( '../', phpmyadminpfad ) WHERE server_id='$ServerID'" );
  }

  ## // 3.0.0
  
  ## 3.0.2
	if( $::dbType eq 'Pg' ){
		$dbh->do( "UPDATE kunden SET number = to_number(replace(kunde, ?, ''),'999999999') WHERE server_id='$ServerID'", undef, $user_prefix);
	}else{
		$dbh->do( "UPDATE kunden SET number = replace(kunde, ?, '') WHERE server_id='$ServerID'", undef, $user_prefix);
	}
  ## /3.0.2
  
  ## 3.0.4
  $dbh->do( "UPDATE allgemein SET checknewversion = 12 WHERE checknewversion = 0 AND server_id='$ServerID'");
  $dbh->do( "UPDATE zeiten SET checknewversion = 12 WHERE checknewversion = 0 AND server_id='$ServerID'");
  ## /3.0.4
  
  ## 3.3.2
  $dbh->do( "UPDATE httpd_states SET data='<Directory \"##user_home##/##user##/html\">\r\nAllowOverride All\r\nOptions +FollowSymlinks\r\n</Directory>' WHERE id=6");
  ## /3.3.2   
}

#
#
#==================================
#
#
sub checkSkinVer {
	my( $ver, $ptrHash ) = @_;

	my $sth = $dbh->prepare( "SELECT name,id,path FROM custom_skins WHERE version='$ver' AND owner_type='preinstalled' AND server_id='$ServerID'" );
	$sth->execute();
	
	my($key,$id,$title,$cnt,$path);
	
	while( ($key,$id,$path) = $sth->fetchrow()){
		if ( exists $ptrHash->{$key} ) {
			delete $ptrHash->{$key};
			if( "/skins/$key" ne $path){
				$dbh->do( "UPDATE custom_skins SET path='/skins/$key' WHERE version='$ver' ".
								 "AND id=$id AND owner_type='preinstalled' AND server_id='$ServerID'")
			}
		} else {
			$dbh->do( "DELETE FROM custom_skins WHERE version='$ver' ".
								"AND id=$id AND owner_type='preinstalled' AND server_id='$ServerID'" );
		}
	}
	$sth->finish();

	$cnt = 0;
	foreach $key (sort keys %{$ptrHash} ){
		$title = $ptrHash->{$key};

		$dbh->do( "INSERT INTO custom_skins( name, show_name, owner_type, version, path, server_id)".
					 " VALUES ( '$key', '$title', 'preinstalled', '$ver', '/skins/$key', '$ServerID')");
		$cnt++;
	}

	return $cnt;
}

sub upgradeSkins{

  my $skinname = $dbh->quote(ltext("sk_default_skin"));
	
	my %xp30 = ( 'skin_1' => 'Blue Color Scheme',
							 'skin_2' => 'Green Color Scheme',
							 'skin_3' => 'Olivegreen Color Scheme',
							 'skin_4' => 'Red Color Scheme',
							 'skin_5' => 'Silver Color Scheme');

	&checkSkinVer( 'xp30', \%xp30);

	my %classic20 = ( 'default' => 'Confixx 2.0 Grey Color Scheme',
										'skinblue' => 'Confixx 2.0 Blue Color Scheme',
										'skingreen' => 'Confixx 2.0 Green Color Scheme',
										'skinred' => 'Confixx 2.0 Red Color Scheme',
									);

	&checkSkinVer( 'classic20', \%classic20);

	my %mskins = ( 'mskin_1' => 'Modern Blue Color Scheme',
								 'mskin_2' => 'Modern Green Color Scheme',
								 'mskin_3' => 'Modern Olivegreen Color Scheme',
								 'mskin_4' => 'Modern Red Color Scheme',
								 'mskin_5' => 'Modern Silver Color Scheme'
							 );


	&checkSkinVer( 'powp', \%mskins );

	my $sth = $dbh->prepare( "SELECT a.anbieter FROM anbieter a ".
													 " LEFT JOIN custom_skins c ON a.anbieter = c.anbieter AND c.server_id='$ServerID' ".
													 " WHERE c.id IS NULL AND a.server_id='$ServerID'"
												 );
	if( $sth->execute ){
		while( my($anbieter) = $sth->fetchrow ){

			$dbh->do( "INSERT INTO custom_skins( show_name, owner_type, anbieter, version, server_id )".
							 " VALUES ( $skinname, 'reseller', '$anbieter', 'powp', '$ServerID' )" );

		}
		$sth->finish;
	}

#
# bug #92204 - restore the deleted skin of admin
#
	$sth = $dbh->prepare( "SELECT COUNT(*) FROM skins WHERE cuser='admin' AND server_id='$ServerID'" );
	if( $sth->execute ){
		my( $cnt ) = $sth->fetchrow;
		$sth->finish;
		if( $cnt > 1 ){
			$dbh->do( "DELETE FROM skins WHERE cuser='admin' AND server_id='$ServerID'");
			$cnt = 0;
		}
		unless( $cnt ){
			$dbh->do( "INSERT INTO skins(cuser,skin_id,server_id) VALUES('admin',10,'$ServerID')");
		}
	}
#
# end restore admin skin
#

	if( $dbType eq 'Pg' ){
		$dbh->do ( "UPDATE custom_skins SET path =  '/skins/skin_'||id".
							 " WHERE owner_type = 'reseller' AND version='xp30' AND server_id='$ServerID'" );
		$dbh->do ( "UPDATE custom_skins SET path =  '/skins/mskin_'||id".
							 " WHERE owner_type = 'reseller' AND version='powp' AND server_id='$ServerID'" );

	} else {
		$dbh->do ( "UPDATE custom_skins SET path = CONCAT( '/skins/skin_', id )".
							 " WHERE owner_type = 'reseller' AND version='xp30' AND server_id='$ServerID'" );
		$dbh->do ( "UPDATE custom_skins SET path = CONCAT( '/skins/mskin_', id )".
							 " WHERE owner_type = 'reseller' AND version='powp' AND server_id='$ServerID'" );
	}
}

sub defaultUsers{
	my ( $sth, $username );
	my (  $maxpop, $maxemail, $use_frontpage, $timestamp, $maxcronjobs, 
				$maxidn, $maxmaillist, $scponly,$maxautoresponder );

	if ( $mta eq "noEmail" || $mta eq "" ){
		$maxpop = $maxemail = $maxautoresponder = '0';

	}	else {
		$maxpop = $maxemail = $maxautoresponder = '-1';
	}

	$use_frontpage = ( -x $bin_fpsrvadm ) ? '1' : '0';
	$maxcronjobs = $cronjobs_support ? '-1' : '0';
	$maxidn = ( -x $idn_shell && $idn_vendor ) ? '-1' : '0';
	$maxmaillist = ( -d $majordomo_home && -x $majordomo_wrapper ) ? '-1' : '0';
	$scponly = ( -x $scponly_shell ) ? '1' : '0';
	$timestamp = time;


	my ($index, %admin, %res0, $cnt);

	$sql = "SELECT * FROM admin WHERE server_id='$ServerID'";
	$sth = $dbh->prepare( $sql );
	if( $sth->execute ){
		if( $master_confixx == 2 && ! $sth->rows ){ ## in datacenter there is the sonfixx
			return;
		}
		%admin = %{$sth->fetchrow_hashref()};
	}
	$sth->finish;
	
	$sth = $dbh->prepare ( "SELECT * FROM anbieter WHERE anbieter = 'res0' AND server_id='$ServerID'" );
	$sth->execute;
	if ( $sth->rows == 0 ) {
		$index = &ltext ( "install_default_indexcode", $hostname );


		%res0 = ('anbieter' => 'res0',
						 'number' => 0,
						 'passwort' => '',
						 'longpw' => $admin{'longpw'}||'',
						 'maxkunden' => -1,
						 'maxkundenlimit' => 0,
						 'maxpop' => $maxpop,
						 'maxpoplimit' => 0,
						 'maxkb' => -1,
						 'maxkblimit' => 0,
						 'maxmysql' => $admin{'mysql'}?-1:0,
						 'maxmysqllimit' => 0,
						 'maxemail' => $maxemail,
						 'maxautoresponder' => $maxautoresponder,
						 'maxemaillimit' => 0,
						 'maxautoresponderlimit' => 0,
						 'maxftp' => -1,
						 'maxftplimit' => 0,
						 'maxtransfer' => -1,
						 'maxsubdomains' => -1,
						 'maxsubdomainslimit' => 0,
						 'maxdomains' => -1,
						 'maxdomainslimit' => 0,
						 'maxwildcards' => -1,
						 'php' => 1,
						 'ftp' => 1,
						 'perl' => 1,
						 'ssi' => 1,
						 'cssl' => $admin{'cssl'}?1:0,
						 'shell' => 1,
						 'statistik' => 1,
						 'pwschutz' => 1,
						 'fehlerseiten' => 1,
						 'webftp' => 1,
						 'webmail' => 1,
						 'stdcgi' => 1,
						 'frontpage' => $use_frontpage,
						 'anmeldedatum' => $timestamp,
						 'name' => 'res0',
						 'firma' => '',
						 'anschrift' => '',
						 'plzort' => '',
						 'telefon' => '',
						 'fax' => '',
						 'gender' => '',
						 'firstname' => '',
						 'plz' => '',
						 'land' => '',
						 'emailadresse' => $admin{'emailadresse'}||'',
						 'kundennummer' => '',
						 'freifeldname1' => '',
						 'freifeldwert1' => '',
						 'freifeldname2' => '',
						 'freifeldwert2' => '',
						 'freifeldname3' => '',
						 'freifeldwert3' => '',
						 'personendatenangeben' => 1 ,
						 'kundendatenanzeigen' => 0,
						 'kundendatenbeikundenanzeigen' => 1,
						 'indexcode' => $index,
						 'indexfile' => 'index.html',
						 'hilfecode' => '',
						 'standardip' => $admin{'standardip'},
						 'language' => $admin{'language'},
						 'lastchange' => $timestamp,
						 'httpdspezial' => '',
						 'phpupload' => 1,
						 'dirlist' => 1,
						 'dbext' => 1,
						 'wap' => 1,
						 'coldfusion' => $coldfusion_support,
						 'dns' => $admin{'dns'},
						 'pns' => $admin{'ip_pns'},
						 'sns' => $admin{'ip_sns'},
						 'dnr' => $admin{'dnr'},
						 'maxcronjobs' => $maxcronjobs,
						 'maxcronjobslimit' => 0,
						 'spamfilter' => $spamassassin_support,
						 'maxidn' => $maxidn,
						 'maxidnlimit' => 0,
						 'maxmaillist' => $maxmaillist,
						 'maxmaillistlimit' => 0,
						 'scponly' => $scponly,
						 'maxatdomains' => -1,
						 'modpython' => $admin{'modpython'},
						 'server_id' => $ServerID
						);

		my @keyRes0 = keys %res0;

		$sql = 'INSERT INTO anbieter ('.join(',', @keyRes0).') VALUES('.join(',',map{'?'}@keyRes0).')';
		$sth = $dbh->prepare($sql);

		my @valRes0 = map{$res0{$_}} @keyRes0;
		$sth->execute( @valRes0 );


		$dbh->do ( "INSERT into skins (cuser, skin, server_id) VALUES ( 'res0', 'default', '$ServerID' )")
	} else {
		%res0 = %{$sth->fetchrow_hashref()};
		$sth->finish;
	}

	$username = $user_prefix . '0';
	$sth = $dbh->prepare ( "SELECT COUNT(*) FROM kunden WHERE kunde = " . $dbh->quote($username)." AND server_id='$ServerID'" );
	$sth->execute;
	($cnt) = $sth->fetchrow;	
	$sth->finish;
	unless( $cnt ){

		my (%web0);
		
		%web0 = ('kunde' => $username,
						 'number' => 0,
						 'uid' => 0,
						 'passwort' => '',
						 'longpw' => undef,
						 'anbieter' => undef,
						 'maxpop' => undef,
						 'maxkb' => undef,
						 'maxmysql' => undef,
						 'maxemail' => undef,
						 'maxautoresponder' => undef,
						 'maxftp' => undef,
						 'maxtransfer' => undef,
						 'maxsubdomains' => undef,
						 'php' => undef,
						 'ftp' => undef,
						 'wildcard' => $res0{'maxwildcards'},
						 'perl' => undef,
						 'ssi' => undef,
						 'shell' => undef,
						 'statistik' => undef,
						 'statistikpasswort' => '',
						 'statistiklongpw' => 'xxx',
						 'pwschutz' => undef,
						 'fehlerseiten' => undef,
						 'webftp' => undef,
						 'webmail' => undef,
						 'stdcgi' => undef,
						 'anmeldedatum' => $timestamp,
						 'name' => '',
						 'firma' => undef,
						 'anschrift' => undef,
						 'plzort' => undef,
						 'telefon' => undef,
						 'fax' => undef,
						 'gender' => undef,
						 'firstname' => undef,
						 'plz' => undef,
						 'land' => undef,
						 'emailadresse' => undef,
						 'kundennummer' => undef,
						 'freifeldname1' => undef,
						 'freifeldwert1' => undef,
						 'freifeldname2' => undef,
						 'freifeldwert2' => undef,
						 'freifeldname3' => undef,
						 'freifeldwert3' => undef,
						 'kundendatenanzeigen' => undef,
						 'ip' => $res0{'standardip'},
						 'quota' => 1,
						 'language' => undef,
						 'lastchange' => $timestamp,
						 'phpupload' => undef,
						 'wap' => undef,
						 'coldfusion' => undef,
						 'dirlist' => undef,
						 'httpdspezial' => undef,
						 'maxcronjobs' => undef,
						 'spamfilter' => undef,
						 'maxidn' => undef,
						 'maxmaillist' => undef,
						 'scponly' => undef,
						 'maxatdomains' => undef,
						 'modpython' => undef,
						 'cssl' => undef,
						 'server_id' => undef
						);	

		my ($key,$value);
		my @keyWeb0 = keys %web0;

		foreach $key (@keyWeb0) {
			$value = $web0{$key};
			next if defined($value);
			if ( exists($res0{$key}) ) {
				$web0{$key} = $res0{$key};
			}else{
				print STDERR "Error: key '$key' is not found in 'res0'\n";
			}
		}

		$sql = 'INSERT INTO kunden ('.join(',', @keyWeb0).') VALUES('.join(',',map{'?'}@keyWeb0).')';
		$sth = $dbh->prepare($sql);

		my @valWeb0 = map{ $web0{$_} } @keyWeb0;
		$sth->execute( @valWeb0 );
	}

	my ( $admin, $sql_domain );
	$sql_domain = $dbh->quote( join('.',$username,$admin{'standarddomain'}) );

	$sth = $dbh->prepare ( "SELECT COUNT(*) FROM domains WHERE domain = $sql_domain" );

	$sth->execute;
	($cnt) = $sth->fetchrow;
	$sth->finish;

	$username = $dbh->quote($username);

	if( $cnt ){
		$dbh->do("UPDATE domains SET server_id='$ServerID' WHERE domain = $sql_domain" );

	}else{

		$dbh->do ( "INSERT INTO domains ( domain, kunde, anbieter, richtigedomain, pfad, lastchange, zusatz, server_id )".
							 "	VALUES ( $sql_domain, $username, 'res0', '3', '/', '$timestamp', '', '$ServerID' )" );

		$dbh->do ( "INSERT INTO domainlog ( kunde, neu, domain, loeschen, server_id )".
							 " VALUES ( $username, 1, $sql_domain, 0, '$ServerID' )" );
		
		$dbh->do ( "INSERT INTO frontpagealias ( domain, kunde, anbieter, port, neu, loeschen, server_id )".
							 " VALUES ( $sql_domain, $username, 'res0', 80, 1, 0, '$ServerID' )" );
		
		$dbh->do ( "INSERT INTO frontpagealias ( domain, kunde, anbieter, port, neu, loeschen, server_id )".
							 " VALUES ( $sql_domain, $username, 'res0', 443, 1, 0, '$ServerID' )" );

		$dbh->do ( "INSERT INTO webalizer ( kunde, loeschen, neu, anbieter, server_id )".
							 " VALUES ( $username, 0, 1, 'res0', '$ServerID' )" );
		
		$dbh->do ( "INSERT INTO perl ( kunde, loeschen, neu, anbieter, server_id )".
							 " VALUES ( $username, 0, 1, 'res0', '$ServerID' )" );

		$dbh->do ( "UPDATE allgemein SET adduser=1, httpd=1, httpdupdate=1, quota=1, stdcgi=1,".
							 " perl=1, domains=1,webalizer=1 WHERE server_id='$ServerID'" );
	}
	&unlimited_services;

	$dbh->do( "UPDATE kunden SET httpd=1 WHERE kunde=$username" );

}


sub getBin {
  my ($binary, $nn) = @_;
  unless(defined $nn && $nn == 1){
    $nn = 0;
  }
  my $finished = 0;
  my $weiter = 0;
  my @paths = ("/bin", "/usr/bin", "/usr/sbin", "/sbin", "/usr/local/bin");
  my $path;
  until($finished || $weiter){
     if(-x "$binary"){
      $finished = 1;
      return("$binary");
    }
     foreach $path (@paths){
      if(-x "$path/$binary"){
        $finished = 1;
        return("$path/$binary");
      }
    }
    if(!($finished) && (!($nn))){
      print &ltext('install_bin_manual', $binary);
      my $input = <STDIN>;
      chop($input);
      if ( -x "$input" && $input =~ /$binary$/ ) {
        $finished = 1;
        print &ltext('install_selected', $input);
        return($input);
      }
      else{
        print &ltext('install_bin_name', $input, $binary);
      }
    }
    else{
      $weiter = 1;
    }
  }
  unless($finished){
    return($finished);
  }
}

## //Unterprogramme

