#!/usr/bin/perl

########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####


use IO::Socket;
use URI::Escape;
use DBI;

## VARS
$SN = 'SERIENNUMMER';
$KEY = 'AKTIVIERUNGSKEY';
$EMAIL = 'root'; # besser user@domain.de (fur Fehlermeldungen)
$SENDMAIL = '/usr/sbin/sendmail';
$VERSION = 'Pro'; # required for Confixx v2.x
## // VARS


&loadConfFile;

$dbh = DBI->connect($db_address, $dbUser, $dbPw)
  or die &ltext('db_connect', '#XXX', $DBI::errstr);

&register;

$dbh->disconnect;


## SUBS
sub register {
  my ($sth, @row, $serverid, $request, $header, %server, $sql);

  $sth = $dbh->prepare("SELECT seriennummer, lizenz, ablauf, hwaddr, ip, version FROM register WHERE version = '$VERSION'");
  $sth->execute;
  unless($sth->rows){
    $dbh->do( "INSERT INTO register(version, server_id) VALUES('$VERSION','$ServerID')" );
		print "Please run confixx_counterscript and try again\n";
		$sth->finish;
		exit 0;
	}
						
  @row = $sth->fetchrow_array;
  $sth->finish;

  if($row[3] eq ''){
    die "HWaddr is empty!\nPlease run: $installDir/confixx_counterscript.pl\n";
  }

  if($row[4] eq ''){
    die "IPaddr is empty!\nPlease run: $installDir/confixx_counterscript.pl\n";
  }
  
  $serverid = unpack("H*", "$SN\:-:$row[3]:-:$row[4]:-:");

  if($version < 2){
  
    $request = 'sn=' . uri_escape($SN);
    $request .= '&key=' . uri_escape($KEY);
    $request .= '&serverid=' . uri_escape($serverid);
    $request .= '&auto=1';
    $request .= '&language=' . $language;

    $header = "POST /register2.php HTTP/1.1\r\n";
    $header .= "Host: register.confixx.de\r\n";
    $header .= "Content-type: application/x-www-form-urlencoded\r\n";
    $header .= "Content-length: " . length($request) . "\r\n";
    $header .= "Connection: close\r\n\r\n";

  }
  else{

    $request = 'serial=' . uri_escape($SN);
    $request .= '&serialkey=' . uri_escape($KEY);
    $request .= '&serverid=' . uri_escape($serverid);
    $request .= '&auto=1';
    $request .= '&language=' . $language;
    $request .= '&version=' . $VERSION;

    $header = "POST /v2/register2.php HTTP/1.1\r\n";
    $header .= "Host: register.confixx.de\r\n";
    $header .= "Content-type: application/x-www-form-urlencoded\r\n";
    $header .= "Content-length: " . length($request) . "\r\n";
    $header .= "Connection: close\r\n\r\n";

  }

  $socket = IO::Socket::INET->new(PeerAddr => 'register.confixx.de',
                                  PeerPort => 80,
                                  Proto => 'tcp',
                                  Type => SOCK_STREAM)
   or die "Couldn't connect to register.confixx.de:80 : $@\n";

  if($socket){
    print $socket "$header$request";
    while(<$socket>){
      if($_ =~ /ABLAUF: (\d+)/){
        $server{'ablauf'} = $1;
      }
      if($_ =~ /VERSION: (\S+)/){
        $server{'version'} = $1;
      }
      if($_ =~ /FEHLER:\((\d+)\) (.*)\n/){
        $server{'errorcode'} = $1;
        $server{'errortext'} = $2;
      }
      if($_ =~ /LIZENZ: (\S+)/){
        $server{'lizenz'} = $1;
        $server{'lizenz'} =~ s/-/\n/g;
        $server{'lizenz'} .= "\n";
      }
    }
  }
  close($socket);

  if(defined $server{'errorcode'} && $server{'errorcode'} ne ''){
    print "ERROR $server{errorcode}: $server{errortext}\n";
    &email_error($server{errorcode}, $server{errortext});
    exit 1;
  }
  elsif($server{'ablauf'} eq '' || $server{'lizenz'} eq '' || $server{'version'} eq ''){
    print "ERROR 99: incomplete return values.\n";
    print "Ablauf:\n$server{'ablauf'}\n";
    print "Lizenz:\n$server{'lizenz'}\n";
    print "Version:\n$server{'version'}\n";
    &email_error(99, 'incomplete return values.');
    exit 1;
  }
  else{
    $sql = "UPDATE register SET seriennummer = ?, ablauf = ?, lizenz = ?, version = ? WHERE server_id = ? AND version = ? ";
    $dbh->do($sql, undef, $SN, $server{'ablauf'}, $server{'lizenz'}, $server{'version'},$ServerID,$VERSION);
    print "UPDATE OK\n";
    print "Valid until: " . localtime($server{'ablauf'}) . "\n";
  }

}


sub email_error{
  my ($code, $message) = @_;

  if($EMAIL eq ''){
    print "Variable \$EMAIL is empty!\n";
    exit 1;
  }

  my $hostname = `/bin/hostname -f`;
  chop($hostname);

  open(MAIL, "|$SENDMAIL -t -i");
    print MAIL "From: root\@$hostname\r\n";
    print MAIL "To: $EMAIL\r\n"; 
    print MAIL "Subject: Confixx auto_reg error($code) on host $hostname\r\n\r\n"; 
    print MAIL "$0 failed updating your Confixx Licence Key with the following error message:\r\n";
    print MAIL "$message\r\n\r\n";
  close(MAIL);

}


sub ltext {
  my $text_name = shift;
  if (!%lang_text) {
    my $langFile = "$confixx_htmlDir/languages/$language/scripts.local";
    do $langFile;
  }
  if (!defined($lang_text{$text_name})) {
    return "Sorry, text $text_name not found!";
  }
  else {
    my @VAR = @_;
    my $text = $lang_text{$text_name};
    $text =~ s/\$VAR\[(\d+)\]/$VAR[$1]/g;
    if ($text) {
      return $text;
    }
    else {
      return "Sorry, localizing text $text_name failed!";
    }
  }
}


sub loadConfFile{
  my ($file, $base);
  if(-T "/root/confixx/confixx_main.conf"){
    $file = "/root/confixx/confixx_main.conf";
  }
  else{
   $0 = $^X unless ($^X =~ m%(^|[/\\])(perl)|(perl.exe)$%i);
   ($base) = $0 =~ m%^(.*)[/\\]%;
   $base ||= ".";
   $file = "$base/confixx_main.conf";
   unless(-T $file){
     die("Couldn't find confixx_main.conf");
   }
 }
 do $file;
}
## //SUBS
