#!/usr/bin/perl

########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

BEGIN{
	use FindBin qw($Bin);
	use File::Basename;

  use lib $Bin=~s%(?<=.)/$%%?$Bin:$Bin;
  use lib dirname( $Bin ).'/subs';
  use lib dirname( $Bin ).'/scripts';
  use lib $Bin.'/admin/subs';
}

use Getopt::Long;
use DBI;

use lib_module_common;

use strict;
use vars qw/$DEBUG/;

my @conf_opts = ( 'email|e=s',
									'template|tmpl=s',

									'resellers|r=s',
									'users|u=s',
									'mboxes|m=s',
									'disk|d=s',
									'traffic|t=s',

									'debug|dbg',
									'help|h'
								);
my %args = ();

unless( &GetOptions( \%args, @conf_opts ) ) {
  warn "Error: Errors in the command line found. Use the format described below.\n";
  print STDERR &help_text();
  exit 1;
}

if( exists($args{'help'}) ){
    print &help_text;
    exit 0;
    }

my( $send_to, $sql, $sth, @row );
if( exists( $args{'debug'} ) ){
	$DEBUG = 1;
	delete( $args{'debug'} );
}else{
	$DEBUG = 0;
}

&initConfig();

my $template = $Bin.'/confixx_alert.tmpl';
if( exists( $args{'template'} ) ){
	$template = $args{'template'};
	delete( $args{'template'} );
}

unless( -f $template ){
	die "Template file ($template) is not found\n".&help_text;
}

if( $DEBUG ){
	print "template: $template\n";
}


my $dbh = DBI->connect( $db_address, $dbUser, $dbPw ) or
	die "Error connetion to database: $DBI::errstr\n";

if( exists( $args{'email'} ) ){
	$send_to = $args{'email'};
	delete( $args{'email'} );
}else{
	$sql = "SELECT  p.emailadresse AS p_email, a.emailadresse AS a_email ".
		" FROM admin a LEFT JOIN personalinfo p ".
			" ON ( a.personalinfoid=p.id AND p.server_id=a.server_id )".
				" WHERE a.server_id='$ServerID'";

	if($DEBUG){
		print "sql: $sql\n";
	}

	$sth = $dbh->prepare( $sql );
	if( $sth->execute && $sth->rows ){
		@row = $sth->fetchrow;
		$sth->finish();
		unless( $send_to = shift @row ){
			$send_to = shift @row;
		}
	}
}

unless( $send_to ){
	die "Please, specify e-mail\n".&help_text;
}

if( $DEBUG ){
	print "send to: $send_to\n";
}



my %handlers = ( 'resellers' => \&checkResellers,
								 'users' => \&checkUsers,
								 'mboxes' => \&checkMBoxes,
								 'disk' => \&checkDisk,
								 'traffic' => \&checkTraffic 
							 );
my( %alerts, $ret, $limit );

foreach my $key (keys %args){
	if( exists $handlers{$key} ){

		if( $DEBUG ){
			print "call $key: $args{$key}\n";
		}

		if( ($ret,$limit) = &{$handlers{$key}}( $args{$key} ) ){ ## call handler

			$alerts{$key} = $ret;
			$alerts{'limit_'.$key} = $limit;
			$alerts{'over_'.$key} = $ret - $limit;
			if( $key =~ /disk|traffic/ ){ ## add value for Mb, Gb
				$alerts{$key.'K'} = sprintf( "%.2f", $ret );
				$alerts{$key.'M'} = sprintf( "%.2f", $ret / 1024 );
				$alerts{$key.'G'} = sprintf( "%.2f", $ret / ( 1024 * 1024 ) );
			}
		}
	}else{
		warn "Key: '$key' is not supported\n";
	}
}

if( keys %alerts ){
	my $date = localtime();

	$alerts{'date'} = $date;
	$alerts{'hostname'} = $::hostname;

	unless( &sendNotify( $send_to, \%alerts, $template ) ){
		warn "Notify is not sended";
	}
}

$dbh->disconnect();

#
#
#===================================================
#
#
#

sub sendNotify{
	my( $send_to, $ptrVals, $template ) = @_;

	if( $::DEBUG ){
		print "sendNotify:\n";
		map{ print "$_ -> $ptrVals->{$_}\n" } keys %{$ptrVals};
	}

	unless( open( IN, '<', $template ) ){
		die "Error open template: $!\n";
	}

	if( open( MAIL,"| $::bin_sendmail -t -i -f root") ){
		print MAIL "To: $send_to\n";
	}else{
		close( IN );
		die "Error send mail: $!\n";
	}

	if( $template=~/\.epl$/ ){
		require Parse::ePerl;

		my $script = join( '', <IN> );

		no strict 'refs';
		while( my($key,$val) = each( %{$ptrVals} ) ){
			${$key} = $val;
		}
		use strict 'refs';

		no strict 'vars';
		
		my $out = '';
		my( $error );
		my $rc = Parse::ePerl::Expand( {
																		'Script' => $script,
																		'Result' => \$out,
																		'Error' => \$error,
																		'Name' => 'Template'
																	 } );
		use strict 'vars';

		print MAIL $out;

	}else{
	
		my( $chunk, $state, $out, @ifs, $if_show, @line, $cmd );
		$if_show = 1;
		while( <IN> ){
			chomp;
			
			@line = split( /(?<!\\)({|})/, $_ ) if $_;

			if( ! $_ || @line == 1 ){ ## the is not '{' or '}'
				$out = $_;

			}else{
				$state = 0;
				$out = $if_show? '': undef ; ## out buffer
				while( @line ){
					$chunk = shift @line;
					if( $state == 1 ){
						$cmd = $chunk;
						
						$cmd =~ s/^\s+//; ## all trim
						$cmd =~ s/\s+$//;
						
						$chunk = shift @line;
						
						if( $chunk eq '}' ){ ## OK
							$state = 0;
							
						}else{
							$state = 0;
							warn "Template is bad: $out\{$cmd$chunk".join('',@line);
							last;
						}
				
					
						if( $cmd =~ /if\s+(\$\S+.*)\s*/ ){
							
							push @ifs,[ $1, &runCommand( $1, $ptrVals ) ];
							$if_show = calcIf( \@ifs );
							
						}elsif( $cmd =~ /ifnot\s+(\$\S+.*)\s*/ ){
							push @ifs,[ $1, &runCommand( $1, $ptrVals )? 0: 1 ];
							$if_show = calcIf( \@ifs );
							
						}elsif( $cmd =~ /endif/ ){
							pop @ifs;
							$if_show = calcIf( \@ifs );
							
						}else{
							$out .= &runCommand( $cmd, $ptrVals ) if $if_show;
						}

					}else{
						if( $chunk eq '{' ){
							$state = 1;
							
						}elsif( $state == 0 ){
							if( $if_show ){
								$chunk =~ s/\\({|})/$1/g;
								$out .= $chunk;
							}
							
						}else{
							warn "Template: logic error";
						}
					}
				}
			}
			if( defined( $out ) && ( $out || $if_show ) ){
				print MAIL $out,"\n";
				if( $::DEBUG ){
					print $out,"\n";
				}
			}
		}
	}
	close( MAIL );
	close( IN );

	return 1;
}

sub runCommand{
	my( $cmd,$ptrVar ) = @_;
	my( $ret );
	if( $cmd =~ /^\$([a-z0-9_]+)$/i ){ ## simple case: $key
		return $ptrVar->{$1};

	}else{
		
		no strict 'refs';
		while( my($key,$val) = each( %{$ptrVar} ) ){
			${$key} = $val;
		}
		use strict 'refs';

		no strict 'vars';
		eval "\$ret = $cmd";
		use strict 'vars';

		if( $@ ){
			$ret = undef;
			if( $::DEBUG ){
				warn "error execute '$cmd': $@\n";
			}
		}
	}
	return $ret;
}

sub calcIf{
	my $ptrIfs = shift;
	if( @{$ptrIfs} ){
		foreach my $ptrItem (@{$ptrIfs}){
			return 0 unless $ptrItem->[1];
		}
		return 1;
	}else{
		return 1;
	}
}

sub checkResellers{
	my $arg = shift;
	unless( $arg =~ /^\d+$/ ){
		warn "please, specify a number for maximum of reselles";
		return undef;
	}
	if( $::DEBUG ){
		print "checkResellers: $arg\n";
	}
	my $sql = "SELECT COUNT(*) FROM anbieter WHERE server_id='$ServerID'";
	if( $::DEBUG ){
		print "sql: $sql\n";
	}
	my $sth = $dbh->prepare( $sql );
	my $cnt = 0;
	if( $sth->execute ){
		($cnt) = $sth->fetchrow;
		$sth->finish;
	}

	if( $::DEBUG ){
		print "count: $cnt\n";
	}

	if( $cnt >= $arg ){
		if( wantarray()){
			return $cnt,$arg;
		}else{
			return $cnt;
		}
	}else{
		return undef;
	}
}
sub checkUsers{
	my $arg = shift;
	unless( $arg =~ /^\d+$/ ){
		warn "Please, specify a number for maximum of users ($arg)";
		return undef;
	}
	if( $::DEBUG ){
		print "checkUsers: $arg\n";
	}
	my $sql = "SELECT COUNT(*) FROM kunden WHERE server_id='$ServerID'";
	if( $::DEBUG ){
		print "sql: $sql\n";
	}
	my $sth = $dbh->prepare( $sql );
	my $cnt = 0;
	if( $sth->execute ){
		($cnt) = $sth->fetchrow;
		$sth->finish;
	}

	if( $::DEBUG ){
		print "count: $cnt\n";
	}

	if( $cnt >= $arg ){
		if( wantarray()){
			return $cnt,$arg;
		}else{
			return $cnt;
		}
	}else{
		return undef;
	}
}

sub checkMBoxes{
	my $arg = shift;
	unless( $arg =~ /^\d+$/ ){
		warn "Please, specify a number for maximum of reselles ($arg)";
		return undef;
	}
	if( $::DEBUG ){
		print "checkMBoxes: $arg\n";
	}
	my $sql = "SELECT COUNT(*) FROM pop3 WHERE server_id='$ServerID'";
	if( $::DEBUG ){
		print "sql: $sql\n";
	}
	my $sth = $dbh->prepare( $sql );
	my $cnt = 0;
	if( $sth->execute ){
		($cnt) = $sth->fetchrow;
		$sth->finish;
	}

	if( $::DEBUG ){
		print "count: $cnt\n";
	}

	if( $cnt >= $arg ){
		if( wantarray()){
			return $cnt, $arg;
		}else{
			return $cnt;
		}
	}else{
		return undef;
	}
}

sub checkDisk{
	my $arg = shift;
	if( $arg =~ /^(\d+)(K|M|G)?$/i ){
		my $num = $1;
		my $item = $2;
		if( $item =~ /K/i ){
			
		}elsif( $item =~ /M/i ){
			$arg = $num * 1024;

		}elsif( $item =~ /G/i ){
			$arg = $num * 1024 * 1024;
		}
	}else{
		warn "Please, specify a number for maximum of storage space ($arg)";
		return undef;
	}
	if( $::DEBUG ){
		print "checkDisk: $arg\n";
	}

	
	my $sql = $::append_mail_disk_space? "SELECT SUM(kbhomedir), SUM(kbdb)":
		"SELECT SUM(kbhomedir), SUM(kbdb), SUM(kbpop)";
	$sql .= " FROM kunden WHERE server_id='$ServerID'";
	if( $::DEBUG ){
		print "sql: $sql\n";
	}
	my $sth = $dbh->prepare( $sql );
	my $size = 0;
	if( $sth->execute ){
		if( $sth->rows ){
			my @row = $sth->fetchrow;
			map{ $size += $_ } grep{ $_} @row;
		}
		$sth->finish;
	}
	if( $::DEBUG ){
		print "size: $size\n";
	}
	if( $size >= $arg ){
		if( wantarray()){
			return $size, $arg;
		}else{
			return $size;
		}
	}else{
		return undef;
	}

}
sub checkTraffic{
	my $arg = shift;
	if( $arg =~ /^(\d+)(K|M|G)?$/i ){
		my $num = $1;
		my $item = $2;
		if( $item =~ /K/i ){
			
		}elsif( $item =~ /M/i ){
			$arg = $num * 1024;

		}elsif( $item =~ /G/i ){
			$arg = $num * 1024 * 1024;
		}
	}else{
		warn "Please, specify a number for maximum of traffik ($arg)";
		return undef;
	}

	if( $::DEBUG ){
		print "checkTraffic: $arg\n";
	}

	my($mday,$mon,$year) = (localtime())[3,4,5];
	$year += 1900;
	$mon++;
	my $cur_day = ( $year * 100 + $mon) * 100 + $mday;
	my $sql = "SELECT MAX( ( jahr * 100 + monat ) * 100 + tag ) FROM transfer ".
		" WHERE (jahr * 100 + monat ) * 100 + tag < $cur_day AND server_id='$ServerID'";

	if( $::DEBUG ){
		print "sql: $sql\n";
	}

	my $sth = $dbh->prepare( $sql );
	if( $sth->execute ){
		if( $sth->rows ){
			my($max_day) = $sth->fetchrow;
			($year,$mon,$mday) = unpack( 'A4A2A2', $max_day ) if $max_day;
		}
		$sth->finish;
	}
	my $traffic = 0;
	$sql = "SELECT SUM(ftp), SUM(web), SUM(email), SUM(pop), SUM(other) ".
		" FROM transfer WHERE server_id='$ServerID' ".
			" AND jahr=$year AND monat=$mon AND tag=$mday";
	if( $::DEBUG ){
		print "sql: $sql\n";
	}

	$sth = $dbh->prepare( $sql );
	if( $sth->execute ){
		if( $sth->rows ){
			my @row = $sth->fetchrow;
			map{ $traffic += $_ } grep{ $_ } @row;
		}
		$sth->finish;
	}

	if( $::DEBUG ){
		print "traffic: $traffic\n";
	}

	if( $traffic >= $arg ){
		if( wantarray()){
			return $traffic,$arg;
		}else{
			return $traffic;
		}
	}else{
		return undef;
	}

}


sub help_text{
	return <<HELP;

Send resorce notfocations

Usage:
	confixx_alert.pl [argumrts]

Arguments:
       --email    |-e=['send to'-email] default: admin email
       --template |-tmpl=[temlate file]  default: confixx_alert.tmpl

       --resellers|-r=[number of resellers]
       --users    |-u=[number of users]
       --mboxes   |-m=[number of mailboxes]
       --disk     |-d=[storage space in Kb] can use suffixes M, G. example: 100M
       --traffic  |-t=[traffic in Kb] see above

       --debug    |-dbg
       --help     |-h

HELP


}
