package Confixx::Session;

BEGIN{
	no utf8;

	use FindBin;
	use File::Basename;

	use lib $FindBin::Bin=~s%(?<=.)/$%%?$FindBin::Bin:$FindBin::Bin;
	use lib dirname( $FindBin::Bin ); # = $installDir 
}

use DBI;
use Digest::MD5;
use Data::Dumper;
use Data::Serializer;
use SOAP::Lite;
use MIME::Base64;

use lib_module_db;

use strict;

use vars qw/@ISA @EXPORT/;

@ISA = qw(Exporter);

@EXPORT = qw( &loadSession &saveSession &checkRights &getConfig );

my $ptrConfig = &loadConfig();
&loadConfig( 'master.inc.php', $ptrConfig );

my $serializer = Data::Serializer->new( 'serializer' => 'Data::Dumper',
																				'portable'   => '1',
                                        'compress'   => '0',
																				'encoding' => 'b64'
																			);
my $dbh;
my $session;

my @roles = ( ['admin', $ptrConfig->{'masterServerID'}, 'MASTER','login' ],
							['admin', $ptrConfig->{'ServerID'}, 'ADMIN','login' ],
							['anbieter', $ptrConfig->{'ServerID'}, 'RESELLER','anbieter'],
							['kunden', $ptrConfig->{'ServerID'}, 'USER','kunde']
						);
#=============================================================
#
# SOAP methods

sub login {
	my( $this, $login, $passwd ) = @_;
	
	unless( ref($ptrConfig) =~ /HASH/ ){
		die SOAP::Fault->faultcode('Server.Config')
			->faultstring( "Error: config is not found" );
	}	

	unless( $dbh ){
		$dbh = DBI->connect( $ptrConfig->{'dsn_local'},
												 $ptrConfig->{'db_user'},
												 $ptrConfig->{'db_pass'}
											 ) or
												 die SOAP::Fault->faultcode('DBI.Connect')
													 ->faultstring("Error: can't connect to DB: $DBI::errstr");
	}

	my($pw,$table,$role,$ok,$sth, $ptrRow,$server_id, $role_in, $field);
	
	foreach $ptrRow ( @roles ){ ## loop by roles

		($table, $server_id, $role_in, $field ) = @{$ptrRow};

		$sth = $dbh->prepare( "SELECT longpw FROM $table WHERE $field = ? AND server_id= ?" );
		$sth->execute( $login, $server_id ) or
			next;

		if( $sth->rows() ){
			($pw) = $sth->fetchrow();
		}else{
			$pw = undef;
		}
		$sth->finish();

		next unless defined $pw;

		$role = $role_in;

		if( crypt( $passwd, $pw ) eq $pw ){ ## check password
			$ok = 1;
			last;
		}else{

#
# my be password of reseller/admin/master
#
			my ( $login_in, $role_out );
			my %sqls = ( 'USER'=> "SELECT k.anbieter, a.longpw FROM kunden k, anbieter a ".
									 " WHERE k.kunde='$login' AND k.server_id='$server_id' ".
									 " AND k.anbieter=a.anbieter AND a.server_id=k.server_id",
									 'RESELLER' => "SELECT login, longpw FROM admin ".
									 " WHERE server_id='$server_id'",
									 
									 'ADMIN' => "SELECT login, longpw FROM admin ".
									 " WHERE server_id='".$ptrConfig->{'masterServerID'}."'" );

			my @next_roles = qw/RESELLER ADMIN/;

			foreach $role_out ( qw/USER RESELLER ADMIN/ ){
				next unless  $role_in eq $role_out;
				
				$sth = $dbh->prepare( $sqls{$role_out} );

				next unless $sth->execute();

				if( $sth->rows ){
					($login_in, $pw ) = $sth->fetchrow;
				}else{
					$login_in = undef;
				}
				$sth->finish;

				if( $login_in ){
					if( crypt( $passwd, $pw ) eq $pw ){ ## check password
						$ok = 1;
						last;
					}else{
						$role_in = shift @next_roles;
					}
				}
			}

			last if $ok;
		}
	}

	unless( $role && $ok ){

		if( $role ){
			die SOAP::Fault->faultcode( 'Auth.Password ')
				->faultstring( "Error: bad password for login '$login'" );

		}else{
			die SOAP::Fault->faultcode( 'Auth.Login' )
				->faultstring( "Error: login '$login' is not found" );
		}
	}

	my $md5 = Digest::MD5->new();

	$md5->add( $login )->add( $passwd )->add( time() );

	my $session_id = $md5->hexdigest();

	$session = { 'role' => $role,
							 'session_id' => $session_id,
							 'login' => $login
							};

	&saveSession( $session_id );

	return $session_id;
}

sub logout {
	my( $this,$session_id ) = @_;
	unless( ref($ptrConfig) =~ /HASH/ ){
		die SOAP::Fault->faultcode('Server.Config')
			->faultstring( "Error: config is not found" );
	}	
	return &cleanSession( $session_id );
}

sub save_to_session {
	my ($this,$session_id,%vars) = @_;

	unless( &loadSession($session_id) ){
		die SOAP::Fault->fualtcode('Session.Id')
			->faultstring("Error: session id '$session_id' is not found");
	}

	foreach my $key (keys %vars){
		$session->{$key} = $vars{$key};
	}
	&saveSession( $session_id );
}

sub remove_from_session {
	my ($this,$session_id, @keys ) = @_;
	unless( &loadSession($session_id) ){
		die SOAP::Fault->faultcode('Session.Id')
			->faultstring("Error: session id '$session_id' is not found");
	}

	map{ delete $session->{$_}} grep{ exists $session->{$_} } @keys;
	&saveSession( $session_id );
	
}

sub get_session {
	my($this,$session_id,@keys)= @_;

	unless( &loadSession($session_id) ){
		die SOAP::Fault->faultcode('Session.Id')
			->faultstring("Error: session id '$session_id' is not found");
	}

	my(@ret);
	if( @keys ){
		@ret = map{ $session->{$_}} grep { ! ref{$_} }@keys;
	}else{
		@ret =	map{ SOAP::Data->name($_)->value( $session->{$_} ) } keys %{$session};
	}
	return @ret;
}

sub get_config{
	my($this,$session_id,@keys)= @_;
	unless( &loadSession( $session_id ) ){
		die SOAP::Fault->faultcode( 'Session.Id' )
			->faultstring("Error: session id '$session_id' is not found");
	}
	unless( $session->{'role'} =~ /^(ADMIN|MASTER)$/  ){
		die SOAP::Fault->faultcode( 'Session.Role' )
			->faultstring("Error: only admin can get config\n");
	}

	my(@ret);
	if( @keys ){
		@ret = map{ $ptrConfig->{$_}} grep{ ! ref(@_) } @keys;
	}else{
		@ret =	map{ SOAP::Data->name($_)->value( $ptrConfig->{$_} ) } keys %{$ptrConfig};
	}
	if( wantarray() || @ret != 1 ){
		return @ret;
	}else{
		return shift @ret;
	}
	
}
#this actually returns 0 or 1 if there any of dc license if available 3adddc or 3dc
#if no one found 0 returned
sub get_licence{
	my( $this, $session_id, @keys ) = @_;
	unless( &loadSession( $session_id ) ){
		die SOAP::Fault->faultcode( 'Session.Id' )
			->faultstring("Error: session id '$session_id' is not found");
	}
	unless( $session->{'role'} =~ /^(ADMIN|MASTER)$/  ){
		die SOAP::Fault->faultcode( 'Session.Role' )
			->faultstring("Error: only admin can get config\n");
	}

	unless( $dbh ){
		$dbh = DBI->connect( $ptrConfig->{'dsn_local'},
												 $ptrConfig->{'db_user'},
												 $ptrConfig->{'db_pass'}
											 ) or
												 die SOAP::Fault->faultcode('DBI.Connect')
													 ->faultstring("Error: can't connect to DB: $DBI::errstr");
	}
	
	my( $version,$hinweis,$ablauf );
	my $sth = $dbh->prepare("SELECT version,hinweis,ablauf FROM register ".
													" WHERE server_id='".$ptrConfig->{'ServerID'}."'" );
	if( $sth->execute ){
		while(( $version,$hinweis,$ablauf ) = $sth->fetchrow){
			if ($version =~ /dc/){
				$sth->finish;
				return 1;
			}
		}
		$sth->finish;
	}else{
		die SOAP::Fault->faultcode( 'DBI.Execute' )
			->faultstring( "$DBI::errstr\n");
	}
	return 0;
}

sub check_rights{
	my($this, $session_id, $object )= @_;

	unless( &loadSession( $session_id ) ){
		die SOAP::Fault->faultcode('Session.Id')
			->faultstring("Error: session id '$session_id' is not found");
	}

	&checkRights( $session, $object )

}

#
#
#=================================================================
#
#

sub new {
	my $class = shift;
	my $this = {};
	bless( $this, $class);
	return $this;
}

sub loadConfig {
	my $file_name = shift || 'settings.inc.php';
	my $retHash = shift;

#	print "Session::loadConfig : $file_name\n";

	if( -f $file_name ){
		$retHash = &parseConfig( $file_name, $retHash );

	}else{
		my $path = $FindBin::Bin;
		$path =~ s/\/[^\/]+\/\.\.//;
		my @path = grep{$_} split( /\//, $path );
		unshift @path,''; ## add first /
		my( $conf );

		while( @path ){

			$conf = join( '/', @path, $file_name);
#			print "Session::loadConfig : $conf\n";

			if( -f $conf ){
				pop @path;
				my $conf1 = join( '/', @path, $file_name );
				if( -f $conf1 ){
					$conf = $conf1;
				}

				$retHash = &parseConfig( $conf, $retHash );
				
				last;
			}else{
				pop @path;
			}
		}
	}
	return $retHash;
}


sub parseConfig{

	my( $file, $retConf ) = @_;

	return undef unless( -f $file );

	my($key,$value);

	unless( ref($retConf) =~ /HASH/ ){
		$retConf = {};
	}

#	print "Session::parseConfig : $file\n";

	if( open( CONF,'<', $file ) ){
		while(<CONF>){
			if( /^\s*\$(\S+)\s*=\s*(.+);/ ){
				$key = $1;
				$value = $2;
				$value =~ s/^('|")(.*)\1/$2/;
				$retConf->{$key} = $value;
			}
		}
		close(CONF);
		if( $file =~ /\/settings\.inc\.php$/ ){
			my $dsn = &makeDSN( $retConf->{'db_type'},
													$retConf->{'db_host'},
													$retConf->{'db_db'},
													$retConf->{'db_port'},
												);
			$retConf->{'dsn_local'} = $dsn;
		}
	}else{
		die SOAP::Fault->faultcode('System.File')
			->faultstring( "Error: can't open config file '$file': $!" );
	}
	return $retConf;
}

sub loadSession {
	my $session_id = shift;
	unless( ref($ptrConfig) =~ /HASH/ ){
		die SOAP::Fault->faultcode('Server.Config')
			->faultstring( "Error: config is not found" );
	}	
	unless( $dbh ){
		$dbh = DBI->connect( $ptrConfig->{'dsn_local'}, 
												 $ptrConfig->{'db_user'}, 
												 $ptrConfig->{'db_pass'}
											 ) or
												 die SOAP::Fault->faultcode('DBI.Connect')
													 ->faultstring("Error: can't connect to DB: $DBI::errstr");
	}
	$session_id =~ s/[^a-zA-Z0-9]//;
	my $sth = $dbh->prepare( "SELECT sdata FROM sessions WHERE id='$session_id'" );

	$sth->execute() or
		die SOAP::Fault->faultcode( 'MySQL.Execute' )
			->faultstring( "Error: sql query error: $DBI::errstr" );
	
	my ($serData) = $sth->fetchrow();
	$sth->finish();
	
	if( $serData ){
		$session = $serializer->deserialize( $serData );
		$dbh->do( "UPDATE sessions SET lastupdate=".time().
							" WHERE id='$session_id'") or
								die SOAP::Fault->faultcode( 'DBI.Do')
									->faultstring( "Error: sql quere error: $DBI::errstr" );

		return $session;
	} else {
		return undef;
	}
}

sub saveSession {
	my ($session_id) = @_;
	unless( ref($ptrConfig) =~ /HASH/ ){
		die SOAP::Fault->faultcode('Server.Config')
			->faultstring( "Error: config is not found" );
	}	
	unless( $dbh ){
		$dbh = DBI->connect( $ptrConfig->{'dsn_local'}, 
												 $ptrConfig->{'db_user'}, 
												 $ptrConfig->{'db_pass'}
											 ) or
												 die SOAP::Fault->faultcode('DBI.Connect')
													 ->faultstring("Error: can't connect to DB: $DBI::errstr");
	}
	my($cnt);
	my $serData = $serializer->serialize( $session );
	$session_id =~ s/[^a-zA-Z0-9]//;
	my $sth = $dbh->prepare("SELECT COUNT(*) FROM sessions WHERE id='$session_id'");
	if( $sth->execute ){
		($cnt) = $sth->fetchrow();
		$sth->finish();
		if( $cnt > 1 ){
			$dbh->do("DELETE FROM sessions WHERE id='$session_id'");
			$cnt = 0;
		}
	}
	$serData = $dbh->quote( $serData );
	my $now = time();
	my $server_id = $ptrConfig->{'ServerID'};
	if( $cnt == 1 ){
		$dbh->do( "UPDATE sessions SET sdata=$serData,lastupdate=$now,server_id='$server_id'".
							" WHERE id='$session_id'" );
	}else{
		$dbh->do("INSERT INTO sessions(id,sdata,lastupdate,startdate,server_id)".
						 " VALUES('$session_id',$serData,$now,$now,'$server_id')" );
	}

}

sub cleanSession{
	my ($session_id) = @_;
	unless( ref($ptrConfig) =~ /HASH/ ){
		die SOAP::Fault->faultcode('Server.Config')
			->faultstring( "Error: config is not found" );
	}	
	unless( $dbh ){
		$dbh = DBI->connect( $ptrConfig->{'dsn_local'},
												 $ptrConfig->{'db_user'},
												 $ptrConfig->{'db_pass'}
											 ) or
												 die SOAP::Fault->faultcode('DBI.Connect')
													 ->faultstring("Error: can't connect to DB: $DBI::errstr");
	}

	$session_id =~ s/[^a-zA-Z0-9]//;

	$dbh->do( "DELETE FROM sessions WHERE id='$session_id'" ) or
		die SOAP::Fault->faultcode('DBI.Do')
			->faultstring("Error: sql error: $DBI::errstr");

	my $limit = time() - 1800;
	my $server_id = $ptrConfig->{'ServerID'};

	$dbh->do( "DELETE FROM sessions WHERE lastupdate < $limit AND server_id='$server_id'" ) or
		die SOAP::Fault->faultcode('DBI.Do')
			->faultstring("Error: sql error: $DBI::errstr");

	return 1;
}

sub getDbh{
	unless( $dbh ){
		$dbh = DBI->connect( $ptrConfig->{'dsn_local'},
												 $ptrConfig->{'db_user'},
												 $ptrConfig->{'db_pass'}
											 ) or
												 die SOAP::Fault->faultcode('DBI.Connect')
													 ->faultstring("Error: can't connect to DB: $DBI::errstr");
	}
	return $dbh;
}

sub getConfig{
	if( @_ ){
		if( @_ == 1){ ## single key
			my $key = shift;
			return $ptrConfig->{$key};

		}else{
			if( wantarray() ){ ## array
				my @ret = map { $ptrConfig->{$_} } @_;
				return @ret;

			}else{ ## pointer to hash
				my %ret = map { $_ => $ptrConfig->{$_} } @_;
				return \%ret;
			}
		}
	}else{
		return $ptrConfig;
	}
}

sub getSession{
	if( @_ ){
		my @ret = map { $session->{$_} } @_;
		if( wantarray() ){
			return @ret;
		}else{
			return shift @ret;
		}
	}else{
		return $session;
	}
}

sub checkRights {
	my( $session, $object ) = @_;

	if( $session->{'role'} =~ /^(ADMIN|MASTER)$/  ){ ## admin's access
		return $session->{'role'};
	}
	
	if( $session->{'login'} eq $object ){ ## can do myself
		return $session->{'role'};
	}

	my $user_prefix = &getConfig('user_prefix');
	unless( $object =~ /^(\Q$user_prefix\E\d+)/ ){
		die SOAP::Fault->faultcode('Session.Rights')
			->faultstring("Error: bad user_prefix: '$object'");
	}
	my $user = $1;

	if( $session->{'role'} eq 'RESELLER' ){
		unless( $dbh ){
			$dbh = DBI->connect( $ptrConfig->{'dsn_local'},
													 $ptrConfig->{'db_user'},
													 $ptrConfig->{'db_pass'}
												 ) or
													 die SOAP::Fault->faultcode('DBI.Connect')
														 ->faultstring("Error: can't connect to DB: $DBI::errstr");
		}
		my $sth = $dbh->prepare( "SELECT COUNT(kunde) FROM kunden ".
														" WHERE anbieter=? AND kunde=?");
		if( $sth->execute( $session->{'login'}, $object ) ){
			my( $cnt ) = $sth->fetchrow;
			$sth->finish;
			if( $cnt ){
				return $session->{'role'};
			}
		}else{
			die SOAP::Fault->faultcode('Session.DB.Execute')
				->faultstring("Error: sql query error: $DBI::errstr" );
		}
	}

	if( $session->{'role'} eq 'USER' ){
		my $login = $session->{'login'};
		if( $object =~ /^\Q$login\E/ ){
			return $session->{'role'};
		}
	}

	die SOAP::Fault->faultcode('Session.Rights')
		->faultstring("Error: ".$session->{'login'}." is not owner of $object" );
}

END {
	if( $dbh ){
		$dbh->disconnect();
		$dbh = undef;
	}
}

1;
