package Confixx::UsersMySQL;

BEGIN{
	use FindBin;
	use File::Basename;

	use lib $FindBin::Bin=~s%(?<=.)/$%%?$FindBin::Bin:$FindBin::Bin;
	use lib dirname( $FindBin::Bin );
}

use SOAP::Lite;

use lib_module_db;

use Confixx::Session;
use Confixx::MySQL;

use strict;

my ( $userDbh );

my( @userPriv, @dbPriv );

my @PrivY = qw/ Select_priv
								Insert_priv
								Update_priv
								Delete_priv
								Create_priv
								Drop_priv
								Grant_priv
								Alter_priv
								Create_tmp_table_priv
								Lock_tables_priv
								/;

#===================================================
#
# SOAP methods

sub unlock_user{
	my( $this, $session_id, $user, $lock ) = @_;
	unless( $lock =~ /N|0/i  ){
		$lock = 'Y';
	}
	return $this->lock_user( $session_id, $user, $lock );
}

sub lock_user {
	my( $this, $session_id, $user, $lock ) = @_;

	my( $ptrSession );

	unless( $ptrSession = &loadSession( $session_id ) ){
		die SOAP::Fault->faultcode( 'Server.Session' )
				->faultstring( "Error: session '$session_id' is not found" );		
	}

	&checkRights( $ptrSession, $user );

	&getUserDbh();

	unless( @userPriv && @dbPriv ){
		&getPermissions() or
			die SOAP::Fault->faultcode('Mysql.Permissions')
				->faultstring( "Error: List of permissions is empty" );
	}
	
	my( $dbSql, $userSql, $ret );

	$userSql = "UPDATE user SET ".join(',',map{ "$_='N'" } @userPriv );
	$userSql .= " WHERE user=?";

	if( $lock =~ /Y|1/i ){
		my %privY = map{ $_ => 1 } @PrivY;
		$dbSql = "UPDATE db SET ".join(',',map{ "$_='".($privY{$_}?"Y'":"N'") } @dbPriv );
		$ret = 'Y';

	}else{
		$dbSql = "UPDATE db SET ".join(',',map{ "$_='N'" } @dbPriv );
		$ret = 'N';
	}

	$dbSql .= " WHERE user=?";

	$userDbh->do( $userSql, undef, $user ) or
		die SOAP::Fault->faultcode('DBI.Do')
			->faultstring("Error: can't change privileges of '$user': $DBI::errstr");

	$userDbh->do( $dbSql, undef, $user ) or
		die SOAP::Fault->faultcode( 'DBI.Do' )
			->faultstring("Error: can't change privileges of '$user': $DBI::errstr");

	$userDbh->do( "FLUSH PRIVILEGES" ) or
		die SOAP::Fault->faultcode( 'DBI.Do' )
			->faultstring("Error: can't change privileges of '$user': $DBI::errstr");

	return $ret;
}

sub create {
	my $this = shift;
	my $som = pop; ## last item
	my $ref = ref( $som );

	my( $session_id, $db_name, $db_user, $db_paswd, $ptrSession );

	if( $ref =~ /SOAP::SOM/  ) {
		$session_id = $som->valueof( '//create/session_id' );
		unless( $session_id ){
			die SOAP::Fault->faultcode( 'Server.Parameter' )
				->faultstring( "Error: Parameter 'session_id' is not set" );		
		}
	}else{
		($session_id,$db_name,$db_user, $db_paswd) = ( @_, $som );
	}

	unless( $ptrSession = &loadSession( $session_id ) ){
		die SOAP::Fault->faultcode( 'Server.Session' )
				->faultstring( "Error: session '$session_id' is not found" );		
	}
	
	&checkRights( $ptrSession, $db_user );

	&getUserDbh();

	unless( $db_paswd ){
		$db_paswd = &makeRandomPass( 8 );
	}

	my $userAdded = &checkDbUser( $db_user, $db_paswd );

	&checkDbName( $db_name, $db_user );

	$userDbh->do( "CREATE DATABASE $db_name" );

	$userDbh->do( "FLUSH PRIVILEGES" ) or
		die SOAP::Fault->faultcode( 'DBI.Do' )
			->faultstring("Error: can't change privileges of '$db_user': $DBI::errstr");

	if( $userAdded ){
		return $db_name, $db_user, $db_paswd;
	} else {
		return $db_name;
	}
}

sub drop {
	my $this = shift;
	my $som = pop; ## last item
	my $ref = ref($som);

	my( $session_id, $db_name, $db_user, $db_paswd, $ptrSession, $sth, $db );
	if( $ref =~ /SOAP::SOM/  ) {
		$session_id = $som->valueof( '//check_connect/session_id' );
		unless( $session_id ){
			die SOAP::Fault->faultcode( 'Server.Parameter' )
				->faultstring( "Error: Parameter 'session_id' is not set" );		
		}
	}else{
		($session_id,$db_name,$db_user ) = ( @_, $som );
	}

	unless( $ptrSession = &loadSession( $session_id ) ){
		die SOAP::Fault->faultcode( 'Server.Session' )
				->faultstring( "Error: session '$session_id' is not found" );		
	}

	&checkRights( $ptrSession, $db_user );

	&getUserDbh();

	my $qd = qr/^usr_\Q$db_user\E_\d+$/;

	unless( $db_name =~ /$qd/ || $db_name eq 'all' ){
		die SOAP::Fault->faultcode('UsersMySQL.DbName')
			->faultstring("Error: wrong name of user's database: '$db_name'");
	}

	my $dbName = $db_name;
	$dbName =~ s/_/\\_/g;

	if( $db_name eq 'all' ){
		$sth = $userDbh->prepare("SELECT DISTINCT db FROM db WHERE user=?");
		if( $sth->execute( $db_user ) ){
			while( ($dbName) = $sth->fetchrow ){

				$db = $dbName;
				$db =~ s/\\_/_/g;

				next unless $db =~ /$qd/; ## check name of database

				$userDbh->do( "DELETE FROM db WHERE db=?", undef, $dbName );
				$userDbh->do( "DROP DATABASE $db" );
	
			}
			$sth->finish();
		}
	}else{
		$userDbh->do( "DELETE FROM db WHERE db=?", undef, $dbName );
		$userDbh->do( "DROP DATABASE $db_name" );
	}

	$sth = $userDbh->prepare("SELECT COUNT(user) FROM db WHERE user=?");
	if( $sth->execute( $db_user ) ){
		my( $cnt ) = $sth->fetchrow;
		$sth->finish;
		unless( $cnt ){
			$userDbh->do( "DELETE FROM user WHERE user=?", undef, $db_user );
		}
	}

	$userDbh->do( "FLUSH PRIVILEGES" ) or
		die SOAP::Fault->faultcode( 'DBI.Do' )
			->faultstring("Error: can't change privileges of '$db_user': $DBI::errstr");

	return $db_name;
}

sub passwd {
	my $this = shift;
	my $som = pop; ## last item
	my $ref = ref($som);

	my ( $session_id, $db_user, $db_paswd, $ptrSession );

	if( $ref =~ /SOAP::SOM/  ) {
		$session_id = $som->valueof( '//check_connect/session_id' );
		unless( $session_id ){
			die SOAP::Fault->faultcode( 'Server.Parameter' )
				->faultstring( "Error: Parameter 'session_id' is not set" );		
		}
	}else{
		( $session_id, $db_user, $db_paswd ) = ( @_, $som );
	}

	unless( $ptrSession = &loadSession( $session_id ) ){
		die SOAP::Fault->faultcode( 'Server.Session' )
				->faultstring( "Error: session '$session_id' is not found" );		
	}

	&checkRights( $ptrSession, $db_user );

	&getUserDbh();
	unless( $db_paswd ){
		$db_paswd = &makeRandomPass( 8 );
	}

	$userDbh->do( "UPDATE user SET password=PASSWORD(?) WHERE user=?", undef,
								$db_paswd, $db_user ) or
									die SOAP::Fault->faultcode( 'DBI.Do' )
										->faultstring("Error: can't change password of '$db_user': $DBI::errstr");

	$userDbh->do( "FLUSH PRIVILEGES" ) or
		die SOAP::Fault->faultcode( 'DBI.Do' )
			->faultstring("Error: can't change privileges of '$db_user': $DBI::errstr");

	return $db_paswd;

}

sub access {
	my $this = shift;
	my $som = pop; ## last item
	my $ref = ref($som);

	my ( $session_id, $db_user, $db_name, $type, $ptrSession );

	if( $ref =~ /SOAP::SOM/  ) {
		$session_id = $som->valueof( '//check_connect/session_id' );
		unless( $session_id ){
			die SOAP::Fault->faultcode( 'Server.Parameter' )
				->faultstring( "Error: Parameter 'session_id' is not set" );		
		}
	}else{
		( $session_id, $type, $db_user, $db_name ) = ( @_, $som );
	}

	unless( $ptrSession = &loadSession( $session_id ) ){
		die SOAP::Fault->faultcode( 'Server.Session' )
				->faultstring( "Error: session '$session_id' is not found" );		
	}

	&checkRights( $ptrSession, $db_user );

	unless( $ptrSession->{'role'} =~ /MASTER|ADMIN|RESELLER/ ){
		die SOAP::Fault->faultcode( 'UsersMySQL.Rights' )
				->faultstring( "Error: ".$ptrSession->{'login'}." can't change access to user's database" );		
	}

	&getUserDbh();

#=====================================
#
#   database

	my $dbName = $db_name;
	$dbName =~ s/_/\\_/g;

	my $srcHost = $type=~/ext/i? '%': '127.0.0.1';

	my $sth = $userDbh->prepare("SELECT COUNT(host) FROM db WHERE user=? AND db=? ".
															" AND host IN ('127.0.0.1','%')");
	$sth->execute( $db_user, $dbName ) or
		die SOAP::Fault->faultcode( 'DBI.Execute' )
			->faultstring("Error: sql query error: $DBI::errstr");

	my $cnt = $sth->rows;
	$sth->finish;
	if( $cnt == 0 ){
		&addDb( $dbName, $db_user, $srcHost );

	}elsif( $cnt == 1){
		$userDbh->do( "UPDATE db SET host=? WHERE db=? AND user=? ".
									" AND host IN ('127.0.0.1','%')", undef,
									$srcHost, $dbName, $db_user );

	}else{
		$userDbh->do( "DELETE FROM db WHERE host IN ('127.0.0.1','%')".
									" AND db=? AND user=?", undef,
									$dbName, $db_user
								);
		
		&addDb( $dbName, $db_user, $srcHost );
			
	}

# database
#
#---------------------------------------------------------
#
# user

#
# check if need external access
#
	$sth = $userDbh->prepare( "SELECT COUNT(host) FROM db WHERE user=? ".
														" AND host = '%'");
	$sth->execute( $db_user ) or
		die SOAP::Fault->faultcode( 'DBI.Execute' )
			->faultstring("Error: sql query error: $DBI::errstr");

	($cnt) = $sth->fetchrow;
	$sth->finish;

	my $userHost = $cnt? '%': '127.0.0.1';

	$sth = $userDbh->prepare( "SELECT COUNT(host) FROM user WHERE user=? ".
															 " AND host IN ('127.0.0.1','%')" );
	$sth->execute( $db_user ) or
		die SOAP::Fault->faultcode( 'DBI.Execute' )
			->faultstring("Error: sql query error: $DBI::errstr");

	$cnt = $sth->rows;
	$sth->finish;

	if( $cnt == 0 ){
		&addDbUser( $db_user, $userHost );

	}elsif( $cnt == 1){
		$userDbh->do( "UPDATE user SET host=? WHERE user=? ".
									" AND host IN ('127.0.0.1','%')", undef,
									$userHost, $db_user );

	}else{
		$userDbh->do( "DELETE FROM user WHERE host IN ('127.0.0.1','%')".
									" AND user=?", undef,
									$db_user
								);
		
		&addDbUser( $db_user, $userHost );
			
	}

#  user
#
#----------------------------------------------------
	

	$userDbh->do( "FLUSH PRIVILEGES" ) or
		die SOAP::Fault->faultcode( 'DBI.Do' )
			->faultstring("Error: can't change privileges of '$db_user': $DBI::errstr");

	return $srcHost;


}


# end SOAP methods
#
#========================================================

sub new {
	my $class = shift;
	my $this = {};
	bless( $this, $class);
	return $this;
}

sub getUserDbh {
	unless( $userDbh ){

		my $ptrConf = Confixx::Session::getConfig( qw/ mysql_user_host mysql_user_port
																									 mysql_user_user mysql_user_pass/ );
		my $dsn = &makeDSN( 'mysql',
												$ptrConf->{'mysql_user_host'},
												'mysql',
												$ptrConf->{'mysql_user_port'}
											);
		
		$userDbh = DBI->connect( $dsn,
														 $ptrConf->{'mysql_user_user'},
														 $ptrConf->{'mysql_user_pass'}
													 ) or
														 die SOAP::Fault->faultcode('DBI.Connect')
															 ->faultstring("Error: can't connect to user DB: $DBI::errstr");
	}

	return $userDbh;
}

sub getPermissions{

	&getUserDbh();

	my $sth = $userDbh->prepare( "SHOW FIELDS FROM user" );
	$sth->execute() or
		die SOAP::Fault->faultcode('DBI.Execute')
			->faultstring("Error: can't get fields info about 'mysql.user': $DBI::errstr");
	my($row);
	@userPriv = ();
	while( $row = $sth->fetchrow_hashref ){
		if( $row->{'Field'} =~ /_priv$/ ){
			push @userPriv, $row->{'Field'};
		}
	}
	$sth->finish;

	$sth = $userDbh->prepare( "SHOW FIELDS FROM db" );
	$sth->execute() or
		die SOAP::Fault->faultcode('DBI.Execute')
			->faultstring("Error: can't get fields info about 'mysql.db'");
	
	@dbPriv = ();
	while( $row = $sth->fetchrow_hashref ){
		if( $row->{'Field'} =~ /_priv$/ ){
			push @dbPriv, $row->{'Field'};
		}
	}
	$sth->finish;

	return (@userPriv && @dbPriv)?1:0;
}

sub checkDbName{
	my( $db_name, $db_user ) = @_;
	unless( $db_name =~ /^usr_\Q$db_user\E_\d+$/ ){
		die SOAP::Fault->faultcode('UsersMySQL.DbName')
			->faultstring("Error: wrong name of user's database: '$db_name'");
	}

	my $dbName = $db_name;
	$dbName =~ s/_/\\_/g;

	&getUserDbh();

	my($sql,$sth,$cnt);

	$sql = "SELECT COUNT(db) FROM db WHERE db=? AND user=? AND host=?";
	$sth = $userDbh->prepare( $sql );
	if( $sth->execute( $dbName, $db_user, 'localhost' ) ){
		($cnt) = $sth->fetchrow();
		$sth->finish;
		unless( $cnt ){
			&addDb( $dbName, $db_user, 'localhost');
		}
	}

	$sql = "SELECT COUNT(db) FROM db WHERE db=? AND user=? AND host IN (?,?)  ";
	$sth = $userDbh->prepare( $sql );
	if( $sth->execute( $dbName, $db_user, '127.0.0.1', '%' ) ){
		($cnt) = $sth->fetchrow();
		$sth->finish;
		unless( $cnt ){
			&addDb( $dbName, $db_user, '127.0.0.1' );
		}
	}

	return $dbName;
}

sub makeRandomPass{
	my $len = shift||8;
	my $passwd = join '', map{ (0..9,'A'..'Z','a'..'z')[rand 65] }(1..$len);
	return $passwd;
}

sub checkDbUser{
	my( $user, $passwd ) = @_;

	&getUserDbh();

	my($sql,$sth,$cnt, $add );

	$add = 0;

	$sql = "SELECT COUNT(user) FROM user WHERE user=? AND host=?";
	$sth = $userDbh->prepare( $sql );
	if( $sth->execute( $user, 'localhost' ) ){
		($cnt) = $sth->fetchrow();
		$sth->finish;
		unless( $cnt ){
			&addDbUser( $user, 'localhost', $passwd);
			$add++; 
		}
	}

	$sql = "SELECT COUNT(user) FROM user WHERE user=? AND host IN (?,?)";
	$sth = $userDbh->prepare( $sql );
	if( $sth->execute( $user, '127.0.0.1', '%' ) ){
		($cnt) = $sth->fetchrow();
		$sth->finish;
		unless( $cnt ){
			&addDbUser( $user, '127.0.0.1', $passwd );
			$add++; 
		}
	}
	return $add;
}

sub addDbUser{
	my($user,$host, $passwd) = @_;
	$userDbh->do( "INSERT INTO user (user,host,password) VALUES (?,?,PASSWORD(?))",
								undef,
								$user, $host, $passwd ) or
									die SOAP::Fault->faultcode('DBI.Do')
										->faultstring("Error: excute sql-request: $DBI::errstr");
	return 1;
}

sub addDb{
	my($db,$user,$host) = @_;

	unless( @dbPriv ){
		&getPermissions() or
			die SOAP::Fault->faultcode('Mysql.Permissions')
				->faultstring( "Error: List of permissions is empty" );
	}

	my %privY = map{ $_ => 1 } @PrivY;

	my $privVals = join( ',',  map{ $privY{$_}? "'Y'": "'N'" } @dbPriv );
	my $privNames = join( ',', @dbPriv );
	my $sql = "INSERT INTO db ( db,user,host,$privNames ) VALUES (?,?,?,$privVals)";

	$userDbh->do( $sql, undef, $db, $user, $host ) or
		die SOAP::Fault->faultcode('DBI.Do')
			->faultstring("Error: excute sql-request: $sql\n $DBI::errstr");
}

END {
	if( $userDbh ){
		$userDbh->disconnect();
		$userDbh = undef;
	}

}
