<?
########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . "class.ValuesSource.php" );





class ArrayValuesSource extends ValuesSource
{
    /* -------------------- Members -------------------- */
    var $ma_Data; // array of arrays - data
    var $ma_Search; // array of arrays - data of search
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function ArrayValuesSource ( $pa_Data = array(), $pa_Search = array(), $ps_IDName=0, $ps_PageNumber = NULL,
	    $ps_ItemsPerPage = NULL )
    {
	$this->ma_Data = $pa_Data;
	$this->PerformSearch ( $pa_Search );
	$this->ValuesSource ( $ps_IDName, $ps_PageNumber, $ps_ItemsPerPage );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- "abstract" methods -------------------- */
    /* todo: methods needed for search */
    /* -------------------- end "abstract" methods -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
    function Start ( &$pa_Search )
    {
	$this->PerformSearch ( $pa_Search );
	reset ( $this->ma_Search );
    }

    function &NextElement()
    {
	$la_Result = current( $this->ma_Search);
	next( $this->ma_Search );
	return $la_Result;
    }

    function TotalElements ( $pa_Search )
    {
	return count( $this->ma_Search );
    }

    function InIteration()
    {
	return current( $this->ma_Search );
    }
    /* -------------------- end definitions of "abstract" methods -------------------- */





    /* -------------------- PerformSearch -------------------- */
    function PerformSearch ( &$pa_Search )
    {
	if ( $this->IsBrowse($pa_Search) )
	{
	    // todo: implement paging
	    $this->ma_Search =& $this->ma_Data;
	}
	else
	{
	    // todo: implement search & paging
	    $this->ma_Search =& $this->ma_Data;
	}
    }
    /* -------------------- end PerformSearch -------------------- */





    /* -------------------- other methods -------------------- */
    function AddElement ( $pa_Element )
    {
	array_push ( $this->ma_Data, $pa_Element );
	return NULL;
    }

    function DeleteElements ( &$pa_IDs )
    {
	$ls_Unset = 0;
	for ( $i=0; $i<count($this->ma_Data); )
	    if ( in_array( $this->ma_Data[$i][$this->GetIDName()], $pa_IDs ) )
	    {
		array_splice ( $this->ma_Data, $i, 1 );
		$ls_Unset++;
	    }
	    else
		$i++;
	return $ls_Unset;
    }
    /* -------------------- end other methods -------------------- */

}
?>
