<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.InputTextColumn.php" );
include_once ( dirname(__FILE__) . "/class.DefinableValidator.php" );





class DefinableColumn extends InputTextColumn
{

    /* -------------------- Members -------------------- */
    var $ms_LabelName; // name of label field
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function DefinableColumn ( $ps_LabelName, $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(), $ps_Width=NULL,
	$ps_Align=NULL, $ps_ID=NULL )
    {
	$this->InputTextColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
	$this->SetLabelName ( $ps_LabelName );
	$this->SetValidator ( new DefinableValidator(FALSE) );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- Get... -------------------- */
    function GetLabelName()
    {
	return $this->ms_LabelName;
    }

    function GetLabel()
    {
	if ( ! $this->GetInput() )
	    return htmlspecialchars(InputTextColumn::GetLabel());
	$ls_More = $this->GetAttributesHTML();
	return "<input name=\"" . htmlspecialchars($this->GetLabelName()) . "\" value=\"" .
		htmlspecialchars(InputTextColumn::GetLabel()) . "\" $ls_More>";
    }

    function GetLabelText()
    {
	return InputTextColumn::GetLabel();
    }
    /* -------------------- end Get... -------------------- */





    /* -------------------- Set... -------------------- */
    function SetLabelName ( $ps_LabelName )
    {
	$this->ms_LabelName = $ps_LabelName;
    }

    function SetFromArray ( $pa_Data, $ps_ID )
    {
	InputTextColumn::SetFromArray ( $pa_Data, $ps_ID );
	if ( ! is_null($this->ms_LabelName) )
	    $this->SetLabel ( array_key_exists($this->ms_LabelName,$pa_Data) ? $pa_Data[$this->ms_LabelName] : NULL );
    }

    function SetFromPostGet ()
    {
	InputTextColumn::SetFromPostGet();
	if ( ! is_null($this->ms_LabelName) )
	{
	    if ( $_SERVER["REQUEST_METHOD"]=="POST" && array_key_exists( $this->ms_LabelName, $_POST ) &&
		    strlen( $_POST[$this->ms_LabelName] ) )
		$this->SetLabel ( $_POST[$this->ms_LabelName] );
	    else
		$this->SetLabel ( array_key_exists( $this->ms_LabelName, $_GET ) ? $_GET[$this->ms_LabelName] : NULL );
	}
    }
    /* -------------------- end Set... -------------------- */





    /* -------------------- IsValid -------------------- */
    function IsValid()
    {
	$lo_Validator =& $this->GetValidator();
	$lo_Validator->SetLabel ( InputTextColumn::GetLabel() );
	return $lo_Validator->Validate ( $this->GetValue() );
    }
    /* -------------------- end IsValid -------------------- */

}
?>
