<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.InputTextColumn.php" );





class Fieldset
{

	/* -------------------- Members -------------------- */
	var $mo_Legend; // legend
	var $mo_Content; // content - not used now
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function Fieldset( $pm_Legend, $po_Content=NULL )
	{
		$this->SetLegend( $pm_Legend );
		$this->SetContent( $po_Content );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function SetLegend( $pm_Legend )
	{
		if ( is_object( $pm_Legend ) )
			$this->mo_Legend = $pm_Legend;
		else {
			$this->mo_Legend = new InputTextColumn ( NULL, "", $pm_Legend );
			$this->mo_Legend->SetInput (FALSE);
		}
	}

	function GetLegend()
	{
		return $this->mo_Legend;
	}

	function SetContent( $po_Content )
	{
		$this->mo_Content = $po_Content;
	}

	function GetContent()
	{
		return $this->mo_Content;
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- HTML generation -------------------- */
	function GetStartHTML()
	{
		$lo_Legend = $this->GetLegend();
		return "<fieldset><legend>" . $lo_Legend->GetHTML() . "</legend>\n";
	}

	function GetEndHTML()
	{
		return "</fieldset>\n";
	}

	function PrintStartHTML()
	{
		echo ( $this->GetStartHTML() );
	}

	function PrintEndHTML()
	{
		echo ( $this->GetEndHTML() );
	}
	/* -------------------- end HTML generation -------------------- */

}
?>
