<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

class MysqlVersion {

	var $miVersion;

	function MysqlVersion( $psVersion = NULL ){
		global $mysql_user_version;

#		echo "MysqlVersion: $psVersion<br>\n";

		$miVersion = 0;
		if ( is_null( $psVersion ) ) {
			if ( isset($mysql_user_version) ) {
  			  $this->Version( $mysql_user_version );
			} else {
			  $this->miVersion = 0;
			}
		} else {
			$this->Version( $psVersion );
		}
	}

	function Version ( $psVersion = NULL ) {
	
		if ( !is_null( $psVersion ) ) {

			if ( is_numeric( $psVersion ) ) {
				if ( preg_match('/^(\d+(\.\d+)?)/',$psVersion, $matches) ) {
					$this->miVersion = $matches[1];
				} else {
				}
			} elseif ( is_object( $psVersion ) ) {
				$this->miVersion = $psVersion->Version();

			} elseif ( is_string( $psVersion ) ) {
				if ( preg_match('/(\d+)\.(\d+)\.(\d+)/',$psVersion,$matches) ) {
					$this->miVersion = $matches[1] + ( $matches[2] + $matches[3] * 0.001 ) * 0.001;
				}else{
					$this->miVersion = 0;
				}
			}
		}

		return $this->miVersion;
	}

	function versionNotLess( $poVer ) {

		if ( is_numeric( $poVer ) ) {
			return ( $this->miVersion >= $poVer );

		} elseif( is_object( $poVer ) ) {
			return ( $this->miVersion >= $poVer->Version() );
		}
	}

	function getClone() {
		return new MysqlVersion( $this->miVersion );
	}

	function copyfrom( $poFrom ) {
		if( is_object( $poFrom ) ) {
			$this->miVersion = $poFrom->Version();
		}
	}
}

class MysqlPermission extends MysqlVersion {
	var $msName;
	var $msValue;
	var $msType;

	function MysqlPermission ( $psName, $psValue = 'N' , $psVersion = NULL, $psType = 'priv' ){

		MysqlVersion::MysqlVersion( $psVersion );

		$this->msName = $psName;
		$this->Type( $psType );
		$this->Value( $psValue );
	}

	function Name ( $psName = NULL ) {
		if ( !is_null( $psName ) ) {
			$this->msName = $psName;
		}
		return $this->msName;
	}


	function Type ( $psType = NULL ) {
		if ( !is_null( $psType ) ){
			$this->msType = ($psType == 'max')?'max':'priv';
		}
		return $this->msType;
	}


	function Value ( $psValue = NULL ) {
		if ( !is_null( $psValue ) ) {
			if ( $psValue ) {
				if ( $this->msType == 'priv' ) {
					if ( $psValue == 'N' || $psValue == 'n' ) {
						$this->msValue = 'N';
					} else {
						$this->msValue = 'Y';
					}
				} else {
					if ( is_numeric( $psValue ) ) {
						$this->msValue = intval( $psValue );
					}
				}
			} else {
				if ( $this->msType == 'priv' ) {
					$this->msValue = 'N';
				} else {
					$this->msValue = 0;
				}
			}
		}
		return $this->msValue;
	}

	function setLock ( $plLock = false ) {
	  if ( $plLock ) {
		if ( $this->msType == 'priv' ) {
		  $this->msValue = 'N';
		} else {
	  	  $this->msValue = 0;
		}		
	  }
	}

	function getSqlField () {
	  return $this->msName;
	}

	function getSqlValue() {
		if ( $this->msType == 'max' ) {
			return $this->msValue;
		} else {
			return  "'".$this->msValue."'";
		}
	}

	function getClone() {
		return new MysqlPermission( $this->msName, $this->msValue, $this->Version(), $this->msType );
	}

	function copyfrom( $poFrom ) {

		if ( is_object($poFrom) ) {
			MysqlVersion::copyfrom( $poFrom );

			$this->msName = $poFrom->Name();
			$this->msValue = $poFrom->Value();
			$this->msType = $poFrom->Type();
		}
	}

}

$defaultUserPermissions = array ( new MysqlPermission( 'Select_priv', 'N', 0 ),
																	new MysqlPermission( 'Insert_priv', 'N', 0 ),
																	new MysqlPermission( 'Update_priv', 'N', 0 ),
																	new MysqlPermission( 'Delete_priv', 'N', 0 ),
																	new MysqlPermission( 'Create_priv', 'N', 0 ),
																	new MysqlPermission( 'Drop_priv', 'N', 0 ),
																	new MysqlPermission( 'Reload_priv', 'N', 0 ),
																	new MysqlPermission( 'Shutdown_priv', 'N', 0 ),
																	new MysqlPermission( 'Process_priv', 'N', 0 ),
																	new MysqlPermission( 'File_priv', 'N', 0 ),
																	new MysqlPermission( 'Grant_priv', 'N', 0 ),
																	new MysqlPermission( 'References_priv', 'N', 0 ),
																	new MysqlPermission( 'Index_priv', 'N', 0 ),
																	new MysqlPermission( 'Alter_priv', 'N', 0 ),
																	new MysqlPermission( 'Show_db_priv', 'N', 4.000024 ),
																	new MysqlPermission( 'Super_priv', 'N', 4.001 ),
																	new MysqlPermission( 'Create_tmp_table_priv', 'N', 4.001 ),
																	new MysqlPermission( 'Lock_tables_priv', 'N', 4.001 ),
																	new MysqlPermission( 'Execute_priv', 'N', 4.001 ),
																	new MysqlPermission( 'Repl_slave_priv', 'N', 4.001 ),
																	new MysqlPermission( 'Repl_client_priv', 'N', 4.001 )
																	);

$defaultDbPermissions = array ( new MysqlPermission( 'Select_priv', 'Y', 0 ),
																new MysqlPermission( 'Insert_priv', 'Y', 0 ),
																new MysqlPermission( 'Update_priv', 'Y', 0 ),
																new MysqlPermission( 'Delete_priv', 'Y', 0 ),
																new MysqlPermission( 'Create_priv', 'Y', 0 ),
																new MysqlPermission( 'Drop_priv', 'Y', 0 ),
																new MysqlPermission( 'Grant_priv', 'Y', 0 ),
																new MysqlPermission( 'References_priv', 'N', 0 ),
																new MysqlPermission( 'Index_priv', 'N', 0 ),
																new MysqlPermission( 'Alter_priv', 'Y', 0 ),
																new MysqlPermission( 'Create_tmp_table_priv', 'Y' , 4.000002 ),
																new MysqlPermission( 'Lock_tables_priv', 'Y', 4.000002 )
													 );

class MysqlPermissionSet extends MysqlVersion {
	var $mlLock;
	var $maPerms;
	var $maDefaultPerms;
	var $msType;
	var $mlChecked;
	
	function MysqlPermissionSet ( $psType, $plLock = false, $psVersion = NULL ) {

		

		MysqlVersion::MysqlVersion( $psVersion ); ## call parent constructor
	  
		$this->mlLock = $plLock? true: false;
		$this->setType( $psType );
		$this->mlChecked = false;

		if( userdb_has_connect() ){
			$this->check();
		}
	}

	function check( $conn = NULL ) {
		
		global $DEBUG;
		
		$sql = "SHOW COLUMNS FROM ".$this->msType;	
		
		if ( is_null( $conn ) || !$conn )	{
			$res = userdb_query( $sql);	
		} else {
			$res = mysql_query( $sql, $conn );	
		}	
		$ret = 0;
		if( $res ) {

			$this->mlChecked = true;

			while ($row = mysql_fetch_assoc($res)) {
				$laFields[] = $row['Field'];
			}
					
			foreach( $laFields as $key ) {
				$keys[] = strtolower($key);
			}
			mysql_free_result( $res );

			if( $DEBUG ){
				echo "MysqlPermissionSet::check <br><pre>\n";
				print_r($keys);
				echo "<hr>\n";
			}
			
			$cnt = count($this->maPerms);
			for( $i = $j = 0; 
					 ( $i < count( $this->maPerms ) ) && ( $j < $cnt ); 
					 $j++ ) { // duble protection
				$perm = $this->maPerms[$i];
				$name = strtolower( $perm->Name() );
				if ( in_array( $name, $keys ) ) {
					$i++;
				}	else {
					if ( $DEBUG ) {
						echo "Remove privelege '$name'<br>\n";	
					}
					array_splice( $this->maPerms, $i, 1);
					$ret++;
				}	
			}
		}
		return $ret;
	}
	
	function Lock( $plLock = NULL ) {
		if ( !is_null($plLock) ){
			$this->setLock( $plLock );
		}
		return $this->mlLock;
	}

	function Version( $psVersion = NULL ) {
		if ( is_null( $psVersion ) ) {
  		  return MysqlVersion::Version(); ## call parent method
		
		} else {

			$liVer = MysqlVersion::Version( $psVersion ); ## call parent method

			$this->setLock();
			
			return $liVer;
		}
	}

	function setLock( $plLock = NULL ) {

		global $DEBUG;
		if ( !is_null($plLock) ){
			$this->mlLock = $plLock? true: false;
		}


		if ( is_array( $this->maDefaultPerms ) ) {
			$this->maPerms = array(); ## clean array

			foreach ( $this->maDefaultPerms as $perm ) { ## loop by permissions
				
				if ( $this->mlChecked ||
						 $this->versionNotLess( $perm->Version() ) ){ ## check version

					$newPerm = $perm->getClone();
					
					$newPerm->setLock( $this->mlLock ); 
					
					$this->maPerms[] = $newPerm; ## add permission into array

				} else {
					if( $DEBUG ){
						echo "version restriction ".$perm->Version()."<br>\n";
					}
				}
			}
		} else {
//		  echo "not array<br>\n";
		}

		return $this->mlLock;
	}

	function setType( $psType = 'db' ) {

	  global $defaultUserPermissions, $defaultDbPermissions;

		if (  $psType == 'user' ) {
			$this->maDefaultPerms =& $defaultUserPermissions;
			$this->msType = 'user';
		} else {
			$this->maDefaultPerms =& $defaultDbPermissions;
			$this->msType = 'db';
		}
		$this->setLock();
	}

	function getSqlUpdates( $psVal = NULL ) {
		if ( is_array($this->maPerms) ) {
			$chunks = array();
			if ( is_null( $psVal ) ) {  
			  foreach ( $this->maPerms as $perm ){
				$chunks[] = $perm->getSqlField()."=".$perm->getSqlValue();
			  }
			} else {
			  foreach ( $this->maPerms as $perm ){
				$chunks[] = $perm->getSqlField()."=".$psVal;
			  }
			}  
			$ret = join( ',', $chunks );
		} else {
			$ret = '';
		}
		return $ret;
	}

	function getSqlFields() {
		if ( is_array($this->maPerms) ) {
			$chunks = array();
			foreach ( $this->maPerms as $perm ) {
				$chunks[] = $perm->getSqlField();
			}
			$ret = join( ',', $chunks );
		} else {
			$ret = '';
		}
		return $ret;
	}

	function getSqlValues( $psVal = NULL ) {
		if ( is_array($this->maPerms) ) {
			$chunks = array();
			if ( is_null( $psVal ) ) {
			  foreach ( $this->maPerms as $perm ) {
				$chunks[] = $perm->getSqlValue();
			  }	
			} else {
			  foreach ( $this->maPerms as $perm ) {
				$chunks[] = $psVal;
			  }	
			}
			$ret = join( ',', $chunks );
		} else {
			$ret = '';
		}
		return $ret;
	}
	
	function &getValues() {
	  $chunks = array();
	  if ( is_array($this->maPerms) ) {
		foreach ( $this->maPerms as $perm ) {
		  $chunks[] = $perm->getSqlValue();
		}	
	  }	
	  return $chumks;
	}

}

                                   
class MysqlUserPermissions extends MysqlPermissionSet {

	function MysqlUserPermissions( $plLock = false, $psVersion = false) {
		
		MysqlPermissionSet::MysqlPermissionSet( 'user', $plLock, $psVersion );
	}
}

class MysqlDbPermissions extends MysqlPermissionSet {

	function MysqlDbPermissions( $plLock = false, $psVersion = false ) {

		MysqlPermissionSet::MysqlPermissionSet( 'db', $plLock, $psVersion );
	}
}


?>
