<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.FormPage.php" );
include_once ( dirname(__FILE__) . "/class.FormPageRow.php" );
include_once ( dirname(__FILE__) . "/class.FormPageHeaderRow.php" );
include_once ( dirname(__FILE__) . "/class.InputTextColumn.php" );
include_once ( dirname(__FILE__) . "/class.SelectColumn.php" );
include_once ( dirname(__FILE__) . "/class.DefinableColumn.php" );
include_once ( dirname(__FILE__) . "/module.Database.php" );
include_once ( dirname(__FILE__) . "/class.ButtonColumn.php" );
include_once ( dirname(__FILE__) . "/class.EMailValidator.php" );





class PersonalInfo extends FormPage{

    /* -------------------- Members -------------------- */
	var $mcServerID;
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
	function PersonalInfo ( $ps_FormURL, $ps_Select, $ps_ButtonText=NULL ){

		$this->FormPage ( $ps_FormURL );

		$this->AddRow ( new FormPageHeaderRow( ltext("pi_label"), ltext("pi_input") ) );
		$this->AddRow ( new FormPageRow ( new SelectColumn( array( "m"=>ltext("pi_male"), "f"=>ltext("pi_female") ),
																													"gender", ltext("pi_gender"), "" ) ) );
		$this->AddRow ( new FormPageRow ( new InputTextColumn( "firstname", ltext("pi_firstname"), "" ) ) );
		$this->AddRow ( new FormPageRow ( new InputTextColumn( "name", ltext("pi_lastname"), "" ) ) );
		$this->AddRow ( new FormPageRow ( new InputTextColumn( "firma", ltext("pi_company"), "" ) ) );
		$this->AddRow ( new FormPageRow ( new InputTextColumn( "anschrift", ltext("pi_address"), "" ) ) );
		$this->AddRow ( new FormPageRow ( new InputTextColumn( "plzort", ltext("pi_city"), "" ) ) );
		$this->AddRow ( new FormPageRow ( new InputTextColumn( "plz", ltext("pi_zip"), "" ) ) );
		$this->AddRow ( new FormPageRow ( new InputTextColumn( "land", ltext("pi_country"), "" ) ) );
		$this->AddRow ( new FormPageRow ( new InputTextColumn( "telefon", ltext("pi_phone"), "" ) ) );
		$this->AddRow ( new FormPageRow ( new InputTextColumn( "fax", ltext("pi_fax"), "" ) ) );
		$lo_Field = new InputTextColumn ( "emailadresse", ltext("pi_email"), "" );
		$lo_Field->SetValidator ( new EMailValidator(TRUE) );
		$this->AddRow ( new FormPageRow ( $lo_Field ) );
		$this->AddRow ( new FormPageRow ( new InputTextColumn( "kundennummer", ltext("pi_customerid"), "" ) ) );
		$this->AddRow ( new FormPageHeaderRow( ltext("pi_definable"), ltext("pi_input") ) );
		$this->AddRow ( new FormPageRow ( new DefinableColumn( "freifeldname1", "freifeldwert1", "", "" ) ) );
		$this->AddRow ( new FormPageRow ( new DefinableColumn( "freifeldname2", "freifeldwert2", "", "" ) ) );
		$this->AddRow ( new FormPageRow ( new DefinableColumn( "freifeldname3", "freifeldwert3", "", "" ) ) );
		$this->AddRow ( new FormPageRow ( new ButtonColumn( "", is_null($ps_ButtonText) ?
																													ltext("pi_apply") : $ps_ButtonText ), TRUE, array( "align"=>"center" ) ) );

		if( is_string( $ps_Select ) ){
			$lo_DB =& get_db_connection();
			
			$lo_Query =& $lo_DB->Select ( $ps_Select );
			if( $lo_Query ){
				if ( $la_Row =& $lo_Query->nextrow() ){
					$this->SetData ($la_Row);
				}
			}
		}

		$this->AddHiddenField( new InputHiddenColumn( 'server_id', // name 
																									'', // label
																									$this->ServerID() // value
																									)
													 );
	}
    /* -------------------- end Constructor -------------------- */

	function &ServerID( $pcServerID = NULL ){
		if( is_string( $pcServerID ) ){
			$this->mcServerID = $pcServerID;
		}
		return $this->mcServerID;
	}

	function addHidden( $pcName, $pcValue=NULL ){

		if( is_array($pcName) ){
			foreach( $pcName as $lcName => $lcValue ){
				$this->AddHiddenField( new InputHiddenColumn( $lcName, // name 
																											'', // label
																											$lcValue // value
																											)
															 );
			}

		}elseif( is_object( $pcName ) ){
			$this->AddHiddenField( $pcName );

		}else{
			$this->AddHiddenField( new InputHiddenColumn( $pcName, // name 
																										'', // label
																										$pcValue // value
																										)
													 );
		}
	}
}
?>
