<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.LimitColumn.php" );
include_once ( dirname(__FILE__) . "/elements/data/class.CompoundDataField.php" );
include_once ( dirname(__FILE__) . "/elements/data/class.TextLimitDataField.php" );





class ResellerLimitColumn extends LimitColumn
{

    /* -------------------- Members -------------------- */
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function ResellerLimitColumn (  $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(), $ps_Width=NULL, $ps_Align=NULL,
	$ps_ID=NULL )
    {
	$this->LimitColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- GetHTML & related -------------------- */
    function GetHTML()
    {
	if ( ! $this->GetInput() )
	    return LimitColumn::GetHTML();
	$ls_More = $this->GetAttributesHTML();
	return "<input name=\"" . htmlspecialchars($this->GetName()) . "\" value=\"" . htmlspecialchars($this->GetValue())
		. "\" $ls_More> " . ltext("uc_maximum");
    }

    function GetAttributesHTML()
    {
	$ls_Result = " size=8 ";
	foreach ( $this->ma_Attributes as $ls_Key => $ls_Value )
	    $ls_Result .= " $ls_Key=\"" . $ls_Value . "\"";
	return $ls_Result;
    }

	function GetAttributes() {
		$la_Result = $this->ma_Attributes;
		$la_Result["size"] = "8";
		return $la_Result;
	}

	// method that maps old classes to include/elements/*
	function GetDataField() {
		$lo_Result = new TextLimitDataField( $this->GetValue(), $this->GetPureName() );
		$lo_Result->AppendAttributes( $this->GetAttributes() );
		return $lo_Result;
	}
    /* -------------------- end GetHTML & related -------------------- */

}
?>
