<?
########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "class.ValuesSource.php" );
include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "module.Database.php" );





class SQLValuesSource extends ValuesSource
{
    /* -------------------- Members -------------------- */
    var $mo_Query; // DB query object
    var $ms_InIteration; // if iteration started and not ended yet
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function SQLValuesSource (  $ps_IDName=0, $ps_PageNumber = NULL, $ps_ItemsPerPage = NULL )
    {
	$this->ValuesSource ( $ps_IDName, $ps_PageNumber, $ps_ItemsPerPage );
	$this->ms_InIteration = FALSE;
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- "abstract" methods -------------------- */
    function GetBrowseSQL()
    {
	echo ( "method GetBrowseSQL should return SQL!" );
    }

    function GetSearchSQL ( &$pa_Search )
    {
	echo ( "method GetSearchSQL should return SQL!" );
    }

    function GetCountBrowseSQL()
    {
	echo ( "method GetCountBrowseSQL should return SQL!" );
    }

    function GetCountSearchSQL ( &$pa_Search )
    {
	echo ( "method GetCountSearchSQL should return SQL!" );
    }

    function GetElementSQL()
    {
	echo ( "method GetElementSQL should return SQL!" );
    }
    /* -------------------- end "abstract" methods -------------------- */





    /* -------------------- iteration -------------------- */
    function Start ( &$pa_Search )
    {
	$lo_DB =& get_db_connection();
	$this->mo_Query =& $lo_DB->Select (
		$this->IsSearch( $pa_Search ) ? $this->GetSearchSQL ( $pa_Search ) : $this->GetBrowseSQL(),
		$this->GetItemsPerPage(), $this->GetPageNumber() );
	$this->ms_InIteration = TRUE;
    }

    function &NextElement()
    {
	$la_Row =& $this->mo_Query->nextrow();
	if ( ! $la_Row )
	    $this->ms_InIteration = FALSE;
	return $la_Row;
    }

    function TotalElements ( $pa_Search )
    {
	$lo_DB =& get_db_connection();
	$lo_Query =& $lo_DB->Select ( $this->IsSearch( $pa_Search ) ? $this->GetCountSearchSQL($pa_Search) :
		$this->GetCountBrowseSQL() );
	$la_Row =& $lo_Query->nextrow();
	return $la_Row[0];
    }

    function InIteration()
    {
	return $this->ms_InIteration;
    }
    /* -------------------- end iteration -------------------- */





    /* -------------------- GetElement -------------------- */
    function GetElement()
    {
	$lo_DB =& get_db_connection();
	$lo_Query =& $lo_DB->Select ( $this->GetElementSQL() );
	$la_Row =& $lo_Query->nextrow();
	return $la_Row;
    }
    /* -------------------- end GetElement -------------------- */





    /* -------------------- UnLock -------------------- */
    function UnLock()
    {
	$lo_DB =& get_db_connection();
	$lo_DB->unLockTables();
    }
    /* -------------------- end UnLock -------------------- */

}
?>
