<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.ListColumn.php" );
include_once ( dirname(__FILE__) . "/elements/data/class.ShellServiceDataField.php" );





class ShellColumn extends ListColumn
{

    /* -------------------- Members -------------------- */
    var $ms_Standard; // standard shell
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function ShellColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(), $ps_Width=NULL, $ps_Align=NULL,
		$ps_ID=NULL )
    {
	$this->ListColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
	$this->SetStandard (TRUE);
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- Set.../Get... -------------------- */
    function SetValue( $ps_Value )
    {
	ListColumn::SetValue ( $ps_Value ? ( $this->GetStandard() ? 1 : 2 ) : 0 );
    }

    function SetStandard ( $ps_Standard )
    {
	$this->ms_Standard = $ps_Standard;
    }

    function GetStandard()
    {
	return $this->ms_Standard;
    }
    /* -------------------- end Set.../Get... -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
    function GetHTML()
    {
	if ( $this->GetValue() )
	{
	    $ls_Yes = "checked";
	    $ls_No = "";
	}
	else
	{
	    $ls_Yes = "";
	    $ls_No = "checked";
	}
	if ( $this->GetStandard() )
	{
	    $ls_YesText = ltext ("g_yes");
	    $ls_Value = 1;
	}
	else
	{
	    $ls_YesText = ltext ("uc_scponly");
	    $ls_Value = 2;
	}
	return "<input type=radio name=\"" . htmlspecialchars($this->GetName()) . "\" value=$ls_Value $ls_Yes> $ls_YesText "
		. " <input type=radio name=\"" . htmlspecialchars($this->GetName()) . "\" value=0 $ls_No> <b>" .
		ltext("g_no") . "!</b>";
    }

	// method that maps old classes to include/elements/*
	function GetDataField() {
		return new ShellServiceDataField( $this->GetValue(), $this->GetPureName() );
	}
    /* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
