<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

include_once( 'class.CompoundValue.php' );
include_once( 'class.ValueFromArray.php' );
/**
 * Container Class for  array
 *
 */
class CompoundArrayValue extends CompoundValue {

	var $maArray;
	var $maFields;
	var $moTemplate;
	var $miTotalNumber;
	var $miStart;
	var $miSize;

	function CompoundArrayValue( &$paArray, $piSize = NULL, $piStart = NULL ) {
		$this->CompoundValue();
		$this->maArray = $paArray;
		$this->miSize  = $piSize;
		$this->miStart = $piStart;
	}

	function &PageSize($piSize = NULL) {
		if (is_integer($piSize)) {
			$this->miSize = $piSize;
		}
		return $this->miSize;
	}

	function StartIndex($piStart = NULL) {
		if (is_integer($piStart)) {
			$this->miStart = $piStart;
		}
		return $this->miStart + 1;
	}

	function &TotalNumber($piTotal = NULL){
		if (is_integer($piTotal)) {
			$this->miTotalNumber = $piTotal;
		}
		return $this->miTotalNumber;
	}

	function &Fields($paFields = NULL){
		if (is_array($paFields)) {
			$this->maFields = $paFields;
		}
		return $this->maFields;
	}

	function &Template($poTempl = NULL) {
		if (is_a( $poTempl, 'CompoundValue')) {
			$this->moTemplate = $poTempl;
		} elseif(is_a( $poTempl, 'KeyValue' )) {
			$this->moTemplate = new CompoundValue(func_get_args());
		} elseif(is_array($poTempl)) {
			$this->moTemplate = new CompoundValue($poTempl);
		}
		return $this->moTemplate;
	}

///////////////////////////////////////////////////////////////////////////////

	function doQuery ($piSize = NULL, $piStart = NULL) {
		global $DEBUG;
	
		$liTotal = $this->miTotalNumber;
		$liPage = $this->miSize;
		
		if ( ( $liTotal > 0 ) && ( $liPage > 0 ) && ($liPage >= $liTotal ) ) {   
			$this->StartIndex( 0 );
		}

		$loID = count($this->maArray);

		if( $loID ){

			$this->clean();

			if( !is_array( $this->maFields ) ) {
				$this->maFields = array_keys($this->maArray[0]);
			}

			if( is_a( $this->moTemplate, 'CompoundValue') ) {
				$llHasTemplate = TRUE;
				$loIter = $this->moTemplate->getTreeIterator();
				$laFields = array();
				while ( $loItem =& $loIter->getNext() ){
					$laFields[] = $loItem->Key();
				}
			} else {
				$laFields =& $this->maFields;
			}
			
//			$liBegin = $this->miStart;
//			$liEnd = $this->miStart +  $this->miSize;
//			
			$liBegin = 0;
			$liEnd = count($this->maArray);
			
			for ($i=$liBegin; $i<$liEnd; $i++) {
			if ( $row = $this->maArray[$i]) {
				if( $llHasTemplate ){
					$loRow =& $this->moTemplate->getClone();
					$loRow->setFromArray( $row );
				} else {
					$loRow = new CompoundValue();
					foreach ( $laFields as $lcFieldName ) {
						$loRow->addValue( new ValueFromArray( $lcFieldName, $row[$lcFieldName] ) );
					}
				}
				$this->addValue( $loRow );}
			}

			return $this->getCount();

		} else {
			return NULL;
		}
	}

///////////////////////////////////////////////////////////////////////////////

	function setFromArray( $liIndex, $paSource ){
		$loItem =& $this->Value( $liIndex );
		if( $loItem ){
			return $loItem->setFromArray();
		} else {
			return FALSE;
		}
	}

	function &getColumn( $piIndex ){

		global $DEBUG;

		$loRet = new CompoundValue();
		$loIter =& $this->getFirstIterator();
		while( $loItem =& $loIter->getNext() ){

			if(is_numeric($piIndex)){
				$loRet->addValue( $loItem->Value( $piIndex ) );

			} else {
				$loRowIter =& $loItem->getFirstIterator();
				$llNotFound = TRUE;
				while ( $loCell =& $loRowIter->getNext()){
					if( $loCell->sameKey( $piIndex ) ){
						$loRet->addValue( $loCell );
						$llNotFound = FALSE;
						break;
					}
				}
				if( $llNotFound ) {
					$loRet->addValue( NULL );
				}
			}

		}
		return $loRet;
	}
}
?>
