<?
include_once( 'class.SQLQuery.php' );
include_once( 'class.CompoundValue.php' );
include_once( 'class.ValueFromArray.php' );

class CompoundDBValue extends CompoundValue {

	var $moQuery;
	var $maFields;
	var $moTemplate;
	var $miTotalNumber;

	function CompoundDBValue( $poSQLQuery, $piSize = NULL, $piStart = NULL ) {
		global $DEBUG;
		
		$this->CompoundValue();
		$this->SQLQuery( $poSQLQuery, NULL, $piSize, $piStart );
	}

	function &SQLQuery( $poQuery = NULL, $paParams = NULL, $piSize = NULL, $piStart = NULL ) {
		if( !is_null( $poQuery ) ) {
			$this->moQuery = new SQLQuery( $poQuery, $paParams, $piSize, $piStart);
		}
		return $this->moQuery;
	}

	function &PageSize( $piSize = NULL){
		return $this->moQuery->Size( $piSize );
	}

	function StartIndex( $piStart = NULL){
		return $this->moQuery->Start( $piStart ) + 1;
	}

	function &TotalNumber( $piTotal = NULL){
		if( is_numeric( $piTotal ) ) {
			$this->miTotalNumber = $piTotal;
		}
		return $this->miTotalNumber;
	}


	function &Parameters( $paParam = NULL){
		return $this->moQuery->Parameters( $paParam );
	}

	function &Fields( $paFields = NULL ){
		if( is_array( $paFields ) ) {
			$this->maFields = $paFields;
		}
		return $this->maFields;
	}

	function &Template( $poTempl = NULL ) {
		if( is_a( $poTempl, 'CompoundValue' ) ){
			$this->moTemplate = $poTempl;
		} elseif( is_a( $poTempl, 'KeyValue' ) ) {
			$this->moTemplate = new CompoundValue( func_get_args() );
		} elseif( is_array( $poTempl ) ) {
			$this->moTemplate = new CompoundValue( $poTempl );
		}
		return $this->moTemplate;
	}


	function setFields( $paFields ) {
		$this->maFields = $paFields;
	}

	function &getFields() {
		return $this->maFields;
	}


	function doQuery($paParams=NULL, $piSize = NULL, $piStart = NULL){
		global $DEBUG;
		if( !is_a( $this->moQuery, 'SQLQuery' ) ) {
			echo "CompondDBValue::doQuery: error: it is not a 'SQLQuery'-object<br>\n";
			return NULL;
		}
		$liTotal = $this->TotalNumber();
		$liPage = $this->PageSize();
		if ( ( $liTotal > 0 ) && ( $liPage > 0 ) && ($liPage >= $liTotal ) ) {   
			$this->StartIndex( 0 );
		}

		$loID = $this->moQuery->doQuery( $paParams, $piSize, $piStart );

		if( $loID ){

			$this->clean();

			if( !is_array( $this->maFields ) ) {
				$this->maFields = $this->moQuery->getFieldNames();
			}

			if( is_a( $this->moTemplate, 'CompoundValue') ) {
				$llHasTemplate = TRUE;
				$loIter = $this->moTemplate->getTreeIterator();
				$laFields = array();
				while ( $loItem =& $loIter->getNext() ){
					$laFields[] = $loItem->Key();
				}
			} else {
				$laFields =& $this->maFields;
			}

			while ( $row = $this->moQuery->fetchArray('A') ) {
				if( $llHasTemplate ){
					$loRow =& $this->moTemplate->getClone();
					$loRow->setFromArray( $row );
				} else {
					$loRow = new CompoundValue();
					foreach ( $laFields as $lcFieldName ) {
						$loRow->addValue( new ValueFromArray( $lcFieldName, $row[$lcFieldName] ) );
					}
				}
				$this->addValue( $loRow );
			}
			$this->moQuery->freeResult();

			return $this->getCount();

		} else {
			return NULL;
		}
	}

	function setFromArray( $liIndex, $paSource ){
		$loItem =& $this->Value( $liIndex );
		if( $loItem ){
			return $loItem->setFromArray();
		} else {
			return FALSE;
		}
	}

	function &getColumn( $piIndex ){

		global $DEBUG;

		$loRet = new CompoundValue();
		$loIter =& $this->getFirstIterator();
		while( $loItem =& $loIter->getNext() ){

			if(is_numeric($piIndex)){
				$loRet->addValue( $loItem->Value( $piIndex ) );

			} else {
				$loRowIter =& $loItem->getFirstIterator();
				$llNotFound = TRUE;
				while ( $loCell =& $loRowIter->getNext()){
					if( $loCell->sameKey( $piIndex ) ){
						$loRet->addValue( $loCell );
						$llNotFound = FALSE;
						break;
					}
				}
				if( $llNotFound ) {
					$loRet->addValue( NULL );
				}
			}

		}
		return $loRet;
	}
}
?>
