<?
include_once("class.ValueFromArray.php");

class ValueFormated extends ValueFromArray {
	var $mcFormatFunction;
	var $maArgs;
	var $miIndexOfValue;
	var $mlHasHTML;

	function ValueFormated( $pcKey, $puValue = NULL, $psFunction = '', $paArgs = array()){
		global $DEBUG;
		$this->mlHasHTML = FALSE;
		if( is_a( $pcKey,'ValueFormated' ) ) {
			$this->copyFrom( $pcKey );
		} else {
			$this->ValueFromArray( $pcKey, $puValue );
			$this->FormatFunction( $psFunction, $paArgs );
		}
	}

	function hasHTML( $mlNewValue = NULL ){
		if( !is_null( $mlNewValue ) ) {
			$this->mlHasHTML = $mlNewValue;
		}
		return $this->mlHasHTML;
	}

	function FormatFunction( $psFunction = '', $paArgs = array()){
		if( function_exists( $psFunction ) ) {
			$this->mcFormatFunction = $psFunction;
			if( is_array( $paArgs ) ) {
				$this->maArgs = $paArgs;
				$this->miIndexOfValue = array_search( '?', $this->maArgs);
				if( !is_numeric($this->miIndexOfValue) ) {
					$this->miIndexOfValue = count($this->maArgs);
					$this->maArgs[$this->miIndexOfValue] = '?';
				}
			}
		}
		return $this->mcFormatFunction;
	}

	function &getFormatFunction() {
		return $this->mcFormatFunction;
	}

	function &getFormatParameters() {
		return $this->maArgs;
	}

	function &getIndexOfValue() {
		return $this->miIndexOfValue;
	}

	function callFormatFunction(){
		global $DEBUG;
		if( function_exists( $this->mcFormatFunction ) ) {
			$laArgs = $this->maArgs;
			$laArgs[$this->miIndexOfValue] = parent::Value();
			/*
			if($DEBUG){
				echo "ValueFormated::callFormatFunction: ".$this->mcFormatFunction." (".join(',',$laArgs).")<br>\n";
			}
			*/
			return call_user_func_array( $this->mcFormatFunction, $laArgs );
		} else {
			return NULL;
		}
	}

	function Value( $puValue = NULL){
		global $DEBUG;
		/*
		if($DEBUG){
			echo "ValueFormated::Value: call parent<br>\n";
		}
		*/
		parent::Value( $puValue );
		
		return $this->callFormatFunction();
	}

	function UnformatedValue( $puValue = NULL ){
		return parent::Value( $puValue );
	}

	function copyFrom( &$poSource ) {
		if ( is_a( $poSource, 'ValueFormated' ) ) {
			$this->FormatFunction( $poSource->getFormatFunction(), $poSource->getFormatParameters() );
			parent::copyFrom( $poSource );
		}
	}

	function &getClone() {
		return new ValueFormated( $this );
	}
}
?>
